#ifndef MMeshShapeObject_Header
#define MMeshShapeObject_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MMeshShape;

  typedef MRefCountedPtr<MMeshShape> MMeshShapePtr;
}

#include <MShapeObject.h>
#include <MMesh.h>
#include <params/MObjectParameter.h>

namespace Aztec {

  //--------------
  // MShapeObect
  //--------------
  class MGENEXPORT MMeshShape : public MShapeObject {
  public:
    MMeshShape(MMeshPtr input = NULL);
    ~MMeshShape();
    
    /**
     * This gets the Mesh that is the input for this shape.
     *
     * @return The input Mesh for this Shape.
     */
    MMeshPtr getMeshObject();

    /**
     * This sets the input mesh for this shape.
     *
     * @param mesh The new mesh to use as the input.
     */
    void setMeshObject(MMeshPtr mesh);

    // MShapeObject methods
    MMeshPtr convertToMesh();
    bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    MComponentisedObjectPtr getComponentObject();
    MEditableComponentisedObjectPtr getEditableComponentObject();

    // MBaseObject methods
    virtual MStr getClassName() {return MStr("MMeshShape");};
    virtual MStr getParentClassName() {return MStr("MShapeObject");};
    virtual MBaseObjectPtr createNew();

  protected:
    MObjectParameterPtr m_InMeshParam;

  };
  
  
}


#endif
