#ifndef MValue_Header 
#define MValue_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MValue;
  typedef MRefCountedPtr<MValue> MValuePtr;

}

#include "MDAGNode.h"

namespace Aztec {

  /**
   * This is an interface class that defins some sort of animatable value.
   */
  class MGENEXPORT MValue : public virtual MDAGNode {
  public:
    /**
     * This attempts to copy all the animation information from 
     * the source value.
     * 
     * @param source The source value to copy form.
     * @return true if the copy succeded, false if it failed.
     */
    virtual bool copyFromValue(MValuePtr source) = 0;

    /**
     * This tells the value to store a copy of all the information
     * about the value so that it may be resotred at a later date.
     * The implmentation of this need not implement it this way, as it may 
     * use a copy on write mechanism, so no data is copied unless it is needed.
     */
    virtual void storeValue() = 0;

    /**
     * This tells the value to restore the previously stored copy
     * of the value information. After this, the original MUST be maintained,
     * the values may be resotred a number of times.
     */
    virtual void restoreValue() = 0;
  };
  

}

#endif 
