#ifndef MParameterFactory_Header
#define MParameterFactory_Header

#include "ModelGeneric.h"

#include <params/MBooleanParameter.h>
#include <params/MChoiceParameter.h>
#include <params/MIntParameter.h>
#include <params/MStringParameter.h>
#include <params/MVector3Parameter.h>
#include <params/MFloatParameter.h>
#include <params/MFloatKeyParameter.h>
#include <params/MObjectParameter.h>
#include <params/MObjectListParameter.h>
#include <params/MMatrix4Parameter.h>

namespace Aztec {

  /**
   * MParameterObject represents a parameter of some type. A
   * parameter is a value of a specific type, and has three names 
   * associated with it. It has a short name, long name and a friendly name.
   * The names are used to identify the parameter so it can be set 
   * without knowledge of the object that contains the parameters.
   */
  class MGENEXPORT MParameterFactory {
  public:
    static MBooleanParameterPtr createBoolean(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MChoiceParameterPtr  createChoice(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MVector3ParameterPtr createColour(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MStringParameterPtr createFilename(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MFloatKeyParameterPtr createFloat(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MStringParameterPtr createImageFilename(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MIntParameterPtr createInteger(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MObjectParameterPtr createObject(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MObjectListParameterPtr createObjectList(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MStringParameterPtr createString(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MVector3ParameterPtr createVector3(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MVector3ParameterPtr createStaticVector3(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);
    static MMatrix4ParameterPtr createMatrix(const MStr &shortName, const MStr &longName, const MStr &friendlyName, bool inputParameter = true);

  };

}

#endif
