#include <StdAfx.h>

#include <animation/MIKController.h>
#include <params/MParameterFactory.h>

namespace Aztec {

  MIKController::MIKController() {
    startBoneParam = MParameterFactory::createObject("startBone", "startBone", "Start Bone");
    endBoneParam = MParameterFactory::createObject("endBone", "endBone", "End Bone");
    endEffectorParam = MParameterFactory::createObject("endEffect", "endEffector", "End Effector");

    addParameter(startBoneParam);
    addParameter(endBoneParam);
    addParameter(endEffectorParam);
  }

  MSceneObjectPtr MIKController::getStartBone() {
    return AZTEC_CAST(MSceneObject, startBoneParam->getValue());
  }

  MSceneObjectPtr MIKController::getEndBone() {
    return AZTEC_CAST(MSceneObject, endBoneParam->getValue());
  }

  MSceneObjectPtr MIKController::getEndEffector() {
    return AZTEC_CAST(MSceneObject, endEffectorParam->getValue());
  }

  MObjectParameterPtr MIKController::getStartBoneParameter() {
    return startBoneParam;
  }

  MObjectParameterPtr MIKController::getEndBoneParameter() {
    return endBoneParam;
  }

  MObjectParameterPtr MIKController::getEndEffectorParameter() {
    return endEffectorParam;
  }


}
