#include "StdAfx.h"

#include "MSystemManager.h"
#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  using namespace std;

  //---------------------
  //  MStringParameterImpl
  //---------------------
  MStringParameterImpl::MStringParameterImpl(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    int meaning) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL)
  {
    this->meaning = meaning;
  }
  
  MStringParameterImpl::~MStringParameterImpl()
  {
  }

  int MStringParameterImpl::getDataMeaning() const {
    return meaning;
  }

  bool MStringParameterImpl::getValueString(MStr &value) {
    updateObject();
    value = m_Value;
    return true;
  }

  bool MStringParameterImpl::getValueInteger(int &value) {
    updateObject();
    value = strToInt(m_Value);
    return true;
  }

  bool MStringParameterImpl::getValueFloat(float &value) {
    updateObject();
    value = strToFloat(m_Value);
    return true;
  }

  bool MStringParameterImpl::getValueBoolean(bool &value) {
    updateObject();
    value = strToBool(m_Value);
    return true;
  }

  bool MStringParameterImpl::getValueVector(MVector3 &value) {
    updateObject();
    return value.convertFromString(m_Value);
  }

  bool MStringParameterImpl::setValueString(const MStr &value) {
    ensureUndo();

    m_Value = value;

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);

    return true;
  }

  bool MStringParameterImpl::setValueInteger(int value) {
    return setValueString(intToStr(value));
  }

  bool MStringParameterImpl::setValueFloat(float value) {
    return setValueString(floatToStr(value));
  }

  bool MStringParameterImpl::setValueBoolean(bool value) {
    return setValueString(boolToStr(value));
  }

  bool MStringParameterImpl::setValueVector(const MVector3 &value) {
    return setValueString(value.convertToString());
  }

  bool MStringParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    MStr val;
    if (value->getValueString(val)) {
      return setValueString(val);
    }

    return false;
  }
  
  MParameterObjectPtr MStringParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  void MStringParameterImpl::finishWithUndoNode() {
    undoNode = NULL;
  }

  void MStringParameterImpl::ensureUndo() {
    if (undoNode == NULL && MUndoManager::isEnabled()) {
      undoNode = new StringUndoNode(this);
      MUndoManager::getInstance()->addUndoNode(undoNode);
    }
  }

  MStringParameterImpl::StringUndoNode::StringUndoNode(MStringParameterImpl *param) {
    this->param = param;
    value = param->m_Value;
  }

  // MBaseUndoNode methods
  MUndoableObject* MStringParameterImpl::StringUndoNode::getObject() {
    return &*param;
  }

  void MStringParameterImpl::StringUndoNode::undo() {
    std::string temp = value;
    value = param->m_Value.c_str();
    param->m_Value = temp.c_str();
  }

  void MStringParameterImpl::StringUndoNode::redo() {
    std::string temp = value;
    value = param->m_Value.c_str();
    param->m_Value = temp.c_str();
  }

  
}
