#ifndef UNDOGENERAL_H
#define UNDOGENERAL_H

#include "MListsTrees.h"
#include "MScene.h"
#include "MEditableMesh.h"
#include <MKeyableValue.h>

#include "MBaseUndoNode.h"

class MSelectUndoNode;
class MTimeUndoNode;
class MKeyListUndoSubItem;
class MParameterUndoNode;
class MSceneTreeUndoNode;
class MMeshUndoNode;

typedef MRefCountedPtr<MSelectUndoNode> MSelectUndoNodePtr;
typedef MRefCountedPtr<MTimeUndoNode> MTimeUndoNodePtr;
typedef MRefCountedPtr<MKeyListUndoSubItem> MKeyListUndoSubItemPtr;
typedef MRefCountedPtr<MParameterUndoNode> MParameterUndoNodePtr;
typedef MRefCountedPtr<MSceneTreeUndoNode> MSceneTreeUndoNodePtr;
typedef MRefCountedPtr<MMeshUndoNode> MMeshUndoNodePtr;

//----------------------------------------------------------------------------------------
//  MSelectUndoNode
//----------------------------------------------------------------------------------------
class MSelectUndoNode : public MBaseUndoNode {
protected:
   MBaseObjectListPtr m_SelectList;

public:
   MSelectUndoNode();
   virtual ~MSelectUndoNode();

   virtual int execute();
   virtual MBaseUndoNodePtr createNew();
   virtual bool reverse();
};


//----------------------------------------------------------------------------------------
//  MTimeUndoNode
//----------------------------------------------------------------------------------------
class MTimeUndoNode : public MBaseUndoNode
{
public:
   long              m_Time;

   MTimeUndoNode();
   virtual ~MTimeUndoNode();

   virtual int execute();
   virtual MBaseUndoNodePtr createNew();
   virtual bool reverse();
};


//----------------------------------------------------------------------------------------
// MKeyListUndoSubItem
//----------------------------------------------------------------------------------------
class MKeyListUndoSubItem : public MBaseObject {
protected:
   MKeyableValuePtr m_OrigKey;
   MKeyableValuePtr m_StoredKey;
   MParameterObjectPtr m_OrigParam;
   MParameterObjectPtr m_StoredParam;
public:
   MKeyListUndoSubItem();
   ~MKeyListUndoSubItem();

   // Class related
   virtual MStr getClassName() {return MStr("MKeyListUndoSubItem");};
   virtual MStr getParentClassName() {return MStr("MNamedObject");};
   virtual MBaseObjectPtr createNew();

   void setItem(MKeyableValuePtr value);
   void setItem(MParameterObjectPtr ParamObj);
   void deleteItems();

   int execute();
   bool reverse();
};

//----------------------------------------------------------------------------------------
//  MParameterUndoNode
//----------------------------------------------------------------------------------------
class MParameterUndoNode : public MBaseUndoNode {
public:
   MBaseObjectListPtr m_ParamList;

   MParameterUndoNode();
   virtual ~MParameterUndoNode();

   virtual int execute();
   virtual MBaseUndoNodePtr createNew();
   virtual bool reverse();

   void addKeyableValue(MKeyableValuePtr value);
   void AddParamObj(MParameterObjectPtr ParamObj);
   void AddParamObj(MNamedObjectPtr Obj, const MStr &ParamName);
};

//----------------------------------------------------------------------------------------
//  MSceneTreeUndoNode
//----------------------------------------------------------------------------------------
class MSceneTreeUndoNode : public MBaseUndoNode {
public:
   MScenePtr m_Scene;
   MBaseObjectTreePtr m_StoredTree;

   MSceneTreeUndoNode();
   virtual ~MSceneTreeUndoNode();

   virtual int execute();
   virtual MBaseUndoNodePtr createNew();
   virtual bool reverse();

   void setScene(MScenePtr Scene);
   void getObjectFlags();
   void setObjectFlags();
};

//----------------------------------------------------------------------------------------
//  MMeshUndoNode
//----------------------------------------------------------------------------------------
class MMeshUndoNode : public MBaseUndoNode {
public:
   MMeshPtr m_StoredMesh;
   MEditableMeshPtr m_MeshToChange;

   MMeshUndoNode();
   virtual ~MMeshUndoNode();

   virtual int execute();
   virtual MBaseUndoNodePtr createNew();
   virtual bool reverse();

   void setMesh(MEditableMeshPtr Src);
};


#endif