#ifndef ParameterViewWnd_Header
#define ParameterViewWnd_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BaseViewWnd.h"
#include <AztecGUIMParameterPlugin.h>

#include <map>

class CParameterViewWnd : public MBaseViewWnd
{
// Construction
public:
	CParameterViewWnd();

    // Class related
   virtual MStr getClassName() {return MStr("ParameterViewWnd");};
   virtual MStr getParentClassName() {return MStr("MBaseViewWnd");};
   virtual MBaseObjectPtr createNew();

   virtual void ViewCreate();
   virtual void DrawView();

   virtual DWORD ViewPopupMenu(int x, int y);
   virtual int HandlePopupCommand(DWORD Cmd);

protected:
  typedef std::pair<CWnd *, AztecGUI::MParameterPluginPtr> CWndPluginPair;
  typedef std::vector< CWndPluginPair > PluginPairList;

  class ParamGUI {
  public:
    ParamGUI(CWnd *parent = NULL);
    ParamGUI(const ParamGUI &src);

    void destroy();
    void addChildWindow(CWnd *child, const AztecGUI::MParameterPluginPtr &plugin);

    CWnd *parentWnd;
    PluginPairList childWindows;
  };

  CTabCtrl *tabbedCtrl;

  typedef std::map<MNamedObjectPtr, int> ObjTabMap;
  typedef std::map<int, MNamedObjectPtr> TabObjMap;
  typedef std::map<MNamedObjectPtr, ParamGUI> CWndMap;

  /**
   * This is a map from Object to tab index.
   */
  ObjTabMap objectTabs;
  TabObjMap tabObjects;

  void addTabFor(const MNamedObjectPtr &obj);
  void removeTabFor(const MNamedObjectPtr &obj);

  RECT addControlsForObject(CWnd *parentWnd, MNamedObjectPtr obj, int startY, CWndMap::iterator wndMapIt);
  CWnd* getWndFor(const MNamedObjectPtr &obj);
  void removeWndFor(const MNamedObjectPtr &obj);

  void showTab(int index, DWORD action);
  void resizeToFitTab(CWnd *wnd);
  CWnd* getWndForTabIndex(int index);

  ParamGUI getParamGUIForTabIndex(int index);

  CWndMap windowList;



public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CParameterViewWnd)
public:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CParameterViewWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CParameterViewWnd)
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif
