// ColorHSL_Dlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "resource.h"
#include "ColorHslDlg.h"

#include "DlgGlobs.h"
#include "MdlMsgs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorHSL_Dlg dialog


CColorHSL_Dlg::CColorHSL_Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CColorHSL_Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CColorHSL_Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

   m_ChanParam = NULL;
}


void CColorHSL_Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorHSL_Dlg)
	DDX_Control(pDX, IDC_RSLIDER, m_RedSlider);
	DDX_Control(pDX, IDC_REDIT, m_RedEdit);
	DDX_Control(pDX, IDC_GSLIDER, m_GreenSlider);
	DDX_Control(pDX, IDC_GEDIT, m_GreenEdit);
	DDX_Control(pDX, IDC_BSLIDER, m_BlueSlider);
	DDX_Control(pDX, IDC_BEDIT, m_BlueEdit);
	DDX_Control(pDX, IDC_COLORPREVIEWBUT, m_ColorBut);
    DDX_Control(pDX, IDC_COLORWHEEL, m_ColorWheel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CColorHSL_Dlg, CDialog)
	//{{AFX_MSG_MAP(CColorHSL_Dlg)
	ON_WM_CLOSE()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CColorHSL_Dlg::SetChannelParameter(MChannelParameterPtr Param) {
   m_ChanParam = Param;

   if (m_ChanParam != NULL) {
      MStr     Title;

      Title.Format("%s.%s", (LPCTSTR)m_ChanParam->getSelectedObject()->getName(), (LPCTSTR)m_ChanParam->getDisplayName());
      SetWindowText((LPCTSTR)Title);
      SetColor(m_ChanParam->getSelectedObject()->getParamVec(m_ChanParam->getParamName()));

   } else {
      SetWindowText("Colour Picker");
   }

   // RVE> TEMPORARY: Yep, the color button will return soon.. ;)
   m_ColorBut.ShowWindow(SW_HIDE);
}

void CColorHSL_Dlg::SetColor(const MVector3 &Vec)
{
   BYTE     R, G, B;

   m_CurCol = Vec;

   R = (BYTE)(m_CurCol.x * 255);
   G = (BYTE)(m_CurCol.y * 255);
   B = (BYTE)(m_CurCol.z * 255);

   m_CurColINT = R + (G << 8) + (B << 16);
   m_ColorBut.SetColor(m_CurColINT);

   m_RedEdit.SetWindowText(MStr().Format("%.2f", m_CurCol.x));
   m_GreenEdit.SetWindowText(MStr().Format("%.2f", m_CurCol.y));
   m_BlueEdit.SetWindowText(MStr().Format("%.2f", m_CurCol.z));

   m_RedSlider.SetPos((int)(100 * m_CurCol.x));
   m_GreenSlider.SetPos((int)(100 * m_CurCol.y));
   m_BlueSlider.SetPos((int)(100 * m_CurCol.z));

   m_ChanParam->getSelectedObject()->setParamByName(m_ChanParam->getParamName(), m_CurCol.convertToString());
   m_ChanParam->UpdateControls();
   g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);

}


BOOL CColorHSL_Dlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
   m_RedSlider.SetRange(0, 100, TRUE);
   m_GreenSlider.SetRange(0, 100, TRUE);
   m_BlueSlider.SetRange(0, 100, TRUE);
   
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CColorHSL_Dlg::OnClose() 
{
	
	CDialog::OnClose();
}

LRESULT CColorHSL_Dlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
   
	return CDialog::WindowProc(message, wParam, lParam);
}

void CColorHSL_Dlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
   int         RPos, GPos, BPos;
   MVector3    Pos;

   if (!m_RedSlider.m_hWnd)
      return;
   if (!m_GreenSlider.m_hWnd)
      return;
   if (!m_BlueSlider.m_hWnd)
      return;
   RPos = m_RedSlider.GetPos();
   GPos = m_GreenSlider.GetPos();
   BPos = m_BlueSlider.GetPos();

   Pos.x = RPos / 100.0f;
   Pos.y = GPos / 100.0f;
   Pos.z = BPos / 100.0f;

   SetColor(Pos);
   
   
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CColorHSL_Dlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class

    if (wParam == (WM_USER+1))
    {
        // RVE> TODO: Update color values and other stuff

        m_ColorWheel.PaintBullet();
    }

	return CDialog::OnCommand(wParam, lParam);
}
