// AztecMainDlg.cpp : implementation file
//

#include <AztecMainPCH.h>

#include <AztecVersion.h>

#include "AztecMain.h"
#include "AztecMainDlg.h"

#include "ModelGLConst.h"
#include "MdlGlobs.h"
#include "MainFunc.h"
#include "DlgGlobs.h"

#include "MToolTipWnd.h"
#include <controls/AztecSplashScreen.h>

#include "RegCtrl.h"

#include "KeyFuncs.h"
#include "KeyFuncView.h"
#include "KeyFuncGeneral.h"

#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>

#include "MdlMsgs.h"

#include "SceneViewWnd.h"

#include "ShelfDlg.h"

#include "ToolClasses.h"
#include <AztecGUIMPluginManager.h>

#include <mesh/MMeshCreator.h>
#include "..\..\include\main\aztecmaindlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define VIEWEDGE_SIZE      6

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
  CAboutDlg();
  
  // Dialog Data
  //{{AFX_DATA(CAboutDlg)
  enum { IDD = IDD_ABOUTBOX };
  //}}AFX_DATA
  
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CAboutDlg)
protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL
  
  // Implementation
protected:
  //{{AFX_MSG(CAboutDlg)
  afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
  //{{AFX_DATA_INIT(CAboutDlg)
  //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAboutDlg)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
ON_WM_GETMINMAXINFO()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAztecMainDlg dialog

CAztecMainDlg::CAztecMainDlg(CWnd* pParent /*=NULL*/)
: CDialog(CAztecMainDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CAztecMainDlg)
  //}}AFX_DATA_INIT
  // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
  m_ChannelBar = NULL;
#if USE_SPACEBALL
  m_DevHdl = 0;
#endif
}

void CAztecMainDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAztecMainDlg)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAztecMainDlg, CDialog)
//{{AFX_MSG_MAP(CAztecMainDlg)
ON_WM_SYSCOMMAND()
ON_WM_PAINT()
ON_WM_QUERYDRAGICON()
ON_WM_WINDOWPOSCHANGED()
ON_WM_SHOWWINDOW()
ON_WM_LBUTTONDOWN()
ON_WM_KEYDOWN()
ON_WM_LBUTTONUP()
ON_WM_MBUTTONDOWN()
ON_WM_MBUTTONUP()
ON_WM_RBUTTONDOWN()
ON_WM_RBUTTONUP()
ON_WM_MOUSEMOVE()
ON_WM_TIMER()
ON_WM_CLOSE()
ON_WM_KEYUP()
ON_WM_MOUSEWHEEL()
ON_WM_DESTROY()
//}}AFX_MSG_MAP
ON_WM_CREATE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAztecMainDlg message handlers

LRESULT CAztecMainDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
  if (message == MM_UPDATEVIEWPORTS && m_Ready) {
    m_BottomToolDlg.m_TimeScroll.SetScrollRange( g_Scene->tickToFrame(g_Scene->getStartTime()) , 
                                                 g_Scene->tickToFrame(g_Scene->getEndTime()) );
    m_BottomToolDlg.UpdateScroller();
    g_ViewList.DrawAllViews();
  }
  
  if (message == MM_FILENAMECHANGED) {
    SetWindowText(MStr("Aztec ") + AZTEC_VERSION_NUMBER + " - " + g_CurFileName);
    
  }
  if (message == MM_STOPPLAY) {
  }
  if (message == MM_UPDATEFEEDBACK) {
    if (wParam & MMC_XLABEL || wParam & MMC_YLABEL || wParam & MMC_ZLABEL) {
      //         m_BottomToolDlg.SetXYZLabels(g_curx, g_cury, g_curz);
    }
  }
  if (message == MM_UPDATECHANNELBAR && m_Ready) {
    m_ChannelBar->channelBar.UpdateAllParams();
  }
  
  if (message == WM_INITMENU) {
    {
      // Create the materials menu if necessary
      if (!m_hMaterialsMenu) {
        m_hMaterialsMenu = ::CreatePopupMenu();
      }
      
      // Delete all the entries in a menu
      while (::DeleteMenu(m_hMaterialsMenu, 0, MF_BYPOSITION) == TRUE);
      
      // Go through the scene object list and add all the materials
      MBaseObjectPtr Obj;
      MMaterial      *Material;
      int            Count;
      
      Count = 0;
      
      g_Scene->getObjectList()->beginIteration();
      while ((Obj = g_Scene->getObjectList()->getNext()) != NULL) {
        Material = AZTEC_CAST(MMaterial, Obj);
        if (Material != NULL) {
          ::AppendMenu( m_hMaterialsMenu, 
                        MF_ENABLED | MF_STRING, 
                        MM_MATERIALS_MENUBASE+Count, 
                        (LPCTSTR)Material->getName());
          Count++;
        }
      }
      g_Scene->getObjectList()->endIteration();
      
      MENUITEMINFO      MenuInfo;
      
      MenuInfo.cbSize = sizeof(MENUITEMINFO);
      MenuInfo.fMask = MIIM_SUBMENU;
      MenuInfo.hSubMenu = m_hMaterialsMenu;
      SetMenuItemInfo(GetMenu()->m_hMenu, ID_MATERIALS_ASSIGNTOSELECTION, FALSE, &MenuInfo);
    }
    
    {
      // Create the materials menu if necessary
      if (!m_hPrimitivesMenu) {
        m_hPrimitivesMenu = ::CreatePopupMenu();
      }
      
      // Delete all the entries in a menu
      while (::DeleteMenu(m_hPrimitivesMenu, 0, MF_BYPOSITION) == TRUE);
      
      // Go through the scene object list and add all the materials
      MBaseObjectPtr Obj;
      int            Count;
      
      Count = 0;
      
      for (int i = 0; i < g_SysMan->getPluginManager()->getPrimitiveCount(); ++i) {
        ::AppendMenu(m_hPrimitivesMenu, MF_ENABLED | MF_STRING, MM_PRIMITIVES_MENUBASE+Count, g_SysMan->getPluginManager()->getPrimitive(i)->getName().c_str());

        Count++;
      }
      
      MENUITEMINFO      MenuInfo;
      
      MenuInfo.cbSize = sizeof(MENUITEMINFO);
      MenuInfo.fMask = MIIM_SUBMENU;
      MenuInfo.hSubMenu = m_hPrimitivesMenu;
      
      BOOL Res = SetMenuItemInfo(GetMenu()->m_hMenu, ID_PRIMITIVES_OBJECTS, FALSE, &MenuInfo);
    }
    
  }
  
  return CWnd::WindowProc(message, wParam, lParam);
}


class MultiLineEditListener : public MLogFileListener { 
public:

  MultiLineEditListener(HWND hWnd) 
    : hWnd(hWnd)
  {
  }

  void writeString(MLogFile *logfile, const std::string &text) {
    std::string result;

    int length = ::GetWindowTextLength(hWnd);
    char *buf = new char[length+1];
    memset(buf, 0, length+1);

    ::GetWindowText(hWnd, buf, length+1);
  
    result = buf;

    delete[] buf;
    // convert all of the \n's to \r\n's for the edit control
    for (int i = 0; i < text.length() ; ++i ) {
      if (text[i] == '\n') {
        result += "\r\n";
      } else {
        result += text[i];
      }
    }

    ::SendMessage(hWnd, WM_SETTEXT, 0, (long)result.c_str());

    int NumLines = SendMessage(hWnd, EM_GETLINECOUNT,0,0);

    SendMessage( hWnd, EM_LINESCROLL, 0 , NumLines);
  }
  
  void writeLine(MLogFile *logfile, const std::string &text) {
    writeString(logfile, text + "\n");
  }

private:

  HWND hWnd;
};


BOOL CAztecMainDlg::OnInitDialog() {
  CDialog::OnInitDialog();
  
//  InitialiseGlobals();

  m_Ready = false;
  m_MidPointMoveX = false;
  m_MidPointMoveY = false;
  
  // Initialise the menu item for the materials.
  m_hMaterialsMenu = NULL;
  m_hPrimitivesMenu = NULL;
  
  // Create the Console Editor Dialog
  
  m_ConsoleDlg.m_MainDlg = this;
  if (m_ConsoleDlg.m_hWnd == NULL) {
    m_ConsoleDlg.Create(IDD_CONSOLE_DIALOG, this);
  }

  g_SysMan->getLogger()->addListener(new MultiLineEditListener(m_ConsoleDlg.m_OutputEdit.m_hWnd));

  g_SysMan->logOutput("Initialising Views...");
  
  // Create the GL View windows.
  for(int i=0;i<4;i++) {
    g_Views[i] = new COpenGLWnd;
    g_Views[i]->Create(NULL, "GLView", WS_CHILD | WS_CLIPSIBLINGS|WS_DLGFRAME, CRect(10,10,500,500), this, 0);
    g_Views[i]->ViewCreate();
    g_Views[i]->ShowWindow(SW_SHOW);
    
    g_ViewList.AddView(g_Views[i]);
  }
  
  g_CurView = g_Views[0];
  KViewportTop();
  g_CurView = g_Views[1];
  KViewportFront();
  g_CurView = g_Views[2];
  KViewportRight();
  g_CurView = g_Views[3];
  KViewportPerspective();
  
  g_CurView = g_Views[0];
  
  g_SysMan->logOutput("Initialising Panels...");
  // Create Side tool panel tabs
  m_BottomToolDlg.Create(IDD_TOOLDLG_BOTTOM, this);
  m_BottomToolDlg.ShowWindow(SW_SHOW);
  m_TopToolDlg.Create(IDD_TOOLDLG_TOP, this);
  m_TopToolDlg.ShowWindow(SW_SHOW);

  RECT cbarRect = {0, 0, 64, 64};
  m_ChannelBar = new CChannelBarContainer();
  m_ChannelBar->Create(m_hWnd, cbarRect, "ChannelBar", WS_CLIPCHILDREN | WS_CHILD);
  m_ChannelBar->ShowWindow(SW_SHOW);
  
  g_Playing = 0;
  m_PlayTimerID = SetTimer(2000, 1000 / 30, NULL);
  
  m_ShelfMan.SetTabControl(&m_TopToolDlg.m_TabCtrl);
  
  m_ShelfMan.AddShelves(g_ProgSet.m_PrefsPath + "*.shelf");
  //   m_ShelfMan.AddShelf(g_ProgSet.m_PrefsPath + "Standard.shelf");
  //   m_ShelfMan.AddShelf(g_ProgSet.m_PrefsPath + "UVEdit.shelf");
  
  // Set the styles forthe buttons so they are two-state buttons
  // only set for the tool buts.
  
  // top dialog 
  AddWndStyle(m_TopToolDlg, IDC_OBJECTMODEBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_POINTMODEBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_FACEMODEBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_EDGEMODEBUT, BS_PUSHLIKE | BS_CHECKBOX);
  
  // Top dialog tool buttons
  AddWndStyle(m_TopToolDlg, IDC_SELECTTOOLBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_MOVETOOLBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_ROTATETOOLBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_SCALETOOLBUT, BS_PUSHLIKE | BS_CHECKBOX);
  AddWndStyle(m_TopToolDlg, IDC_LASTTOOLBUT, BS_PUSHLIKE | BS_CHECKBOX);
  
  // Bottom dialog tool buttons
  AddWndStyle(m_BottomToolDlg, IDC_ANIMATEBUT, BS_PUSHLIKE | BS_CHECKBOX);
  
  //   g_CurTool.Set(m_TopToolDlg, "Select");
  
  // Set Default Menu Items
  GetMenu()->EnableMenuItem(ID_EDIT_PASTE, MF_GRAYED);
  
  // set up the initial tools.
  KToolSelect();
  
  g_ChangesMade = 0;
  g_CurFileName = "Untitled";
  SendMessage(MM_FILENAMECHANGED,0,0);
  
  m_MidpointX = 0.5;
  m_MidpointY = 0.5;
  
  g_Scene->setTime(0);
  // Set the default range to be from 0 to 200 frames.
  g_Scene->setTimeRange(0, 200 * 3600 / g_Scene->getFramesPerSecond() );
  
  
  //	DragAcceptFiles(Handle, true);
  m_Closing = false;
  
  KModeObject();
  
  // Set the icon for this dialog.  The framework does this automatically
  //  when the application's main window is not a dialog
  SetIcon(m_hIcon, TRUE);			// Set big icon
  SetIcon(m_hIcon, FALSE);		// Set small icon
  
  // Set the icons for the window
  {
    HICON    hIcon;
    
    hIcon = (HICON)::LoadImage(AfxGetApp()->m_hInstance, (LPCTSTR)IDR_MAINFRAME, IMAGE_ICON, 16, 16, 0);
    int   Err = ::GetLastError();
    SetIcon(hIcon, FALSE);
    
    hIcon = (HICON)::LoadImage(AfxGetApp()->m_hInstance, (LPCTSTR)IDR_MAINFRAME, IMAGE_ICON, 32, 32, 0);
    SetIcon(hIcon, TRUE);
  }
  
  
  LoadConfigFromReg();
  
  // set up the initial tools.
  KToolSelect();
  
  
  // Create the Color Picker Dialog.
  g_ClrPickDlg = new CColorPickerDlg;
  g_ClrPickDlg->Create(IDD_COLOURPICKER_DIALOG);

  
	// load the initlisation script.
	std::string result;
	MScriptInterpreter::getInstance()->ExecuteScript("load('init.js');", result);

  return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAztecMainDlg::OnSysCommand(UINT nID, LPARAM lParam) {
  //	if ((nID & 0xFFF0) == IDM_ABOUTBOX) {
  //		CAboutDlg dlgAbout;
  //		dlgAbout.DoModal();
  //	}
  //	else
  {
    CDialog::OnSysCommand(nID, lParam);
  }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAztecMainDlg::OnPaint() {
  if (IsIconic()) {
    CPaintDC dc(this); // device context for painting
    
    SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
    
    // Center icon in client rectangle
    int cxIcon = GetSystemMetrics(SM_CXICON);
    int cyIcon = GetSystemMetrics(SM_CYICON);
    CRect rect;
    GetClientRect(&rect);
    int x = (rect.Width() - cxIcon + 1) / 2;
    int y = (rect.Height() - cyIcon + 1) / 2;
    
    // Draw the icon
    dc.DrawIcon(x, y, m_hIcon);
  } else {
    
    if (!m_Ready) {
      return;
    }
    
    m_BottomToolDlg.m_TimeScroll.SetScrollRange( g_Scene->tickToFrame(g_Scene->getStartTime()) , 
                                                 g_Scene->tickToFrame(g_Scene->getEndTime()) );
    
    if (g_Views[3]->m_RequireRedraw) {
      g_Views[3]->DrawView();
    }
    
    
    g_Views[0]->m_RequireRedraw = true;
    g_Views[1]->m_RequireRedraw = true;
    g_Views[2]->m_RequireRedraw = true;
    g_Views[3]->m_RequireRedraw = true;
    
    g_Resizing = false;
    
    CDialog::OnPaint();
  }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAztecMainDlg::OnQueryDragIcon() {
  return (HCURSOR) m_hIcon;
}


void CAztecMainDlg::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) {
  CDialog::OnWindowPosChanged(lpwndpos);
  
  RECT	ClientRect, BotDlgRect, TopDlgRect, ChannelBarRect;
  int   BotDlgHeight, TopDlgHeight;
  
  
  GetClientRect(&ClientRect);
  
  if (m_BottomToolDlg.m_hWnd) {
    m_BottomToolDlg.GetWindowRect(&BotDlgRect);
    BotDlgHeight = BotDlgRect.bottom - BotDlgRect.top;
  } else {
    BotDlgHeight = 0;
  }
  
  if (m_TopToolDlg.m_hWnd) {
    m_TopToolDlg.GetWindowRect(&TopDlgRect);
  TopDlgHeight = TopDlgRect.bottom - TopDlgRect.top;
  } else {
    TopDlgHeight = 0;
  }
  
  TopDlgRect.left = 0;
  TopDlgRect.right = ClientRect.right;
  TopDlgRect.top = 0;
  TopDlgRect.bottom = TopDlgHeight;
  
  // This is if you want the bottom bialog to extend all the way across the client window area
  
  if (m_TopToolDlg.m_hWnd) {
    m_TopToolDlg.MoveWindow(&TopDlgRect);
  }
  // Resize all controls on the window here
  
  ChannelBarRect.left = ClientRect.right - 2 - 180;
  ChannelBarRect.right = ClientRect.right - 2;
  ChannelBarRect.top = TopDlgRect.bottom + 2;
  ChannelBarRect.bottom = ClientRect.bottom - 2 - BotDlgHeight;

  if (m_ChannelBar != NULL && m_ChannelBar->m_hWnd != NULL) {
    m_ChannelBar->MoveWindow(&ChannelBarRect);
  }
  
  // Move the Other dialogs about the place.
  if (m_BottomToolDlg.m_hWnd) {
    m_BottomToolDlg.MoveWindow(0,ClientRect.bottom-BotDlgHeight,ClientRect.right - 2, BotDlgHeight);
  }
  //      m_BottomToolDlg.MoveWindow(0,ClientRect.bottom-BotDlgHeight,ChannelBarRect.left - 2, BotDlgHeight);
  
  
  DoResize();
}

BOOL CAztecMainDlg::OnCommand(WPARAM wParam, LPARAM lParam) {
  //   if (wParam == IDOK || wParam == IDCANCEL)
  //      return TRUE;
  {
    WORD     wNotifyCode, wID;
    DWORD    hCtrl;
    
    wNotifyCode = HIWORD(wParam);
    wID = LOWORD(wParam);
    hCtrl = lParam;
    
    if (wNotifyCode == 0) {     // 0 if the WM_COMMAND is from a menu
      if (hCtrl == 0) {  // Message received from menu
        hCtrl = (DWORD)::GetMenu(m_hWnd);
      }
      
      {
        MShiftState ShiftState;
        
        ShiftState.SetFromKeyState();
        if (ShiftState.m_Ctrl) {
          MAction  *Action;
          if (Action = g_KeyList.FindAction((HMENU)hCtrl, wID, "")) {
            g_ProgSet.ShowToolParameterEditWindow(Action->m_ActionName);
          }
        } else if (g_KeyList.ExecuteAction((HMENU)hCtrl, wID, "")) {
          return TRUE;
        }
      }
      
      // Check to see if this command is a mru selection
      if (wID >= ID_FILE_MRU_FILE1 && wID <= ID_FILE_MRU_FILE5) {
        if (KFileOpenMRU(wID - ID_FILE_MRU_FILE1)) {
          return TRUE;
        }
      }
      
      // check to see if we have clicked a Material to assign
      if (wID >= MM_MATERIALS_MENUBASE && wID < MM_MATERIALS_MENUBASE + 50) {
        char     Str[256];
        GetMenuString(m_hMaterialsMenu, wID, Str, 256, MF_BYCOMMAND);
        
        g_MaterialToAssign = Str;
        
        KAssignMaterialToSelection();
      }
      
      // check to see if we have clicked a Material to assign
      if (wID >= MM_PRIMITIVES_MENUBASE && wID < MM_PRIMITIVES_MENUBASE + 50) {
        char objectType[256];
        GetMenuString(m_hPrimitivesMenu, wID, objectType, 256, MF_BYCOMMAND);
        
        MBaseObjectPtr Obj;
        Obj = g_SysMan->getPluginManager()->createObjectFromDefault(objectType);

        bool needsUpdate = false;

        // if we have a scene object, select it
        if (AZTEC_CAST(MSceneObject, Obj) != NULL) {
          MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, Obj);
          g_Scene->selectNone();
          g_Scene->selectObject(sceneObj);
     
          needsUpdate = true;

          // first check to see if our primitive is a shape object. If it is
          // make a scene object, and connect them up.
        } else if (AZTEC_CAST(MShapeObject, Obj) != NULL) {
          MShapeObjectPtr shapeObj = AZTEC_CAST(MShapeObject, Obj);
          MSceneObjectPtr sceneObj = new MSceneObject();
          shapeObj->setName(MStr(objectType) + "Shape");
          sceneObj->setName(objectType);
          sceneObj->setShapeObject(shapeObj);
          
          g_Scene->addObject(sceneObj);
          
          g_Scene->selectNone();
          g_Scene->selectObject(sceneObj);
          
          needsUpdate = true;
        } else {

          // if we haven't got a shape object, then check for a mesh creator instead
          MMeshCreatorPtr meshCreator = AZTEC_CAST(MMeshCreator, Obj);
          if (meshCreator != NULL) {
            MShapeObjectPtr shapeObj = new MMeshShape();
            MSceneObjectPtr sceneObj = new MSceneObject();
            shapeObj->setName(MStr(objectType) + "Shape");
            sceneObj->setName(objectType);
            sceneObj->setShapeObject(shapeObj);
            meshCreator->setName(MStr(objectType) + "Creator");

            shapeObj->findParameter("inMesh")->setInputParameter(meshCreator->getOutputParameter());

            g_Scene->addObject(sceneObj);
        
            g_Scene->selectNone();
            g_Scene->selectObject(sceneObj);

            needsUpdate = true;
          }
        }

        if (needsUpdate) {
          SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
          SendMessage(MM_UPDATECHANNELBAR, 0, 0);
        }
      }
      
      
    }
    
  }
  
  return CDialog::OnCommand(wParam, lParam);
}

void CAztecMainDlg::WasOnShowWindow() {
  // Load program settings from registry
  
  m_Ready = true;
  
  
  // This loads any files specefied by the command line params
  
  UpdateMenuMRU();
  CCommandLineInfo   CmdLine;
  
  AfxGetApp()->ParseCommandLine(CmdLine);
  
  if (CmdLine.m_strFileName != "") {
    
  }
  
  /*
  if (ParamStr(1) != "")
  {
  LoadFile(ParamStr(1));
  CurFileName = ParamStr(1);
  MainForm->Caption = MStr("Quake Model Editor - ") + CurFileName;
  
    CalcViewportWidthHeight();
    
      NextBut->Enabled=true;
      PrevBut->Enabled=true;
      FrameLabel->Caption = g_CurFrame;
      NameLabel->Caption = g_CurMdl.GetFrameName(g_CurFrame);
      FitButtonClick(Sender);
      
        SkinEditForm->FormPaint(this);
        SendMessage(WM_PAINT);
        }
  */
}

void CAztecMainDlg::DoResize() {
  CalcViewportWidthHeight();
  DoViewPortSize();
}

void CAztecMainDlg::CalcViewportWidthHeight() {
  RECT  ViewsRect;
  
  ViewsRect = GetViewportsRect();
  
  m_VWidthL =  (int)((ViewsRect.right - ViewsRect.left - VIEWEDGE_SIZE)*m_MidpointX);
  m_VWidthR =  (int) (ViewsRect.right - ViewsRect.left - VIEWEDGE_SIZE) - m_VWidthL;
  m_VHeightT = (int)((ViewsRect.bottom - ViewsRect.top - VIEWEDGE_SIZE)*m_MidpointY);
  m_VHeightB = (int) (ViewsRect.bottom - ViewsRect.top - VIEWEDGE_SIZE) - m_VHeightT;
  
  m_VWidthL2 = m_VWidthL/2;
  m_VWidthR2 = m_VWidthR/2;
  m_VHeightT2 = m_VHeightT/2;
  m_VHeightB2 = m_VHeightB/2;
}

RECT CAztecMainDlg::GetViewportsRect() {
  RECT  ClientRect, ViewsRect;
  
  GetClientRect(&ClientRect);
  
  ViewsRect = ClientRect;
  
  // Do the windows on the left hand side
  ViewsRect.left += 2;
  
  // Do the windows on the right hand side
  ViewsRect.right -= 5;
  
  if (m_ChannelBar != NULL && ::IsWindow(m_ChannelBar->m_hWnd)) {
    RECT  ChannelRect;
    m_ChannelBar->GetClientRect(&ChannelRect);
    ViewsRect.right -= ChannelRect.right;
  }
  
  // do the windows at the top
  // ViewsRect.top += 
  {
    RECT  TopPanelRect;
    
    if (::IsWindow(m_hWnd) && ::IsWindow(m_TopToolDlg.m_hWnd)) {      
      m_TopToolDlg.GetWindowRect(&TopPanelRect);
      ScreenToClient(&TopPanelRect);
      ViewsRect.top += TopPanelRect.bottom;
    }
  }
  
  // Do the windows at the bottom
  ViewsRect.bottom -= m_BottomToolDlg.GetHeight() + 3;
  
  return ViewsRect;
}

void CAztecMainDlg::DoViewPortSize() {
  if (!m_Ready) return;
  
  RECT     ViewsRect;
  
  ViewsRect = GetViewportsRect();
  
  int FullScreen = -1;
  for (int i=0;i<4;i++) {
    if (g_Views[i] != NULL && g_Views[i]->isFlagged(GLVIEW_FLAGS_FULLSCREEN)) {
      FullScreen = i;
      break;
    }
  }
  if (FullScreen != -1) {
    for (int i=0;i<4;i++) {
      if (g_Views[i] != NULL && i != FullScreen) {
        g_Views[i]->ShowWindow(SW_HIDE);
        g_Views[i]->MoveWindow(0,0,0,0);
      }
    }
  }
  if (FullScreen == -1) {
    for (int i=0;i<4;i++) {
      if (g_Views[i] != NULL) {
        g_Views[i]->ShowWindow(SW_SHOW);
      }
    }
  }
  
  if (FullScreen == -1) {
    if (g_Views[0] != NULL) {
      g_Views[0]->MoveWindow((int)(ViewsRect.left+VIEWEDGE_SIZE/2), (int)(ViewsRect.top+VIEWEDGE_SIZE/2), m_VWidthL, m_VHeightT);
    }
    if (g_Views[0] != NULL) {
      g_Views[1]->MoveWindow((int)(ViewsRect.left+VIEWEDGE_SIZE/2), (int)(ViewsRect.top+m_VHeightT+VIEWEDGE_SIZE), m_VWidthL, m_VHeightB);
    }
    if (g_Views[0] != NULL) {
      g_Views[2]->MoveWindow((int)(ViewsRect.left+m_VWidthL+VIEWEDGE_SIZE), (int)(ViewsRect.top+m_VHeightT+VIEWEDGE_SIZE), m_VWidthR, m_VHeightB);
    }
    if (g_Views[0] != NULL) {
      g_Views[3]->MoveWindow((int)(ViewsRect.left+m_VWidthL+VIEWEDGE_SIZE), (int)(ViewsRect.top+VIEWEDGE_SIZE/2), m_VWidthR, m_VHeightT);
    }
  } else if (g_Views[FullScreen] != NULL) {
    g_Views[FullScreen]->MoveWindow((int)(ViewsRect.left+VIEWEDGE_SIZE/2), (int)(ViewsRect.top+VIEWEDGE_SIZE/2), m_VWidthL + m_VWidthR, m_VHeightT+m_VHeightB);
  }
}

void CAztecMainDlg::OnShowWindow(BOOL bShow, UINT nStatus) {
  CDialog::OnShowWindow(bShow, nStatus);
  
  if (!m_Ready) {
    WasOnShowWindow();
  }
}

bool CAztecMainDlg::tryAccellerator(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	m_KeyState.SetFromKeyState();
	
    bool s,a,c;
    s = m_KeyState.m_Shift;
    a = m_KeyState.m_Alt;
    c = m_KeyState.m_Ctrl;
    
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"General")) return true;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Main")) return true;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Display")) return true;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Window")) return true;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"View")) return true;
    
    // Final Catch all
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"")) return true;
	
	return false;
}

void CAztecMainDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  // If we aren't a valud window yet, we can't really do anything.
  if (!::IsWindow(m_hWnd)) {
    return;
  }

  SetFocus();
  // Set up the ctrl, shift, and alt members of the m_KeyState object.
  
  m_KeyState.SetFromKeyState();
  
  {
    bool s,a,c;
    s = m_KeyState.m_Shift;
    a = m_KeyState.m_Alt;
    c = m_KeyState.m_Ctrl;
    
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"General")) return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Main")) return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Display")) return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"Window")) return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"View")) return;
    
    // Final Catch all
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"")) return;
  }
  
  CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CAztecMainDlg::MouseUp(MShiftState Shift, int X, int Y) {  
  int      ClientWidth, ClientHeight;
  RECT     ClientRect;
  
  GetWindowRect(&ClientRect);
  ClientWidth = ClientRect.right;
  ClientHeight = ClientRect.bottom;
  
  bool Update = false;
  
  if (!Shift.m_Left) {
    m_MidPointMoveX = false;
    m_MidPointMoveY = false;
  }
  
  if ((Shift.m_Left || Shift.m_Right || Shift.m_Mid) == false) {
  }
  
  ReleaseCapture();
  
}

void CAztecMainDlg::MouseDown(MShiftState Shift, int X, int Y) {
  SetCapture();
  
  int      ClientWidth, ClientHeight;
  RECT     ClientRect;
  
  GetWindowRect(&ClientRect);
  ClientWidth = ClientRect.right;
  ClientHeight = ClientRect.bottom;
  
  if (Shift.m_Left) {
    int      CentreX, CentreY;
    RECT     ViewsRect;
    
    ViewsRect = GetViewportsRect();
    
    CentreX = m_VWidthL + VIEWEDGE_SIZE/2 + ViewsRect.left;
    CentreY = m_VHeightT + VIEWEDGE_SIZE/2 + ViewsRect.top;
    
    if (abs(X - CentreX) < VIEWEDGE_SIZE) {
      m_MidPointMoveX = true;
    }
    if (abs(Y - CentreY) < VIEWEDGE_SIZE) {
      m_MidPointMoveY = true;
    }
  }
  
}

void CAztecMainDlg::OnLButtonDown(UINT nFlags, CPoint point) {
  m_ShiftState.m_Left = true;
  m_ShiftState.SetFromFlags(nFlags);
  
  MouseDown(m_ShiftState, point.x, point.y); 
  
  CDialog::OnLButtonDown(nFlags, point);
}

void CAztecMainDlg::OnLButtonUp(UINT nFlags, CPoint point) {
  m_ShiftState.m_Left = false;
  m_ShiftState.SetFromFlags(nFlags);
  
  MouseUp(m_ShiftState, point.x, point.y); 
  
  
  CDialog::OnLButtonUp(nFlags, point);
}

void CAztecMainDlg::OnMButtonDown(UINT nFlags, CPoint point) {
  m_ShiftState.m_Mid = true;
  m_ShiftState.SetFromFlags(nFlags);
  
  MouseDown(m_ShiftState, point.x, point.y); 
  
  
  CDialog::OnMButtonDown(nFlags, point);
}

void CAztecMainDlg::OnMButtonUp(UINT nFlags, CPoint point) {
  m_ShiftState.m_Mid = false;
  m_ShiftState.SetFromFlags(nFlags);
  
  MouseUp(m_ShiftState, point.x, point.y); 
  
  
  CDialog::OnMButtonUp(nFlags, point);
}

void CAztecMainDlg::OnRButtonDown(UINT nFlags, CPoint point) {
  m_ShiftState.m_Right = true;
  m_ShiftState.SetFromFlags(nFlags);
  
  MouseDown(m_ShiftState, point.x, point.y); 
  
  
  CDialog::OnRButtonDown(nFlags, point);
}

void CAztecMainDlg::OnRButtonUp(UINT nFlags, CPoint point) {
  m_ShiftState.m_Right = false;
  m_ShiftState.SetFromFlags(nFlags);
  
  if (g_MainAction != atNone) {
    MouseUp(m_ShiftState, point.x, point.y); 
  } else {
    CDialog::OnRButtonUp(nFlags, point);
  }
}

void CAztecMainDlg::OnMouseMove(UINT nFlags, CPoint point) {
  int   X,Y;
  int   ClientWidth, ClientHeight;
  RECT  ClientRect, ViewsRect;
  MShiftState Shift;
  
  Shift.SetFromFlags(nFlags);
  
  GetClientRect(&ClientRect);
  ClientWidth = ClientRect.right;
  ClientHeight = ClientRect.bottom;
  
  X = point.x;
  Y = point.y;
  
  ViewsRect = GetViewportsRect();
  
  if ( m_MidPointMoveX || m_MidPointMoveY) {
    if (m_MidPointMoveX && m_MidPointMoveY) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZEALL));
    } else if (m_MidPointMoveX) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZEWE));
    } else if (m_MidPointMoveY) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZENS));
    } else {
      ::SetCursor(LoadCursor(NULL, IDC_ARROW));
    }
    
    if (m_MidPointMoveX) {
      m_MidpointX = (float)(X-ViewsRect.left)/(float)(ViewsRect.right-ViewsRect.left);
    }
    if (m_MidPointMoveY) {
      m_MidpointY = (float)(Y-ViewsRect.top)/(float)(ViewsRect.bottom - ViewsRect.top);
    }
    if (m_MidpointX < 0) {
      m_MidpointX = 0;
    }
    if (m_MidpointY < 0) {
      m_MidpointY = 0;
    }
    if (m_MidpointX > 1) {
      m_MidpointX = 1;
    }
    if (m_MidpointY > 1) {
      m_MidpointY = 1;
    }
    
    DoResize();
    
    return;

  } else {
    int      CentreX, CentreY;
    RECT     ViewsRect;
    bool     SizeX =false, SizeY = false;
    
    ViewsRect = GetViewportsRect();
    
    CentreX = m_VWidthL + VIEWEDGE_SIZE/2 + ViewsRect.left;
    CentreY = m_VHeightT + VIEWEDGE_SIZE/2 + ViewsRect.top;
    
    if (abs(X - CentreX) < VIEWEDGE_SIZE) {
      SizeX = true;
    }
    if (abs(Y - CentreY) < VIEWEDGE_SIZE) {
      SizeY = true;
    }
    
    if (SizeX && SizeY) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZEALL));
    } else if (SizeX) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZEWE));
    } else if (SizeY) {
      ::SetCursor(LoadCursor(NULL, IDC_SIZENS));
    } else {
      ::SetCursor(LoadCursor(NULL, IDC_ARROW));
    }
  }
  
  bool Update = false;
  
  CDialog::OnMouseMove(nFlags, point);
}


void CAztecMainDlg::OnTimer(UINT nIDEvent) {
  if (nIDEvent == 2000) { // the playback animation timer
    static int lastSystemTime = ::GetTickCount();
    int curSystemTime = ::GetTickCount();
    int timeDiff = curSystemTime - lastSystemTime;

    // update the last System time.  
    lastSystemTime = ::GetTickCount();
    
    // is the camera playing
    if (g_Playing) {
      int timeLength = g_Scene->getEndTime() - g_Scene->getStartTime();

      int curTime = g_Scene->getTime();
      // we want to advance (curSystemTime - lastSystemTime) / 1000.0 seconds ahead
      int newTime = curTime + 3600 * timeDiff / 1000.0;

      newTime = (newTime - g_Scene->getStartTime()) % timeLength + g_Scene->getStartTime() ;

      // Set the new time, and update the viewports.
      g_Scene->setTime( newTime );
      ::SendMessage(m_hWnd, MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    }

  }
  
  CDialog::OnTimer(nIDEvent);
}

UINT CAztecMainDlg::IsMenuChecked(UINT IDItem) {
  return GetMenu()->GetMenuState(IDItem, MF_CHECKED) & MF_CHECKED;
}

UINT CAztecMainDlg::ToggleMenuChecked(UINT IDItem) {
  if (IsMenuChecked(IDItem)) {
    return GetMenu()->CheckMenuItem(IDItem, MF_UNCHECKED);
  } else {
    return GetMenu()->CheckMenuItem(IDItem, MF_CHECKED);
  }
}

void CAztecMainDlg::OnClose() {
  g_Closing = true;
  
	if (KFileExit() == 0) {
		return;
	}

  // Note: We need to delete the parameters before clearing out some of the other
  // parts of Aztec.  Not sure which of the lines below is the one causing the
  // problem, but if this statement is after "g_SysMan = NULL", then we get
  // an access violation on exit when a plugin has added something to the
  // channel bar.
  if (m_ChannelBar != NULL) {
    m_ChannelBar->channelBar.DeleteAllParams();
    m_ChannelBar->DestroyWindow();
    delete m_ChannelBar;
    m_ChannelBar = NULL;
  }

  g_SysMan->getLogger()->removeAllListeners();
  g_SysMan->logOutput("Set output to NULL");
  
  KillTimer(m_PlayTimerID);
  SaveConfigToReg();
  g_SysMan->logOutput("config saved");
  
  m_ShelfMan.DeleteAllShelves();
  g_SysMan->logOutput("Shelves deleted");
  m_ShelfMan.SetTabControl(NULL);
  g_SysMan->logOutput("Tab Control set to NULL");
  
  CleanUpGlobals();
  g_SysMan->logOutput("Globals Clean");

  // remove our system manager first
  g_SysMan = NULL;

  // then clean up the global system manager
  MSystemManager::cleanInstance();

//  PostMessage(WM_QUIT);

/*
  for (int i=0;i<4;i++) {
    if (g_Views[i] != NULL) {
      g_Views[i]->DestroyWindow();
    }
  }
  
  if (m_ChannelBar != NULL) {
    m_ChannelBar->DestroyWindow();
    delete m_ChannelBar;
    m_ChannelBar = NULL;
  }
*/
#if 0 && USE_SPACEBALL
	// Close connection to the 3DxWare driver.
	if (m_DevHdl != NULL) {
		SiClose (m_DevHdl);
		m_DevHdl = NULL;
	}
#endif

//  DestroyWindow();
  CDialog::OnClose();
  PostQuitMessage(0);
}

void CAztecMainDlg::LoadConfigFromReg() {
  g_SysMan->logOutput("Loading Registry Settings from %s", "Software\\MartinTools\\Aztec\\1.0\\");
  
  g_ProgSet.LoadFromRegistry("Software\\MartinTools\\Aztec\\1.0\\");
  
  g_SysMan->logOutput("Loading Configuration from %s", (LPCTSTR)MStr(g_ProgSet.m_PrefsPath + g_ProgSet.m_CFGFile));
  ReadConfigFile(g_ProgSet.m_PrefsPath + g_ProgSet.m_CFGFile);
  
  InitActionList();
  
  g_ActionList.Sort();
  g_KeyList.m_Actions = &g_ActionList;
  
  g_SysMan->logOutput("Loading Keyboard Configuration from %s", (LPCTSTR)MStr(g_ProgSet.m_PrefsPath + g_ProgSet.m_KEYFile));
  g_KeyList.LoadFromFile(g_ProgSet.m_PrefsPath + g_ProgSet.m_KEYFile);
  
  g_KeyList.UpdateAllMenus();
  
  
  return;
  
}

void CAztecMainDlg::SaveConfigToReg() {
  g_ProgSet.SaveToRegistry("Software\\MartinTools\\Aztec\\1.0\\");
  
  WriteConfigFile((LPCTSTR)(g_ProgSet.m_PrefsPath+g_ProgSet.m_CFGFile));
  g_KeyList.SaveToFile((LPCTSTR)(g_ProgSet.m_PrefsPath+g_ProgSet.m_KEYFile));
}


BOOL CAztecMainDlg::PreTranslateMessage(MSG* pMsg) {
	// If the intended window is once of the Views, don't process the message.
    LONG  WndStyle;
    
    WndStyle = GetWindowLong(pMsg->hwnd, GWL_STYLE);
    if (!(WndStyle & ES_AUTOHSCROLL)) {
		if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_KEYUP) {
#if 0
			if (((pMsg->lParam & (1 <<31)) >> 31) != 0) {
				if (tryAccellerator(pMsg->wParam,pMsg->lParam & 0x0F,(pMsg->lParam&0xF0) >> 4)) {
					return 1;
				}
			}
#else
			if (((pMsg->lParam & (1 <<31)) >> 31) != 0) {
				OnKeyDown(pMsg->wParam,pMsg->lParam & 0x0F,(pMsg->lParam&0xF0) >> 4);
			}
			
			return 1;
#endif
		}
	}

#if 0 && USE_SPACEBALL
	SiSpwEvent event; /* 3DxWare Event */
	SiGetEventData eData; /* 3DxWare Event Data */

	if (m_DevHdl != 0) {
		// Check if this is a 3DxWare event
		SiGetEventWinInit (&eData, pMsg->message, pMsg->wParam, pMsg->lParam);
		if (SiGetEvent (m_DevHdl, 0, &eData, &event) == SI_IS_EVENT) {
			switch (event.type) {
			case SI_MOTION_EVENT:
				break;

			case SI_ZERO_EVENT:
				break;

			case SI_BUTTON_EVENT:
				break; 

			default:
				break;
			}

			return 1;
		}
	}

#endif
	
	// Call CWnd::PreTranslate message so we do not get the special dialog message handling
	return CWnd::PreTranslateMessage(pMsg);         
}

void CAztecMainDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) {
  // If we aren't a valud window yet, we can't really do anything.
  if (!::IsWindow(m_hWnd)) {
    return;
  }

  SetFocus();
  if (nChar == VK_CONTROL) { // control key
    m_KeyState.m_Ctrl = false;
    CDialog::OnKeyUp(nChar, nRepCnt, nFlags);
    return;
    
  }
  if (nChar == VK_SHIFT) { // shift key
    m_KeyState.m_Shift = false;
    CDialog::OnKeyUp(nChar, nRepCnt, nFlags);
    return;
  }
  
  CDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CAboutDlg::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) {
  //   lpMMI->ptMinTrackSize.x = 
  
  CDialog::OnGetMinMaxInfo(lpMMI);
}

void CAztecMainDlg::AddToMRUList(MStr Str) {
  int There = -1;
  for (int i=0;i<g_MRU_Count;i++) {
    if (g_MRUList[i] == Str) {
      There = i;
      break;
    }
  }
  if (There == -1) {
    for (int i=g_MRU_Count-1;i>0;i--) {
      g_MRUList[i] = g_MRUList[i-1];
    }
  } else for (int i=There;i>0;i--) {
    g_MRUList[i] = g_MRUList[i-1];
  }
  
  g_MRUList[0] = Str;
  
  UpdateMenuMRU();
}

void CAztecMainDlg::UpdateMenuMRU() {
  CMenu    *FileMenu;
  int      InsertPos, n;
  
  FileMenu = GetMenu()->GetSubMenu(0);
  if (!FileMenu) {
    return;
  }
  
  FileMenu->DeleteMenu(ID_FILE_MRU_FILE1, MF_BYCOMMAND);
  FileMenu->DeleteMenu(ID_FILE_MRU_FILE2, MF_BYCOMMAND);
  FileMenu->DeleteMenu(ID_FILE_MRU_FILE3, MF_BYCOMMAND);
  FileMenu->DeleteMenu(ID_FILE_MRU_FILE4, MF_BYCOMMAND);
  FileMenu->DeleteMenu(ID_FILE_MRU_FILE5, MF_BYCOMMAND);
  
  InsertPos = FileMenu->GetMenuItemCount() - 2;
  
  for (n=g_MRU_Count-1;n>=0;n--) {
    if (g_MRUList[n].GetLength() > 0) {
      MStr  Text;
      
      Text.Format("&%i   %s", n+1, (LPCTSTR)g_MRUList[n]);
      FileMenu->InsertMenu(InsertPos, MF_BYPOSITION, ID_FILE_MRU_FILE1 + n, Text);
    }
  }
  
}

BOOL CAztecMainDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) {  
  if (zDelta>0) {
    KViewportZoomIn();
  } else if (zDelta < 0) {
    KViewportZoomOut();
  }
  
  return CDialog::OnMouseWheel(nFlags, zDelta, pt);
}

void CAztecMainDlg::OnDestroy() {
  // clean up any menu that has been created
  if (m_hMaterialsMenu != NULL) {
    ::DestroyMenu(m_hMaterialsMenu);
  }
  if (m_hPrimitivesMenu != NULL) {
    ::DestroyMenu(m_hPrimitivesMenu);
  }

  PostQuitMessage(0);

  for (int i=0;i<4;i++) {
    if (g_Views[i] != NULL) {
      g_Views[i]->DestroyWindow();
    }
  }

  m_ShelfMan.DeleteAllShelves();

  CDialog::OnDestroy();

}



int CAztecMainDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
 #if 0 && USE_SPACEBALL
	// Not needed?  Put into each view that needs it?
	SiOpenData oData; // OS Independent data to open device.
	SiOpenWinInit (&oData, m_hWnd); // Initialize Windows specific data.
	if ((m_DevHdl = SiOpen("Aztec", SI_ANY_DEVICE, SI_NO_MASK, SI_EVENT, &oData)) == NULL ) {
		// SiTerminate(); // Shut down the 3DxWare input library
		// MessageBox("No supported 3DxWare device available.\n", NULL, MB_OK);
	} else {
		// Turn the driver GUI on.
		SiSetUiMode (&m_DevHdl, SI_UI_ALL_CONTROLS);
	}
#endif

	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}
