#include <AztecMainPCH.h>
#include <MSelectTool.h>

// AztecMain includes
#include <MDLGlobs.h>

// AztecLib includes
#include <MUIManager.h>

//-------------------
//  MSelectToolType
//-------------------
MSelectToolType::MSelectToolType() {
  setName("KToolSelect");
  justCancelled = false;
}

void MSelectToolType::initialise() {
  justCancelled = false;
}

bool MSelectToolType::cancel() {
  // if we have already cancelled the tool, then we go back to object mode.
  if (justCancelled && 
      Aztec::MUIManager::getComponentMode() == Aztec::MUIManager::POINT_MODE) {
    g_KeyList.ExecuteAction("KModeObject"); 

    justCancelled = false;
  } else {
    g_KeyList.ExecuteAction("KEditSelectNone"); 
    justCancelled = true;
  }

  // return false because we are not finished with this tool.
  return false;
}

int MSelectToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  // If we are in select mode, no need to draw anything
  if (Select)
    return 1;
  
  // Check to see if the mouse buttons are down.
  COpenGLWnd     *GLWnd;
  
  if (View != g_CurView)
    return 1;
  
  GLWnd = AZTEC_CAST(COpenGLWnd, View);
  
  if (GLWnd == NULL)
    return 0;
  
  if (m_Dragging)
  {
    RECT        WindowRect;
    
    WindowRect = GLWnd->m_WindowRect;
    
    glPushAttrib(GL_ENABLE_BIT);
    glDisable(GL_DEPTH_TEST);
    
    glDisable(GL_LIGHTING);
    glDisable(GL_DEPTH_TEST);
    
    // Push the projection stack, so we can draw using screen coordinates
	   glMatrixMode(GL_PROJECTION);
     glPushMatrix();
     
     glViewport(0,0,WindowRect.right, WindowRect.bottom);
     
     glLoadIdentity();
     
     glOrtho(0,WindowRect.right,0,WindowRect.bottom,-20,20);
     
     glMatrixMode(GL_MODELVIEW);
     glPushMatrix();
     
     glLoadIdentity();
     
     
     // Draw the actual selection box
     glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
     glLineWidth(1);
     glColor3f(0.0f, 0.8f, 0.6f);
     
     glBegin(GL_LINE_LOOP);
     
     glVertex2f(m_DownPos.x,WindowRect.bottom-m_DownPos.y);
     glVertex2f(m_DownPos.x,WindowRect.bottom-m_CurPos.y);
     glVertex2f(m_CurPos.x,WindowRect.bottom-m_CurPos.y);
     glVertex2f(m_CurPos.x,WindowRect.bottom-m_DownPos.y);
     
     glEnd();
     
     // Clean up this mess matrix wise
     glMatrixMode(GL_PROJECTION);
     glPopMatrix();
     
     glMatrixMode(GL_MODELVIEW);
     glPopMatrix();
     
     glPopAttrib();
  }
  
  return 1;
}

int MSelectToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseDown(X, Y, Shift);
  
  justCancelled = false;

  m_Selecting = false;
  m_Deselecting = false;
  
  
  m_BoxSelect = false;
  m_Deselecting = false;
  
  if (Shift.m_Left)
  {
    if (Shift.m_Shift)
      m_Deselecting = true;
    else
      m_Selecting = true;
  }
  
  return TOOLRESULT_DRAWALL;
}

int MSelectToolType::onMouseUp(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseUp(X, Y, Shift);

  justCancelled = false;
  
  // Check to see if the mouse buttons are down.
  if (m_Selecting == false && m_Deselecting == false) {
    return TOOLRESULT_DRAWNONE;
  }
  
  COpenGLWnd     *GLWnd;
  
  GLWnd = AZTEC_CAST(COpenGLWnd, g_CurView);
  
  if (GLWnd == NULL) {
    return TOOLRESULT_DRAWNONE;
  }
  
  bool              TargetSel, ToggleSel;
  int               SelChanged;
  
  // check to see if all the mouse buttons are up
  if (Shift.m_Left || Shift.m_Mid || Shift.m_Right) {
    return TOOLRESULT_DRAWNONE;
  }
  
  if (Shift.m_Ctrl && !m_BoxSelect) {
    ToggleSel = true;
  } else {
    ToggleSel = false;
  }
  
  // If we are not holding ctrl, clear the selection
  if (!Shift.m_Ctrl && !Shift.m_Shift)
    g_Scene->selectNone();
  
  MSelectMethod method;
  // select all the objects in the selection
  if (m_Deselecting) {
    TargetSel = false;
    if (m_BoxSelect) {
      method = smDeselectBox;
    } else {
      method = smDeselect;
    }
  } else {
    TargetSel = true;
    if (m_BoxSelect) {
      method = smSelectBox;
    } else {
      method = smSelect;
    }
  }
  
  if (m_BoxSelect) {
    GLWnd->performSelection(m_DownPos.x, m_DownPos.y, X, Y, &m_InputList);
  } else {
    GLWnd->performSelection(X, Y, &m_InputList);
  }
  
  // Go through and select the required objects
  MBaseObjectPtr Obj;
  

  for (int i = 0; i < m_InputList.size(); ++i) {
    MSelectionItem *SelItem = &m_InputList[i];
    
    if (SelItem->getNumComponents() == 0) {
      if (ToggleSel) {
        SelChanged = true;
        
        g_Scene->selectObject(SelItem->getObject(), !SelItem->getObject()->isFlagged(OBJECTFLAG_SELECTED));
      } else {
        if (SelItem->getObject()->isFlagged(OBJECTFLAG_SELECTED) != TargetSel)
          SelChanged = true;
        g_Scene->selectObject(SelItem->getObject(), TargetSel);
      }
    } else {
      MSceneObjectPtr SelObj;
      MComponentisedObjectPtr compObj;
      AztecFlags CompMode;
      MComponentisedObject::MAction action;
      
      if (ToggleSel) {
        action = MComponentisedObject::atToggle;
      } else {
        action = TargetSel ? MComponentisedObject::atSet : MComponentisedObject::atUnset;
      }
      
      SelObj = AZTEC_CAST(MSceneObject, SelItem->getObject());
      
      if (SelObj != NULL) {
        compObj = SelObj->getComponentObject();
        
        for (int n=0; n<SelItem->getNumComponents(); n++) {
          int Num;
          AztecFlags Mode;
          
          SelItem->getComponent(n, Mode, Num);
          
          if (Mode == SELECTITEM_VERTEX) {
            CompMode = MComponentisedObject::POINT_TYPE;
          } else if (Mode == SELECTITEM_FACE) {
            CompMode = MComponentisedObject::FACET_TYPE;
          } else if (Mode == SELECTITEM_EDGE) {
            CompMode = MComponentisedObject::EDGE_TYPE;
          }
          
          if (compObj != NULL) {
            SelChanged = compObj->flagComponent(CompMode, 
                                                Num, 
                                                MComponentisedObject::COMPONENT_SELECTED,
                                                action);

//            if (Mode == SELECTITEM_FACE) {
//              meshObj->flagPolygon(Num, TRIANGLE_SELECTED, TargetSel ? MMesh::atSet : MMesh::atUnset);
//            }
//          } else {
//            SelChanged = SelObj->selectComponent(CompMode, Num, TargetSel);
          }
        }
      }
      
    }
  }
  
  return TOOLRESULT_DRAWALL;
}

int MSelectToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseMove(X, Y, Shift);

  MUIManager::unsetCoordinates();
  
  if (Shift.m_Right || Shift.m_Mid)
    m_Dragging = false;
  if (!Shift.m_Left)
    m_Dragging = false;
  
  if (m_Dragging)
  {
    m_BoxSelect = true;
    return TOOLRESULT_DRAWCURRENT;
  }
  
  return TOOLRESULT_DRAWNONE;
}


