#ifndef _3DSTRANSLATOR_H
#define _3DSTRANSLATOR_H

#include <translator/MSceneTranslator.h>

#define USE_LIB3DS 1

#if USE_LIB3DS
#include "lib3ds/file.h"
#endif

using namespace Aztec;

class M3DSTranslator : public MSceneTranslator {
protected:
#if USE_LIB3DS
	MScenePtr mScene;
	Lib3dsFile *file;

	void BuildLight(Lib3dsLight *light);
	void BuildCamera(Lib3dsCamera *cam);
	void BuildTexture(Lib3dsMaterial *mat);
	bool convert_to_meshes();
#else
  int Parse3DSChunk(int hFile, MScenePtr Scene, int &BytesRead);
  int ParseObjectChunk(int hFile, MScenePtr Scene, int &BytesRead, int Length);
#endif
  
public:
  M3DSTranslator();
  virtual ~M3DSTranslator();
  
  // Class related
  virtual MStr getClassName() {return MStr("M3DSTranslator");};
  virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
  virtual MTranslatorPtr createNew() const;
  
  std::string getFilter() { return "*.3DS"; }
  std::string getFilterDescription() { return "3D Studio Files"; }
  virtual bool canImport() {return true;};
  virtual bool canExport() {return false;};
  virtual bool canImportFile(MStr Filename);
  
  virtual bool importFile(MStr Filename, MScenePtr Scene);
  virtual bool exportFile(MStr Filename, MScenePtr Scene);
};

#endif
