#ifndef PCXTRANSLATOR_H
#define PCXTRANSLATOR_H

#include <translator/MImageTranslator.h>
#include <string>

class DevilTranslator : public Aztec::MImageTranslator {
protected:

public:
  typedef enum { BMP, CHEAD, JPG, OIL, PCX, PNG, PNM, RAW, SGI, TGA, TIF } FileType;
  
  DevilTranslator(FileType type);
  ~DevilTranslator();
  
  // MBaseObject methods
  MStr getClassName();
  MStr getParentClassName() {return MStr("MImageTranslator");}
  Aztec::MTranslatorPtr createNew() const;
  
  // MImageTranslator methods
  std::string getFilter();
  std::string getFilterDescription();
  bool canImport();
  bool canExport();
  bool canImportFile(MStr Filename);
  
  bool importFile(MStr Filename, Aztec::MImagePtr Image);
  bool exportFile(MStr Filename, Aztec::MImagePtr Image);

private:
  void setup(const std::string &filterDesc, const std::string &filter, const std::string &className, bool isImportable, bool isExportable, unsigned int devilID);
  FileType fileType;
  std::string filter;
  std::string filterDesc;
  std::string className;
  bool isImportable;
  bool isExportable;
  unsigned int devilID;
};

#endif
