#! /bin/sh
#
# Aztec 3D Modeller, (c) Phillip Martin, 2003
#
#
# This script will generate the templates needed
# to create the configure and make files.
#

# Set variables for this script
AUTOCONFIG_DIR="config"
SRC_DIR="dirname $0"

set -x


# Create a config directory to put our scripts in
# mkdir -p $AUTOCONFIG_DIR


# TODO: Because Automake doesn't support wildcards
#       we will have to automate the addition of new
#       source files ourselves.


# Put the scripts into a seperate /config
# directory to keep everything more clean

aclocal

# Scan through all Aztec headers and find out what
# is needed by Aztec (headers, standard functions, etc)

autoheader

# Add libtool support

libtoolize --automake --copy --force

# Create all makefiles from the Makefile.am in
# each directory

automake --add-missing --copy --foreign

# Create the final configure script that will check
# if everything that Aztec needs is installed on the
# users system

autoconf

