function onChange(combobox, initialIndex, output, caption) {
	output.value = "Accepted! - " + combobox.value + " - index = " + combobox.index;
}

function createItem(container, caption, width) {
  var label = new MLabel(caption);
  var comboBox = new MComboBox("", width);
  var output = new MTextField("output goes here", 30);

  comboBox.add("value 1");
  comboBox.add("value 2");
  comboBox.add("value 3");
  comboBox.add("value 4");
  comboBox.add("value 5");
  comboBox.add("value 6");

  comboBox.index = initialIndex;

  container.addComponent(label);
  container.addComponent(comboBox);
  container.addComponent(output);

  comboBox.addListener(onChange, output, caption);
}

function comboBoxesExample() {

  var mainWindow = new MWindow();
  // the flow layout takes three args, the x and y margins, 
  // and then the number of components per row
  mainWindow.setLayoutManager(new MFlowLayout(2,2,3));

  createItem(mainWindow, 0, "Label 1", 15);
  createItem(mainWindow, 1, "Label 2", 10);
  createItem(mainWindow, 2, "Label 3", 12);

  mainWindow.setSize(mainWindow.getMinimumSize());
  mainWindow.setVisible(true);	


}

comboBoxesExample();