// MedDLeDoc.cpp : implementation of the CMedDLeDoc class
//

#include "stdafx.h"
#include "MedDLe.h"
//#include "CameraView.h"
#include "ChildFrm.h"
#include "2DView.h"
#include "MedDLeIO.h"
#include "GameDlg.h"
#include "MedDLeEdit.h"		// Our added graphics routines

//jedi knight
#include "FileIO/IO3DO.h"
//quake2
#include "FileIO/IOMD2.h"
// 3dstudio asc
#include "FileIO/IOASC.h"
// quake1
#include "FileIO/IOMDL.h"


//enum filetypes {MDL,BMP,GIF,PCX,ASC,_RAW,_3DS};

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// file extra stuff
#define MDLX_VERSION 1
#define TAG_BASE 0
#define TAG_MAPGEN 1
#define TAG_BONES 2
#define TAG_GROUPS 3
/////////////////////////////////

BYTE magic[]="ZWMM";
float zwmm_version=4.0;

/////////////////////////////////////////////////////////////////////////////
// CMedDLeDoc

IMPLEMENT_DYNCREATE(CMedDLeDoc, CDocument)

BEGIN_MESSAGE_MAP(CMedDLeDoc, CDocument)
	//{{AFX_MSG_MAP(CMedDLeDoc)
	ON_COMMAND(ID_FILE_EXPORTFRAME, OnFileExportframe)
	ON_COMMAND(ID_FILE_IMPORTFRAME, OnFileImportframe)
	ON_COMMAND(ID_EDIT_ROTATE, OnEditRotate)
	ON_COMMAND(ID_EDIT_SCALE, OnEditScale)
	ON_COMMAND(ID_FILE_EXPORTSKIN, OnFileExportskin)
	ON_COMMAND(ID_FILE_IMPORTSKIN, OnFileImportskin)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_2_COPYFRAME, OnCopyframe)
	ON_COMMAND(ID_2_DELETEFRAME, On2Deleteframe)
	ON_COMMAND(ID_2_PASTEFRAME, On2Pasteframe)
	ON_UPDATE_COMMAND_UI(ID_2_PASTEFRAME, OnUpdate2Pasteframe)
	ON_COMMAND(ID_FILE_SETTINGS, OnFileSettings)
	ON_COMMAND(ID_FILE_SETGAME, OnFileSetgame)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_EDIT_PASTENEW, OnEditPastenew)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTENEW, OnUpdateEditPastenew)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_COMMAND(ID_EDIT_SELECTNONE, OnEditSelectnone)
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectall)
	ON_COMMAND(ID_XYZ_XLOCK, OnXyzXlock)
	ON_UPDATE_COMMAND_UI(ID_XYZ_XLOCK, OnUpdateXyzXlock)
	ON_COMMAND(ID_XYZ_YLOCK, OnXyzYlock)
	ON_UPDATE_COMMAND_UI(ID_XYZ_YLOCK, OnUpdateXyzYlock)
	ON_COMMAND(ID_XYZ_ZLOCK, OnXyzZlock)
	ON_UPDATE_COMMAND_UI(ID_XYZ_ZLOCK, OnUpdateXyzZlock)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMedDLeDoc construction/destruction

CMedDLeDoc::CMedDLeDoc()
{
//AfxMessageBox("ctor doc");
	//AfxMessageBox("Doc Start Construct");
	CString strSection       = "Pref";

	m_MedDLeObject.m_curFrame=NULL;
	m_MedDLeObject.m_curFrameN=-1;
	//set up views
	//  [view][axis]=[x,y,z]
	AxisMap[0][0]=1; AxisDir[0][0]=1;//x
	AxisMap[0][1]=0; AxisDir[0][1]=-1;//y
	AxisMap[1][0]=0; AxisDir[1][0]=1;//x
	AxisMap[1][1]=2; AxisDir[1][1]=1;//z
	AxisMap[2][0]=1; AxisDir[2][0]=1;//y
	AxisMap[2][1]=2; AxisDir[2][1]=1;//z
	
	Extent[0][0]=50.f;
	Extent[0][1]=50.f;
	Extent[1][0]=50.f;
	Extent[1][1]=50.f;
	Extent[2][0]=50.f;
	Extent[2][1]=50.f;
	
	Center[0][0]=0.f;
	Center[0][1]=0.f;
	Center[1][0]=0.f;
	Center[1][1]=0.f;
	Center[2][0]=0.f;
	Center[2][1]=0.f;
	
	Zoom[0]=1.f;
	Zoom[1]=1.f;
	Zoom[2]=1.f;

//	m_Grid.b3DVisible=1;
//	m_Grid.fSize[0] = m_Grid.fSize[1] = m_Grid.fSize[2] = 100;
	
	m_Grid.fSpacing = m_Grid.fSpacing = m_Grid.fSpacing = 10;
	m_Grid.bSnap=0;	
	m_Grid.bVisible=1;
	m_Grid.bAxis=1;

	
	// init model variables



   CWinApp* pApp = AfxGetApp();
	
/*
	tcolor=1;
	bcolor=7;
	AnimationPlaying=0;	
*/
	// 3d stuff
	fill_mode=pApp->GetProfileInt(strSection, "FillMode", 4);
//	Rflags=pApp->GetProfileInt(strSection, "Rflags", R_GRID);
	back_color=pApp->GetProfileInt(strSection, "BackColor", 0);

	light_intensity=pApp->GetProfileInt(strSection, "LightAmbient", 50);
	ambient_intensity=pApp->GetProfileInt(strSection, "LightSpot", 24);
	Restrict[0]=pApp->GetProfileInt(strSection, "Lock1", 0);
	Restrict[1]=pApp->GetProfileInt(strSection, "Lock2", 0);
	Restrict[2]=pApp->GetProfileInt(strSection, "Lock3", 0);
//	Vflags[0]=pApp->GetProfileInt(strSection, "Vflag1", R_SOLID|R_VERT);
//	Vflags[1]=pApp->GetProfileInt(strSection, "Vflag2", R_SOLID|R_VERT|R_FB);
//	Vflags[2]=pApp->GetProfileInt(strSection, "Vflag3", R_SOLID|R_VERT);
//	ClearBlue=pApp->GetProfileInt(strSection, "ClearBlue", 1);
	Scale =2.f;

//	Gflags=pApp->GetProfileInt(strSection, "Gflags", 0);
//	EditMode = pApp->GetProfileInt(strSection, "EditMode", SM_VERT);
//	TriAdd=FALSE;
//	Skeleton.cnt=0;
//	SkelAction=BA_TRANS;
//	SkelOptions=0;
//	curParentBone=-1;
//	curChildBones.RemoveAll();
	//AfxMessageBox("Doc Finish Construct");


}

CMedDLeDoc::~CMedDLeDoc()
{

	// write profile strings
	CString strSection = "Pref";
	theApp.WriteProfileString(strSection, "LastDoc", GetPathName());
  
}

//////////////////////////////////////////
/////////// NEW DOC

BOOL CMedDLeDoc::OnNewDocument()
{

	if (!CDocument::OnNewDocument()) return FALSE;

	m_MedDLeObject.m_Frames.RemoveAll();

	CMedDLeFrame *f = new CMedDLeFrame("frame1");

	m_MedDLeObject.m_Frames.Add(f);

	//m_MedDLeObject.m_curFrameN=0;
	m_MedDLeObject.m_curFrame=f;

	ParseAnimationInfo();

	SetTitle("Untitled");
	return TRUE;
}

//-----------------------------------------------------------
// M D L  F i l e  I O
//
/*
#define MDL_VERSION 6
#define MDL_ONSEEM  32
#define MDL_ONFRONT 1
BOOL CMedDLeDoc::WriteMDL(LPCTSTR lpszPathName)
{
/*	FILE *out;
	if((out=fopen(lpszPathName,"wb"))==NULL) return FALSE;
	fputc('I',out);
	fputc('D',out);
	fputc('P',out);
	fputc('O',out);
	unsigned version = VERSION;
	fwrite(&version,4,1,out);
	/// that ends the header
	float scale[3];
	float offset[3];
	float rad;
	GetMDLScaleOffRad(scale,offset,&rad);

	fwrite(scale,sizeof(float),3,out);
	fwrite(offset,sizeof(float),3,out);
	fwrite(&rad,sizeof(float),1,out);

	fwrite(Eye,sizeof(float),3,out);
	fwrite(&num.skins,4,1,out);
	fwrite(&SkinW,4,1,out);
	fwrite(&SkinH,4,1,out);
	fwrite(&num.vertices,4,1,out);
	fwrite(&num.triangles,4,1,out);
	fwrite(&num.frames,4,1,out);

	fwrite(&sync_type,4,1,out); // sync type, either 0 or random
	fwrite(&flags,4,1,out);    // flags
    fwrite(&ave_size,sizeof(float),1,out);       // average size  pixels/triangle?

	unsigned k;
	unsigned i,j;
	unsigned cnt=0;
	unsigned gcnt=0;
	for(k=0; k<num.skins; k++)
	{	
		fwrite(&Skins[cnt]->type,4,1,out);
		if(Skins[cnt]->type==0)
		{
			fwrite(Skins[cnt]->bitmap,1,SkinW*SkinH,out);
			cnt++;
		}
		else
		{
			SkinGroup *msg;
			msg=SkinGroups[gcnt];
			gcnt++;
			fwrite(&msg->skins,4,1,out);
	
			for(j=0; j<msg->skins; j++)
			{
				fwrite(&Skins[cnt+j]->tcode,sizeof(float),1,out);
			}
			for(j=0; j<msg->skins; j++)
			{   
				fwrite(Skins[cnt]->bitmap,1,SkinW*SkinH,out);
				cnt++;
			}
		}
	}
	// now the 2d vertices
	for(i=0;i<num.vertices;i++)
	{
		fwrite(&Verts[i].Mflags,4,1,out);
		fwrite(&Verts[i].x,4,1,out);
		fwrite(&Verts[i].y,4,1,out);
	}

	// now triange definitions
	for(i=0;i<num.triangles;i++)
	{
		fwrite(&Tris[i].flags,4,1,out);
		fwrite(&Tris[i].vindex[0],4,3,out);
	}

	// now frames
	cnt=0;
	gcnt=0;
	for(k=0; k<num.frames;  k++)
	{
		fwrite(&Frames[cnt]->type,4,1,out);
		// not grouped
		if(Frames[cnt]->type==0)
		{	
			Frame *mf=Frames[cnt];
			cnt++;
			fwrite(&mf->bboxmin,1,4,out);
			fwrite(&mf->bboxmax,1,4,out);
			fwrite(mf->name,1,16,out);
			for(i=0;i<num.vertices;i++)
			{
				fwrite(mf->tv+i,1,4,out);
			}
		}
		//grouped frames
		else
		{
			FrameGroup *mfg= FrameGroups[gcnt];
			gcnt++;
			fwrite(&mfg->frames,4,1,out);
			fwrite(&mfg->bboxmin,1,4,out);
			fwrite(&mfg->bboxmax,1,4,out);
			
			for(j=0; j<mfg->frames; j++)
			{
				fwrite(&Frames[cnt+j]->tcode,sizeof(float),1,out);
			}
	
			for(j=0; j<mfg->frames; j++)
			{
				fwrite(&Frames[cnt]->bboxmin,1,4,out);
				fwrite(&Frames[cnt]->bboxmax,1,4,out);
				fwrite(Frames[cnt]->name,1,16,out);
				
				for(i=0;i<num.vertices;i++)
				{
					fwrite(Frames[cnt]->tv+i,1,4,out);
				}
				cnt++;
			}
		}
	}

	fclose(out);
	return TRUE;
	*/
//return FALSE;
//}

BOOL CMedDLeDoc::ReadMM(LPCSTR lpszPathName)
{
	int i,j,k;
//	AfxMessageBox("read mm");

	CFile f;
	DWORD fsize=sizeof (float);
	DWORD dsize=sizeof (DWORD);
	DWORD isize=sizeof (int);

	char null=0;

	if( !f.Open( lpszPathName,CFile::modeRead ) ) 
	{
		return FALSE;
	}
//	CArchive ar( &f, CArchive::load );
		
		
	f.Read(magic,4);
	float readversion;
	f.Read(&readversion,isize);

	char tmpname[256];
	// base frame
	int itemp;

	f.Read(&itemp,isize);
	f.Read(tmpname, itemp);
//AfxMessageBox("4name");
//if(m_MedDLeObject.m_BaseFrame)
	m_MedDLeObject.m_BaseFrame->name=tmpname;
//else {AfxMessageBox("shit"); return 0;}

	int frames, verts, faces;

	f.Read(&frames,isize);
	f.Read(&verts,isize);
	f.Read(&faces,isize);

	m_MedDLeObject.m_BaseFrame->v.RemoveAll();
	m_MedDLeObject.m_BaseFrame->f.RemoveAll();
	m_MedDLeObject.m_BaseFrame->l.RemoveAll();

	CMedDLeBaseVertex bv;
	for (i=0; i<verts; i++)
	{
	    f.Read(&bv.flags,dsize);				// Flags
		f.Read(&bv.group,dsize);				// Object & Group ID#s
		f.Read(&bv.bone,dsize);				// Skeleton Segment ID#
		f.Read(&bv.color,dsize);
		m_MedDLeObject.m_BaseFrame->v.Add(bv);
	}
//AfxMessageBox("basev");

	CMedDLeFace ff;
	int pt[6];
	for (i=0; i<faces; i++)
	{
		f.Read(ff.vindex, 3*dsize);		// Three Vertexes
		f.Read(&ff.flags, dsize);			// Flags Including FRONT
		f.Read(&ff.group, dsize);			// Flags Including FRONT
		f.Read(&ff.color, dsize);			// Flags Including FRONT
		f.Read(&ff.tx, 6*sizeof(float));			// Flags Including FRONT

		f.Read(&ff.texture, dsize);			// Flags Including FRONT
		m_MedDLeObject.m_BaseFrame->f.Add(ff);
	}


	m_MedDLeObject.m_Frames.RemoveAll();


	CMedDLeVertex v;
	for (i=0; i<frames; i++)
	{
		f.Read(&itemp,isize);
		f.Read(tmpname, itemp);

		CMedDLeFrame *mf = new CMedDLeFrame(tmpname); 

		// now vertices
		float ff[3];
		for (j=0; j<verts; j++)
		{
			f.Read(ff, 3*fsize);
			v.x[0]=ff[0];
			v.x[1]=ff[1];
			v.x[2]=ff[2];
			mf->v.Add(v);
		}
		m_MedDLeObject.m_Frames.Add(mf);
	}

	m_MedDLeObject.m_curFrameN=0;
	m_MedDLeObject.m_curFrame=m_MedDLeObject.m_Frames[0];
//AfxMessageBox("linestart");

	AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
		
	f.Close();


	return TRUE;
}

BOOL CMedDLeDoc::WriteMM(LPCSTR lpszPathName)
{
	int i,j,k;
	DWORD fsize=sizeof (float);
	DWORD dsize=sizeof (DWORD);
	DWORD isize=sizeof (int);

	char null=0;

	CFile f;

	if( !f.Open( lpszPathName,CFile::modeCreate | CFile::modeReadWrite | CFile::modeNoTruncate ) ) 
	{
		return FALSE;
	}
	//CArchive ar( &f, CArchive::store);
		
		
	f.Write(magic,4);
	f.Write(&zwmm_version,fsize);

// object
	
//	CArray <CMedDLeMeshAnimation*, CMedDLeMeshAnimation*>m_Anims;

	// quake =1, quake2 =2 jk =3 hexen =4

	f.Write(&m_MedDLeObject.m_game,sizeof(DWORD));
	f.Write(&m_MedDLeObject.m_bValidSkin,sizeof(BOOL));
	f.Write(&m_MedDLeObject.m_nSkinWidth,sizeof(int));
	f.Write(&m_MedDLeObject.m_nSkinHeight,sizeof(int));
	f.Write(&m_MedDLeObject.m_bSaveSkins,sizeof(BOOL));
	
	// base frame
	int itemp;
	itemp=(int)m_MedDLeObject.m_BaseFrame->name.GetLength();
	itemp++;
	if(itemp>256) itemp=256;
	f.Write(&itemp,isize);
	f.Write(m_MedDLeObject.m_BaseFrame->name.GetBuffer(0), itemp-1);
	f.Write(&null,1);

	itemp=m_MedDLeObject.m_Frames.GetSize();
	f.Write(&itemp,isize);
	itemp=m_MedDLeObject.m_BaseFrame->v.GetSize();
	f.Write(&itemp,isize);
	itemp=m_MedDLeObject.m_BaseFrame->f.GetSize();
	f.Write(&itemp,isize);


		for (i=0; i<m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
		{
		    f.Write(&m_MedDLeObject.m_BaseFrame->v[i].flags,dsize);				// Flags
			f.Write(&m_MedDLeObject.m_BaseFrame->v[i].group,dsize);				// Object & Group ID#s
			f.Write(&m_MedDLeObject.m_BaseFrame->v[i].bone,dsize);				// Skeleton Segment ID#
			f.Write(&m_MedDLeObject.m_BaseFrame->v[i].color,dsize);
		}
		for (i=0; i<m_MedDLeObject.m_BaseFrame->f.GetSize(); i++)
		{
			f.Write(m_MedDLeObject.m_BaseFrame->f[i].vindex, 3*dsize);		// Three Vertexes
			f.Write(&m_MedDLeObject.m_BaseFrame->f[i].flags, dsize);			// Flags Including FRONT
			f.Write(&m_MedDLeObject.m_BaseFrame->f[i].group, dsize);			// Flags Including FRONT
			f.Write(&m_MedDLeObject.m_BaseFrame->f[i].color, dsize);			// Flags Including FRONT
			f.Write(m_MedDLeObject.m_BaseFrame->f[i].tx, 6*sizeof(float));			// Flags Including FRONT
			f.Write(&m_MedDLeObject.m_BaseFrame->f[i].texture, dsize);			// Flags Including FRONT
		}

		for (i=0; i<m_MedDLeObject.m_Frames.GetSize(); i++)
		{
			itemp=(int)m_MedDLeObject.m_Frames[i]->name.GetLength();
			itemp++;
			if(itemp>256) itemp=256;
			f.Write(&itemp,isize);
			f.Write(m_MedDLeObject.m_Frames[i]->name.GetBuffer(0), itemp-1);
			f.Write(&null,1);

			// now vertices
			for (j=0; j<m_MedDLeObject.m_Frames[i]->v.GetSize(); j++)
				f.Write(m_MedDLeObject.m_Frames[i]->v[j].x, 3*fsize);
		}


	f.Close();
	return TRUE;
}
/*
*/
void CMedDLeDoc::Serialize(CArchive& ar)
{;}


/////////////////////////////////////////////////////////////////////////////
// CMedDLeDoc commands
#include "meddleGFX/MedDLeGFX.h"

BOOL CMedDLeDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{

	FILE *in;
	if((in=fopen(lpszPathName,"rb"))==NULL) return FALSE;
	
	CString fpath;
	fpath=lpszPathName;
	char type[4];
	fread(type,1,4,in);
	rewind(in);
	fclose(in);
	char str[128];
	strcpy(str,lpszPathName);
	int iex=fpath.ReverseFind('.');
	CString ext;
	if(iex==-1)
	{
		ext="";
	}
	else
	{
		ext=fpath.Right(fpath.GetLength()-iex-1);
	}
	// if an meddle model
	if((type[0]=='Z')&&(type[1]=='W')&&(type[2]=='M')&&(type[3]=='M'))
	{
		// use serialize call
		if(!ReadMM(lpszPathName))
		{ 
			AfxMessageBox("Error reading file."); 
			return FALSE;
		}
		else
		{
			theApp.AddToRecentFileList(lpszPathName);
			return TRUE;
		}

	}	
	// if an id mdl file..
	else if((type[0]=='I')&&(type[1]=='D')&&(type[2]=='P')&&(type[3]=='O'))
	{

		if(IOMDLRead(lpszPathName, m_MedDLeObject))
		{

			// set the palette for all skins
			int N=m_MedDLeObject.m_BaseFrame->t.GetSize();
			BYTE pp[256*3];
			FILE *p;
	
			CString str,last;
			str=theApp.GetProfileString("games\\quake", "palette", "");
			str.TrimRight(); str.TrimLeft();
//			last = str.Right(1);
			if(str.GetLength()==0) str="games/quake/palette.lmp";

			if((p=fopen(str,"rb"))!=NULL)
			{
//				AfxMessageBox("k");
				fread(pp,1,256*3,p);
				fclose(p);
				for(int i=0; i<N; i++)
				{
					RGBQUAD *palette = m_MedDLeObject.m_BaseFrame->t[i]->colors;

			        int palindex;
					for(palindex = 0; palindex < 256; palindex++)
					{
				        palette[palindex].rgbRed       = pp[palindex*3];
					    palette[palindex].rgbGreen     = pp[palindex*3+1];
				        palette[palindex].rgbBlue      = pp[palindex*3+2];
						palette[palindex].rgbReserved  = 0;
			        }
				}
			}else
			{
				for(int i=0; i<N; i++)
				{
					RGBQUAD *palette = m_MedDLeObject.m_BaseFrame->t[i]->colors;

			        int palindex;
					for(palindex = 0; palindex < 256; palindex++)
					{
		          palette[palindex].rgbRed       = MedDLePalette[palindex*3];
		          palette[palindex].rgbGreen     = MedDLePalette[palindex*3+1];
		          palette[palindex].rgbBlue      = MedDLePalette[palindex*3+2];
		          palette[palindex].rgbReserved  = 0;
			        }
				}

			}
			m_MedDLeObject.m_curFrameN=0;
			m_MedDLeObject.m_curFrame=m_MedDLeObject.m_Frames[0];
			AutoCreateObjects(*m_MedDLeObject.m_BaseFrame);
			AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
			ParseAnimationInfo();
			theApp.AddToRecentFileList(lpszPathName);
			return TRUE;
		}
		else
		{
			AfxMessageBox("Error reading file."); 
			return FALSE;
		}

	}
	// if an id md2 file..
	else if((type[0]=='I')&&(type[1]=='D')&&(type[2]=='P')&&(type[3]=='2'))
	{

		if(IOMD2Read(lpszPathName, m_MedDLeObject))
		{
			m_MedDLeObject.m_curFrameN=0;
			m_MedDLeObject.m_curFrame=m_MedDLeObject.m_Frames[0];
			AutoCreateObjects(*m_MedDLeObject.m_BaseFrame);
			AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
			ParseAnimationInfo();
			theApp.AddToRecentFileList(lpszPathName);
			return TRUE;
		}
		else
		{
			AfxMessageBox("Error reading file."); 
			return FALSE;
		}

	}
	else if(ext.CompareNoCase("3do")==0)
	{
		if(IO3DORead(lpszPathName, m_MedDLeObject,0))
		{
			m_MedDLeObject.m_curFrameN=0;
			m_MedDLeObject.m_curFrame=m_MedDLeObject.m_Frames[0];
			AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
			ParseAnimationInfo();
			theApp.AddToRecentFileList(lpszPathName);
			return 1;
		}
		else 
		{
			AfxMessageBox("Error reading file."); 
			return FALSE;
		}
	}

	/*	else
	{
		// see if file extension is supported
		CString extn;
		char *extn1;
		extn1=strstr(lpszPathName,".");
		extn = extn1;
		extn.MakeLower();

		if(	!strncmp(extn.GetBuffer(1),".asc",4) )
		{
			AfxMessageBox("Sorry, asc reader disabled"); 
			return FALSE;
			//export_mdl_frame(str.GetBuffer(1), cur.frameptr, this);
		}
		else if(!strncmp(extn.GetBuffer(1),".raw",4)|| !strncmp(extn.GetBuffer(1),".cob",4)||
			!strncmp(extn.GetBuffer(1),".dxf",4)|| !strncmp(extn.GetBuffer(1),".3ds",4)||
			!strncmp(extn.GetBuffer(1),".pov",4)|| !strncmp(extn.GetBuffer(1),".nff",4)|| 
			!strncmp(extn.GetBuffer(1),".obj",4) || !strncmp(extn.GetBuffer(1),".wtk",4)|| 
			!strncmp(extn.GetBuffer(1),".wrl",4))
		{


			Clear();
			XRoad_Reader((GNode*) this,lpszPathName,"include"); //fileDlg.GetPathName(),"include"))
			m_RawData.RemoveAll();
			xroad2mdl();
			NewFrameFromXRoad(lpszPathName);
			InitModelVars();
			Gflags &= ~S_IS_MDL;
			Gflags &= ~S_HAS_SKIN;
			BaseFromFrame(0);
			MapGenFromFrame(-1);
			MakeSkinMapping(); // this removes all skins!
			fill_mode=1;
			return TRUE;
		}
*/	else 
	{
		AfxMessageBox("Unsupported File type.");
		return FALSE;
	}
	

	return 0;
}

// used to save file as an MDL. use export frame for other single frame formats
void CMedDLeDoc::OnFileSaveAs() 
{

	CString Filter("MedDLe Model (*.mm) | *.mm |");
	Filter+="Quake2 Model (*.md2)|*.md2|";
	Filter+="3D Studio Ascii (*.asc)|*.asc|";
//	Filter+="Quake Model (*.mdl)|*.mdl|";
	Filter+="|";
	
//	Filter+="3D Studio Object (*.3ds)|*.3ds|";
//	Filter+="3D Studio Ascii (*.asc)|*.asc|";
//	Filter+="AutoCAD DXF (*.dxf)|*.dxf|";
//	Filter+="POVRay V2.2 File (*.pov)|*.pov|";
//	Filter+="POVRay V2.2 Include (*.inc)|*.inc|";
//	Filter+="RAW Object (*.raw)|*.raw|";
  //	Filter+="Truespace Object (*.cob)|*.cob|";
 	//Filter+="VRML (*.wrl)|*.wrl|";
//  	Filter+="Wavefront Object (*.obj)|*.obj|";
//	Filter+="WorldToolkit Object (*.nff)|*.nff|";
//	Filter+="All Files (*.*) | *.* ||";

	CFileDialog fileDlg(FALSE, NULL,"*.mm",OFN_HIDEREADONLY| OFN_OVERWRITEPROMPT,Filter);
	
	if(fileDlg.DoModal()==IDOK)
	{

		//CString extn;
		char str[_MAX_PATH];
		strcpy(str,fileDlg.GetPathName());
		char *extn1;
		CString name;//, extn;
		name = fileDlg.GetPathName();
		extn1=strstr(str,".");
		// if there isn't a typed in extension, put one on! (unless it is *.* filter, then save as mdl
		if((extn1==NULL)&&(fileDlg.m_ofn.nFilterIndex!=1))
		{
			switch(fileDlg.m_ofn.nFilterIndex)
			{

			case 0: break;
			case 1: name += ".mm";	break;
			case 2: name += ".asc"; break;

			}
		}

		int w=name.ReverseFind('.');
		CString ex;
		ex=name.Right(name.GetLength()-w);
		if(ex.CompareNoCase(".mm")==0)
		{
			if(!WriteMM(name))
			{
				AfxMessageBox("Couldn't write file");
			}
			else 
			{
				SetPathName(name);
				theApp.AddToRecentFileList(name);
  			}
		}
		else if(ex.CompareNoCase(".md2")==0)
		{
			if(!IOMD2Write(name, m_MedDLeObject))
			{
				AfxMessageBox("Error writing file."); 
			}
			else 
			{
//				SetPathName(name);
//				theApp.AddToRecentFileList(name);
			}
		}
		else if(ex.CompareNoCase(".asc")==0)
		{
			if(!IOASCWrite(name, m_MedDLeObject))
			{
				AfxMessageBox("Error writing file."); 
			}
			else 
			{
//				SetPathName(name);
//				theApp.AddToRecentFileList(name);
			}
		}

	}
}
//		if((extn1==NULL)&&(fileDlg.m_ofn.nFilterIndex!=2))
//		{
			//switch(fileDlg.m_ofn.nFilterIndex)
			//{
			//case 0: case 1: 
//				filename += ".mdl"; //break;
//			case 2: filename += ".3ds";  AfxMessageBox("1");break;
//			case 3: filename += ".asc";  AfxMessageBox("1");break;
//			case 4: filename += ".dxf"; AfxMessageBox("1");break;
//			case 5: filename += ".pov"; AfxMessageBox("1");break;
//			case 6: filename += ".inc"; AfxMessageBox("1");break;
//			case 7: filename += ".raw"; AfxMessageBox("7");break;
//			case 8: filename += ".cob"; break;
//			case 9: filename += ".wrl"; break;
//			case 10: filename += ".obj"; break;
//			case 11: filename += ".nff"; break;
			//}
			//extn1=strstr(filename.GetBuffer(1),".");
//		}

//		extn = extn1;
//		extn.MakeLower();
		
//		if(	!strncmp(extn,".wrl",4)|| !strncmp(extn,".asc",4) )
//		{
//			AfxMessageBox("Use Export Frame to save as .wrl or .asc");
//			return;
//		}
		// if using xroad format
/*
		else if(!strncmp(extn,".raw",4)|| !strncmp(extn,".cob",4)||
			!strncmp(extn,".dxf",4)|| !strncmp(extn,".3ds",4)||
			!strncmp(extn,".pov",4)|| !strncmp(extn,".nff",4)|| 
			!strncmp(extn,".obj",4) || !strncmp(extn,".wtk",4))
		{
			Clear();
			if(Frames.GetSize()>1) 
			{
				if(AfxMessageBox("Only the current frame will be saved. Skin will be lost.",MB_OKCANCEL)!=IDOK) return;
			}
			mdl2xroad();
			XRoad_Writer((GNode*) this, filename);
			//////// reset model to new format
			DeleteContents();
			Clear();
			XRoad_Reader((GNode*) this, filename,"include"); //fileDlg.GetPathName(),"include"))
			m_RawData.RemoveAll();
			xroad2mdl();
			NewFrameFromXRoad(filename);
			InitModelVars();
			Gflags &= ~S_IS_MDL;
			Gflags &= ~S_HAS_SKIN;
			MakeSkinMapping(); // this removes all skins!
			BaseFromFrame(0);
			fill_mode=1;
			UpdateAllViews(NULL);
		}

*/
		
// if using mdl format
	//	else
/*	//	{
		if(MapGen==NULL) MapGenFromFrame(-1); // -1 means use Base
			
		if(	!(Gflags&S_HAS_SKIN) ) //make a skin
		{
			MakeSkinMapping();
		}

		MakeMDL();

		WriteMDL(filename.GetBuffer(1));
	//	}
		SetPathName(filename);
	}	

*/	


void CMedDLeDoc::OnFileSave() 
{


	CString name;
	name=GetPathName();
//	CString extn;

//	char *extn1;
//	extn1=strstr(name,".");
//	extn = extn1;
//	extn.MakeLower();
//	if(	!strncmp(extn.GetBuffer(1),".wrl",4)|| !strncmp(extn.GetBuffer(1),".asc",4) )
//	{
//		export_mdl_frame(str.GetBuffer(1), cur.frameptr, this);
//	}
//	else if(!strncmp(extn.GetBuffer(1),".raw",4)|| !strncmp(extn.GetBuffer(1),".cob",4)||
//		!strncmp(extn.GetBuffer(1),".dxf",4)|| !strncmp(extn.GetBuffer(1),".3ds",4)||
//		!strncmp(extn.GetBuffer(1),".pov",4)|| !strncmp(extn.GetBuffer(1),".nff",4)|| 
//		!strncmp(extn.GetBuffer(1),".obj",4) || !strncmp(extn.GetBuffer(1),".wtk",4))
//	{
/*		Clear();
		if(Frames.GetSize()>1) 
		{
			if(AfxMessageBox("Only the current frame will be saved. Skin will be lost.",MB_OKCANCEL)!=IDOK) return;
		}
		mdl2xroad();
		XRoad_Writer((GNode*) this, str);
		//////// reset model to new format
		DeleteContents();
		Clear();
		XRoad_Reader((GNode*) this, str,"include"); //fileDlg.GetPathName(),"include"))
		m_RawData.RemoveAll();
		xroad2mdl();
		NewFrameFromXRoad(str);
		InitModelVars();
		Gflags &= ~S_IS_MDL;
		Gflags &= ~S_HAS_SKIN;
		MakeSkinMapping(); // this removes all skins!
		BaseFromFrame(0);
		fill_mode=1;
		UpdateAllViews(NULL);
*/	//}
	CString ex;
	ex=name.Right(2);
	if (ex.CompareNoCase("mm")==0)
	{
		if(!WriteMM(name))
		{
			AfxMessageBox("Couldn't write file");
		}
	}
/*		//AfxMessageBox("Saving");
		if(MapGen==NULL) MapGenFromFrame(0);
		
		if(	!(Gflags&S_HAS_SKIN) ) //make a skin
		{
			//AfxMessageBox("making skin");
			MakeSkinMapping();
		}
		MakeMDL();
		WriteMDL(str.GetBuffer(1));
	}
*/

}

void CMedDLeDoc::OnFileExportframe() 
{
/*	if(cur.frameptr==NULL) return;
	
	CString Filter("3d Objects (*.3ds;*asc;*.dxf;*.raw;*.cob;*.wrl;*.nff;*.obj;*.pov;*.inc) | *.3ds; *.dxf; *.raw; *.cob; *.wrl; *.nff; *.obj; *.pov; *.inc |");
 	
	Filter+="3D Studio Object (*.3ds)|*.3ds|";
	Filter+="3D Studio Ascii (*.asc)|*.asc|";
	Filter+="RAW Object (*.raw)|*.raw|";
	Filter+="AutoCAD DXF (*.dxf)|*.dxf|";
  	Filter+="Truespace Object (*.cob)|*.cob|";
 	Filter+="VRML (*.wrl)|*.wrl|";
  	Filter+="Wavefront Object (*.obj)|*.obj|";
	Filter+="WorldToolkit Object (*.nff)|*.nff|";
	Filter+="POVRay V2.2 File (*.pov)|*.pov|";
	Filter+="POVRay V2.2 Include (*.inc)|*.inc|";
	Filter+="All Files (*.*) | *.* ||";
	CFileDialog fileDlg(FALSE, NULL,NULL,OFN_HIDEREADONLY| OFN_OVERWRITEPROMPT,Filter);
	if(fileDlg.DoModal()==IDOK)
	{
		CString extn, name;
		char str[128];
		strcpy(str,fileDlg.GetPathName());
		char *extn1;
		extn1=strstr(fileDlg.GetPathName(),".");
		name=fileDlg.GetPathName();
		// check extension and fix if needed
		if((extn1==NULL)&&((fileDlg.m_ofn.nFilterIndex!=12)||(fileDlg.m_ofn.nFilterIndex!=1)))
		{
			switch(fileDlg.m_ofn.nFilterIndex)
			{
				case 0: case 1: break;
				case 2: name += ".3ds"; break;
				case 3: name += ".asc"; break;
				case 4: name += ".raw"; break;
				case 5: name += ".dxf"; break;
				case 6: name += ".cob"; break;
				case 7: name += ".wrl"; break;
				case 8: name += ".obj"; break;
				case 9: name += ".nff"; break;
				case 10: name += ".pov"; break;
				case 11: name += ".inc"; break;
			}
			strcpy(str,name.GetBuffer(1));
			extn1=strstr(str,".");
		}

		extn = extn1;
		extn.MakeLower();
		if(	!strncmp(extn.GetBuffer(1),".wrl",4)|| !strncmp(extn.GetBuffer(1),".asc",4) )
		{
			export_mdl_frame(str, cur.frameptr, this);
		}
		else if(!strncmp(extn.GetBuffer(1),".raw",4)|| !strncmp(extn.GetBuffer(1),".cob",4)||
		!strncmp(extn.GetBuffer(1),".dxf",4)|| !strncmp(extn.GetBuffer(1),".3ds",4)||
		!strncmp(extn.GetBuffer(1),".pov",4)|| !strncmp(extn.GetBuffer(1),".nff",4)|| 
		!strncmp(extn.GetBuffer(1),".obj",4) || !strncmp(extn.GetBuffer(1),".wtk",4))
		{
			Clear();
			mdl2xroad();
			XRoad_Writer((GNode*) this, name.GetBuffer(1));
		}
	}
*/	
}

void CMedDLeDoc::OnFileImportframe() 
{
/*	CString Filter("3d Objects (*.3ds;*.asc;*.dxf;*.raw;*.cob;*.wrl;*.nff;*.obj;*.pov;*.inc) | *.3ds; *.asc; *.dxf; *.raw; *.cob; *.wrl; *.nff; *.obj; *.pov; *.inc |");
	Filter+="3D Studio Object (*.3ds)|*.3ds|";
	Filter+="3D Studio Ascii (*.asc)|*.asc|";
	Filter+="RAW Object (*.raw)|*.raw|";
	Filter+="AutoCAD DXF (*.dxf)|*.dxf|";
  	Filter+="Truespace Object (*.cob)|*.cob|";
 	Filter+="VRML (*.wrl)|*.wrl|";
  	Filter+="Wavefront Object (*.obj)|*.obj|";
	Filter+="WorldToolkit Object (*.nff)|*.nff|";
	Filter+="POVRay V2.2 File (*.pov)|*.pov|";
	Filter+="POVRay V2.2 Include (*.inc)|*.inc|";
	Filter+="All Files (*.*) | *.* ||";

	CFileDialog fileDlg(TRUE, NULL,"*.3ds;*.asc;*.dxf;*.raw;*.cob;*.wrl;*.nff;*.obj;*.pov;*.inc",OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,Filter);
	if(fileDlg.DoModal()==IDOK)
	{
		CString extn, name;
		char *extn1;
		extn1=strstr(fileDlg.GetPathName(),".");
		name=fileDlg.GetPathName();

		if((extn1==NULL)&&((fileDlg.m_ofn.nFilterIndex!=12)||(fileDlg.m_ofn.nFilterIndex!=1)))
		{
			switch(fileDlg.m_ofn.nFilterIndex)
			{
				case 0: case 1: break;
				case 2: name += ".3ds"; break;
				case 3: name += ".asc"; break;
				case 4: name += ".raw"; break;
				case 5: name += ".dxf"; break;
				case 6: name += ".cob"; break;
				case 7: name += ".wrl"; break;
				case 8: name += ".obj"; break;
				case 9: name += ".nff"; break;
				case 10: name += ".pov"; break;
				case 11: name += ".inc"; break;
			}
			//strcpy(str,name.GetBuffer(1));
			extn1=strstr(name.GetBuffer(1),".");
		}

		extn = extn1;
		extn.MakeLower();

		//if(extn1==NULL) {AfxMessageBox("Type in extension please"); return}
		if(	!strncmp(extn.GetBuffer(1),".asc",4) )
		{
			AfxMessageBox("Sorry, asc reader disabled");
			//import_mdl_frame(fileDlg.GetPathName(), cur.frame, this)
		}
		else if(!strncmp(extn.GetBuffer(1),".raw",4)|| !strncmp(extn.GetBuffer(1),".cob",4)||
		!strncmp(extn.GetBuffer(1),".dxf",4)|| !strncmp(extn.GetBuffer(1),".3ds",4)||
		!strncmp(extn.GetBuffer(1),".pov",4)|| !strncmp(extn.GetBuffer(1),".nff",4)|| 
		!strncmp(extn.GetBuffer(1),".obj",4) || !strncmp(extn.GetBuffer(1),".wtk",4))
		{
			Clear();
			XRoad_Reader((GNode*) this,fileDlg.GetPathName(),"include"); //fileDlg.GetPathName(),"include"))
			m_RawData.RemoveAll();
			xroad2mdl();
			
			AddFrameFromXRoad(fileDlg.GetPathName());
			InitModelVars();
			cur.frame=Frames.GetSize()-1;
			cur.frameptr=Frames[cur.frame];
			if(Frames.GetSize()==1)
			{
				Gflags &= ~S_IS_MDL;
				Gflags &= ~S_HAS_SKIN;
			}
			UpdateAllViews(NULL);
		}
		else
		{
			AfxMessageBox("Unknown file extension.");
		}
	}			
	*/
}


void CMedDLeDoc::DeleteContents() 
{
	if(theApp.m_pActiveDoc==this) theApp.m_pActiveDoc=NULL;

//	int i,N=m_Frames.GetSize();

//	if(N<1) return;

//	CMedDLeFrame *f;
//	for (i=N-1; i>=0; i--)
//	{
//		delete m_Frames.GetAt(i);
//	}
//	m_Frames.RemoveAll();

//	m_curFrame=NULL;

	//AfxMessageBox("Doc Start DeleteContents");
/*	int i, cnt;
	Grids.RemoveAll();
	cnt = Skins.GetSize();
	for(i=0; i<cnt; i++)
	{
		if(Skins[i]->bitmap!=NULL) delete [] Skins[i]->bitmap;
		if(Skins[i]!=NULL) delete Skins[i];
 	}
	Skins.RemoveAll();
	
	cnt = SkinGroups.GetSize();
	for(i=0; i<cnt; i++)
	{
		if(SkinGroups[i]->pSkins!=NULL) delete [] SkinGroups[i]->pSkins;
		if(SkinGroups[i]!=NULL) delete SkinGroups[i];
	}
	SkinGroups.RemoveAll();
	
	  // delete frames
	cnt = Frames.GetSize();
	for(i=0; i<cnt; i++)
	{
//			if(Frames[i]->tv != NULL) delete [] Frames[i]->tv;
//			if(Frames[i]->fv != NULL) delete [] Frames[i]->fv;
		if(Frames[i]!=NULL) delete Frames[i];
	}
	Frames.RemoveAll();

	cnt = FrameGroups.GetSize();
	for(i=0; i<cnt; i++)
	{
		if(FrameGroups[i]!=NULL) delete FrameGroups[i];
	}
	if(cnt>0) FrameGroups.RemoveAll();
	Tris.RemoveAll();
	for (i=0; i<Objects.GetSize(); i++){
		for (int k=0; k<Objects[i].Groups.GetSize(); k++) delete Objects[i].Groups[k];
		Objects[i].Groups.RemoveAll();
	}
	Objects.RemoveAll();

	if(Base!=NULL) delete Base;
	if(MapGen!=NULL) delete MapGen;
*/
}


void CMedDLeDoc::OnFileExportskin() 
{
/*	CString Filter("Graphic Files (*.gif;*.bmp) | *.gif; *.bmp |");
	Filter+="Gif87 (*.gif)|*.gif|";
	Filter+="Windows Bitmap (*.bmp)|*.bmp||";
	//Filter+="All Files (*.*) | *.* ||";
	
	CFileDialog fileDlg(FALSE, NULL,NULL,OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,Filter);
	if(fileDlg.DoModal()==IDOK)
	{

		CString name=fileDlg.GetPathName();
		char *ext;
		ext=strstr(name.GetBuffer(1),".");
		if(ext==NULL)
		{
			if(fileDlg.m_ofn.nFilterIndex==2) name+=".gif";
			if(fileDlg.m_ofn.nFilterIndex==3) name+=".bmp";
		}
		ext=strstr(name.GetBuffer(1),".");
		CString extn;
		extn=ext;
		extn.MakeLower();
		if(!strncmp(extn.GetBuffer(1),".gif",4)|| !strncmp(extn.GetBuffer(1),".bmp",4))
		{ export_mdl_skin(name.GetBuffer(1), cur.skin, this);}
		else {AfxMessageBox("Unknown file type.");}
	}
*/	
}


void CMedDLeDoc::OnFileImportskin() 
{
/*	CString Filter("Graphic Files (*.bmp;*.gif) | *.bmp; *.gif |");
 	
	Filter+="Windows Bitmap (*.bmp)|*.bmp|";
	Filter+="Gif87 (*.gif)|*.gif||";
	//Filter+="All Files (*.*) | *.* ||";
	
	CFileDialog fileDlg(TRUE, NULL,"*.bmp;*.gif",OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,Filter);
	if(fileDlg.DoModal()==IDOK)
	{
		if(!(Gflags&S_HAS_SKIN))
		{
			if((Base==NULL)&&(MapGen==NULL))
			{
				if(Frames.GetSize() <1) return;
				BaseFromFrame(0);
				MapGenFromFrame(0);
			}
			else if(MapGen==NULL) MapGenFromFrame(-1);
			else if(Base==NULL) {if(Frames.GetSize() <1) return; BaseFromFrame(0);};
		
			MakeSkinMapping();
			Gflags|=S_HAS_SKIN;
	//		MakeMDL();
		}

		CString name=fileDlg.GetPathName();
		import_mdl_skin(name.GetBuffer(1), cur.skin, this);
	}
*/	
}

void CMedDLeDoc::AddFrameFromXRoad(LPCTSTR lpszPathName)
{

/*	
	// construct pt list
	float x,y,z;
	float min[3],max[3];
	unsigned nn=m_RawData.GetSize()*3;
	
	//num.vertices=1;
	//num.triangles=n/9;
	char str[128];
//	AfxMessageBox(str);
	if(nn/9!=num.triangles)	
	{	
		sprintf(str,"Num Tris not equal %d, %d,num.triangles, n/9");
		AfxMessageBox(str);
		return;
	}
	
	num.frames++;
	Frame *f=new Frame;
	Frames.Add(f);

	f->type=0;

	CString modelname=lpszPathName;
	int n=modelname.ReverseFind( '\\' )+1;
	if(n==0) n=1;
	//CString modelname=modelpname.Mid(n);
	char name[24], *ptr;
	strncpy(name,modelname.Mid(n),16);
	ptr=strpbrk(name,".");
	ptr[0]=0;
	strcpy(f->name,name);
	
	unsigned k=0;
	for(int i=0; i<3; i++) 
	{
		f->fbboxmin.v[i]=1e23;
		f->fbboxmax.v[i]=-1e23;
	}

	for(int j=0; j< Tris.GetSize(); j++)
	{
		unsigned p;
		int x,y,z;
		for(i=0; i<3; i++)
		{
			//p=triangle[j*4L+1L+i];
			p=Tris[j].vindex[i];
			x=m_RawData[k].X();//Rawraw_pts[k++]-xo)/xscale);
			y=m_RawData[k].Y();//((raw_pts[k++]-yo)/yscale);
			z=m_RawData[k++].Z();//((raw_pts[k++]-zo)/zscale);
 			f->fv[p].v[0]=x;
			f->fv[p].v[1]=y;
			f->fv[p].v[2]=z;
			for(int ii=0; ii<3; ii++) 
			{
				if(f->fbboxmin.v[ii]>f->fv[p].v[ii])f->fbboxmin.v[ii]=f->fv[p].v[ii];		
				if(f->fbboxmax.v[ii]<f->fv[p].v[ii])f->fbboxmax.v[ii]=f->fv[p].v[ii];		
			}

		}
	}
	// now find vertex normals!
	float *norm=new float [3*num.triangles];
	for(k=0; k <num.triangles ; k++) 
		GetNormal(f, k, &norm[3*k]);

	for(j=0;j<num.vertices; j++){
		f->fv[j].vnormal=GetVertexNormal(f,j,norm);
		Verts[j].flags=0;
	}
	delete [] norm;
*/
}



void CMedDLeDoc::InitModelVars(void)
{
/*	cur.skin=0;
	cur.frame=0;
	cur.frameptr=Frames[0];
	tcolor=1;
	bcolor=6;

	float min[3];
	float max[3];
	min[0]=Frames[0]->fv[0].v[0];
	min[1]=Frames[0]->fv[0].v[1];
	min[2]=Frames[0]->fv[0].v[2];
	max[0]=min[0];
	max[1]=min[1];
	max[2]=min[2];
	for (int i=0; i<num.frames; i++){
		if(Frames[i]->fbboxmin.v[0]<min[0]) min[0]=Frames[i]->fbboxmin.v[0];
		if(Frames[i]->fbboxmin.v[1]<min[1]) min[1]=Frames[i]->fbboxmin.v[1];
		if(Frames[i]->fbboxmin.v[2]<min[2]) min[2]=Frames[i]->fbboxmin.v[2];
		if(Frames[i]->fbboxmax.v[0]>max[0]) max[0]=Frames[i]->fbboxmax.v[0];
		if(Frames[i]->fbboxmax.v[1]>max[1]) max[1]=Frames[i]->fbboxmax.v[1];
		if(Frames[i]->fbboxmax.v[2]>max[2]) max[2]=Frames[i]->fbboxmax.v[2];
	}
	boxmin[0]=min[0];
	boxmin[1]=min[1];
	boxmin[2]=min[2];
	boxmax[0]=max[0];
	boxmax[1]=max[1];
	boxmax[2]=max[2];
	// create line data
	PrimeSort();
	OGVParse();
	ColorSort();
	ResetViewVars(0);
	ResetViewVars(1);
	ResetViewVars(2);
	cur.grid=0;
	Grids.RemoveAll();
	Grids.SetSize(1, 5);
	Grids[0].center[0] = ((max[0]-min[0])/2)+min[0];
	Grids[0].center[1] = ((max[1]-min[1])/2)+min[1];
	Grids[0].center[2] = ((max[2]-min[2])/2)+min[2];
	Grids[0].steps[0] = 32;
	Grids[0].steps[1] = 32;
	Grids[0].steps[2] = 32;
	Grids[0].size[0] = max[0]-min[0];
	Grids[0].size[1] = max[1]-min[1];
	Grids[0].size[2] = max[2]-min[2];
	UpdateGrid(0);
	*/
}

/////////////////////////////////////////////////////////////////////////////
// CMedDLeDoc diagnostics and junk

#ifdef _DEBUG
void CMedDLeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMedDLeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CMedDLeDoc::StatusMessage( char* fmt, ... )
{   
	if (AfxGetApp() != NULL && AfxGetApp()->m_pMainWnd != NULL) { 
		char	buffer[256];
	    CStatusBar*	pStatus = (CStatusBar*) AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR); 
		va_list	argptr;      
		
		va_start(argptr, fmt);
		vsprintf( buffer, fmt, argptr );
		va_end(argptr);
	    
	    if (pStatus != NULL) {
			pStatus->SetPaneText(0, buffer);
			pStatus->UpdateWindow(); 
		}
    }
	return;
}

void CMedDLeDoc::ErrorMessage( char* fmt, ... )
{   
	va_list	argptr;
	char	buffer[256];      
	
	va_start(argptr, fmt);
	vsprintf( buffer, fmt, argptr );
	va_end(argptr);

	MessageBox(NULL, buffer, "Error Message", MB_OK | MB_ICONEXCLAMATION);
}

void CMedDLeDoc::StartBusy( void )  { BeginWaitCursor(); }
            
void CMedDLeDoc::EndBusy( void ) { EndWaitCursor(); }  


void CMedDLeDoc::OnEditRotate() 
{
/*	theApp.m_AppAction=AA_ROTATE;
	//ViewAct=C_ROTATE; 
	RotAngle=0.0f;
	RotTail[0]=0.f;
	RotTail[1]=0.f;
	RotTail[2]=0.f;
	RotHead[0]=0.f;
	RotHead[1]=0.f;
	RotHead[2]=30.f;
	UpdateAllViews(NULL);
	*/
}

void CMedDLeDoc::OnEditScale() 
{
//	theApp.m_AppAction=AA_SCALE;
//	ScaleVal[0]=1.f; ScaleVal[1]=1.f;ScaleVal[2]=1.f;
//	UpdateAllViews(NULL);
}


/*void GWriteCvt::
Polygon(GState& state, long faceNum, MFVec3f* v, MFVec3f* n, GWriteMaterial* m)
{
		//CMedDLeDoc* pDoc = m_pDoc;
/*		if (v->Elements() >= 3) 
		{
			SFVec3f	triangle[3];
			SFVec3f	fv[3];
			triangle[0] = (*v)[0];
			
			// Convert polygons into triangles. It doesn't work
			// in all cases, but it does work most of the time and
			// it is very simple.
			for (int i = 2; i < v->Elements(); i++) 
			{
				triangle[1] = (*v)[i-1];
				triangle[2] = (*v)[i];
				for(int j=0; j<3; j++)
				{
					fv[j].X()=triangle[j].Y();
					fv[j].Y()=-triangle[j].X();
					fv[j].Z()=triangle[j].Z();
					m_pDoc->m_RawData.Add(fv[j]);
				}
			}
		}
		*/
//}

void CMedDLeDoc::xroad2mdl(void)
{

//	GWriteCvt* write = new GWriteCvt(this);
//	GState state;
//	Write(state, *write);
//	delete write;
}

void CMedDLeDoc::mdl2xroad(void)
{
/*
	MeshCompactor mesh;
	Frame *f = cur.frameptr;

	mesh.Name(f->name);
	for(int j=0;j<num.triangles; j++)
	{
		mesh.BeginPolygon();
		float f1,f2,f3;
		int i,l;
		for(i=0;i<3;i++)
		{
			l=Tris[j].vindex[i];
			f1=f->fv[l].v[0];
			f2=f->fv[l].v[1];
			f3=f->fv[l].v[2];
			mesh.AddVertex(SFVec3f(-f2,f1,f3));
		}
		mesh.EndPolygon();
		
	}

	mesh.AddTo((GNode*) this);
	*/
}

//////////
void CMedDLeDoc::NewFrameFromXRoad(LPCTSTR lpszPathName)
{
/*	num.frames=1;
	Frame *f=new Frame;

	Frames.RemoveAll();
	Frames.Add(f);
	f->type=0;

	CString modelname=lpszPathName;
	int n=modelname.ReverseFind( '\\' )+1;
	if(n==0) n=1;
	//CString modelname=modelpname.Mid(n);
	char name[24], *ptr;
	strncpy(name,modelname.Mid(n),16);
	ptr=strpbrk(name,".");
	ptr[0]=0;
	strcpy(f->name,name);
	

	// construct pt list
	float x,y,z;
	float *pt_list;
	float minx,miny,minz,maxx,maxy,maxz;
	n=m_RawData.GetSize()*3;
	
	pt_list=new float[n];
	
	pt_list[0]=m_RawData[0].X();
	pt_list[1]=m_RawData[0].Y();
	pt_list[2]=m_RawData[0].Z();
	minx=pt_list[0];miny=pt_list[1];minz=pt_list[2];
	maxx=pt_list[0];maxy=pt_list[1];maxz=pt_list[2];
	num.vertices=1;
	num.triangles=n/9;
	char str[128];
//	sprintf(str,"tris %d (for debugging. BM)",num.triangles);
//	AfxMessageBox(str);

	Tris.SetSize(num.triangles);
	fill_mode=1;

	// construct the triangles
	int vc=0;
	num.vertices=0;

	for(int i=0; i<num.triangles; i++)
	{
		Tris[i].flags=0;//on back
		for(int k=0; k<3; k++)
		{
			int vertnum=-1;

			x=m_RawData[vc].X(); 
			y=m_RawData[vc].Y(); 
			z=m_RawData[vc++].Z();

			for(int j=0; j<num.vertices;j++)
			{
				if((x==pt_list[j*3])&&(y==pt_list[j*3+1])&&(z==pt_list[j*3+2]))
				{
					vertnum=j;
					break;
				}
			}
			if (vertnum == -1)
			{
				int N=num.vertices;
				pt_list[N*3]=x;
				pt_list[N*3+1]=y;
				pt_list[N*3+2]=z;
				vertnum = num.vertices;
				num.vertices++;
				if(x<minx) minx=x;
				if(y<miny) miny=y;
				if(z<minz) minz=z;
				if(x>maxx) maxx=x;
				if(y>maxy) maxy=y;
				if(z>maxz) maxz=z;

			}
		Tris[i].vindex[k] = vertnum;
		}
	}
	
	//f->fv =new FVertex[num.vertices];
	f->fbboxmin.v[0]=minx; f->fbboxmin.v[1]=miny; f->fbboxmin.v[2]=minz;
	f->fbboxmax.v[0]=maxx; f->fbboxmax.v[1]=maxy; f->fbboxmax.v[2]=maxz;

	Radius= sqrt((maxx-minx) * (maxx-minx) +
								 (maxy-miny)* (maxy-miny) +
								(maxz-minz) * (maxz-minz));

	delete [] pt_list;

	unsigned k=0;

	for(int j=0; j< num.triangles; j++)
	{
		unsigned p;
		int x,y,z;
		for(int i=0; i<3; i++)
		{
			//p=triangle[j*4L+1L+i];
			p=Tris[j].vindex[i];
			x=m_RawData[k].X();//Rawraw_pts[k++]-xo)/xscale);
			y=m_RawData[k].Y();//((raw_pts[k++]-yo)/yscale);
			z=m_RawData[k++].Z();//((raw_pts[k++]-zo)/zscale);
 			f->fv[p].v[0]=x;
			f->fv[p].v[1]=y;
			f->fv[p].v[2]=z;

		}
	}

	// now find vertex normals!
	float *norm=new float [3*num.triangles];
	for(k=0; k <num.triangles ; k++) 
		GetNormal(f, k, &norm[3*k]);

	Verts.SetSize(num.vertices);

	for(j=0;j<num.vertices; j++){
		f->fv[j].vnormal=GetVertexNormal(f,j,norm);
		Verts[j].flags=0;
	}
	delete [] norm;
	*/
}




void CMedDLeDoc::OnCopyframe() 
{
//	if(cur.frameptr!=NULL)
//	{
//		CopyFrame(&theApp.ClipBoard, cur.frameptr);
//		theApp.ClipBoardStatus=2;
//	}
}

void CMedDLeDoc::On2Deleteframe() 
{
/*	if(cur.frame<1)
		return;
	else
	{
		int i=cur.frame;
		cur.frame--;
		DeleteFrame(i);
	}
*/	
}

// this is really insert
void CMedDLeDoc::On2Pasteframe() 
{
//	Frame *f = new Frame;
//	CopyFrame(f,&theApp.ClipBoard);
//	InsertFrame(f,cur.frame);			
//	ParseAnimationInfo();
}

void CMedDLeDoc::OnUpdate2Pasteframe(CCmdUI* pCmdUI) 
{
//	pCmdUI->Enable(theApp.ClipBoardStatus == 2);
}

void CMedDLeDoc::OnFileSettings() 
{
/*	CString strSection       = "Pref";

   CWinApp* pApp = AfxGetApp();
   pApp->WriteProfileInt(strSection, "BackColor", back_color);
   pApp->WriteProfileInt(strSection, "LightAmbient", ambient_intensity);
   pApp->WriteProfileInt(strSection, "LightSpot", light_intensity);
   pApp->WriteProfileInt(strSection, "FillMode", fill_mode);
   pApp->WriteProfileInt(strSection, "Rflags", Rflags);
   pApp->WriteProfileInt(strSection, "Lock1", Restrict[0]);
   pApp->WriteProfileInt(strSection, "Lock2", Restrict[1]);
   pApp->WriteProfileInt(strSection, "Lock3", Restrict[2]);
   pApp->WriteProfileInt(strSection, "Vflag1", Vflags[0]);
   pApp->WriteProfileInt(strSection, "Vflag2", Vflags[1]);
   pApp->WriteProfileInt(strSection, "Vflag3", Vflags[2]);
   pApp->WriteProfileInt(strSection, "ClearBlue", ClearBlue);
   pApp->WriteProfileInt(strSection, "Gflags", Gflags);
   pApp->WriteProfileInt(strSection, "EditMode", EditMode);
*/
}

#include "GameDlg.h"
void CMedDLeDoc::OnFileSetgame() 
{

	CGameDlg dlg;
	dlg.DoModal();

/*	CGameDlg dlg;
	if(dlg.DoModal()==IDOK)
	{
		CString strSection       = "Pref";
	
		CWinApp* pApp = AfxGetApp();
		pApp->WriteProfileInt(strSection, "BackColor", back_color);

	}
	*/
}

void CMedDLeDoc::OnEditCopy() 
{

	theApp.m_BaseClipBoard.v.RemoveAll();
	theApp.m_BaseClipBoard.f.RemoveAll();
	theApp.m_BaseClipBoard.l.RemoveAll();
	theApp.m_ClipBoard.v.RemoveAll();

	CArray <int, int&> vindexArray;
	vindexArray.RemoveAll();

	int n[3], exists=0, i,j,k;
	// the triangle defs
	for (i=0; i<m_MedDLeObject.m_BaseFrame->f.GetSize(); i++)
	{

		n[0]=m_MedDLeObject.m_BaseFrame->f[i].vindex[0];
		n[1]=m_MedDLeObject.m_BaseFrame->f[i].vindex[1];
		n[2]=m_MedDLeObject.m_BaseFrame->f[i].vindex[2];

		// if all 3 selected (face selected)
		if((m_MedDLeObject.m_BaseFrame->v[n[0]].flags&V_SELECTED) && (m_MedDLeObject.m_BaseFrame->v[n[1]].flags&V_SELECTED) && (m_MedDLeObject.m_BaseFrame->v[n[2]].flags&V_SELECTED))
		{

			// add face
			CMedDLeFace f(m_MedDLeObject.m_BaseFrame->f[i]);
			
			for(k=0; k<3; k++)
			{
				exists=-1;

				for(j=0; j<vindexArray.GetSize(); j++)
				{
					if(vindexArray[j]==n[k]) 
					{
						exists=j;
						break;
					}
				}

				if(exists==-1)
				{
					CMedDLeVertex v(m_MedDLeObject.m_curFrame->v[n[k]]);
					CMedDLeBaseVertex bv(m_MedDLeObject.m_BaseFrame->v[n[k]]);
					
					vindexArray.Add(n[k]);
					f.vindex[k]=theApp.m_BaseClipBoard.v.GetSize();
					theApp.m_BaseClipBoard.v.Add(bv);
					theApp.m_ClipBoard.v.Add(v);
					
				}
				else 
				{
					f.vindex[k]=exists;
				}
				
			}

			theApp.m_BaseClipBoard.f.Add(f);
		}
	}

	if(theApp.m_BaseClipBoard.f.GetSize()>0)
		theApp.ClipBoardStatus=1;

}

void CMedDLeDoc::OnEditCut() 
{


	OnEditCopy();

	int i,j,k,n[3];
	int add[3];

	for(j=0; j<m_MedDLeObject.m_BaseFrame->v.GetSize();j++)
	{
		m_MedDLeObject.m_BaseFrame->v[j].flags&=~V_TEMP_SELECTED;
	}
	// delete now 
	for (i=m_MedDLeObject.m_BaseFrame->f.GetSize()-1; i>=0; i--)
	{

		n[0]=m_MedDLeObject.m_BaseFrame->f[i].vindex[0];
		n[1]=m_MedDLeObject.m_BaseFrame->f[i].vindex[1];
		n[2]=m_MedDLeObject.m_BaseFrame->f[i].vindex[2];

		// if all 3 selected (face selected)
		if((m_MedDLeObject.m_BaseFrame->v[n[0]].flags&V_SELECTED) && (m_MedDLeObject.m_BaseFrame->v[n[1]].flags&V_SELECTED) && (m_MedDLeObject.m_BaseFrame->v[n[2]].flags&V_SELECTED))
		{
			m_MedDLeObject.m_BaseFrame->f.RemoveAt(i);
		//		RemoveFArray.Add(i);
		}
		else
		{
			m_MedDLeObject.m_BaseFrame->v[n[0]].flags|=V_TEMP_SELECTED;
			m_MedDLeObject.m_BaseFrame->v[n[1]].flags|=V_TEMP_SELECTED;
			m_MedDLeObject.m_BaseFrame->v[n[2]].flags|=V_TEMP_SELECTED;
		}
	}

	
	for(j=m_MedDLeObject.m_BaseFrame->v.GetSize()-1; j>=0; j--)
	{
		m_MedDLeObject.m_BaseFrame->v[j].flags&=~V_SELECTED;
		if(m_MedDLeObject.m_BaseFrame->v[j].flags&V_TEMP_SELECTED)
		{
			m_MedDLeObject.m_BaseFrame->v[j].flags&=~V_TEMP_SELECTED;
		}
		else 
		{
			for (i=0; i<m_MedDLeObject.m_BaseFrame->f.GetSize(); i++)
			{
				for(k=0;k<3; k++)
				{
					if(m_MedDLeObject.m_BaseFrame->f[i].vindex[k]==j)
						AfxMessageBox("shitted");
					if(m_MedDLeObject.m_BaseFrame->f[i].vindex[k]>j)
						m_MedDLeObject.m_BaseFrame->f[i].vindex[k]-=1;
				}
				
			}

			for(i=0; i<m_MedDLeObject.m_Frames.GetSize(); i++)	
				m_MedDLeObject.m_Frames[i]->v.RemoveAt(j);
			m_MedDLeObject.m_BaseFrame->v.RemoveAt(j);
			
		}
	}

	AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
	UpdateAllViews(NULL);
	
}

void CMedDLeDoc::OnEditPaste() 
{

	if(theApp.ClipBoardStatus<1) return;


	int n[3], exists=0, i,j,k, voff;
	voff=m_MedDLeObject.m_BaseFrame->v.GetSize();

	for (i=0; i<theApp.m_BaseClipBoard.v.GetSize(); i++)
	{

		// add to base
		m_MedDLeObject.m_BaseFrame->v.Add(theApp.m_BaseClipBoard.v[i]);
		// add to all others
		for(j=0; j<m_MedDLeObject.m_Frames.GetSize(); j++)
		{
			m_MedDLeObject.m_Frames[j]->v.Add(theApp.m_ClipBoard.v[i]);
		}

	}

	CMedDLeGroup mg;
	int gN = m_MedDLeObject.m_BaseFrame->g.GetSize();
	CString name;
	name.Format("group %d",gN+1);
	mg.name=name;
	BYTE cmap[8]={8, 212, 25, 47, 55, 144, 79, 128};
	mg.color=cmap[(gN)&0x07];
	mg.flags=G_VISIBLE;
	mg.bone=0;
	m_MedDLeObject.m_BaseFrame->g.Add(mg);

	for (i=0; i<theApp.m_BaseClipBoard.f.GetSize(); i++)
	{
		// add to base
		CMedDLeFace f(theApp.m_BaseClipBoard.f[i]);

		f.vindex[0]+=voff;
		f.vindex[1]+=voff;
		f.vindex[2]+=voff;

		f.group= gN;
		f.color=cmap[(gN)&0x07];

		m_MedDLeObject.m_BaseFrame->f.Add(f);

	}

	AutoCreateLineData(*m_MedDLeObject.m_BaseFrame);
	UpdateAllViews(NULL);

}

void CMedDLeDoc::OnEditPastenew() 
{
//	if(m_MedDLeObject.m_curFrame&&theApp.ClipBoardStatus)
//		m_Frames.Add(new CMedDLeFrame(*theApp.ClipBoard) );
	
}

void CMedDLeDoc::OnUpdateEditPastenew(CCmdUI* pCmdUI) 
{
	
}

void CMedDLeDoc::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	
}

void CMedDLeDoc::OnEditUndo() 
{
	// TODO: Add your command handler code here
	
}

//void CMedDLeDoc::PushUndo() 
//{
	// TODO: Add your command handler code here
	
//}
//void CMedDLeDoc::PopUndo() 
//{
	// TODO: Add your command handler code here
	
//}

void CMedDLeDoc::OnEditSelectnone() 
{
	for(int i=0; i< m_MedDLeObject.m_BaseFrame->v.GetSize(); i++) 
	{
		if(m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE) 
		{
			m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_SELECTED;
			m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;
		}
	}
	UpdateAllViews(NULL);
}

void CMedDLeDoc::OnEditSelectall() 
{
	for(int i=0; i< m_MedDLeObject.m_BaseFrame->v.GetSize(); i++) 
	{
		if(m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE)
		{
			m_MedDLeObject.m_BaseFrame->v[i].flags|=V_SELECTED;
			m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;
		}
	}
	UpdateAllViews(NULL);
}

void CMedDLeDoc::OnXyzXlock() 
{
	Restrict[0] = !Restrict[0];
	
}

void CMedDLeDoc::OnUpdateXyzXlock(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(Restrict[0] == TRUE);
}

void CMedDLeDoc::OnXyzYlock() 
{
	Restrict[1] = !Restrict[1];
}

void CMedDLeDoc::OnUpdateXyzYlock(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(Restrict[1] == TRUE);
}

void CMedDLeDoc::OnXyzZlock() 
{
	Restrict[2] = !Restrict[2];
}

void CMedDLeDoc::OnUpdateXyzZlock(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(Restrict[2] == TRUE);
}
