//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"

int mdl_keys(MDL_model *);
void load_model(char *, MDL_model *);
MDL_window win2d, win3d;
int quiet=0;
void setwindows(void);
int oldres=0;
int res=0;
int cur_gskin=0;

// use this stuff for command line options
#define NUM_CFG_OPTIONS 3
char *cfg_option[NUM_CFG_OPTIONS] = {"mode","driver","progspath"};
char driver[128], progspath[128];
unsigned char pal[256*3];
unsigned char cmap[256*32];
//GrContext *BitMapContext;
void OpenColorMap(char *,unsigned char *);

//----------------------------------------------------------------------

int main (int argc, char *argv[])
{
	FILE *in, *out, *qpal;
//	unsigned char bmppal[256*3];
//	unsigned bmpw, bmph;
	struct MDL_model model;
	char *filename=NULL, *tmpfn=NULL;
	char *in_sfilename=NULL,*out_sfilename=NULL;
	char *in_ffilename=NULL,*out_ffilename=NULL;
	char cfg_filename[128];

	char str[256];
	char ch;
	short draw_3d=1;
	short import_bmpfile=0;
	short export_bmpfile=0;
	short import_frame=0;
	short export_frame=0;
	short show_info=0;
	unsigned i,j,k,l;
	int video_mode=0;
	int loop;
	int goto_3d=0;
	int skin=1;
	int frame=1;

	// set default values
	driver[0]=NULL;
	progspath[0]=NULL;


	strcpy(cfg_filename,"mdl.cfg");
	// get command line options
	for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
	{
		// if extract, find type...
		if ((*argv)[1] == 'e' && argc-- > 1)
		{
			tmpfn = *++argv;
			char *extn;
			extn=strstr(tmpfn,".");

			if(!strncmp(extn,".gif",4) || !strncmp(extn,".bmp",4))
			{
				out_sfilename = tmpfn;
				export_bmpfile=1;
				skin = atoi( *(++argv));

			}
			else if(!strncmp(extn,".raw",4)||!strncmp(extn,".asc",4)||
				!strncmp(extn,".dxf",4)|| !strncmp(extn,".3ds",4)||
				!strncmp(extn,".pov",4)|| !strncmp(extn,".wrl",4)||
				!strncmp(extn,".map",4)|| !strncmp(extn,".geo",4)||
				!strncmp(extn,".obj",4)|| !strncmp(extn,".3d",3))
			{
				out_ffilename = tmpfn;
				export_frame=1;
				frame = atoi( *(++argv));
			}
			else
			{
				printf("File type not supported.");
				exit(1);

			}
		}
		else if ((*argv)[1] == 'i' && argc-- > 1)
		{
			tmpfn = *++argv;
			char *extn;
			extn=strstr(tmpfn,".");

			if(!strncmp(extn,".gif",4) || !strncmp(extn,".bmp",4))
			{
				in_sfilename = tmpfn;
				import_bmpfile=1;
				skin = atoi( *(++argv));
			}
			else if(!strncmp(extn,".raw",4)||!strncmp(extn,".asc",4)||
				!strncmp(extn,".dxf",4)|| !strncmp(extn,".3ds",4)||
				!strncmp(extn,".pov",4)|| !strncmp(extn,".wrl",4)||
				!strncmp(extn,".map",4)|| !strncmp(extn,".geo",4))
			{
				in_ffilename = tmpfn;
				import_frame=1;
				frame = atoi( *(++argv));
			}
			else
			{
				printf("File type not supported.");
				exit(1);

			}

		}
		else if ((*argv)[1] == 'c' && argc-- > 1)
		{
				strcpy(cfg_filename,*++argv);
		}

		else if ((*argv)[1] == 'm' && argc-- > 1)
			video_mode= atoi( *(++argv));

		else if ((*argv)[1] == '2')
			draw_3d = 0;

		else if ((*argv)[1] == 's')
			show_info = 1;
		else if ((*argv)[1] == 'q')
			quiet = 1;
		else if ((*argv)[1] == 'h')
		{
			fprintf(stderr, "Usage: mdl [-h] [-2] [-c <file>] [-q] [-e/i <file.xxx> #] [-m #] file.mdl \n");
			fprintf(stderr, "       -h  -- help screen\n");
			fprintf(stderr, "       -2  -- start in 2d view\n");
			fprintf(stderr, "       -c  -- config file to use (mdl.cfg default\n");
			fprintf(stderr, "       -e  -- extract skin/frame, skin/frame number #\n");
			fprintf(stderr, "       -i  -- insert skin/frame, skin/frame number #\n");
			fprintf(stderr, "       -q  -- quiet mode & auto save\n");
//			fprintf(stderr, "       -n  -- quiet mode & auto save\n");
			fprintf(stderr, "       -m  -- video mode\n");
			fprintf(stderr, "              0 = 320x200 (default)\n");
			fprintf(stderr, "              1-4 hi res modes\n");
			exit(1);
		}
		else
		{
			fprintf(stderr, "What is %s?  mdl -h will help you", *argv);
			exit(1);
		}
	}

	// get config file settings
	if((in=fopen(cfg_filename,"rt"))==NULL)
	{
		fprintf(stderr,"Can't open config file, using defaults... \n");
		fprintf(stderr,"Things probably won't work. Hit a key. \n");
		getch();
	}
	else
	{
		ch=0;
		do
		{
			fscanf(in,"%s", str);
			if(feof(in)) break;
			if(str[0]=='#') {while(fgetc(in)!=0x0A);}
			else
			{
				k=0;
				for(i=0; i<NUM_CFG_OPTIONS; i++)
				{
					j=0;
					while(*(cfg_option[i]+j)!=NULL)
					{
						k=i+1;
						if(str[j]!=*(cfg_option[i]+j)) {k=0;break;}
						j++;
					}
					if(k!=0) break;
				}
				if(k==0) fprintf(stderr,"Don't understand option \"%s\" in config file. \n",str);
				else
				{
					fscanf(in,"%s", str);
					switch (k)
					{
						case 1: video_mode=atoi(str); break;//fprintf(stderr," - setting video mode = %d\n",video_mode); break;
						case 2: strcpy(driver,str); break;//fprintf(stderr," - setting driver = %s\n",driver);break;
						case 3: strcpy(progspath,str); break;//fprintf(stderr," - setting progspath = %s\n",progspath);break;
					}
				}
			}
		}while(!feof(in));
		fclose(in);
	}



	if (argc > 0)
		filename = *argv;
	else
	{
		fprintf(stderr, "mdl -h will help you", *argv);
		exit(1);
	}

	// read in quake colors
	BG_OpenPalette("mdl.pal",pal);
	//read color map
	OpenColorMap("mdl.map",cmap);
	// read in mdl file
	// and set up data
	char *extn;
	extn=strstr(filename,".");

	if(!strncmp(extn,".med",4))
	{
		printf("<MedDLe script mode>\n");
		quiet=1;
		model_script(filename);
		goto the_very_end;
	}
	else
	{
		if(!quiet)
		{
		clrscr();
		printf("MedDLe version %2.1f\n\n",VERSION);
		printf("video mode : %d\n",video_mode);
		printf("driver : %s\n",driver);
		printf("progspath : %s\n",progspath);
		}
		load_model(filename, &model);
	}
	//////////// SKIN IO

	// export bitmap of skin
	if(export_bmpfile==1)
	{
		export_mdl_skin(out_sfilename, skin, &model );
		goto the_end;
	}

	// import skin bmp
	if((skin>0)&&(import_bmpfile==1))
	{
		if(import_mdl_skin(in_sfilename, skin, &model )) goto the_end;
		// if quiet mode then autosave
		if(quiet)
		{
			if((out=fopen(model.filename,"wb"))==NULL)
			{
					fprintf(stderr,"can't open mdl file... bye\n");
					exit(1);
			}
			rewind(out);
			write_mdl(out, &model);
			fclose(out);
			goto the_end;
		}

	}

	//////////// FRAME IO
	if(export_frame==1)
	{
	 export_mdl_frame(out_ffilename,frame, &model);
	 goto the_end;
	}

	if(import_frame==1)
	{
		if(import_mdl_frame(in_ffilename,frame, &model)) goto the_end;
		// if quiet mode then autosave
		if(quiet)
		{
			if((out=fopen(model.filename,"wb"))==NULL)
			{
					fprintf(stderr,"can't open mdl file... bye\n");
					exit(1);
			}
			rewind(out);
			write_mdl(out, &model);
			fclose(out);
			goto the_end;
		}

	}

	////////// FINISH SETTING UP
	// intiate graphics mode
	BG_GraphicsMode(driver,video_mode);
	// my windows stuff
	init_win_stuff();
	// change the screen colors to the quake palette
	BG_SetPalette(pal);
	// initiate mouse
	BG_InitMouse();
	BG_MouseStatus();
	// intiate math tables
	BG_InitMath();
	BG_ClearScreen(0);
	// set up windows
	res=video_mode;
	oldres=video_mode;

	setwindows();

	// loop through the 3 modes (3d,2d,help)
	while(1)
	{
		if(oldres!=res)
		{
			oldres=res;
			BG_GraphicsMode(driver,res);
			BG_SetPalette(pal);
			BG_InitMouse();
			BG_MouseStatus();
			setwindows();
		}
		if(draw_3d==1)
		{
			if((i=mdl_3d(&model,&win3d))==0) break;
			if(i==2) draw_3d=2;
			else if(i==1) draw_3d=0;
		}
		if(draw_3d==2)
		{
			if((i=mdl_keys(&model))==0) break;
			if(i==1) draw_3d=0;
			else draw_3d=1;
		}
		if(draw_3d==0)
		{
			if((i=mdl_2d(&model,&win2d))==0) break;
			if(i==2) draw_3d=2;
			else if(i==1) draw_3d=1;
		}


	}
	GrDestroyContext(win3d.gcontext);
	GrDestroyContext(win2d.gcontext);

	// go back to text mode
	GrSetModeRestore(0);
	BG_TextMode();
	clrscr();
	if(!quiet)
		printf("\nMedDLe v%2.1f 1996\n  by Brian Martin\n  brian@phyast.pitt.edu\n",VERSION);

	the_end:

	delete_3d_data(&model);
	clean_mdl(&model);
	the_very_end:
	return(0);
}

void setwindows(void)
{

	win3d.windowed=1;
	win3d.x=0;
	win3d.y=0;
	win3d.w=BG_ScreenWidth;
	win3d.h=BG_ScreenHeight;
	if(win3d.gcontext != NULL)
		GrDestroyContext(win3d.gcontext);
	win3d.gcontext=GrCreateContext(BG_ScreenWidth,BG_ScreenHeight,NULL,NULL);
	win2d.windowed=0;
	win2d.x=0;
	win2d.y=0;
	win2d.w=BG_ScreenWidth;
	win2d.h=BG_ScreenHeight;
	if(win2d.gcontext != NULL)
		GrDestroyContext(win2d.gcontext);
	win2d.gcontext=GrCreateContext(BG_ScreenWidth,BG_ScreenHeight,NULL,NULL);

}
// read in the color map needed for shading
void OpenColorMap(char *mapfile,unsigned char *cm)
{
	FILE *in;
	in=fopen(mapfile,"rb");

	fread(cm,1,256*32,in);
	fclose(in);

}
// help file
int mdl_keys(MDL_model *m)
{
	 int loop=1;
	 int draw_3d=2;
	 int cur_key;
	 static int page=0;
	 int MAXPAGE=5;
	 int update =1;
	 BG_ClearScreen(0);


		while(loop)
		{

			if(kbhit())
			{
				if((cur_key=getch())==0x0) cur_key=getch();
			 //	cur_key=getch();
				switch(cur_key)
				{
				case 27:	       	loop=0; draw_3d=2; break;
				case '3':			loop=0; draw_3d=1; break;
				case '2':			loop=0; draw_3d=0; break;

				case ARROW_RIGHT: case ARROW_DOWN:    if(page<MAXPAGE) page+=1;
														else page=0;
														break;
				case ARROW_LEFT: case ARROW_UP:	    if(page>0) page-=1;
														else page=MAXPAGE;
														break;

				}
				update=1;
			}

		 if(update==1)
		 {
				 BG_ClearScreen(0);
				update=0;

			if(page==0)
			{
				// page 0
				BG_Text("..About MedDLe..",BG_ScreenWidth/2-60,2,250,0);

				BG_Text("MedDLe was written by Brian Martin",5,30,253,0);
				BG_Text("",5,60,253,0);
				BG_Text("It is free-ware and the source is included.",5,75,253,0);
				BG_Text("This is NOT an id software product! ",5,90,253,0);
				BG_Text("Questions or whatever go to:",5,105,253,0);
				BG_Text("brian@phyast.pitt.edu ",5,120,253,0);
				BG_Text("http://www.phyast.pitt.edu/~brian",5,135,253,0);
				BG_Text("",5,150,253,0);
				BG_Text("I will program for food. (i.e. hire me)",5,155,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==1)
			{
						// page 1
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Key  Action",5,15,250,0);
				BG_Text("1    Brings up Help",5,30,253,0);
				BG_Text("2    Brings up (2D) Skin Editor",5,45,253,0);
				BG_Text("3    Brings up (3D) Frame Editor",5,60,253,0);
				BG_Text("Esc  Exits",5,75,253,0);
				BG_Text("These keys always work. For specifics, read on.",5,90,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}
			else if(page==2)
			{
				// page 2
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Keys for 2D Mode",5,15,250,0);
				BG_Text("1,3,Esc  Help, 3d mode, exit",5,30,253,0);
				BG_Text("<,>  move through skins",5,45,253,0);
				BG_Text("t    Show wireframe (triangles)",5,60,253,0);
				BG_Text("v    Show vertices",5,75,253,0);
				BG_Text("s    Saves changes",5,90,253,0);
				BG_Text(";,'  change pants",5,105,253,0);
				BG_Text("[,]  change shirt",5,120,253,0);
				BG_Text("Mouse and arrow keys move cursor",5,135,253,0);
				BG_Text("Mouse Left Button grabs vertex",5,150,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}
			else if(page==3)
			{
				// page 3
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("Keys for 3D Mode",5,15,250,0);
				BG_Text("1,2,Esc    Help,Skin Editor,Exit",5,30,253,0);
				BG_Text("r    Reset View",5,45,253,0);
				BG_Text("s    Save View to file 'pic#.bmp'",5,60,253,0);
				BG_Text("TAB  change render mode",5,75,253,0);
				BG_Text(";,'  change pants",5,90,253,0);
				BG_Text("[,]  change shirt",5,105,253,0);
				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==4)
			{
				// page 4
				BG_Text("..MedDLe Useful Keys..",BG_ScreenWidth/2-70,2,250,0);
				BG_Text("..MORE Keys for 3D Mode",5,15,250,0);

				BG_Text("h    Show Frame Header Info",5,30,253,0);
				BG_Text("c    Cycle Through Frames",5,45,253,0);
				BG_Text("b    Change Background Color",5,60,253,0);
				BG_Text("Up/Down    Move View Up or Down",5,75,253,0);
				BG_Text("Left/Right    Cycle Frames Forward/Backward",5,90,253,0);
				BG_Text("Move Mouse moves light source",5,105,253,0);
				BG_Text("Move Mouse front/back + Right Button Zooms in/out",5,120,253,0);
				BG_Text("Move Mouse + Left Button Rotates Object",5,135,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}

			else if(page==5)
			{
				// page 5
				BG_Text("..MedDLe Other Info..",BG_ScreenWidth/2-70,2,250,0);

				BG_Text("Import bitmap by command line:",5,30,253,0);
				BG_Text("mdl -i player.bmp [# skin] player.mdl",5,45,253,0);
				BG_Text("  if # is bigger than num skins, adds a skin",5,60,253,0);
				BG_Text("Export bitmaps by command line:",5,60,253,0);
				BG_Text("mdl -e player.bmp [# skin] player.mdl",5,75,253,0);
				BG_Text(" if # is 0, creats a blank skin",5,90,253,0);

				BG_Text("Use arrow keys (up/down) to see more.",5,170,250,0);
			}


		 }


		}


	if(draw_3d==2) return 0;
	else if(draw_3d==1) return 2;
	else return 1;

}

void load_model(char *filename, MDL_model *model)
{
	FILE *in;
	char str[256];

	strcpy(str,progspath);
	strcat(str,filename);

	if((in=fopen(str,"rb"))==NULL)
	{
		printf("can't open mdl file \"%s\" ...exiting\n",str);
		exit(1);
	}
	read_mdl(in, model);
	fclose(in);

	strcpy(model->filename,filename);

	// setup 3d stuff
	 if(!quiet)	printf("wait... setting up 3d data.\n");
	 setup_3d_data(model);

}
#define MDL_VER 6

void read_mdl(FILE *in, MDL_model *model)
{
	int i,j,k;
	int tx, ty;


	fread(&model->filetype,4,1,in);       // magic nums
	fread(&model->version,4,1,in);        // version 6 now
	fread(&model->xscale,4,1,in);         // scale = (max - min)/255.9
	fread(&model->yscale,4,1,in);
	fread(&model->zscale,4,1,in);
	fread(&model->xoffset,4,1,in);        // min
	fread(&model->yoffset,4,1,in);
	fread(&model->zoffset,4,1,in);
	fread(&model->radius,4,1,in);         // bounding radius
	fread(&model->eyex,4,1,in);             // eye position
	fread(&model->eyey,4,1,in);
	fread(&model->eyez,4,1,in);
	fread(&model->num_skins,4,1,in);      // num skins
	fread(&model->skinw,4,1,in);        // skin width
	fread(&model->skinh,4,1,in);        // skin height
	fread(&model->num_vertices,4,1,in);
	fread(&model->num_triangles,4,1,in);
	fread(&model->num_frames,1,4,in);
	if(model->version == MDL_VER)
		fread(&model->sync_type,1,4,in);          // sync type, either 0 or random
	else
		model->sync_type=0;
	fread(&model->flags,4,1,in);          // flags
	if(model->version == MDL_VER)
		fread(&model->ave_size,4,1,in);       // average size  pixels/triangle?
	else
		model->ave_size=0.;
	/// that ends the header
	if(!quiet) printf("s:%d v:%d t:%d f:%d \n",model->num_skins,model->num_vertices,model->num_triangles,model->num_frames);

	tx=wherex();
	ty=wherey();
	// now the skin stuff
	model->skin = new (MDL_model_skin)[model->num_skins];
	for(k=0; k<model->num_skins; k++)
	{
		gotoxy(tx,ty);
		if(!quiet) printf("reading skin: %d \n",k+1 );
		fread(&model->skin[k].type,4,1,in);
		if(model->skin[k].type==0)
		{
			model->skin[k].bitmap = new (unsigned char)[model->skinw*model->skinh];
			fread(model->skin[k].bitmap,1,model->skinw*model->skinh,in);

		}
		else
		{
			if(!quiet) printf("group skin %d : ",k+1 );
			fread(&model->skin[k].num_gskins,4,1,in);
			model->skin[k].gskin_interval = new (float)[model->skin[k].num_gskins];
			model->skin[k].gskin = new (MDL_group_skin)[model->skin[k].num_gskins];
			for(j=0; j<model->skin[k].num_gskins; j++)
			{
				fread(&model->skin[k].gskin_interval[j],4,1,in);

			}
			for(j=0; j<model->skin[k].num_gskins; j++)
			{

				if(!quiet) printf("sub skin %d\n ",j+1 );
				model->skin[k].gskin[j].bitmap = new (unsigned char)[model->skinw*model->skinh];
				fread(model->skin[k].gskin[j].bitmap,1,model->skinw*model->skinh,in);
			}


		}

	}

	// now read the 2d vertices
	model->vertex = new (unsigned)[model->num_vertices*3];

	for(i=0;i<model->num_vertices;i++)
	{
		fread(model->vertex+i*3,4,1,in);
		if(model->version!=MDL_VER)
		{
			if(model->vertex[i*3]==1) model->vertex[i*3]=32;
		}
		fread(model->vertex+i*3+1,4,1,in);
		fread(model->vertex+i*3+2,4,1,in);
	}

	// now read triange definitions
	model->triangle = new (unsigned)[model->num_triangles*4];

	for(i=0;i<model->num_triangles;i++)
	{
		fread(model->triangle+i*4,4,1,in);
		fread(model->triangle+i*4+1,4,1,in);
		fread(model->triangle+i*4+2,4,1,in);
		fread(model->triangle+i*4+3,4,1,in);

	}

	// now read the frames
	model->frame = new (struct MDL_frame)[model->num_frames];

	tx=wherex();
	ty=wherey();

	for(k=0; k<model->num_frames;  k++)
	{
		if(model->version == MDL_VER)
			fread(&model->frame[k].type,4,1,in);
		else model->frame[k].type=0;
		// if single frames

		if(model->frame[k].type==0)
		{
			gotoxy(tx,ty);
			if(!quiet) printf("reading frame %d : ",k+1 );
			if(model->version!=MDL_VER) fread(&model->frame[k].sframe.bboxmin,1,4,in);
			fread(&model->frame[k].sframe.bboxmin,1,4,in);
			fread(&model->frame[k].sframe.bboxmax,1,4,in);
			if(model->version==MDL_VER)
				fread(model->frame[k].sframe.name,16,1,in);
			else strcpy(model->frame[k].sframe.name,"noname");

			if(!quiet) printf("%s \n",model->frame[k].sframe.name );
			model->frame[k].sframe.tv = new (trivertex)[model->num_vertices];

			for(i=0;i<model->num_vertices;i++)
			{
				fread(model->frame[k].sframe.tv+i,1,4,in);
			}
		}
		else
		{

			gotoxy(tx,ty);
			if(!quiet) printf("reading group %d :\n",k+1 );
			fread(&model->frame[k].gframe.num_gsframes,1,4,in);
			fread(&model->frame[k].gframe.bboxmin,1,4,in);
			fread(&model->frame[k].gframe.bboxmax,1,4,in);
			model->frame[k].gframe.gsframe_interval = new (float)[model->frame[k].gframe.num_gsframes];
			model->frame[k].gframe.gsframe = new (MDL_model_frame)[model->frame[k].gframe.num_gsframes];
			for(j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				fread(&model->frame[k].gframe.gsframe_interval[j],4,1,in);
//				printf("%g :",model->frame[k].gframe.gsframe_interval[j]);
			}

			for(j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				fread(&model->frame[k].gframe.gsframe[j].bboxmin,1,4,in);
				fread(&model->frame[k].gframe.gsframe[j].bboxmax,1,4,in);
				fread(model->frame[k].gframe.gsframe[j].name,16,1,in);
				model->frame[k].gframe.gsframe[j].tv = new (trivertex)[model->num_vertices];
				if(!quiet) printf(" sub frame %d : %s \n",j+1,model->frame[k].gframe.gsframe[j].name );

				for(i=0;i<model->num_vertices;i++)
				{
					fread(model->frame[k].gframe.gsframe[j].tv+i,1,4,in);
				}

			}


		}



	}
	if(model->version!=MDL_VER) model->version=MDL_VER;
	// set some initial things
	model->cur_skin=0;
	model->tcolor=1;
	model->bcolor=6;
//	getch();
}

void write_mdl(FILE *out, MDL_model *model)
{

	int i,j,k;

	fwrite(&model->filetype,4,1,out);       // magic nums
	fwrite(&model->version,4,1,out);        // version 6 now
	fwrite(&model->xscale,4,1,out);         // scale = (max - mout)/255.9
	fwrite(&model->yscale,4,1,out);
	fwrite(&model->zscale,4,1,out);
	fwrite(&model->xoffset,4,1,out);        // mout
	fwrite(&model->yoffset,4,1,out);
	fwrite(&model->zoffset,4,1,out);
	fwrite(&model->radius,4,1,out);         // boundoutg radius
	fwrite(&model->eyex,4,1,out);             // eye position
	fwrite(&model->eyey,4,1,out);
	fwrite(&model->eyez,4,1,out);
	fwrite(&model->num_skins,4,1,out);      // num skins
	fwrite(&model->skinw,4,1,out);        // skin width
	fwrite(&model->skinh,4,1,out);        // skin height
	fwrite(&model->num_vertices,4,1,out);
	fwrite(&model->num_triangles,4,1,out);
	fwrite(&model->num_frames,1,4,out);
	fwrite(&model->sync_type,1,4,out);          // sync type, either 0 or random
	fwrite(&model->flags,4,1,out);          // flags
	fwrite(&model->ave_size,4,1,out);       // average size
	/// that ends the header
	// now the skin stuff
	for(k=0; k<model->num_skins; k++)
	{
		fwrite(&model->skin[k].type,4,1,out);
		if(model->skin[k].type==0)
		{
			for(j=0;j<model->skinh;j++)
			{
				for(i=0;i<model->skinw;i++)
				{
					fputc(model->skin[k].bitmap[i+model->skinw*j],out);
				}
			}

		}
		else
		{
			fwrite(&model->skin[k].num_gskins,4,1,out);
			for(j=0; j<model->skin[k].num_gskins; j++)
			{
				fwrite(&model->skin[k].gskin_interval[j],4,1,out);
			}
			for(j=0; j<model->skin[k].num_gskins; j++)
			{

				for(int jj=0;jj<model->skinh;jj++)
				{
					for(int ii=0;ii<model->skinw;ii++)
					{
						fputc(model->skin[k].gskin[j].bitmap[ii+model->skinw*jj],out);
					}
				}
			}


		}

	}

	// now the 2d vertices

	for(i=0;i<model->num_vertices;i++)
	{
		fwrite(model->vertex+i*3,4,1,out);
		fwrite(model->vertex+i*3+1,4,1,out);
		fwrite(model->vertex+i*3+2,4,1,out);
	}

	// now triangle definitions

	for(i=0;i<model->num_triangles;i++)
	{
		fwrite(model->triangle+i*4,4,1,out);
		fwrite(model->triangle+i*4+1,4,1,out);
		fwrite(model->triangle+i*4+2,4,1,out);
		fwrite(model->triangle+i*4+3,4,1,out);

	}

	// now the frames

	for(k=0; k<model->num_frames;  k++)
	{
		fwrite(&model->frame[k].type,4,1,out);
		// if single frames
		if(model->frame[k].type==0)
		{
			fwrite(&model->frame[k].sframe.bboxmin,1,4,out);
			fwrite(&model->frame[k].sframe.bboxmax,1,4,out);
			fwrite(model->frame[k].sframe.name,16,1,out);

			for(i=0;i<model->num_vertices;i++)
			{
				fwrite(model->frame[k].sframe.tv+i,1,4,out);
			}
		}
		else
		{

			fwrite(&model->frame[k].gframe.num_gsframes,1,4,out);
			fwrite(&model->frame[k].gframe.bboxmin,1,4,out);
			fwrite(&model->frame[k].gframe.bboxmax,1,4,out);
			for(j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				fwrite(&model->frame[k].gframe.gsframe_interval[j],4,1,out);
			}

			for(j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				fwrite(&model->frame[k].gframe.gsframe[j].bboxmin,1,4,out);
				fwrite(&model->frame[k].gframe.gsframe[j].bboxmax,1,4,out);
				fwrite(model->frame[k].gframe.gsframe[j].name,16,1,out);

				for(i=0;i<model->num_vertices;i++)
				{
					fwrite(model->frame[k].gframe.gsframe[j].tv+i,1,4,out);
				}

			}


		}



	}
//	char string1[64];
//	sprintf(string1,"MedDLe is the Greatest!!!!!");
//
//	fwrite(string1,1,28,out);

}

// this routine puts quake data into a format that I like for my
// matrix routines

void setup_3d_data(MDL_model *model)
{
	int i,j,k;
	BG_3pt vect1, vect2;
	int maxn;


		unsigned num_sides=model->num_triangles;
		model->side=new (BG_Side)[num_sides];
		if(model->side==NULL) exit(1);

		for(j=0;j<num_sides; j++)
		{

			model->side[j].pt[0]=model->triangle[j*4L+1L];
			model->side[j].pt[1]=model->triangle[j*4L+2L];
			model->side[j].pt[2]=model->triangle[j*4L+3L];
		}


	// block is like a cube. a single object.
	// since each mdl frame is a single object, it is a block


	model->blocks=0;
	// get num of blocks
	for(i=0; i<model->num_frames; i++)
	{
		if(model->frame[i].type==0) model->blocks++;
		else
		{
			model->blocks+=model->frame[i].gframe.num_gsframes;
		}

	}

	model->block= new (BG_Block)[model->blocks];
	if(model->block==NULL) exit(1);

	i=0;
	int f=0;
	unsigned num_pts=model->num_vertices;
	for(f=0; f< model->num_frames; f++)
	{
		if(model->frame[f].type==0)
		{
		model->block[i].ptlist=new (BG_3pt)[num_pts+8];
		model->block[i].nindex=new (unsigned char)[num_pts];
		if(model->block[i].ptlist==NULL) exit(1);
		maxn=0;
		// read all points
		for(j=0;j<num_pts;j++)
		{
			model->block[i].ptlist[j].x=model->xscale*((float)model->frame[f].sframe.tv[j].v[0])+model->xoffset;
			model->block[i].ptlist[j].y=model->yscale*((float)model->frame[f].sframe.tv[j].v[1])+model->yoffset;
			model->block[i].ptlist[j].z=model->zscale*((float)model->frame[f].sframe.tv[j].v[2])+model->zoffset;
			model->block[i].nindex[j]=model->frame[f].sframe.tv[j].vnormal;
		}
		model->block[i].ptlist[num_pts].x= model->xscale*model->frame[f].sframe.bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts].y= model->yscale*model->frame[f].sframe.bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts].z= model->zscale*model->frame[f].sframe.bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+1].x= model->xscale*model->frame[f].sframe.bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+1].y= model->yscale*model->frame[f].sframe.bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+1].z= model->zscale*model->frame[f].sframe.bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+2].x= model->xscale*model->frame[f].sframe.bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+2].y= model->yscale*model->frame[f].sframe.bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+2].z= model->zscale*model->frame[f].sframe.bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+3].x= model->xscale*model->frame[f].sframe.bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+3].y= model->yscale*model->frame[f].sframe.bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+3].z= model->zscale*model->frame[f].sframe.bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+4].x= model->xscale*model->frame[f].sframe.bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+4].y= model->yscale*model->frame[f].sframe.bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+4].z= model->zscale*model->frame[f].sframe.bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+5].x= model->xscale*model->frame[f].sframe.bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+5].y= model->yscale*model->frame[f].sframe.bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+5].z= model->zscale*model->frame[f].sframe.bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+6].x= model->xscale*model->frame[f].sframe.bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+6].y= model->yscale*model->frame[f].sframe.bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+6].z= model->zscale*model->frame[f].sframe.bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+7].x= model->xscale*model->frame[f].sframe.bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+7].y= model->yscale*model->frame[f].sframe.bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+7].z= model->zscale*model->frame[f].sframe.bboxmin.v[2]+model->zoffset;


		// calc surface normals
		model->block[i].side_normal=new (BG_3pt) [num_sides];
		if(model->block[i].side_normal==NULL) exit(1);

		for(j=0;j<num_sides; j++)
		{
			vect1=BG_SubtractPts(&(model->block[i].ptlist[model->side[j].pt[1]]),&(model->block[i].ptlist[model->side[j].pt[0]]));
			vect2=BG_SubtractPts(&(model->block[i].ptlist[model->side[j].pt[2]]),&(model->block[i].ptlist[model->side[j].pt[1]]));
			model->block[i].side_normal[j]=BG_CrossProduct(&vect2,&vect1);
			BG_Normalize(&(model->block[i].side_normal[j]));
		}

		model->block[i].name=model->frame[f].sframe.name;
		i++;
		}

		// if group frame
		else
		{

		for(int ii=0; ii<model->frame[f].gframe.num_gsframes; ii++)
		{
		model->block[i].ptlist=new (BG_3pt)[num_pts+8];
		model->block[i].nindex=new (unsigned char)[num_pts];
		if(model->block[i].ptlist==NULL) exit(1);
		maxn=0;
		// read all points
		for(j=0;j<model->num_vertices;j++)
		{
			model->block[i].ptlist[j].x=model->xscale*(model->frame[f].gframe.gsframe[ii].tv[j].v[0])+model->xoffset;//+model->f1;//+model->f1)+model->xoffset;
			model->block[i].ptlist[j].y=model->yscale*(model->frame[f].gframe.gsframe[ii].tv[j].v[1])+model->yoffset;//+model->f2;//+model->f2)+model->yoffset;
			model->block[i].ptlist[j].z=model->zscale*(model->frame[f].gframe.gsframe[ii].tv[j].v[2])+model->zoffset;//+model->f3;//+model->f3)+model->zoffset;
			model->block[i].nindex[j]=model->frame[f].gframe.gsframe[ii].tv[j].vnormal;
		}
		model->block[i].ptlist[num_pts].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+1].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+1].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+1].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+2].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+2].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+2].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+3].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+3].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+3].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+4].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+4].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+4].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+5].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+5].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+5].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+6].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+6].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+6].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[2]+model->zoffset;

		model->block[i].ptlist[num_pts+7].x= model->xscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[0]+model->xoffset;
		model->block[i].ptlist[num_pts+7].y= model->yscale*model->frame[f].gframe.gsframe[ii].bboxmax.v[1]+model->yoffset;
		model->block[i].ptlist[num_pts+7].z= model->zscale*model->frame[f].gframe.gsframe[ii].bboxmin.v[2]+model->zoffset;


		// calc surface normals
		model->block[i].side_normal=new (BG_3pt) [num_sides];
		if(model->block[i].side_normal==NULL) exit(1);

		for(j=0;j<num_sides; j++)
		{
			vect1=BG_SubtractPts(&(model->block[i].ptlist[model->side[j].pt[1]]),&(model->block[i].ptlist[model->side[j].pt[0]]));
			vect2=BG_SubtractPts(&(model->block[i].ptlist[model->side[j].pt[2]]),&(model->block[i].ptlist[model->side[j].pt[1]]));
			model->block[i].side_normal[j]=BG_CrossProduct(&vect2,&vect1);
			BG_Normalize(&(model->block[i].side_normal[j]));
		}
		model->block[i].name=model->frame[f].gframe.gsframe[ii].name;
		i++;
		}
		}
	}

}



// clean up 3d data
void delete_3d_data(MDL_model *model)
{
	int i,j,k;


	delete [] model->side;

	// block is like a cube. a single object.
	// since each mdl frame is a single object, it is a block

	for(i=0; i< model->blocks; i++)
	{
			delete [] model->block[i].ptlist;
			delete [] model->block[i].nindex;
			delete [] model->block[i].side_normal;
	}

	delete [] model->block;

}

void delete_frame(MDL_model *model, int frame)
{
	// this is frame as in frame 1 is frame=0

	delete [] model->block[frame].ptlist;
	delete [] model->block[frame].nindex;
	delete [] model->block[frame].side_normal;

}

void clean_mdl(MDL_model *model)
{
	for(int k=0; k<model->num_skins; k++)
	{
		if(model->skin[k].type==0)
			delete [] model->skin[k].bitmap;
		else
		{

			for(int j=0; j<model->skin[k].num_gskins; j++)
				delete [] model->skin[k].gskin[j].bitmap;

			delete [] model->skin[k].gskin_interval;
			delete [] model->skin[k].gskin;

		}
	}
	delete [] model->skin;
//	delete [] mdl.bitmap;
	delete[] model->vertex;
	delete [] model->triangle;

	for(int k=0; k<model->num_frames;  k++)
	{
		if(model->frame[k].type==0)
			delete [] model->frame[k].sframe.tv;

		else
		{

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
				delete [] model->frame[k].gframe.gsframe[j].tv;
			delete [] model->frame[k].gframe.gsframe_interval;
			delete [] model->frame[k].gframe.gsframe;
		}
	}
	delete [] model->frame;

}