//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"
#include <math.h>

void vline(unsigned char *pic, int *v1, int *v2, MDL_model *model);

void generate_mdl(char * filename, MDL_model *model)
{

	FILE *in;
//	int i,j,k;
	char str[128];
	printf("generating model\n");

	//set some defaults
	strncpy(model->filetype,"IDPO",4);
	model->version=6;
	model->xscale=1.;
	model->yscale=1.;
	model->zscale=1.;
	model->xoffset=0.;
	model->yoffset=0.;
	model->zoffset=0.;
	model->radius=1.;
	model->eyex=0.;
	model->eyey=0.;
	model->eyez=1.;
	model->num_skins=0;
	model->skinw=0;
	model->skinh=0;
	model->num_vertices=0;
	model->num_triangles=0;
	model->num_frames=0;
	model->sync_type=0;
	model->flags=0;
	model->ave_size=0.;

	//read in new frame data
	char *extn;
	extn=strstr(filename,".");
	if(!strncmp(extn,".raw",4)||!strncmp(extn,".asc",4)||
			!strncmp(extn,".dxf",4)|| !strncmp(extn,".3ds",4)||
			!strncmp(extn,".pov",4)|| !strncmp(extn,".wrl",4)||
			!strncmp(extn,".map",4))
	{
		quiet=0;
//		printf("reading in base frame\n");
		import_mdl_frame(filename,model->num_frames, model);
		quiet=1;
	}
	// 3d data is set up...(for viewing)

	// set up 2d triangles
//	printf("constructing 2d triangles\n");
	model->vertex = new (unsigned)[model->num_vertices*3];
	for (int i=0 ; i<model->num_vertices ; i++)
	{
		model->vertex[i*3] = 0;
	}
	float xmin,xmax,ymin,ymax,zmin,zmax;
	xmin=floor(model->xscale*(float)model->frame[0].sframe.bboxmin.v[0]+model->xoffset);
	ymin=floor(model->yscale*(float)model->frame[0].sframe.bboxmin.v[1]+model->yoffset);
	zmin=floor(model->zscale*(float)model->frame[0].sframe.bboxmin.v[2]+model->zoffset);
	xmax=ceil(model->xscale*(float)model->frame[0].sframe.bboxmax.v[0]+model->xoffset);
	ymax=ceil(model->yscale*(float)model->frame[0].sframe.bboxmax.v[1]+model->yoffset);
	zmax=ceil(model->zscale*(float)model->frame[0].sframe.bboxmax.v[2]+model->zoffset);

	double width = (ymax - ymin);
	double height = (zmax - zmin);
	double scale = 8.;
	int iwidth,iheight;
	if (width*scale >= 150)
		scale = 150. / width;
	if (height*scale >= 190)
		scale = 190. / height;
	iwidth = (int)(ceil(width*scale) + 4);
	iheight = (int)(ceil(height*scale) + 4);

	int skinwidth = iwidth*2;
	model->skinw = (skinwidth + 3) & ~3;
	model->skinh = iheight;
//	printf("skinw: %d skinh: %d\n",model->skinw,model->skinh);

	float		basex, basey;

	for (int i=0 ; i<model->num_triangles ; i++)
	{
		int		j;

// may be minus	model->block[0].side_normal[i]
		// look at y part
		// if facing back
		if (model->block[0].side_normal[i].x < 0)
		{
			basex = iwidth + 2;
			model->triangle[i*4] = 0;
		}
		else
		{
			basex = 2;
			model->triangle[i*4] = 1;
		}
		basey = 2;

		for (j=0 ; j<3 ; j++)
		{
				BG_3pt *vert3;
				vert3=&model->block[0].ptlist[model->side[i].pt[j]];
				int tri_index=model->triangle[i*4+j+1];

			if (model->triangle[i*4])
			{
				model->vertex[tri_index*3] |=1;
			}
			else
			{
				model->vertex[tri_index*3] |= 2;
			}

			if ((model->triangle[i*4]) || ((model->vertex[tri_index*3] & 1) == 0))
			{
			// we want the front s value for seam vertices
				model->vertex[tri_index*3+1]=(int)((vert3->y - ymin) * scale + basex);
				model->vertex[tri_index*3+2]=model->skinh-(int)((vert3->z - zmin) * scale + basey);
//				model->vertex[tri_index*3+1]=1;
//				model->vertex[tri_index*3+2]=1;
			}
		}
	}
	for (int i=0 ; i<model->num_vertices ; i++)
	{
		if (model->vertex[i*3] == 3)
		{
			 model->vertex[i*3] = 32;
		}
		else
		{
			 model->vertex[i*3] = 0;
		}
	}
	// should add here to calculate size (surface area)!!
	// but am too lazy
	// give a new skin
	// printf("constructing blank skin\n");
	model->num_skins=1;
	model->skin = new (MDL_model_skin);
	model->skin[0].type=0;
	model->skin[0].bitmap = new (unsigned char)[model->skinw*model->skinh];
	unsigned char *pic;

	pic=model->skin[0].bitmap;

			for(int j=0; j<model->skinh; j++)
			{
				for(int i=0; i<model->skinw; i++)
				{
					pic[i+model->skinw*j]=0;
				}
			}
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;

			int v1[2], v2[2];
			for(int i=0;i<model->num_triangles;i++)
			{
				p1=model->triangle[i*4+1];
				p2=model->triangle[i*4+2];
				p3=model->triangle[i*4+3];
				p4=model->triangle[i*4];
				x1=x2=x3=0;
				if((model->vertex[3*p1]==32)&&(p4==0)) x1=model->skinw/2;
				if((model->vertex[3*p2]==32)&&(p4==0)) x2=model->skinw/2;
				if((model->vertex[3*p3]==32)&&(p4==0)) x3=model->skinw/2;
				v1[0]=model->vertex[p2*3+1]+x2;
				v1[1]=model->vertex[p2*3+2];
				v2[0]=model->vertex[p3*3+1]+x3;
				v2[1]=model->vertex[p3*3+2];
				vline(pic,v1,v2,model);
				v1[0]=model->vertex[p3*3+1]+x3;
				v1[1]=model->vertex[p3*3+2];
				v2[0]=model->vertex[p1*3+1]+x1;
				v2[1]=model->vertex[p1*3+2];
				vline(pic,v1,v2,model );
				v1[0]=model->vertex[p1*3+1]+x1;
				v1[1]=model->vertex[p1*3+2];
				v2[0]=model->vertex[p2*3+1]+x2;
				v2[1]=model->vertex[p2*3+2];
				vline(pic,v1,v2,model);
			}



	delete_3d_data(model);
	printf("model complete\n");

//	fclose(in);
}

