/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <iostream.h>
#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "pcx.h"

int CImage::Read (char szfilename[])
{
	int w_count = 0;
	int c, i;
	int repeat;

	m_szCurrentFile = strdup (szfilename);

	FILE *pcx;

	if ((pcx = fopen(szfilename, "rb")) == NULL)
	{
		return -1;
	}

	if ((c = getc(pcx)) != 10)
	{
		fclose(pcx);
		return -1;
	}

	if ((c = getc(pcx)) != 5)
	{
		fclose(pcx);
		return -1;
	}

	if ((ReadPCXDimensions (pcx)) == -1)
		return -1;

	m_pixel_buffer = new unsigned char [(m_iWidth * m_iHeight)];

	fseek(pcx, 128, SEEK_SET);

	while (w_count < (m_iWidth * m_iHeight)) {

		c = getc(pcx);

		if (c > 0xbf)
		{
			repeat = 0x3f & c;

			c = getc(pcx);

			for (i = 0; i < repeat; i++)
			{
				m_pixel_buffer[w_count++] = c;
			}
		}
		else
		{
			m_pixel_buffer[w_count++] = c;
		}

		fflush(stdout);
	}

	m_palette_buffer = new unsigned char [768];

	fseek (pcx, -769, SEEK_END);

	if ((c = getc(pcx)) != 12)
	{
		fclose(pcx);
		return -1;
	}

	for (i = 0; i < 768; i++)
	{
		c = getc(pcx);
		m_palette_buffer[i] = c;
	}

	fclose (pcx);
	return 0;
}

int CImage::ReadPCXDimensions (FILE *fp)
{
	if (fp == NULL)
		return -1;

	int sx, sy, ex, ey;

	rewind(fp);

	fgetc(fp);	fgetc(fp);	fgetc(fp);	fgetc(fp);

	sx = fgetc(fp);
	sx |= fgetc(fp)<<8;

	sy = fgetc(fp);
	sy |= fgetc(fp)<<8;

	ex = fgetc(fp);
	ex |= fgetc(fp)<<8;

	ey = fgetc(fp);
	ey |= fgetc(fp)<<8;

	m_iWidth	= ex - sx + 1;
	m_iHeight	= ey - sy + 1;

	return 0;
}

void CImage::Destroy (void)
{
	if (glTexture != NULL) {
		delete [] glTexture;
		glTexture = NULL;
	}

	if (m_pixel_buffer != NULL)
	{
		delete [] m_pixel_buffer;
		m_pixel_buffer = NULL;
	}

	if (m_palette_buffer != NULL)
	{
		delete [] m_palette_buffer;
		m_palette_buffer = NULL;
	}
}

void CImage::Image2GLTexture (void)
{
	GLubyte *unScaled;
	int i, j;

	unScaled = new GLubyte [m_iWidth * m_iHeight * 4];

	for (j = 0; j < m_iHeight; j++) {
		for (i = 0; i < m_iWidth; i++) {
			unScaled[4*(j * m_iWidth + i)+0] = (GLubyte) m_palette_buffer[3*m_pixel_buffer[j*m_iWidth+i]+0];
			unScaled[4*(j * m_iWidth + i)+1] = (GLubyte) m_palette_buffer[3*m_pixel_buffer[j*m_iWidth+i]+1];
			unScaled[4*(j * m_iWidth + i)+2] = (GLubyte) m_palette_buffer[3*m_pixel_buffer[j*m_iWidth+i]+2];
			unScaled[4*(j * m_iWidth + i)+3] = (GLubyte) 255;
		}
	}

	if (m_iWidth > 256)
		m_iscaledWidth = 512;
	else if (m_iWidth > 128)
		m_iscaledWidth = 256;
	else if (m_iWidth > 64)
		m_iscaledWidth = 128;
	else if (m_iWidth > 32)
		m_iscaledWidth = 64;
	else if (m_iWidth > 16)
		m_iscaledWidth = 32;
	else if (m_iWidth > 8)
		m_iscaledWidth = 16;
	else if (m_iWidth > 4)
		m_iscaledWidth = 8;
	else if (m_iWidth > 2)
		m_iscaledWidth = 4;
	else if (m_iWidth > 1)
		m_iscaledWidth = 2;

	if (m_iHeight > 256)
		m_iscaledHeight = 512;
	else if (m_iHeight > 128)
		m_iscaledHeight = 256;
	else if (m_iHeight > 64)
		m_iscaledHeight = 128;
	else if (m_iHeight > 32)
		m_iscaledHeight = 64;
	else if (m_iHeight > 16)
		m_iscaledHeight = 32;
	else if (m_iHeight > 8)
		m_iscaledHeight = 16;
	else if (m_iHeight > 4)
		m_iscaledHeight = 8;
	else if (m_iHeight > 2)
		m_iscaledHeight = 4;
	else if (m_iHeight > 1)
		m_iscaledHeight = 2;

	if (glTexture != NULL) {
		delete [] glTexture;
		glTexture = NULL;
	}

	glTexture = new GLubyte [m_iscaledWidth * m_iscaledHeight * 4];

	gluScaleImage (GL_RGBA, m_iWidth, m_iHeight, GL_UNSIGNED_BYTE, unScaled, m_iscaledWidth, m_iscaledHeight, GL_UNSIGNED_BYTE, glTexture);

	delete [] unScaled;
}