//
//                 mxToolKit (c) 1999 by Mete Ciragan
//
// file:           mxTga.cpp
// implementation: all
// last modified:  Apr 15 1999, Mete Ciragan
// copyright:      The programs and associated files contained in this
//                 distribution were developed by Mete Ciragan. The programs
//                 are not in the public domain, but they are freely
//                 distributable without licensing fees. These programs are
//                 provided without guarantee or warrantee expressed or
//                 implied.
//
#include <mx/mxTga.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <mx/Tga.h> //hypov8 move to mx

//====================================================//


mxImage *LoadUncompressedTGA(mxImage *image, const char *filename, FILE *fTGA)	// Load an uncompressed TGA (note, much of this code is based on NeHe's 
{																			// TGA Loading code nehe.gamedev.net)
		
	if(fread(tga.header, sizeof(tga.header), 1, fTGA) == 0)				// Read TGA header
	{										
		MessageBox(NULL, "Could not read info header", "ERROR", MB_OK);		// Display error
		if(fTGA != NULL)													// if file is still open
		{
			fclose(fTGA);													// Close it
		}
		return false;														// Return failular
	}	

	image->width  = tga.header[1] * 256 + tga.header[0];					// Determine The TGA Width	(highbyte*256+lowbyte)
	image->height = tga.header[3] * 256 + tga.header[2];					// Determine The TGA Height	(highbyte*256+lowbyte)
	image->bpp	= tga.header[4];										// Determine the bits per pixel
	tga.Width		= image->width;										// Copy width into local structure						
	tga.Height		= image->height;										// Copy height into local structure
	tga.Bpp			= image->bpp;											// Copy BPP into local structure

	if((image->width <= 0) || (image->height <= 0) || ((image->bpp != 24) && (image->bpp !=32)))	// Make sure all information is valid
	{
		MessageBox(NULL, "Invalid texture information", "ERROR", MB_OK);	// Display Error
		if(fTGA != NULL)													// Check if file is still open
		{
			fclose(fTGA);													// If so, close it
		}
		return false;														// Return failed
	}

/*	if(image->bpp == 24)													//If the BPP of the image is 24...
	{
		texture->type	= GL_RGB;											// Set Image type to GL_RGB
	}
	else																	// Else if its 32 BPP
	{
		texture->type	= GL_RGBA;											// Set image type to GL_RGBA
	} */

	tga.bytesPerPixel	= (tga.Bpp / 8);									// Compute the number of BYTES per pixel
	tga.imageSize		= (tga.bytesPerPixel * tga.Width * tga.Height);		// Compute the total amout ofmemory needed to store data
	image->data		= (byte *)malloc(tga.imageSize);					// Allocate that much memory

	if(image->data == NULL)											// If no space was allocated
	{
		MessageBox(NULL, "Could not allocate memory for image", "ERROR", MB_OK);	// Display Error
		fclose(fTGA);														// Close the file
		return false;														// Return failed
	}

	if(fread(image->data, 1, tga.imageSize, fTGA) != tga.imageSize)	// Attempt to read image data
	{
		MessageBox(NULL, "Could not read image data", "ERROR", MB_OK);		// Display Error
		if(image->data != NULL)										// If imagedata has data in it
		{
			free(image->data);										// Delete data from memory
		}
		fclose(fTGA);														// Close file
		return false;														// Return failed
	}

	//Need to fix tga bug...remove one pixel at the end of each line if width is odd
	if(image->width&1)
	{
		//this is where we can fix it or stop it from loading //hypov8 todo:
	}
	// Byte Swapping Optimized By Steve Thomas
	for(GLuint cswap = 0; cswap < (int)tga.imageSize; cswap += tga.bytesPerPixel)
	{
		image->data[cswap] ^= image->data[cswap+2] ^= image->data[cswap] ^= image->data[cswap+2];
	}

	fclose(fTGA);															// Close file
	return image;															// Return success
}

mxImage *LoadCompressedTGA(mxImage *image, const char *filename, FILE *fTGA)		// Load COMPRESSED TGAs
{ 
	if(fread(tga.header, sizeof(tga.header), 1, fTGA) == 0)					// Attempt to read header
	{
		MessageBox(NULL, "Could not read info header", "ERROR", MB_OK);		// Display Error
		if(fTGA != NULL)													// If file is open
		{
			fclose(fTGA);													// Close it
		}
//		return false;														// Return failed
	}

	image->width  = tga.header[1] * 256 + tga.header[0];					// Determine The TGA Width	(highbyte*256+lowbyte)
	image->height = tga.header[3] * 256 + tga.header[2];					// Determine The TGA Height	(highbyte*256+lowbyte)
	image->bpp    = tga.header[4];										// Determine Bits Per Pixel
	tga.Width		= image->width;										// Copy width to local structure
	tga.Height		= image->height;										// Copy width to local structure
	tga.Bpp			= image->bpp;											// Copy width to local structure

	if((image->width <= 0) || (image->height <= 0) || ((image->bpp != 24) && (image->bpp !=32)))	//Make sure all texture info is ok
	{
		MessageBox(NULL, "Invalid texture information", "ERROR", MB_OK);	// If it isnt...Display error
		if(fTGA != NULL)													// Check if file is open
		{
			fclose(fTGA);													// Ifit is, close it
		}
//		return false;														// Return failed
	}

	tga.bytesPerPixel	= (tga.Bpp / 8);									// Compute BYTES per pixel
	tga.imageSize		= (tga.bytesPerPixel * tga.Width * tga.Height);		// Compute amout of memory needed to store image
	image->data		= (byte *)malloc(tga.imageSize);					// Allocate that much memory

	if(image->data == NULL)											// If it wasnt allocated correctly..
	{
		MessageBox(NULL, "Could not allocate memory for image", "ERROR", MB_OK);	// Display Error
		fclose(fTGA);														// Close file
//		return false;														// Return failed
	}

	GLuint pixelcount	= tga.Height * tga.Width;							// Nuber of pixels in the image
	GLuint currentpixel	= 0;												// Current pixel being read
	GLuint currentbyte	= 0;												// Current byte 
	byte * colorbuffer = (byte *)malloc(tga.bytesPerPixel);			// Storage for 1 pixel

	//Need to fix tga bug...remove one pixel at the end of each line if width is odd
	if(image->width&1)
	{
		//this is where we can fix it or stop it from loading
	}

	do
	{
		GLubyte chunkheader = 0;											// Storage for "chunk" header

		if(fread(&chunkheader, sizeof(GLubyte), 1, fTGA) == 0)				// Read in the 1 byte header
		{
			MessageBox(NULL, "Could not read RLE header", "ERROR", MB_OK);	// Display Error
			if(fTGA != NULL)												// If file is open
			{
				fclose(fTGA);												// Close file
			}
			if(image->data != NULL)									// If there is stored image data
			{
				free(image->data);									// Delete image data
			}
//			return false;													// Return failed
		}

		if(chunkheader < 128)												// If the ehader is < 128, it means the that is the number of RAW color packets minus 1
		{																	// that follow the header
			chunkheader++;													// add 1 to get number of following color values
			for(short counter = 0; counter < chunkheader; counter++)		// Read RAW color values
			{
				if(fread(colorbuffer, 1, tga.bytesPerPixel, fTGA) != tga.bytesPerPixel) // Try to read 1 pixel
				{
					MessageBox(NULL, "Could not read image data", "ERROR", MB_OK);		// IF we cant, display an error

					if(fTGA != NULL)													// See if file is open
					{
						fclose(fTGA);													// If so, close file
					}

					if(colorbuffer != NULL)												// See if colorbuffer has data in it
					{
						free(colorbuffer);												// If so, delete it
					}

					if(image->data != NULL)										// See if there is stored Image data
					{
						free(image->data);										// If so, delete it too
					}

//					return false;														// Return failed
				}
																						// write to memory
				image->data[currentbyte		] = colorbuffer[2];				    // Flip R and B vcolor values around in the process 
				image->data[currentbyte + 1	] = colorbuffer[1];
				image->data[currentbyte + 2	] = colorbuffer[0];

				if(tga.bytesPerPixel == 4)												// if its a 32 bpp image
				{
					image->data[currentbyte + 3] = colorbuffer[3];				// copy the 4th byte
				}

				currentbyte += tga.bytesPerPixel;										// Increase thecurrent byte by the number of bytes per pixel
				currentpixel++;															// Increase current pixel by 1

				if(currentpixel > pixelcount)											// Make sure we havent read too many pixels
				{
					MessageBox(NULL, "Too many pixels read", "ERROR", NULL);			// if there is too many... Display an error!

					if(fTGA != NULL)													// If there is a file open
					{
						fclose(fTGA);													// Close file
					}	

					if(colorbuffer != NULL)												// If there is data in colorbuffer
					{
						free(colorbuffer);												// Delete it
					}

					if(image->data != NULL)										// If there is Image data
					{
						free(image->data);										// delete it
					}

//					return false;														// Return failed
				}
			}
		}
		else																			// chunkheader > 128 RLE data, next color reapeated chunkheader - 127 times
		{
			chunkheader -= 127;															// Subteact 127 to get rid of the ID bit
			if(fread(colorbuffer, 1, tga.bytesPerPixel, fTGA) != tga.bytesPerPixel)		// Attempt to read following color values
			{	
				MessageBox(NULL, "Could not read from file", "ERROR", MB_OK);			// If attempt fails.. Display error (again)

				if(fTGA != NULL)														// If thereis a file open
				{
					fclose(fTGA);														// Close it
				}

				if(colorbuffer != NULL)													// If there is data in the colorbuffer
				{
					free(colorbuffer);													// delete it
				}

				if(image->data != NULL)											// If thereis image data
				{
					free(image->data);											// delete it
				}

//				return false;															// return failed
			}

			for(short counter = 0; counter < chunkheader; counter++)					// copy the color into the image data as many times as dictated 
			{																			// by the header
				image->data[currentbyte		] = colorbuffer[2];					// switch R and B bytes areound while copying
				image->data[currentbyte + 1	] = colorbuffer[1];
				image->data[currentbyte + 2	] = colorbuffer[0];

				if(tga.bytesPerPixel == 4)												// If TGA images is 32 bpp
				{
					image->data[currentbyte + 3] = colorbuffer[3];				// Copy 4th byte
				}

				currentbyte += tga.bytesPerPixel;										// Increase current byte by the number of bytes per pixel
				currentpixel++;															// Increase pixel count by 1

				if(currentpixel > pixelcount)											// Make sure we havent written too many pixels
				{
					MessageBox(NULL, "Too many pixels read", "ERROR", NULL);			// if there is too many... Display an error!

					if(fTGA != NULL)													// If there is a file open
					{
						fclose(fTGA);													// Close file
					}	

					if(colorbuffer != NULL)												// If there is data in colorbuffer
					{
						free(colorbuffer);												// Delete it
					}

					if(image->data != NULL)										// If there is Image data
					{
						free(image->data);										// delete it
					}

//					return false;														// Return failed
				}
			}
		}
	}	while(currentpixel < pixelcount);													// Loop while there are still pixels left


	fclose(fTGA);																		// Close the file
	
	return image;																		// return success
	
}






//===============TESTING============================//
mxImage *mxTgaRead(const char *filename)				// Load a TGA file
{
	int y;
	FILE * fTGA = 0;												// File pointer to texture file


	if(fopen_s(&fTGA,filename, "rb"))										// If it didn't open....
	{
		//MessageBox(NULL, "Could not open texture file", "ERROR", MB_OK);	// Display an error message
		return false;														// Exit function
	}

	if(fread(&tgaheader, sizeof(TGAHeader), 1, fTGA) == 0)					// Attempt to read 12 byte header from file
	{
		MessageBox(NULL, "Could not read file header", "ERROR", MB_OK);		// If it fails, display an error message 
		if(fTGA != NULL)													// Check to seeiffile is still open
		{
			fclose(fTGA);													// If it is, close it
		}
		return false;														// Exit function
	}

	mxImage *image = new mxImage ();
	
	if(memcmp(uTGAcompare, &tgaheader, sizeof(tgaheader)) == 0)				// See if header matches the predefined header of 
	{																		// an Uncompressed TGA image
		image = LoadUncompressedTGA(image, filename, fTGA);					// If so, jump to Uncompressed TGA loading code

	}
	else if(memcmp(cTGAcompare, &tgaheader, sizeof(tgaheader)) == 0)		// See if header matches the predefined header of
	{																		// an RLE compressed TGA image
		image = LoadCompressedTGA(image, filename, fTGA);							// If so, jump to Compressed TGA loading code
	}
	else																	// If header matches neither type
	{
		MessageBox(NULL, "TGA file be type 2 or type 10 ", "Invalid Image", MB_OK);	// Display an error
		fclose(fTGA);
		return false;																// Exit function
	}
																// All went well, continue on

	//Damn skin is upside down..need an algorithm to flip it the right way up
	mxImage *tmp = new mxImage ();
	tmp->create(image->width, image->height, image->bpp);

	long counter = 0;
	int bpp = image->bpp/8;

	//long length = (image->height*image->width*3)-1;
	long length = (image->height*image->width*bpp)-1;
	
	//	for(long y=length;y>=0;y-=3)
		for(long y=length;y>=0;y-=bpp)
		{
			if(bpp==4)
			{
				tmp->data[counter] = image->data[y-3];
				tmp->data[counter+1] = image->data[y-2];
				tmp->data[counter+2] = image->data[y-1];
			}
			else
			{
				tmp->data[counter] = image->data[y-2];
				tmp->data[counter+1] = image->data[y-1];
				tmp->data[counter+2] = image->data[y];
			}
			counter+=3;
		}

		for (y=0; y<tmp->height; y++) 
		{ 
			long left = y*tmp->width*3; 
			long right = left + tmp->width*3 - 3; 
			for (long x=0; x<tmp->width*0.5; x++) 
			{ 
				unsigned char tempRed   = tmp->data[left]; 
				unsigned char tempGreen = tmp->data[left+1]; 
				unsigned char tempBlue  = tmp->data[left+2]; 
				
				tmp->data[left]   = tmp->data[right]; 
				tmp->data[left+1] = tmp->data[right+1]; 
				tmp->data[left+2] = tmp->data[right+2]; 
				
				tmp->data[right]   = tempRed; 
				tmp->data[right+1] = tempGreen; 
				tmp->data[right+2] = tempBlue; 
				
				left  += 3; 
				right -= 3; 
			} 
		} 

//hypov8 todo: free image!!!
// add code from glWindow

	return tmp;
}



bool
mxTgaWrite (const char *filename, mxImage *image)
{
	if (!image)
		return false;

	if (image->bpp != 24)
		return false;

	FILE *file = 0; ;
	if (fopen_s(&file,filename, "wb"))
		return false;

	//
	// write header
	//
	fputc (0, file); // identFieldLength
	fputc (0, file); // colorMapType == 0, no color map
	fputc (2, file); // imageTypeCode == 2, uncompressed RGB

	word w = 0;
	fwrite (&w, sizeof (word), 1, file); // colorMapOrigin
	fwrite (&w, sizeof (word), 1, file); // colorMapLength
	fputc (0, file); // colorMapEntrySize

	fwrite (&w, sizeof (word), 1, file); // imageOriginX
	fwrite (&w, sizeof (word), 1, file); // imageOriginY

	w = (word) image->width;
	fwrite (&w, sizeof (word), 1, file); // imageWidth

	w = (word) image->height;
	fwrite (&w, sizeof (word), 1, file); // imageHeight

	fputc (24, file); // imagePixelSize
	fputc (0, file); // imageDescriptorByte

	// write no ident field

	// write no color map

	// write imagedata

	byte *data = (byte *) image->data;
	for (int y = 0; y < image->height; y++)
	{
		byte *scanline = (byte *) &data[(image->height - y - 1) * image->width * 3];
		for (int x = 0; x < image->width; x++)
		{
			fputc ((byte) scanline[x * 3 + 2], file);
			fputc ((byte) scanline[x * 3 + 1], file);
			fputc ((byte) scanline[x * 3 + 0], file);
		}
	}

	fclose (file);

	return true;
}