#ifndef INCLUDED_MDXVIEWER
#define INCLUDED_MDXVIEWER


#ifndef INCLUDED_MXWINDOW
#include <mx/mxWindow.h>
#endif

#ifndef INCLUDED_MDX
#include "mdx.h"
#endif



#define IDC_MODEL_LOADMODEL			1001
#define IDC_MODEL_LOADWEAPON		1002
#define IDC_MODEL_UNLOADMODEL		1003
#define IDC_MODEL_UNLOADWEAPON		1004
#define IDC_MODEL_OPENPAKFILE		1005
#define IDC_MODEL_OPENPAKFILE2		1006
#define IDC_MODEL_CLOSEPAKFILE		1007
#define IDC_MODEL_RECENTMODELS1		1008
#define IDC_MODEL_RECENTMODELS2		1009
#define IDC_MODEL_RECENTMODELS3		1010
#define IDC_MODEL_RECENTMODELS4		1011
#define IDC_MODEL_RECENTPAKFILES1	1012
#define IDC_MODEL_RECENTPAKFILES2	1013
#define IDC_MODEL_RECENTPAKFILES3	1014
#define IDC_MODEL_RECENTPAKFILES4	1015
#define IDC_MODEL_EXIT				1016
#define IDC_MODEL_MD2				1017

#define IDC_SKIN_MODELSKIN			1021
#define IDC_SKIN_WEAPONSKIN			1022
#define IDC_SKIN_BACKGROUND			1023
#define IDC_SKIN_WATER				1024
#define IDC_SKIN_SCREENSHOT			1025
#define IDC_SKIN_MODELSKIN3			1026
#define IDC_SKIN_MODELSKIN4			1027
#define IDC_SKIN_MODELSKIN5			1028
#define IDC_SKIN_MODELSKIN6			1029
#define IDC_SKIN_AVI				1030


#define IDC_OPTIONS_BGCOLOR			1031
#define IDC_OPTIONS_WFCOLOR			1032
#define IDC_OPTIONS_FGCOLOR			1033
#define IDC_OPTIONS_LIGHTCOLOR		1034
#define IDC_OPTIONS_CENTERMODEL		1035
#define IDC_OPTIONS_GENERATELIGHTNORMALS	1036

#define IDC_HELP_GOTOHOMEPAGE		1051
#define IDC_HELP_ABOUT				1052

#define IDC_RENDERMODE				2001
#define IDC_WATER					2002
#define IDC_LIGHT					2003
#define IDC_BRIGHTNESS				2004
#define IDC_SHININESS				2005
#define IDC_BACKGROUND				2006
#define IDC_TEXTURELIMIT			2007

#define IDC_ANIMATION				3001
#define IDC_INTERPOLATE				3002
#define IDC_GLCOMMANDS				3003
#define IDC_PITCH					3004
#define IDC_PAUSE					3005
#define IDC_FRAME					3006
#define IDC_INCFRAME				3007
#define IDC_DECFRAME				3008

class mxProgressBar;
class mxTab;
class mxMenuBar;
class mxButton;
class mxLineEdit;
class mxLabel;
class mxChoice;
class mxCheckBox;
class mxSlider;
class GlWindow;
class PAKViewer;

class MDXViewer : public mxWindow
{
	mxMenuBar *mb;
	mxTab *tab;
	mxProgressBar *bar;

	mxChoice *cRenderMode;
	mxCheckBox *cbWater, *cbLight, *cbBackground;

	mxChoice *cAnim;
	mxButton *bPause;
	mxLineEdit *leFrame;
	mxButton *bDecFrame, *bIncFrame, *bSetFrame;

	mxLabel *lModelInfo1;

	mxLineEdit *leWidth, *leHeight;
	mxCheckBox *cb3dfxOpenGL, *cbCDS;

	GlWindow *glw;
	PAKViewer *pakViewer;

	mdx_model_t *mdxModel;
	mdx_model_t *mdxWeapon;

	void loadRecentFiles ();
	void saveRecentFiles ();
	void initRecentFiles ();

	bool loadModel (const char *ptr, int pos);
	void setModelInfo (mdx_model_t *model, int pos);
	void initAnimation (mdx_model_t *model, int animation);
	void initAVIAnimation (mdx_model_t *model, int animation, int *start, int *end);
	int MakeAVI(int start, int end);
	
public:
	friend PAKViewer;

	// CREATORS
	MDXViewer ();
	~MDXViewer ();

	// MANIPULATORS
	virtual int handleEvent (mxEvent *event);
	void redraw ();
	void makeScreenShot (const char *filename);
	void setRenderMode (int index);
	void centerModel ();

	// ACCESSORS
	mxMenuBar *getMenuBar () const { return mb; }
};



extern MDXViewer *g_mdxViewer;



#endif // INCLUDED_MDXVIEWER