/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "model.h"
#include "log.h"
#include "texture.h"

#include <math.h>

static void _defaultMaterial()
{
   float fval[4] = { 0.2f, 0.2f, 0.2f, 1.0f };
   glMaterialfv( GL_FRONT, GL_AMBIENT,
         fval );
   fval[0] = fval[1] = fval[2] = 0.8f;
   glMaterialfv( GL_FRONT, GL_DIFFUSE, fval );
   fval[0] = fval[1] = fval[2] = 0.0f;
   glMaterialfv( GL_FRONT, GL_SPECULAR, fval );
   glMaterialfv( GL_FRONT, GL_EMISSION, fval );
   glMaterialf( GL_FRONT, GL_SHININESS, 0.0f );
}

#if 0 
void Model::draw( unsigned drawOptions, unsigned context )
{
   bool colorSelected = false;

   if ( m_initialized )
   {
      if ( drawOptions & DO_WIREFRAME )
      {
         glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
      }
      else
      {
#ifdef MM3D_EDIT
         glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
#else
         glPolygonMode( GL_FRONT, GL_FILL );
#endif
      }

      if ( !m_validNormals )
      {
         calculateNormals();
      }

      DrawingContext * drawContext = NULL;
      if ( context )
      {
         drawContext = getDrawingContext( context );
         //drawContext->m_textures.clear();

         if ( !drawContext->m_valid )
         {
            loadTextures( context );
            log_debug( "loaded textures for %08X\n", context );
         }
      }

      for ( unsigned t = 0; t < m_triangles.size(); t++ )
      {
         m_triangles[t]->m_marked = false;
      }

      if ( m_animationMode )
      {
         if ( m_animationMode == ANIMMODE_SKELETAL && m_currentAnim < m_skelAnims.size() )
         {
            for ( unsigned m = 0; m < m_groups.size(); m++ )
            {
               if ( drawOptions & DO_TEXTURE )
               {
                  glColor3f( 1.0f, 1.0f, 1.0f );
                  if ( m_groups[ m ]->m_materialIndex >= 0 )
                  {
                     int index = m_groups[m]->m_materialIndex;

                     glMaterialfv( GL_FRONT, GL_AMBIENT,
                           m_materials[ index ]->m_ambient );
                     glMaterialfv( GL_FRONT, GL_DIFFUSE,
                           m_materials[ index ]->m_diffuse );
                     glMaterialfv( GL_FRONT, GL_SPECULAR,
                           m_materials[ index ]->m_specular );
                     glMaterialfv( GL_FRONT, GL_EMISSION,
                           m_materials[ index ]->m_emissive );
                     glMaterialf( GL_FRONT, GL_SHININESS,
                           m_materials[ index ]->m_shininess );

                     if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                           && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                     {
                        if ( drawContext )
                        {
                           glBindTexture( GL_TEXTURE_2D,
                                 drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                        }
                        else
                        {
                           glBindTexture( GL_TEXTURE_2D,
                                 m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                        }

                        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                              (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                              (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                        glEnable( GL_TEXTURE_2D );
                     }
                     else
                     {
                        glDisable( GL_TEXTURE_2D );
                     }
                  }
                  else
                  {
                     _defaultMaterial();
                     glDisable( GL_TEXTURE_2D );
                  }
               }
               else
               {
                  _defaultMaterial();
                  glDisable( GL_TEXTURE_2D );
                  glColor3f( 0.9f, 0.9f, 0.9f );
               }

               colorSelected = false;

               glBegin( GL_TRIANGLES );
               for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
               {
                  unsigned triIndex = m_groups[m]->m_triangleIndices[t];
                  Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 1.0, 0.0, 0.0 );
                           }
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 0.9, 0.9, 0.9 );
                           }
                        }
                        colorSelected = false;
                     }

                     for ( int v = 0; v < 3; v++ )
                     {
                        Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                        if ( vertex->m_boneId == -1 )
                        {
                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           if ( drawOptions & DO_SMOOTHING )
                           {
                              glNormal3dv( 
                                    m_keyframeTriangles[ triIndex ].m_normals[v] );
                           }
                           else
                           {
                              glNormal3f( 
                                    triangle->m_flatNormals[v][0], 
                                    triangle->m_flatNormals[v][1], 
                                    triangle->m_flatNormals[v][2] );
                           }
                           glVertex3f( 
                                 vertex->m_coord[0],
                                 vertex->m_coord[1],
                                 vertex->m_coord[2]
                                 );
                        }
                        else
                        {
                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                           Vector norm( m_keyframeTriangles[ triIndex ].m_normals[v] );
                           norm.transform3( final );
                           glNormal3dv( norm.getVector() );

                           Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                           vert.transform( final );
                           glVertex3dv( vert.getVector() );
                        }
                     }
                  }
               }
               glEnd();
            }

            // draw ungrouped
            {
               _defaultMaterial();
               glDisable( GL_TEXTURE_2D );
               glBegin( GL_TRIANGLES );
               for ( unsigned t = 0; t < m_triangles.size(); t++ )
               {
                  if ( m_triangles[t]->m_marked == false  )
                  {
                     unsigned triIndex = t;
                     Triangle * triangle = m_triangles[ t ];
                     triangle->m_marked = true;

                     if ( triangle->m_visible )
                     {
                        if ( triangle->m_selected )
                        {
                           if ( colorSelected == false )
                           {
                              glColor3f( 1.0, 0.0, 0.0 );
                           }
                           colorSelected = true;
                        }
                        else
                        {
                           if ( colorSelected == true )
                           {
                              glColor3f( 0.9, 0.9, 0.9 );
                           }
                           colorSelected = false;
                        }

                        for ( int v = 0; v < 3; v++ )
                        {
                           Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                           if ( vertex->m_boneId == -1 )
                           {
                              glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                              if ( drawOptions & DO_SMOOTHING )
                              {
                                 glNormal3dv( 
                                       m_keyframeTriangles[ triIndex ].m_normals[v] );
                              }
                              else
                              {
                                 glNormal3f( 
                                       triangle->m_flatNormals[v][0], 
                                       triangle->m_flatNormals[v][1], 
                                       triangle->m_flatNormals[v][2] );
                              }
                              glVertex3f( 
                                    vertex->m_coord[0],
                                    vertex->m_coord[1],
                                    vertex->m_coord[2]
                                    );
                           }
                           else
                           {
                              glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                              Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                              Vector norm( m_keyframeTriangles[ triIndex ].m_normals[v] );
                              norm.transform3( final );
                              glNormal3dv( norm.getVector() );

                              Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                              vert.transform( final );
                              glVertex3dv( vert.getVector() );
                           }
                        }
                     }
                  }
               }
               glEnd();
            }
         }
         else if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            //log_debug( "drawing animation '%s' frame %d\n", m_frameAnims[m_currentAnim]->m_name.c_str(), m_currentFrame );

            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               for ( unsigned m = 0; m < m_groups.size(); m++ )
               {
                  if ( drawOptions & DO_TEXTURE )
                  {
                     glColor3f( 1.0, 1.0, 1.0 );

                     if ( m_groups[ m ]->m_materialIndex >= 0 )
                     {
                        int index = m_groups[m]->m_materialIndex;

                        glMaterialfv( GL_FRONT, GL_AMBIENT,
                              m_materials[ index ]->m_ambient );
                        glMaterialfv( GL_FRONT, GL_DIFFUSE,
                              m_materials[ index ]->m_diffuse );
                        glMaterialfv( GL_FRONT, GL_SPECULAR,
                              m_materials[ index ]->m_specular );
                        glMaterialfv( GL_FRONT, GL_EMISSION,
                              m_materials[ index ]->m_emissive );
                        glMaterialf( GL_FRONT, GL_SHININESS,
                              m_materials[ index ]->m_shininess );

                        if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                              && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                        {
                           if ( drawContext )
                           {
                              glBindTexture( GL_TEXTURE_2D,
                                    drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                           }
                           else
                           {
                              glBindTexture( GL_TEXTURE_2D,
                                    m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                           }

                           glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                                 (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                           glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                                 (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                           glEnable( GL_TEXTURE_2D );
                        }
                        else
                        {
                           glDisable( GL_TEXTURE_2D );
                        }
                     }
                     else
                     {
                        _defaultMaterial();
                        glDisable( GL_TEXTURE_2D );
                     }
                  }
                  else
                  {
                     _defaultMaterial();
                     glColor3f( 0.9, 0.9, 0.9 );
                     glDisable( GL_TEXTURE_2D );
                  }

                  colorSelected = false;

                  glBegin( GL_TRIANGLES );
                  for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
                  {
                     Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
                     triangle->m_marked = true;

                     if ( triangle->m_visible )
                     {
                        if ( triangle->m_selected )
                        {
                           if ( colorSelected == false )
                           {
                              if ( !(drawOptions & DO_TEXTURE) )
                              {
                                 glColor3f( 1.0, 0.0, 0.0 );
                              }
                           }
                           colorSelected = true;
                        }
                        else
                        {
                           if ( colorSelected == true )
                           {
                              if ( !(drawOptions & DO_TEXTURE) )
                              {
                                 glColor3f( 0.9, 0.9, 0.9 );
                              }
                           }
                           colorSelected = false;
                        }

                        for ( int v = 0; v < 3; v++ )
                        {
                           FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           glNormal3f( 
                                 vertex->m_normal[0], 
                                 vertex->m_normal[1], 
                                 vertex->m_normal[2] );
                           glVertex3f( 
                                 vertex->m_coord[0],
                                 vertex->m_coord[1],
                                 vertex->m_coord[2]
                                 );
                        }
                     }
                  }
                  glEnd();
               }

               // draw ungrouped
               {
                  _defaultMaterial();
                  glDisable( GL_TEXTURE_2D );
                  glBegin( GL_TRIANGLES );
                  for ( unsigned t = 0; t < m_triangles.size(); t++ )
                  {
                     if ( m_triangles[t]->m_marked == false  )
                     {
                        Triangle * triangle = m_triangles[ t ];
                        triangle->m_marked = true;

                        if ( triangle->m_visible )
                        {
                           if ( triangle->m_selected )
                           {
                              if ( colorSelected == false )
                              {
                                 glColor3f( 1.0, 0.0, 0.0 );
                              }
                              colorSelected = true;
                           }
                           else
                           {
                              if ( colorSelected == true )
                              {
                                 glColor3f( 0.9, 0.9, 0.9 );
                              }
                              colorSelected = false;
                           }

                           for ( int v = 0; v < 3; v++ )
                           {
                              FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                              glNormal3f( 
                                    vertex->m_normal[0], 
                                    vertex->m_normal[1], 
                                    vertex->m_normal[2] );
                              glVertex3f( 
                                    vertex->m_coord[0],
                                    vertex->m_coord[1],
                                    vertex->m_coord[2]
                                    );
                           }
                        }
                     }
                  }
                  glEnd();
               }
            }
            else
            {
               log_error( "No frame, (or no vertices) for this animation frame.\n" );
            }
         }
      }
      else
      {
         for ( unsigned m = 0; m < m_groups.size(); m++ )
         {
            if ( drawOptions & DO_TEXTURE )
            {
               glColor3f( 1.0, 1.0, 1.0 );
               if ( m_groups[ m ]->m_materialIndex >= 0 )
               {
                  int index = m_groups[m]->m_materialIndex;

                  glMaterialfv( GL_FRONT, GL_AMBIENT,
                        m_materials[ index ]->m_ambient );
                  glMaterialfv( GL_FRONT, GL_DIFFUSE,
                        m_materials[ index ]->m_diffuse );
                  glMaterialfv( GL_FRONT, GL_SPECULAR,
                        m_materials[ index ]->m_specular );
                  glMaterialfv( GL_FRONT, GL_EMISSION,
                        m_materials[ index ]->m_emissive );
                  glMaterialf( GL_FRONT, GL_SHININESS,
                        m_materials[ index ]->m_shininess );

                  if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                        && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                  {
                     if ( drawContext )
                     {
                        glBindTexture( GL_TEXTURE_2D,
                              drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                     }
                     else
                     {
                        glBindTexture( GL_TEXTURE_2D,
                              m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                     }

                     glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                           (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                     glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                           (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                     glEnable( GL_TEXTURE_2D );
                  }
                  else
                  {
                     glDisable( GL_TEXTURE_2D );
                  }
               }
               else
               {
                  _defaultMaterial();

                  glDisable( GL_TEXTURE_2D );
                  glColor3f( 0.9, 0.9, 0.9 );
               }
            }
            else
            {
               _defaultMaterial();
            }

            colorSelected = false;

            glBegin( GL_TRIANGLES );
            for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
            {
               Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
               triangle->m_marked = true;

               if ( triangle->m_visible )
               {
                  if ( triangle->m_selected )
                  {
                     if ( colorSelected == false )
                     {
                        if ( !(drawOptions & DO_TEXTURE) )
                        {
                           glColor3f( 1.0, 0.0, 0.0 );
                        }
                     }
                     colorSelected = true;
                  }
                  else
                  {
                     if ( colorSelected == true )
                     {
                        if ( !(drawOptions & DO_TEXTURE) )
                        {
                           glColor3f( 0.9, 0.9, 0.9 );
                        }
                     }
                     colorSelected = false;
                  }

                  for ( int v = 0; v < 3; v++ )
                  {
                     Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                     glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                     if ( (drawOptions & DO_SMOOTHING) )
                     {
                        glNormal3dv( triangle->m_flatNormals[v] );
                     }
                     else
                     {
                        glNormal3dv( triangle->m_flatNormals[v] );
                     }
                     glVertex3dv( vertex->m_coord );
                  }
               }
            }
            glEnd();
         }

         // Draw ungrouped triangles
         {
            _defaultMaterial();
            glDisable( GL_TEXTURE_2D );
            glBegin( GL_TRIANGLES );
            for ( unsigned t = 0; t < m_triangles.size(); t++ )
            {
               if ( m_triangles[t]->m_marked == false  )
               {
                  Triangle * triangle = m_triangles[ t ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           glColor3f( 1.0, 0.0, 0.0 );
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           glColor3f( 0.9, 0.9, 0.9 );
                        }
                        colorSelected = false;
                     }

                     for ( int v = 0; v < 3; v++ )
                     {
                        Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                        if ( drawOptions & DO_SMOOTHING )
                        {
                           glNormal3f( 
                                 triangle->m_vertexNormals[v][0], 
                                 triangle->m_vertexNormals[v][1], 
                                 triangle->m_vertexNormals[v][2] );
                        }
                        else
                        {
                           glNormal3f( 
                                 triangle->m_flatNormals[v][0], 
                                 triangle->m_flatNormals[v][1], 
                                 triangle->m_flatNormals[v][2] );
                        }
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
            }
            glEnd();
         }
      }

      glDisable( GL_TEXTURE_2D );
   }
}

void Model::drawLines() // Used for orthographic projections
{
   bool colorSelected = false;

   glDisable( GL_TEXTURE_2D );

   if ( m_initialized )
   {
      if ( m_animationMode )
      {
         if ( m_animationMode == ANIMMODE_SKELETAL && m_currentAnim < m_skelAnims.size() )
         {
            glBegin( GL_LINES );
            glColor3f( 1.0, 1.0, 1.0 );
            for ( unsigned t = 0; t < m_triangles.size(); t++ )
            {
               Triangle * triangle = m_triangles[ t ];

               if ( triangle->m_visible )
               {
                  if ( triangle->m_selected )
                  {
                     if ( colorSelected == false )
                     {
                        glColor3f( 1.0, 0.0, 0.0 );
                     }
                     colorSelected = true;
                  }
                  else
                  {
                     if ( colorSelected == true )
                     {
                        glColor3f( 1.0, 1.0, 1.0 );
                     }
                     colorSelected = false;
                  }

                  double vertices[3][3];

                  for ( int v = 0; v < 3; v++ )
                  {
                     Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                     if ( vertex->m_boneId == -1 )
                     {
                        vertices[v][0] = vertex->m_coord[0];
                        vertices[v][1] = vertex->m_coord[1];
                        vertices[v][2] = vertex->m_coord[2];
                     }
                     else
                     {
                        Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                        Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                        vert.transform( final );
                        glVertex3dv( vert.getVector() );

                        vertices[v][0] = vert.get( 0 );
                        vertices[v][1] = vert.get( 1 );
                        vertices[v][2] = vert.get( 2 );
                     }
                  }

                  glVertex3dv( vertices[0] );
                  glVertex3dv( vertices[1] );

                  glVertex3dv( vertices[1] );
                  glVertex3dv( vertices[2] );

                  glVertex3dv( vertices[2] );
                  glVertex3dv( vertices[0] );
               }
            }
            glEnd();
         }
         else if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            //log_debug( "drawing animation '%s' frame %d\n", m_frameAnims[m_currentAnim]->m_name.c_str(), m_currentFrame );

            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               glBegin( GL_LINES );
               glColor3f( 1.0, 1.0, 1.0 );
               for ( unsigned t = 0; t < m_triangles.size(); t++ )
               {
                  Triangle * triangle = m_triangles[ t ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           glColor3f( 1.0, 0.0, 0.0 );
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           glColor3f( 1.0, 1.0, 1.0 );
                        }
                        colorSelected = false;
                     }

                     double vertices[3][3];

                     for ( int v = 0; v < 3; v++ )
                     {
                        FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                        vertices[v][0] = vertex->m_coord[0];
                        vertices[v][1] = vertex->m_coord[1];
                        vertices[v][2] = vertex->m_coord[2];
                     }

                     glVertex3dv( vertices[0] );
                     glVertex3dv( vertices[1] );

                     glVertex3dv( vertices[1] );
                     glVertex3dv( vertices[2] );

                     glVertex3dv( vertices[2] );
                     glVertex3dv( vertices[0] );
                  }
               }
               glEnd();
            }
            else
            {
               log_error( "No frame, (or no vertices) for this animation frame.\n" );
            }
         }
      }
      else
      {
         glLineWidth( 1.0 );
         glBegin( GL_LINES );
         glColor3f( 1.0, 1.0, 1.0 );
         for ( unsigned t = 0; t < m_triangles.size(); t++ )
         {
            Triangle * triangle = m_triangles[ t ];
            triangle->m_marked = true;

            if ( triangle->m_visible )
            {
               if ( triangle->m_selected )
               {
                  if ( colorSelected == false )
                  {
                     glEnd();
                     glLineWidth( 1.6 );
                     glBegin( GL_LINES );
                     glColor3f( 1.0, 0.0, 0.0 );
                  }
                  colorSelected = true;
               }
               else
               {
                  if ( colorSelected == true )
                  {
                     glEnd();
                     glLineWidth( 1.0 );
                     glBegin( GL_LINES );
                     glColor3f( 1.0, 1.0, 1.0 );
                  }
                  colorSelected = false;
               }

               double vertices[3][3];

               for ( int v = 0; v < 3; v++ )
               {
                  Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                  vertices[v][0] = vertex->m_coord[0];
                  vertices[v][1] = vertex->m_coord[1];
                  vertices[v][2] = vertex->m_coord[2];
               }

               glVertex3dv( vertices[0] );
               glVertex3dv( vertices[1] );

               glVertex3dv( vertices[1] );
               glVertex3dv( vertices[2] );

               glVertex3dv( vertices[2] );
               glVertex3dv( vertices[0] );
            }
         }
         glEnd();
      }
   }

   glLineWidth( 1.0 );
}

void Model::drawPoints()
{
   if ( m_initialized ) // && m_selectionMode == SelectVertices )
   {
      if ( m_animationMode )
      {
         // Note, in animation mode, we don't draw vertices for
         // skeletal animation, only for frame animations
         if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               glPointSize( 3.0 );

               glBegin( GL_POINTS );

               glColor3f( 1.0, 1.0, 1.0 );
               for ( unsigned t = 0; t < m_vertices.size(); t++ )
               {
                  if ( m_vertices[t]->m_visible )
                  {
                     FrameAnimVertex * vertex = (*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[t];

                     if ( m_vertices[t]->m_selected == false )
                     {
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
               glEnd();

               glPointSize( 4.0 );

               glBegin( GL_POINTS );
               glColor3f( 1.0, 0.0, 0.0 );
               for ( unsigned t = 0; t < m_vertices.size(); t++ )
               {
                  if ( m_vertices[t]->m_visible )
                  {
                     FrameAnimVertex * vertex = (*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[t];

                     if ( m_vertices[t]->m_selected )
                     {
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
               glEnd();
            }
         }
      }
      else
      {
         glPointSize( 3.0 );

         glBegin( GL_POINTS );

         glColor3f( 1.0, 1.0, 1.0 );
         for ( unsigned t = 0; t < m_vertices.size(); t++ )
         {
            if ( m_vertices[t]->m_visible )
            {
               Vertex * vertex = (m_vertices[ t ]);

               if ( vertex->m_selected == false )
               {
                  glVertex3f( 
                        vertex->m_coord[0],
                        vertex->m_coord[1],
                        vertex->m_coord[2]
                        );
               }
            }
         }
         glEnd();

         glPointSize( 4.0 );

         glBegin( GL_POINTS );
         glColor3f( 1.0, 0.0, 0.0 );
         for ( unsigned t = 0; t < m_vertices.size(); t++ )
         {
            if ( m_vertices[t]->m_visible )
            {
               Vertex * vertex = (m_vertices[ t ]);

               if ( vertex->m_selected )
               {
                  glVertex3f( 
                        vertex->m_coord[0],
                        vertex->m_coord[1],
                        vertex->m_coord[2]
                        );
               }
            }
         }
         glEnd();
      }
   }
}

#ifdef MM3D_EDIT

void Model::drawJoints()
{
   if ( m_drawJoints != JOINTMODE_NONE )
   {
      if ( m_initialized )
      {
         if ( m_animationMode == ANIMMODE_NONE || m_animationMode == ANIMMODE_SKELETAL )
         {
            glPointSize( 3.0 );

            glBegin( GL_LINES );
            for ( unsigned j = 0; j < m_joints.size(); j++ )
            {
               if ( m_joints[j]->m_visible && m_joints[j]->m_parent >= 0
                     && m_joints[ m_joints[j]->m_parent ]->m_visible )
               {
                  if ( m_animationMode && parentJointSelected( j ) )
                  {
                     glColor3f( 1.0, 0.0, 1.0 );
                  }
                  else
                  {
                     glColor3f( 0.0, 0.0, 1.0 );
                  }
                  Joint * joint  = m_joints[ j ];
                  Joint * parent = m_joints[ joint->m_parent ];

                  Vector pvec;
                  pvec.set( 0, parent->m_final.get(3, 0) );
                  pvec.set( 1, parent->m_final.get(3, 1) );
                  pvec.set( 2, parent->m_final.get(3, 2) );

                  Vector jvec;
                  jvec.set( 0, joint->m_final.get(3, 0) );
                  jvec.set( 1, joint->m_final.get(3, 1) );
                  jvec.set( 2, joint->m_final.get(3, 2) );

                  glVertex3f( 
                        pvec.get( 0 ),
                        pvec.get( 1 ),
                        pvec.get( 2 )
                        );
                  glVertex3f( 
                        jvec.get( 0 ),
                        jvec.get( 1 ),
                        jvec.get( 2 )
                        );

                  Vector face( 0.0, 1.0, 0.0 );
                  Vector point( jvec.get(0) - pvec.get(0), jvec.get(1) - pvec.get(1), jvec.get(2) - pvec.get(2) );

                  double length = distance( pvec, jvec );

                  Quaternion qrot;
                  qrot.setRotationToPoint( face, point );

                  Vector v1(  0.07,  0.10,  0.07 );
                  Vector v2( -0.07,  0.10,  0.07 );
                  Vector v3( -0.07,  0.10, -0.07 );
                  Vector v4(  0.07,  0.10, -0.07 );

                  v1 = v1 * length;
                  v2 = v2 * length;
                  v3 = v3 * length;
                  v4 = v4 * length;

                  Matrix m;
                  m.setRotationQuaternion( qrot );
                  v1 = v1 * m;
                  v2 = v2 * m;
                  v3 = v3 * m;
                  v4 = v4 * m;

                  if ( m_drawJoints == JOINTMODE_BONES )
                  {
                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                  }
               }
            }
            glEnd();

            glBegin( GL_POINTS );
            for ( unsigned j = 0; j < m_joints.size(); j++ )
            {
               if ( m_joints[j]->m_visible )
               {
                  if ( m_joints[j]->m_selected )
                  {
                     glColor3f( 1.0, 0.0, 1.0 );
                  }
                  else if ( m_animationMode && hasSkelAnimKeyframe( m_currentAnim, m_currentFrame, j, true )  
                        || m_animationMode && hasSkelAnimKeyframe( m_currentAnim, m_currentFrame, j, false ) )
                  {
                     glColor3f( 0.0, 1.0, 0.0 );
                  }
                  else
                  {
                     glColor3f( 0.0, 0.0, 1.0 );
                  }
                  Joint * joint = (m_joints[ j ]);

                  glVertex3f( 
                        joint->m_final.get(3, 0),
                        joint->m_final.get(3, 1),
                        joint->m_final.get(3, 2)
                        );
               }
            }
            glEnd();
         }
      }
   }
}

#endif // MM3D_EDIT


#else
void Model::draw( unsigned drawOptions, unsigned context, float * viewPoint )
{
   bool colorSelected = false;

   if ( m_initialized )
   {
      if ( drawOptions & DO_WIREFRAME )
      {
         glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
      }
      else
      {
#ifdef MM3D_EDIT
         glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
#else
         glPolygonMode( GL_FRONT, GL_FILL );
#endif
      }

      if ( !m_validNormals )
      {
         calculateNormals();
      }

      DrawingContext * drawContext = NULL;
      if ( context )
      {
         drawContext = getDrawingContext( context );
         //drawContext->m_textures.clear();

         if ( !drawContext->m_valid )
         {
            loadTextures( context );
            log_debug( "loaded textures for %08X\n", context );
         }
      }

      if ( drawOptions & DO_ALPHA )
      {
         glEnable( GL_BLEND );
         if ( !m_validBspTree )
         {
            calculateBspTree();
         }
      }
      else
      {
         glDisable( GL_BLEND );
      }

      for ( unsigned t = 0; t < m_triangles.size(); t++ )
      {
         m_triangles[t]->m_marked = false;
      }

      if ( m_animationMode )
      {
         glDisable( GL_BLEND ); // TODO: alpha blending on animations is not implemented
         if ( m_animationMode == ANIMMODE_SKELETAL && m_currentAnim < m_skelAnims.size() )
         {
            for ( unsigned m = 0; m < m_groups.size(); m++ )
            {
               if ( drawOptions & DO_TEXTURE )
               {
                  glColor3f( 1.0f, 1.0f, 1.0f );
                  if ( m_groups[ m ]->m_materialIndex >= 0 )
                  {
                     int index = m_groups[m]->m_materialIndex;

                     glMaterialfv( GL_FRONT, GL_AMBIENT,
                           m_materials[ index ]->m_ambient );
                     glMaterialfv( GL_FRONT, GL_DIFFUSE,
                           m_materials[ index ]->m_diffuse );
                     glMaterialfv( GL_FRONT, GL_SPECULAR,
                           m_materials[ index ]->m_specular );
                     glMaterialfv( GL_FRONT, GL_EMISSION,
                           m_materials[ index ]->m_emissive );
                     glMaterialf( GL_FRONT, GL_SHININESS,
                           m_materials[ index ]->m_shininess );

                     if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                           && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                     {
                        if ( drawContext )
                        {
                           glBindTexture( GL_TEXTURE_2D,
                                 drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                        }
                        else
                        {
                           glBindTexture( GL_TEXTURE_2D,
                                 m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                        }

                        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                              (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                        glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                              (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                        glEnable( GL_TEXTURE_2D );
                     }
                     else
                     {
                        glDisable( GL_TEXTURE_2D );
                     }
                  }
                  else
                  {
                     _defaultMaterial();
                     glDisable( GL_TEXTURE_2D );
                  }
               }
               else
               {
                  _defaultMaterial();
                  glDisable( GL_TEXTURE_2D );
                  glColor3f( 0.9f, 0.9f, 0.9f );
               }

               colorSelected = false;

               glBegin( GL_TRIANGLES );
               for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
               {
                  unsigned triIndex = m_groups[m]->m_triangleIndices[t];
                  Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 1.0, 0.0, 0.0 );
                           }
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 0.9, 0.9, 0.9 );
                           }
                        }
                        colorSelected = false;
                     }

                     for ( int v = 0; v < 3; v++ )
                     {
                        Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                        if ( vertex->m_boneId == -1 )
                        {
                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           if ( drawOptions & DO_SMOOTHING )
                           {
                              glNormal3dv( 
                                    m_keyframeTriangles[ triIndex ].m_normals[v] );
                           }
                           else
                           {
                              glNormal3f( 
                                    triangle->m_flatNormals[v][0], 
                                    triangle->m_flatNormals[v][1], 
                                    triangle->m_flatNormals[v][2] );
                           }
                           glVertex3f( 
                                 vertex->m_coord[0],
                                 vertex->m_coord[1],
                                 vertex->m_coord[2]
                                 );
                        }
                        else
                        {
                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                           Vector norm( m_keyframeTriangles[ triIndex ].m_normals[v] );
                           norm.transform3( final );
                           glNormal3dv( norm.getVector() );

                           Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                           vert.transform( final );
                           glVertex3dv( vert.getVector() );
                        }
                     }
                  }
               }
               glEnd();
            }

            // draw ungrouped
            {
               _defaultMaterial();
               glDisable( GL_TEXTURE_2D );
               glBegin( GL_TRIANGLES );
               for ( unsigned t = 0; t < m_triangles.size(); t++ )
               {
                  if ( m_triangles[t]->m_marked == false  )
                  {
                     unsigned triIndex = t;
                     Triangle * triangle = m_triangles[ t ];
                     triangle->m_marked = true;

                     if ( triangle->m_visible )
                     {
                        if ( triangle->m_selected )
                        {
                           if ( colorSelected == false )
                           {
                              glColor3f( 1.0, 0.0, 0.0 );
                           }
                           colorSelected = true;
                        }
                        else
                        {
                           if ( colorSelected == true )
                           {
                              glColor3f( 0.9, 0.9, 0.9 );
                           }
                           colorSelected = false;
                        }

                        for ( int v = 0; v < 3; v++ )
                        {
                           Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                           if ( vertex->m_boneId == -1 )
                           {
                              glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                              if ( drawOptions & DO_SMOOTHING )
                              {
                                 glNormal3dv( 
                                       m_keyframeTriangles[ triIndex ].m_normals[v] );
                              }
                              else
                              {
                                 glNormal3f( 
                                       triangle->m_flatNormals[v][0], 
                                       triangle->m_flatNormals[v][1], 
                                       triangle->m_flatNormals[v][2] );
                              }
                              glVertex3f( 
                                    vertex->m_coord[0],
                                    vertex->m_coord[1],
                                    vertex->m_coord[2]
                                    );
                           }
                           else
                           {
                              glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                              Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                              Vector norm( m_keyframeTriangles[ triIndex ].m_normals[v] );
                              norm.transform3( final );
                              glNormal3dv( norm.getVector() );

                              Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                              vert.transform( final );
                              glVertex3dv( vert.getVector() );
                           }
                        }
                     }
                  }
               }
               glEnd();
            }
         }
         else if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            //log_debug( "drawing animation '%s' frame %d\n", m_frameAnims[m_currentAnim]->m_name.c_str(), m_currentFrame );

            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               for ( unsigned m = 0; m < m_groups.size(); m++ )
               {
                  if ( drawOptions & DO_TEXTURE )
                  {
                     glColor3f( 1.0, 1.0, 1.0 );

                     if ( m_groups[ m ]->m_materialIndex >= 0 )
                     {
                        int index = m_groups[m]->m_materialIndex;

                        glMaterialfv( GL_FRONT, GL_AMBIENT,
                              m_materials[ index ]->m_ambient );
                        glMaterialfv( GL_FRONT, GL_DIFFUSE,
                              m_materials[ index ]->m_diffuse );
                        glMaterialfv( GL_FRONT, GL_SPECULAR,
                              m_materials[ index ]->m_specular );
                        glMaterialfv( GL_FRONT, GL_EMISSION,
                              m_materials[ index ]->m_emissive );
                        glMaterialf( GL_FRONT, GL_SHININESS,
                              m_materials[ index ]->m_shininess );

                        if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                              && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                        {
                           if ( drawContext )
                           {
                              glBindTexture( GL_TEXTURE_2D,
                                    drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                           }
                           else
                           {
                              glBindTexture( GL_TEXTURE_2D,
                                    m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                           }

                           glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                                 (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                           glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                                 (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                           glEnable( GL_TEXTURE_2D );
                        }
                        else
                        {
                           glDisable( GL_TEXTURE_2D );
                        }
                     }
                     else
                     {
                        _defaultMaterial();
                        glDisable( GL_TEXTURE_2D );
                     }
                  }
                  else
                  {
                     _defaultMaterial();
                     glColor3f( 0.9, 0.9, 0.9 );
                     glDisable( GL_TEXTURE_2D );
                  }

                  colorSelected = false;

                  glBegin( GL_TRIANGLES );
                  for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
                  {
                     Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
                     triangle->m_marked = true;

                     if ( triangle->m_visible )
                     {
                        if ( triangle->m_selected )
                        {
                           if ( colorSelected == false )
                           {
                              if ( !(drawOptions & DO_TEXTURE) )
                              {
                                 glColor3f( 1.0, 0.0, 0.0 );
                              }
                           }
                           colorSelected = true;
                        }
                        else
                        {
                           if ( colorSelected == true )
                           {
                              if ( !(drawOptions & DO_TEXTURE) )
                              {
                                 glColor3f( 0.9, 0.9, 0.9 );
                              }
                           }
                           colorSelected = false;
                        }

                        for ( int v = 0; v < 3; v++ )
                        {
                           FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                           glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                           glNormal3f( 
                                 vertex->m_normal[0], 
                                 vertex->m_normal[1], 
                                 vertex->m_normal[2] );
                           glVertex3f( 
                                 vertex->m_coord[0],
                                 vertex->m_coord[1],
                                 vertex->m_coord[2]
                                 );
                        }
                     }
                  }
                  glEnd();
               }

               // draw ungrouped
               {
                  _defaultMaterial();
                  glDisable( GL_TEXTURE_2D );
                  glBegin( GL_TRIANGLES );
                  for ( unsigned t = 0; t < m_triangles.size(); t++ )
                  {
                     if ( m_triangles[t]->m_marked == false  )
                     {
                        Triangle * triangle = m_triangles[ t ];
                        triangle->m_marked = true;

                        if ( triangle->m_visible )
                        {
                           if ( triangle->m_selected )
                           {
                              if ( colorSelected == false )
                              {
                                 glColor3f( 1.0, 0.0, 0.0 );
                              }
                              colorSelected = true;
                           }
                           else
                           {
                              if ( colorSelected == true )
                              {
                                 glColor3f( 0.9, 0.9, 0.9 );
                              }
                              colorSelected = false;
                           }

                           for ( int v = 0; v < 3; v++ )
                           {
                              FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                              glNormal3f( 
                                    vertex->m_normal[0], 
                                    vertex->m_normal[1], 
                                    vertex->m_normal[2] );
                              glVertex3f( 
                                    vertex->m_coord[0],
                                    vertex->m_coord[1],
                                    vertex->m_coord[2]
                                    );
                           }
                        }
                     }
                  }
                  glEnd();
               }
            }
            else
            {
               log_error( "No frame, (or no vertices) for this animation frame.\n" );
            }
         }
      }
      else
      {
         bool skipAlphaGroup = false;
         for ( unsigned m = 0; m < m_groups.size(); m++ )
         {
            skipAlphaGroup = false;

            if ( drawOptions & DO_TEXTURE )
            {
               glColor3f( 1.0, 1.0, 1.0 );
               if ( m_groups[ m ]->m_materialIndex >= 0 )
               {
                  int index = m_groups[m]->m_materialIndex;

                  if ( (drawOptions & DO_ALPHA) && m_materials[ index ]->m_textureData->m_format == Texture::FORMAT_RGBA )
                  {
                     skipAlphaGroup = true;
                  }

                  glMaterialfv( GL_FRONT, GL_AMBIENT,
                        m_materials[ index ]->m_ambient );
                  glMaterialfv( GL_FRONT, GL_DIFFUSE,
                        m_materials[ index ]->m_diffuse );
                  glMaterialfv( GL_FRONT, GL_SPECULAR,
                        m_materials[ index ]->m_specular );
                  glMaterialfv( GL_FRONT, GL_EMISSION,
                        m_materials[ index ]->m_emissive );
                  glMaterialf( GL_FRONT, GL_SHININESS,
                        m_materials[ index ]->m_shininess );

                  if ( m_materials[ index ]->m_type == Model::Material::MATTYPE_TEXTURE
                        && (!m_materials[ index ]->m_textureData->m_isBad || (drawOptions & DO_BADTEX) ) )
                  {
                     if ( drawContext )
                     {
                        glBindTexture( GL_TEXTURE_2D,
                              drawContext->m_textures[ m_groups[m]->m_materialIndex ] );
                     }
                     else
                     {
                        glBindTexture( GL_TEXTURE_2D,
                              m_materials[ m_groups[m]->m_materialIndex ]->m_texture );
                     }

                     glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, 
                           (m_materials[ m_groups[m]->m_materialIndex ]->m_sClamp ? GL_CLAMP : GL_REPEAT) );
                     glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, 
                           (m_materials[ m_groups[m]->m_materialIndex ]->m_tClamp ? GL_CLAMP : GL_REPEAT) );

                     glEnable( GL_TEXTURE_2D );
                  }
                  else
                  {
                     glDisable( GL_TEXTURE_2D );
                  }
               }
               else
               {
                  _defaultMaterial();

                  glDisable( GL_TEXTURE_2D );
                  glColor3f( 0.9, 0.9, 0.9 );
               }
            }
            else
            {
               _defaultMaterial();
            }

            colorSelected = false;

            if ( skipAlphaGroup == false )
            {
               glBegin( GL_TRIANGLES );
               for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
               {
                  Triangle * triangle = m_triangles[ m_groups[m]->m_triangleIndices[t] ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 1.0, 0.0, 0.0 );
                           }
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           if ( !(drawOptions & DO_TEXTURE) )
                           {
                              glColor3f( 0.9, 0.9, 0.9 );
                           }
                        }
                        colorSelected = false;
                     }

                     for ( int v = 0; v < 3; v++ )
                     {
                        Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                        glTexCoord2f( triangle->m_s[ v ], triangle->m_t[ v ] );
                        if ( (drawOptions & DO_SMOOTHING) )
                        {
                           glNormal3dv( triangle->m_finalNormals[v] );
                        }
                        else
                        {
                           glNormal3dv( triangle->m_flatNormals[v] );
                        }
                        glVertex3dv( vertex->m_coord );
                     }
                  }
               }
               glEnd();
            }
            else
            {
               for ( unsigned t = 0; t < m_groups[m]->m_triangleIndices.size(); t++ )
               {
                  m_triangles[ m_groups[m]->m_triangleIndices[t] ]->m_marked = true;
               }
            }
         }

         // Draw ungrouped triangles
         {
            _defaultMaterial();
            glDisable( GL_TEXTURE_2D );
            glBegin( GL_TRIANGLES );
            for ( unsigned t = 0; t < m_triangles.size(); t++ )
            {
               if ( m_triangles[t]->m_marked == false  )
               {
                  Triangle * triangle = m_triangles[ t ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           glColor3f( 1.0, 0.0, 0.0 );
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           glColor3f( 0.9, 0.9, 0.9 );
                        }
                        colorSelected = false;
                     }

                     for ( int v = 0; v < 3; v++ )
                     {
                        Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                        if ( drawOptions & DO_SMOOTHING )
                        {
                           glNormal3f( 
                                 triangle->m_vertexNormals[v][0], 
                                 triangle->m_vertexNormals[v][1], 
                                 triangle->m_vertexNormals[v][2] );
                        }
                        else
                        {
                           glNormal3f( 
                                 triangle->m_flatNormals[v][0], 
                                 triangle->m_flatNormals[v][1], 
                                 triangle->m_flatNormals[v][2] );
                        }
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
            }
            glEnd();
         }

         // Draw depth-sorted alpha blended polys last
         if ( (drawOptions & DO_ALPHA) && viewPoint )
         {
            m_bspTree.render( viewPoint, drawContext );
         }

      }

      glDisable( GL_TEXTURE_2D );
   }
}

void Model::drawLines() // Used for orthographic projections
{
   bool colorSelected = false;

   glDisable( GL_TEXTURE_2D );

   if ( m_initialized )
   {
      if ( m_animationMode )
      {
         if ( m_animationMode == ANIMMODE_SKELETAL && m_currentAnim < m_skelAnims.size() )
         {
            glBegin( GL_LINES );
            glColor3f( 1.0, 1.0, 1.0 );
            for ( unsigned t = 0; t < m_triangles.size(); t++ )
            {
               Triangle * triangle = m_triangles[ t ];

               if ( triangle->m_visible )
               {
                  if ( triangle->m_selected )
                  {
                     if ( colorSelected == false )
                     {
                        glColor3f( 1.0, 0.0, 0.0 );
                     }
                     colorSelected = true;
                  }
                  else
                  {
                     if ( colorSelected == true )
                     {
                        glColor3f( 1.0, 1.0, 1.0 );
                     }
                     colorSelected = false;
                  }

                  double vertices[3][3];

                  for ( int v = 0; v < 3; v++ )
                  {
                     Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                     if ( vertex->m_boneId == -1 )
                     {
                        vertices[v][0] = vertex->m_coord[0];
                        vertices[v][1] = vertex->m_coord[1];
                        vertices[v][2] = vertex->m_coord[2];
                     }
                     else
                     {
                        Matrix & final = m_joints[ vertex->m_boneId ]->m_final;

                        Vector vert( m_keyframeVertices[ triangle->m_vertexIndices[v] ].m_coord );
                        vert.transform( final );
                        glVertex3dv( vert.getVector() );

                        vertices[v][0] = vert.get( 0 );
                        vertices[v][1] = vert.get( 1 );
                        vertices[v][2] = vert.get( 2 );
                     }
                  }

                  glVertex3dv( vertices[0] );
                  glVertex3dv( vertices[1] );

                  glVertex3dv( vertices[1] );
                  glVertex3dv( vertices[2] );

                  glVertex3dv( vertices[2] );
                  glVertex3dv( vertices[0] );
               }
            }
            glEnd();
         }
         else if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            //log_debug( "drawing animation '%s' frame %d\n", m_frameAnims[m_currentAnim]->m_name.c_str(), m_currentFrame );

            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               glBegin( GL_LINES );
               glColor3f( 1.0, 1.0, 1.0 );
               for ( unsigned t = 0; t < m_triangles.size(); t++ )
               {
                  Triangle * triangle = m_triangles[ t ];
                  triangle->m_marked = true;

                  if ( triangle->m_visible )
                  {
                     if ( triangle->m_selected )
                     {
                        if ( colorSelected == false )
                        {
                           glColor3f( 1.0, 0.0, 0.0 );
                        }
                        colorSelected = true;
                     }
                     else
                     {
                        if ( colorSelected == true )
                        {
                           glColor3f( 1.0, 1.0, 1.0 );
                        }
                        colorSelected = false;
                     }

                     double vertices[3][3];

                     for ( int v = 0; v < 3; v++ )
                     {
                        FrameAnimVertex * vertex = ((*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[ triangle->m_vertexIndices[v] ]);

                        vertices[v][0] = vertex->m_coord[0];
                        vertices[v][1] = vertex->m_coord[1];
                        vertices[v][2] = vertex->m_coord[2];
                     }

                     glVertex3dv( vertices[0] );
                     glVertex3dv( vertices[1] );

                     glVertex3dv( vertices[1] );
                     glVertex3dv( vertices[2] );

                     glVertex3dv( vertices[2] );
                     glVertex3dv( vertices[0] );
                  }
               }
               glEnd();
            }
            else
            {
               log_error( "No frame, (or no vertices) for this animation frame.\n" );
            }
         }
      }
      else
      {
         glLineWidth( 1.0 );
         glBegin( GL_LINES );
         glColor3f( 1.0, 1.0, 1.0 );
         for ( unsigned t = 0; t < m_triangles.size(); t++ )
         {
            Triangle * triangle = m_triangles[ t ];
            triangle->m_marked = true;

            if ( triangle->m_visible )
            {
               if ( triangle->m_selected )
               {
                  if ( colorSelected == false )
                  {
                     glEnd();
                     glLineWidth( 1.6 );
                     glBegin( GL_LINES );
                     glColor3f( 1.0, 0.0, 0.0 );
                  }
                  colorSelected = true;
               }
               else
               {
                  if ( colorSelected == true )
                  {
                     glEnd();
                     glLineWidth( 1.0 );
                     glBegin( GL_LINES );
                     glColor3f( 1.0, 1.0, 1.0 );
                  }
                  colorSelected = false;
               }

               double vertices[3][3];

               for ( int v = 0; v < 3; v++ )
               {
                  Vertex * vertex = (m_vertices[ triangle->m_vertexIndices[v] ]);

                  vertices[v][0] = vertex->m_coord[0];
                  vertices[v][1] = vertex->m_coord[1];
                  vertices[v][2] = vertex->m_coord[2];
               }

               glVertex3dv( vertices[0] );
               glVertex3dv( vertices[1] );

               glVertex3dv( vertices[1] );
               glVertex3dv( vertices[2] );

               glVertex3dv( vertices[2] );
               glVertex3dv( vertices[0] );
            }
         }
         glEnd();
      }
   }

   glLineWidth( 1.0 );
}

void Model::drawPoints()
{
   if ( m_initialized ) // && m_selectionMode == SelectVertices )
   {
      if ( m_animationMode )
      {
         // Note, in animation mode, we don't draw vertices for
         // skeletal animation, only for frame animations
         if ( m_animationMode == ANIMMODE_FRAME && m_currentAnim < m_frameAnims.size() )
         {
            if ( m_currentFrame < m_frameAnims[m_currentAnim]->m_frameVertices.size() && m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame]->size() > 0 )
            {
               glPointSize( 3.0 );

               glBegin( GL_POINTS );

               glColor3f( 1.0, 1.0, 1.0 );
               for ( unsigned t = 0; t < m_vertices.size(); t++ )
               {
                  if ( m_vertices[t]->m_visible )
                  {
                     FrameAnimVertex * vertex = (*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[t];

                     if ( m_vertices[t]->m_selected == false )
                     {
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
               glEnd();

               glPointSize( 4.0 );

               glBegin( GL_POINTS );
               glColor3f( 1.0, 0.0, 0.0 );
               for ( unsigned t = 0; t < m_vertices.size(); t++ )
               {
                  if ( m_vertices[t]->m_visible )
                  {
                     FrameAnimVertex * vertex = (*m_frameAnims[m_currentAnim]->m_frameVertices[m_currentFrame])[t];

                     if ( m_vertices[t]->m_selected )
                     {
                        glVertex3f( 
                              vertex->m_coord[0],
                              vertex->m_coord[1],
                              vertex->m_coord[2]
                              );
                     }
                  }
               }
               glEnd();
            }
         }
      }
      else
      {
         glPointSize( 3.0 );

         glBegin( GL_POINTS );

         glColor3f( 1.0, 1.0, 1.0 );
         for ( unsigned t = 0; t < m_vertices.size(); t++ )
         {
            if ( m_vertices[t]->m_visible )
            {
               Vertex * vertex = (m_vertices[ t ]);

               if ( vertex->m_selected == false )
               {
                  glVertex3f( 
                        vertex->m_coord[0],
                        vertex->m_coord[1],
                        vertex->m_coord[2]
                        );
               }
            }
         }
         glEnd();

         glPointSize( 4.0 );

         glBegin( GL_POINTS );
         glColor3f( 1.0, 0.0, 0.0 );
         for ( unsigned t = 0; t < m_vertices.size(); t++ )
         {
            if ( m_vertices[t]->m_visible )
            {
               Vertex * vertex = (m_vertices[ t ]);

               if ( vertex->m_selected )
               {
                  glVertex3f( 
                        vertex->m_coord[0],
                        vertex->m_coord[1],
                        vertex->m_coord[2]
                        );
               }
            }
         }
         glEnd();
      }
   }
}

#ifdef MM3D_EDIT

void Model::drawJoints()
{
   if ( m_drawJoints != JOINTMODE_NONE )
   {
      if ( m_initialized )
      {
         if ( m_animationMode == ANIMMODE_NONE || m_animationMode == ANIMMODE_SKELETAL )
         {
            glPointSize( 3.0 );

            glBegin( GL_LINES );
            for ( unsigned j = 0; j < m_joints.size(); j++ )
            {
               if ( m_joints[j]->m_visible && m_joints[j]->m_parent >= 0
                     && m_joints[ m_joints[j]->m_parent ]->m_visible )
               {
                  if ( m_animationMode && parentJointSelected( j ) )
                  {
                     glColor3f( 1.0, 0.0, 1.0 );
                  }
                  else
                  {
                     glColor3f( 0.0, 0.0, 1.0 );
                  }
                  Joint * joint  = m_joints[ j ];
                  Joint * parent = m_joints[ joint->m_parent ];

                  Vector pvec;
                  pvec.set( 0, parent->m_final.get(3, 0) );
                  pvec.set( 1, parent->m_final.get(3, 1) );
                  pvec.set( 2, parent->m_final.get(3, 2) );

                  Vector jvec;
                  jvec.set( 0, joint->m_final.get(3, 0) );
                  jvec.set( 1, joint->m_final.get(3, 1) );
                  jvec.set( 2, joint->m_final.get(3, 2) );

                  glVertex3f( 
                        pvec.get( 0 ),
                        pvec.get( 1 ),
                        pvec.get( 2 )
                        );
                  glVertex3f( 
                        jvec.get( 0 ),
                        jvec.get( 1 ),
                        jvec.get( 2 )
                        );

                  Vector face( 0.0, 1.0, 0.0 );
                  Vector point( jvec.get(0) - pvec.get(0), jvec.get(1) - pvec.get(1), jvec.get(2) - pvec.get(2) );

                  double length = distance( pvec, jvec );

                  Quaternion qrot;
                  qrot.setRotationToPoint( face, point );

                  Vector v1(  0.07,  0.10,  0.07 );
                  Vector v2( -0.07,  0.10,  0.07 );
                  Vector v3( -0.07,  0.10, -0.07 );
                  Vector v4(  0.07,  0.10, -0.07 );

                  v1 = v1 * length;
                  v2 = v2 * length;
                  v3 = v3 * length;
                  v4 = v4 * length;

                  Matrix m;
                  m.setRotationQuaternion( qrot );
                  v1 = v1 * m;
                  v2 = v2 * m;
                  v3 = v3 * m;
                  v4 = v4 * m;

                  if ( m_drawJoints == JOINTMODE_BONES )
                  {
                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( pvec.get( 0 ), pvec.get( 1 ), pvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v1.get(0), pvec.get(1) + v1.get(1), pvec.get(2) + v1.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v2.get(0), pvec.get(1) + v2.get(1), pvec.get(2) + v2.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v3.get(0), pvec.get(1) + v3.get(1), pvec.get(2) + v3.get(2) );

                     glVertex3f( jvec.get( 0 ), jvec.get( 1 ), jvec.get( 2 ));
                     glVertex3f( pvec.get(0) + v4.get(0), pvec.get(1) + v4.get(1), pvec.get(2) + v4.get(2) );

                  }
               }
            }
            glEnd();

            glBegin( GL_POINTS );
            for ( unsigned j = 0; j < m_joints.size(); j++ )
            {
               if ( m_joints[j]->m_visible )
               {
                  if ( m_joints[j]->m_selected )
                  {
                     glColor3f( 1.0, 0.0, 1.0 );
                  }
                  else if ( m_animationMode && hasSkelAnimKeyframe( m_currentAnim, m_currentFrame, j, true )  
                        || m_animationMode && hasSkelAnimKeyframe( m_currentAnim, m_currentFrame, j, false ) )
                  {
                     glColor3f( 0.0, 1.0, 0.0 );
                  }
                  else
                  {
                     glColor3f( 0.0, 0.0, 1.0 );
                  }
                  Joint * joint = (m_joints[ j ]);

                  glVertex3f( 
                        joint->m_final.get(3, 0),
                        joint->m_final.get(3, 1),
                        joint->m_final.get(3, 2)
                        );
               }
            }
            glEnd();
         }
      }
   }
}

#endif // MM3D_EDIT


#endif // 0 
