/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __TEXWIDGET_H
#define __TEXWIDGET_H

#include <qgl.h>

#include <vector>
#include <list>

class Texture;
class Model;
class QTimer;

class TextureWidget : public QGLWidget
{
   Q_OBJECT

   public:

      enum MouseOperation
      {
         MouseMove,
         MouseSelect,
         MouseScale
      };

      struct _TextureVertex {
         double s;
         double t;
         bool   selected;
      };

      typedef struct _TextureVertex TextureVertex;
      typedef std::vector< TextureVertex * > TextureVertexVector;

      struct _TextureTriangle {
         int vertex[3];
      };

      typedef struct _TextureTriangle TextureTriangle;
      typedef std::vector< TextureTriangle * > TextureTriangleVector;

      TextureWidget( QWidget * parent = NULL, const char * name = "" );
      ~TextureWidget();

      void setModel( Model * model );
      void setTexture( int materialId, Texture * texture );

      void set3d( bool o );

      void setTextureCount( unsigned c );
      void setSClamp( bool o ) { m_sClamp = o; setTexture( m_materialId, m_texture ); };
      void setTClamp( bool o ) { m_tClamp = o; setTexture( m_materialId, m_texture ); };

      void setMouseOperation( MouseOperation op );

      int  addVertex( double t, double s );
      int  addTriangle( int v1, int v2, int v3 );

      void clearCoordinates();
      void getCoordinates( int tri, float * s, float * t );

      // This is min/max of the current viewport, not of the
      // vertices in the viewport
      double getMinViewCoord() { return m_xMin; };
      double getMaxViewCoord() { return m_xMax; };

   public slots:
      void animationTimeout();

   signals:
      void updateCoordinatesSignal();

   protected:
      virtual void mousePressEvent( QMouseEvent * e );
      virtual void mouseReleaseEvent( QMouseEvent * e );
      virtual void mouseMoveEvent( QMouseEvent * e );

      void moveSelectedVertices( double x, double y );
      void updateSelectRegion( double x, double y );
      void startScale( double x, double y );
      void scaleSelectedVertices( double x, double y );

      void selectDone();
      void drawSelectBox();
      void clearSelected();

      void initializeGL();
      void paintGL();
      void resizeGL( int w, int h );

      void updateViewport();

      double distance( const double &, const double &, const double &, const double & );
      double max( const double &, const double & );

      int m_viewportWidth;
      int m_viewportHeight;

      bool m_sClamp;
      bool m_tClamp;

      float m_xOffset;
      float m_yOffset;

      int m_lastXPos;
      int m_lastYPos;

      Model * m_model;

      int       m_materialId;
      Texture * m_texture;
      GLuint m_glTexture;

      unsigned m_textureCount;

      TextureVertexVector   m_vertices;
      TextureTriangleVector m_triangles;

      MouseOperation m_operation;

      bool   m_selecting;
      bool   m_drawBounding;
      bool   m_3d;
      
      // For 3d view
      QTimer * m_animTimer;

      double m_xMin;
      double m_xMax;
      double m_yMin;
      double m_yMax;

      // For select
      double m_xSel1;
      double m_ySel1;
      double m_xSel2;
      double m_ySel2;
      
      // For scale
      typedef struct ScaleVertices_t
      {
         unsigned index;
         double x;
         double y;
      } ScaleVertices;

      typedef std::list<ScaleVertices> ScaleVerticesList;

      double m_farX;
      double m_farY;
      double m_startLengthX;
      double m_startLengthY;

      ScaleVerticesList m_scaleList;
};

#endif // __TEXWIDGET_H
