/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __VIEWWIN_H
#define __VIEWWIN_H

#include "mq3macro.h"
#include "mq3compat.h"

#include <list>


using std::list;

class QVBoxLayout;
class QMenuBar;
class QPopupMenu;
#ifdef HAVE_QT4
class Q3ToolBar;
#else 
class QToolBar;
#endif 

class QTimer;
class ViewPanel;
class StatusBar;
class Model;

class Command;
class Tool;
class Script;

class AnimWindow;
class QToolButton;

class Toolbox;
class CommandManager;
class QAccel;

class ViewWindow : public QMainWindow
{
   Q_OBJECT

   public:
      ViewWindow( Model * model, QWidget * parent = NULL, const char * name = "" );
      virtual ~ViewWindow();

      static bool closeAllWindows();

      static bool openModel( const char * filename );
      static bool openModelDialog( const char * openDirectory = NULL );

      static void invalidateModelTextures();

      void setModel( Model * model );

      bool openModelInWindow( const char * filename );
      bool openModelDialogInWindow( const char * openDirectory = NULL );

      bool getSaved();
      bool getAbortQuit() { return m_abortQuit; };
      void setAbortQuit( bool o ) { m_abortQuit = o; };
      
      Model *getModel() { return m_model; };

   public slots:
      void helpNowEvent( int );

      void saveModelEvent();
      void saveModelAsEvent();

      void mergeModelsEvent();
      void mergeAnimationsEvent();
      void scriptEvent();
      void runScript( const char * filename );

      void frameAllEvent();
      void frameSelectedEvent();

      void renderBadEvent();
      void renderSelectionEvent();

      void groupWindowEvent();
      void textureWindowEvent();
      void textureCoordEvent();
      void metaWindowEvent();
      void reloadTexturesEvent();

      void buttonToggled( bool on );

      void toolActivated( int id );
      void primitiveCommandActivated( int id );
      void groupCommandActivated( int id );
      void scriptActivated( int id );

      void animSetWindowEvent();
      void animExportWindowEvent();
      void animSetRotEvent();
      void animSetTransEvent();

      void startAnimationMode();
      void stopAnimationMode();
      void animationModeDone();

      void undoRequest();
      void redoRequest();

      void fillMruMenu();
      void openMru( int id );

      void fillScriptMruMenu();
      void openScriptMru( int id );

      void openModelEvent();
      void newModelEvent();
      void quitEvent();

      void pluginWindowEvent();
      void backgroundWindowEvent();
      void helpWindowEvent();
      void aboutWindowEvent();
      void licenseWindowEvent();

      void updateTimeoutCheck();
      void savedTimeoutCheck();

   protected:
      void updateCaption();

      void initializeToolbox();
      void initializeCommands();

      void closeEvent( QCloseEvent * e );
      //void resizeEvent( QResizeEvent * );

      typedef struct
      {
         int id;
         ::Tool * tool;
         int arg;
      } ToolMenuItem;

      typedef list< ToolMenuItem * > ToolMenuItemList;

      typedef struct
      {
         int id;
         Command * command;
         int arg;
      } CommandMenuItem;

      typedef list< CommandMenuItem * > CommandMenuItemList;

      QAccel      * m_accel;
      QMenuBar    * m_menuBar;
      QPopupMenu  * m_fileMenu;
      QPopupMenu  * m_viewMenu;
      QPopupMenu  * m_toolMenu;
      QPopupMenu  * m_primitiveMenu;
      QPopupMenu  * m_groupMenu;
      QPopupMenu  * m_animMenu;
      QPopupMenu  * m_scriptMenu;
      QPopupMenu  * m_helpMenu;
      QPopupMenu  * m_mruMenu;
      QPopupMenu  * m_scriptMruMenu;
#ifdef HAVE_QT4
      Q3ToolBar    * m_toolBar;
#else
      QToolBar   * m_toolBar;
#endif
      ViewPanel   * m_viewPanel;
      StatusBar   * m_statusBar;
      Model       * m_model;
      AnimWindow  * m_animWin;

      int           m_animSetsItem;
      int           m_animExportItem;
      int           m_animSetRotItem;
      int           m_animSetTransItem;
      int           m_startAnimItem;
      int           m_stopAnimItem;
      int           m_renderBadItem;
      int           m_renderSelectionItem;

      bool          m_abortQuit;

      CommandMenuItemList m_primitiveCommands;
      CommandMenuItemList m_groupCommands;
      ToolMenuItemList m_tools;

      CommandManager * m_cmdMgr;

      // Moved from toolwidget
      int m_toolCount;
      Toolbox     * m_toolbox;
      ::Tool        ** m_toolList;
      QToolButton ** m_toolButtons;
      QToolButton * m_last;
      ::Tool        * m_currentTool;

      QTimer      * m_savedTimer;
};


#endif // __VIEWWIN_H
