/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __ANIMWIN_H
#define __ANIMWIN_H

#include "animwin.base.h"

#include "mq3macro.h"

#include "mm3dport.h"

#include <list>

class Model;
class QTimer;
class QAccel;

class AnimWindow : public AnimWinBase
{
   Q_OBJECT

   public:
      AnimWindow( Model * model, bool isUndo, QWidget * parent = NULL, const char * name = "" );
      virtual ~AnimWindow();

      void doPlay();
      void doPause();

   signals:
      void animWindowClosed();

   public slots:
      void helpNowEvent( int );
      void closeEvent( QCloseEvent * e );

      void reject();

      void frameClearFrame();
      void frameCopyFrame();
      void framePasteFrame();
      void frameNewClicked();
      void frameRenameClicked();
      void frameDeleteClicked();
      void frameNameSelected(int);
      void frameSetCurrentFrame(int);
      void frameChangeFPS();
      void frameChangeFrameCount();

      void skelClearFrame();
      void skelCopyFrame();
      void skelDeleteClicked();
      void skelNameSelected(int);
      void skelNewClicked();
      void skelPasteFrame();
      void skelRenameClicked();
      void skelSetCurrentFrame(int);
      void skelChangeFPS();
      void skelChangeFrameCount();


      void timeElapsed();

      void playClicked();
      void stopClicked();
      void loopToggled(bool);

      void pageChanged( QWidget * newPage );

      void undoRequest();
      void redoRequest();
      void accelActivated( int id );

      void refreshPage();

   protected:
      void stopAnimationMode();

      Model  * m_model;
      bool     m_doLoop;
      bool     m_playing;
      double   m_timeInterval;
      double   m_currentTime;
      unsigned m_currentAnim;
      unsigned m_currentFrame;
      bool     m_isSkel;
      bool     m_undoing;
      bool     m_ignoreChange;
      bool     m_needShutdown;

      typedef struct KeyframeCopy_t
      {
         unsigned joint;
         double x;
         double y;
         double z;
         bool   isRotation;
      } KeyframeCopy;

      typedef struct FrameCopy_t
      {
         unsigned vertex;
         double x;
         double y;
         double z;
      } FrameCopy;

      typedef std::list<KeyframeCopy> KeyframeCopyList;
      typedef std::list<FrameCopy>    FrameCopyList;

      KeyframeCopyList m_keyframeCopyList;
      FrameCopyList    m_frameCopyList;

      PORT_timeval m_startTime;

      QTimer * m_animTimer;
      QAccel * m_accel;
};

#endif // __ANIMWIN_H
