#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msPlugInImpl.h"
#include "msLib.h"
#include "DlgOptions.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CMsPlugInApp

BEGIN_MESSAGE_MAP(CMsPlugInApp, CWinApp)
	//{{AFX_MSG_MAP(CMsPlugInApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp::CMsPlugInApp()
{
}

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp theApp;



cMsPlugIn*
CreatePlugIn ()
{
    return new cPlugIn ();
}



cPlugIn::cPlugIn ()
{
    strcpy (szTitle, "Vampire: the Masquerade NOD...");
}



cPlugIn::~cPlugIn ()
{
}



int
cPlugIn::GetType ()
{
    return cMsPlugIn::eTypeExport;
}



const char*
cPlugIn::GetTitle ()
{
    return szTitle;
}



static int
_LookupVertex (nod_vertex_t *pVertex, nod_vertex_t *pVertices, int nStartVertex, int *nNumVertices)
{
	for (int i = nStartVertex; i < *nNumVertices; i++)
	{
		if (memcmp (pVertex, &pVertices[i], sizeof (nod_vertex_t)) == 0)
			return i;
	}
	memcpy (&pVertices[*nNumVertices], pVertex, sizeof (nod_vertex_t));
	++(*nNumVertices);
	return ((*nNumVertices) - 1);
}



int
cPlugIn::Execute (msModel *pModel)
{
    if (!pModel)
        return -1;

    //
    // switch the module state for MFC Dlls
    //
    AFX_MANAGE_STATE(AfxGetStaticModuleState());

	if (msModel_GetMeshCount (pModel) == 0 &&
		msModel_GetMaterialCount (pModel) == 0)
	{
		::AfxMessageBox ("The model ist empty!  Nothing exported!");
		return -1;
	}

    //
    // options dialog
    //
    cDlgOptions dlgOptions (NULL);
    if (dlgOptions.DoModal () != IDOK)
        return 0;

    CString sPath = dlgOptions.GetPathName ();
    if (sPath.IsEmpty ())
        return 0;

    int nOptionFlags = dlgOptions.GetOptionFlags ();

	//
	//
	//

	int i, j, v;
	word nNumMaterials = msModel_GetMaterialCount (pModel);
	word nNumBones;
	if (nOptionFlags & eStaticModelOnly)
		nNumBones = 0;
	else
		nNumBones = msModel_GetBoneCount (pModel);
	word nNumMeshes = msModel_GetMeshCount (pModel);

	int nNumVertices = 0;
	int nNumFaces = 0;

	int nModelFlags;
	if (nOptionFlags & eStaticModelOnly)
		nModelFlags = NOD_MF_STATIC;
	else
		nModelFlags = 0;
	float Bounds[6] = { 99999, 99999, 99999, -99999, -99999, -99999 };

	// count total amount of triangles
	for (i = 0; i < msModel_GetMeshCount (pModel); i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		nNumFaces += msMesh_GetTriangleCount (pMesh);
	}

	// allocate enough storage
	nod_vertex_t *pNodVertices = new nod_vertex_t[nNumFaces * 3];
	if (!pNodVertices)
		return -1;

	nod_face_t *pNodFaces = new nod_face_t[nNumFaces];
	if (!pNodFaces)
	{
		delete[] pNodVertices;
		return -1;
	}

	nod_meshgroup_t *pNodMeshGroups = new nod_meshgroup_t[nNumMeshes];
	if (!pNodMeshGroups)
	{
		delete[] pNodFaces;
		delete[] pNodVertices;
		return -1;
	}

	nNumFaces = 0;
	int nLastNumVertices = 0;
	// prepare the vertex data and the faces
	for (i = 0; i < nNumMeshes; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		memset (&pNodMeshGroups[i], 0, sizeof (nod_meshgroup_t));
		pNodMeshGroups[i].MaterialID = msMesh_GetMaterialIndex (pMesh);
		pNodMeshGroups[i].NumFaces = msMesh_GetTriangleCount (pMesh);
		pNodMeshGroups[i].NumVertices = 0; // see below
		pNodMeshGroups[i].GroupFlags = NOD_GF_NOWEIGHTS;
		pNodMeshGroups[i].BoneNum = 0;
		pNodMeshGroups[i].MeshNum = i;
		for (j = 0; j < pNodMeshGroups[i].NumFaces; j++)
		{
			msTriangle *pTriangle = msMesh_GetTriangleAt (pMesh, j);
			word vindices[3];
			word nindices[3];
			msTriangle_GetVertexIndices (pTriangle, vindices);
			msTriangle_GetNormalIndices (pTriangle, nindices);
			word nIndices[3];
			for (v = 0; v < 3; v++)
			{
				msVertex *pVertex = msMesh_GetVertexAt (pMesh, vindices[v]);
				msVec3 Normal;
				msMesh_GetVertexNormalAt (pMesh, nindices[v], Normal);
				nod_vertex_t NodVertex;
				NodVertex.Pos[0] = pVertex->Vertex[0];
				NodVertex.Pos[2] = pVertex->Vertex[1];
				NodVertex.Pos[1] = pVertex->Vertex[2];
				NodVertex.Norm[0] = Normal[0];
				NodVertex.Norm[2] = Normal[1];
				NodVertex.Norm[1] = Normal[2];
				NodVertex.UV[0] = pVertex->u;
				NodVertex.UV[1] = 1.0f - pVertex->v;
				NodVertex.BoneNum = pVertex->nBoneIndex;

				nIndices[v] = _LookupVertex (&NodVertex, pNodVertices, nLastNumVertices, &nNumVertices)
							- nLastNumVertices;

				// calc bounds
				for (int t = 0; t < 3; t++)
				{
					if (NodVertex.Pos[t] < Bounds[t])
						Bounds[t] = NodVertex.Pos[t];
					if (NodVertex.Pos[t] > Bounds[3 + t])
						Bounds[3 + t] = NodVertex.Pos[t];
				}
			}
			pNodFaces[nNumFaces].indices[0] = nIndices[0];
			pNodFaces[nNumFaces].indices[2] = nIndices[1];
			pNodFaces[nNumFaces].indices[1] = nIndices[2];
			++nNumFaces;
		}
		pNodMeshGroups[i].NumVertices = nNumVertices - nLastNumVertices;
		pNodMeshGroups[i].MinVertices = pNodMeshGroups[i].NumVertices;
		nLastNumVertices = nNumVertices;
	}

	//
	// write it to file
	//

	FILE *file = fopen((LPCTSTR) sPath, "wb");
	if (!file)
		return -1;

	nod_header1_t Header1;
	Header1.Version = 7;
	Header1.NumMaterials = nNumMaterials;
	fwrite (&Header1, 1, sizeof (nod_header1_t), file);

	for (i = 0; i < nNumMaterials; i++)
	{
		msMaterial *pMaterial = msModel_GetMaterialAt (pModel, i);
		char szMaterialName[32];
		memset (szMaterialName, 0, 32);
		msMaterial_GetName (pMaterial, szMaterialName, 32);
		fwrite (szMaterialName, 32, sizeof (char), file);
	}

	nod_header2_t Header2;
	Header2.NumBones = nNumBones;
	Header2.NumMeshs = nNumMeshes;
	Header2.NumVertices = nNumVertices;
	Header2.NumFaces = nNumFaces;
	Header2.NumGroups = nNumMeshes;
	Header2.ModelFlags = nModelFlags;
	memcpy (Header2.Bounds, Bounds, sizeof (float) * 6);
	fwrite (&Header2, 1, sizeof (nod_header2_t), file);

	// bones
	for (i = 0; i < Header2.NumBones; i++)
	{
		msBone *pBone = msModel_GetBoneAt (pModel, i);
		nod_bone_t NodBone;
		memset (&NodBone, 0, sizeof (nod_bone_t));
		// MCTODO:
		NodBone.ParentID = -1;
		NodBone.ChildID = -1;
		NodBone.SiblingID = -1;
		fwrite (&NodBone, 1, sizeof (nod_bone_t), file);
	}
	
	// mesh definitions
	for (i = 0; i < Header2.NumMeshs; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		char szMeshName[32];
		memset (szMeshName, 0, 32);
		msMesh_GetName (pMesh, szMeshName, 32);
		fwrite (szMeshName, 32, sizeof (char), file);
	}

	// vertices
	fwrite (pNodVertices, Header2.NumVertices, sizeof (nod_vertex_t), file);

	// no LOD

	// faces
	fwrite (pNodFaces, Header2.NumFaces, sizeof (nod_face_t), file);

	// mesh groups
	fwrite (pNodMeshGroups, Header2.NumGroups, sizeof (nod_meshgroup_t), file);

	fclose (file);

	delete[] pNodMeshGroups;
	delete[] pNodFaces;
	delete[] pNodVertices;

	//
	// Never forget to destroy the model, after an export!!
	//
	msModel_Destroy (pModel);

    return 0;
}

