#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msPlugInImpl.h"
#include "msLib.h"
#include "DlgOptions.h"
#include "mathlib.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CMsPlugInApp

BEGIN_MESSAGE_MAP(CMsPlugInApp, CWinApp)
	//{{AFX_MSG_MAP(CMsPlugInApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp::CMsPlugInApp()
{
}

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp theApp;



cMsPlugIn*
CreatePlugIn ()
{
    return new cPlugIn ();
}



cPlugIn::cPlugIn ()
{
    strcpy (szTitle, "Vampire: the Masquerade NOD...");
}



cPlugIn::~cPlugIn ()
{
}



int
cPlugIn::GetType ()
{
    return cMsPlugIn::eTypeImport;
}



const char*
cPlugIn::GetTitle ()
{
    return szTitle;
}



void GUtil_GetEulerAngles2(const float m[3][4], float angles[3])
{
	float cy;

	// order of angles x,y,z

	cy = (float) sqrt(m[0][0] * m[0][0] + m[0][1] * m[0][1]); // AX^2 + BX^2

	if (cy > 16 * 0.001)
		{
			angles[0] = (float) atan2(m[1][2], m[2][2]); // CY, CZ
			angles[1] = (float) atan2(-m[0][2], cy); // -CX, cy
			angles[2] = (float) atan2(m[0][1], m[0][0]); // BX, AX
		}
	else
		{
			angles[0] = (float) atan2(-m[2][1], m[1][1]); //-BZ, BY
			angles[1] = (float) atan2(-m[0][2], cy);	// -CX, cy
			angles[2] = 0;
		}
}



int
cPlugIn::Execute (msModel *pModel)
{
    if (!pModel)
        return -1;

    //
    // switch the module state for MFC Dlls
    //
    AFX_MANAGE_STATE(AfxGetStaticModuleState());

    //
    // options dialog
    //
    cDlgOptions dlgOptions (NULL);
    if (dlgOptions.DoModal () != IDOK)
        return 0;

    CString sPath = dlgOptions.GetPathName ();
    if (sPath.IsEmpty ())
        return 0;

    int nOptionFlags = dlgOptions.GetOptionFlags ();

	//
	//
	//

	FILE *file = fopen((LPCTSTR) sPath, "rb");
	if (!file)
		return -1;

	fseek (file, 0, SEEK_END);
	int nLen = (int) ftell (file);
	fseek (file, 0, SEEK_SET);

	byte *pBuffer = new byte[nLen];
	if (!pBuffer)
	{
		fclose (file);
		return -1;
	}

	fread (pBuffer, nLen, sizeof (byte), file);
	fclose (file);

	// setup pointers
	nod_header1_t *pHeader1 = (nod_header1_t *) pBuffer;
	nod_material_t *pMaterials = (nod_material_t *) ((byte *) pHeader1 + sizeof (nod_header1_t));
	nod_header2_t *pHeader2 = (nod_header2_t *) ((byte *) pMaterials + pHeader1->NumMaterials * sizeof (nod_material_t));
	nod_bone_t *pBones = (nod_bone_t *) ((byte *) pHeader2 + sizeof (nod_header2_t));
	nod_mesh_t *pMeshes = (nod_mesh_t *) ((byte *) pBones + pHeader2->NumBones * sizeof (nod_bone_t));	
	nod_vertex_t *pVertices = (nod_vertex_t *) ((byte *) pMeshes + pHeader2->NumMeshs * sizeof (nod_mesh_t));
	nod_meshgroup_t *pMeshGroups = (nod_meshgroup_t *) ((byte *) pHeader1 + nLen - pHeader2->NumGroups * sizeof (nod_meshgroup_t));
	nod_face_t *pFaces = pFaces = (nod_face_t *) ((byte *) pMeshGroups - pHeader2->NumFaces * sizeof (nod_face_t));
	pVertices = (nod_vertex_t *) ((byte *) pFaces - pHeader2->NumVertices * sizeof (nod_vertex_t));
	if (pHeader2->ModelFlags & NOD_MF_HASLOD)
		pVertices = (nod_vertex_t *) ((byte *) pVertices - pHeader2->NumVertices * sizeof (word));

	//
	// materials
	//
	int i;
	for (i = 0; i < pHeader1->NumMaterials; i++)
	{
		int nMaterial = msModel_AddMaterial (pModel);
		msMaterial *pMaterial = msModel_GetMaterialAt (pModel, i);
		msMaterial_SetName (pMaterial, pMaterials[i].MaterialName);
		char szTexture[256];
		sprintf (szTexture, "%s.tga", pMaterials[i].MaterialName);
		msMaterial_SetDiffuseTexture (pMaterial, szTexture);
		msVec4 ambient = { 0.2f, 0.2f, 0.2f, 1.0f };
		msMaterial_SetAmbient (pMaterial, ambient);
		msVec4 diffuse = { 0.8f, 0.8f, 0.8f, 1.0f };
		msMaterial_SetDiffuse (pMaterial, diffuse);
	}

	//
	// bones
	//

	vec3_t angles = { -90.0f, 0.0f, 0.0f };
	float m[3][4];
	AngleMatrix (angles, m);

	if (nOptionFlags & eBones)
	{
		for (i = 0; i < pHeader2->NumBones; i++)
		{
			int nBone = msModel_AddBone (pModel);
			msBone *pBone = msModel_GetBoneAt (pModel, nBone);
			char szName[32];
			sprintf (szName, "Bone%02d", i + 1);
			msBone_SetName (pBone, szName);
			msVec3 Rot = { 0.0f, 0.0f, 0.0f };
			msVec3 Pos;
			GUtil_GetEulerAngles2 (pBones[i].RestMatrixInverse, Rot);
			if (pBones[i].ParentID != -1)
			{
				Pos[0] = pBones[i].RestTranslate[0];
				Pos[1] = pBones[i].RestTranslate[1];
				Pos[2] = pBones[i].RestTranslate[2];
				sprintf (szName, "Bone%02d", pBones[i].ParentID);
			}
			else
			{
				Pos[0] = pBones[i].RestTranslate[0];
				Pos[1] = pBones[i].RestTranslate[1];
				Pos[2] = pBones[i].RestTranslate[2];
				//Rot[0] += 90.0f;
				strcpy (szName, "");
			}
			msBone_SetParentName (pBone, szName);
			msBone_SetPosition (pBone, Pos);
			msBone_SetRotation (pBone, Rot);
		}
	}

	//
	// meshes
	//
	int j;
	int nVertexBase = 0;
	int nFaceBase = 0;

	for (i = 0; i < pHeader2->NumGroups; i++)
	{
		int nMesh = msModel_AddMesh (pModel);
		msMesh *pMesh = msModel_GetMeshAt (pModel, nMesh);
		msMesh_SetName (pMesh, pMeshes[pMeshGroups[i].MeshNum].MeshName);
		msMesh_SetMaterialIndex (pMesh, pMeshGroups[i].MaterialID);

		for (j = 0; j < pMeshGroups[i].NumVertices; j++)
		{
			int nVertex = msMesh_AddVertex (pMesh);
			msVertex *pVertex = msMesh_GetVertexAt (pMesh, nVertex);
			pVertex->Vertex[0] = pVertices[nVertexBase + j].Pos[0];
			pVertex->Vertex[2] = pVertices[nVertexBase + j].Pos[1];
			pVertex->Vertex[1] = pVertices[nVertexBase + j].Pos[2];
			pVertex->u = pVertices[nVertexBase + j].UV[0];
			pVertex->v = 1.0f - pVertices[nVertexBase + j].UV[1];
			if (nOptionFlags & eBones)
				pVertex->nBoneIndex = pVertices[nVertexBase + j].BoneNum;
			else
				pVertex->nBoneIndex = -1;
		}

		for (j = 0; j < pMeshGroups[i].NumFaces; j++)
		{
			int nTriangle = msMesh_AddTriangle (pMesh);
			msTriangle *pTriangle = msMesh_GetTriangleAt (pMesh, nTriangle);
			word nIndices[3];
			nIndices[0] = pFaces[nFaceBase + j].indices[0];
			nIndices[2] = pFaces[nFaceBase + j].indices[1];
			nIndices[1] = pFaces[nFaceBase + j].indices[2];
			msTriangle_SetVertexIndices (pTriangle, nIndices);
		}

		nVertexBase += pMeshGroups[i].NumVertices;
		nFaceBase += pMeshGroups[i].NumFaces;
	}

	delete[] pBuffer;

    return 0;
}

