#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msPlugInImpl.h"
#include "msLib.h"
#include "DlgOptions.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CMsPlugInApp

BEGIN_MESSAGE_MAP(CMsPlugInApp, CWinApp)
	//{{AFX_MSG_MAP(CMsPlugInApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp::CMsPlugInApp()
{
}

/////////////////////////////////////////////////////////////////////////////
//

CMsPlugInApp theApp;



cMsPlugIn*
CreatePlugIn ()
{
    return new cPlugIn ();
}



cPlugIn::cPlugIn ()
{
    strcpy (szTitle, "The Sims SKN");
}



cPlugIn::~cPlugIn ()
{
}



int
cPlugIn::GetType ()
{
    return cMsPlugIn::eTypeExport;
}



const char*
cPlugIn::GetTitle ()
{
    return szTitle;
}



int
cPlugIn::Execute (msModel *pModel)
{
    if (!pModel)
        return -1;

    //
    // switch the module state for MFC Dlls
    //
    AFX_MANAGE_STATE(AfxGetStaticModuleState());

	if (msModel_GetMeshCount (pModel) == 0)
	{
		::AfxMessageBox ("The model ist empty!  Nothing exported!");
		return -1;
	}

	if (msModel_GetMaterialCount (pModel) >= 1)
	{
		::AfxMessageBox ("SKN files support only one texture per model!  Texture of first material is used!");
	}
		
	CString sPathName;
    CFileDialog fileDlg (FALSE, "skn", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
                         "The Sims SKN Files (*.skn)|*.skn|All Files (*.*)|*.*||");
    if (!fileDlg.DoModal ())
	{
        return -1;
	}
    else
	{
        sPathName = fileDlg.GetPathName ();
	}

	FILE *file = fopen ((LPCTSTR) sPathName, "wt");
	if (!file)
		return -1;

	fprintf (file, "%s\n", (LPCTSTR) fileDlg.GetFileTitle ());

	char szTexture[256] = "x";
	if (msModel_GetMaterialCount (pModel) > 0)
	{
		msMaterial *pMaterial = msModel_GetMaterialAt (pModel, 0);
		if (strlen (pMaterial->szDiffuseTexture) > 0)
			msMaterial_GetDiffuseTexture (pMaterial, szTexture, 256);
	}
	fprintf (file, "%s\n", szTexture);

	int i, j;
	int nMeshCount = msModel_GetMeshCount (pModel);
	fprintf (file, "%d\n", nMeshCount);
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		char szMeshName[64];
		msMesh_GetName (pMesh, szMeshName, 64);
		fprintf (file, "%s\n", szMeshName);
	}

	int nVertexCount = 0;
	int nTriangleCount = 0;
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		nVertexCount += msMesh_GetVertexCount (pMesh);
		nTriangleCount += msMesh_GetTriangleCount (pMesh);
	}

	fprintf (file, "%d\n", nTriangleCount);
	int nLastVertexCount = 0;
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		for (j = 0; j < msMesh_GetTriangleCount (pMesh); j++)
		{
			msTriangle *pTriangle = msMesh_GetTriangleAt (pMesh, j);
			word nIndices[3];
			msTriangle_GetVertexIndices (pTriangle, nIndices);
			fprintf (file, "%d %d %d\n",
				nIndices[0] + nLastVertexCount,
				nIndices[1] + nLastVertexCount,
				nIndices[2] + nLastVertexCount);
		}
		nLastVertexCount += msMesh_GetVertexCount (pMesh);
	}

	fprintf (file, "%d\n", nMeshCount);
	nLastVertexCount = 0;
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		fprintf (file, "%d %d %d -1 0\n", i, nLastVertexCount, msMesh_GetTriangleCount (pMesh));
		nLastVertexCount += msMesh_GetVertexCount (pMesh);
	}

	fprintf (file, "%d\n", nVertexCount);
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		for (j = 0; j < msMesh_GetVertexCount (pMesh); j++)
		{
			msVertex *pVertex = msMesh_GetVertexAt (pMesh, j);
			fprintf (file, "%f %f\n", pVertex->u, pVertex->v);
		}
	}

	fprintf (file, "0\n");

	fprintf (file, "%d\n", nVertexCount);
	for (i = 0; i < nMeshCount; i++)
	{
		msMesh *pMesh = msModel_GetMeshAt (pModel, i);
		for (j = 0; j < msMesh_GetVertexCount (pMesh); j++)
		{
			msVertex *pVertex = msMesh_GetVertexAt (pMesh, j);
			fprintf (file, "%f %f %f 1.0 0.0 0.0\n",
				pVertex->Vertex[0], pVertex->Vertex[1], pVertex->Vertex[2]);
		}
	}

	fclose (file);

	//
	// Never forget to destroy the model, after an export!!
	//
	msModel_Destroy (pModel);

    return 0;
}

