/*
    msPlugInOptions.cpp - Exporter options.

    Copyright (c) John Thompson, 2001-2004.  All rights reserved.
*/

#include "stdafx.h"
#include "msPlugInImpl.h"
#include "msPlugInOptions.h"
#include "msPlugInHelp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPlugInOptions dialog


CPlugInOptions::CPlugInOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CPlugInOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlugInOptions)
	m_fAnimationRate = 30.0f;
	m_fPositionScale = 0.1f;
	m_fPositionOffsetX = 0.0f;
	m_fPositionOffsetY = 0.0f;
	m_fPositionOffsetZ = 0.0f;
	m_fRotationX = 0.0f;
	m_fRotationY = 0.0f;
	m_fRotationZ = 0.0f;
	m_blFlipTextureVertical = FALSE;
	m_blExcludeAnimation = FALSE;
	m_sRootFrameName = _T("");
	m_blLoopAnimations = FALSE;
	m_blSplinePositions = FALSE;
	m_blSplineRotations = FALSE;
	m_sAnimationSetName = _T("");
	m_blMatrixKeys = FALSE;
	m_blCenterAtOffset = FALSE;
	m_blStandAtOffset = FALSE;
	m_blExcludeAnimationOptions = FALSE;
	m_blAddInterpolations = FALSE;
	m_blBinaryFormat = FALSE;
	m_blFlipTextureHorizontal = FALSE;
	m_iInterpolationCount = 0;
	m_blRightHanded = FALSE;
	m_blExcludeGeometry = FALSE;
	m_blMeshOnly = FALSE;
	m_blBinary = FALSE;
	m_fAnimationRangeLow = 0.0f;
	m_fAnimationRangeHigh = 0.0f;
	m_blAddRootFrame = FALSE;
	m_blAddTemplates = FALSE;
	m_blAddSkinAndBonesTemplates = FALSE;
	m_blCloseHoles = FALSE;
    m_blExcludeNormals = FALSE;
	//}}AFX_DATA_INIT

    m_iFormat = kFormatDirectXRetainedMode;
}


void CPlugInOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlugInOptions)
	DDX_Control(pDX, IDC_CHECK_CLOSE_HOLES, m_oCheckCloseHoles);
	DDX_Control(pDX, IDC_CHECK_ADD_TEMPLATES, m_oCheckAddTemplates);
	DDX_Control(pDX, IDC_CHECK_ADD_SKIN_AND_BONES_TEMPLATES, m_oCheckAddSkinAndBonesTemplates);
	DDX_Control(pDX, IDC_CHECK_ADD_ROOT_FRAME, m_oCheckAddRootFrame);
	DDX_Control(pDX, IDC_CHECK_BINARY, m_oCheckBinary);
	DDX_Control(pDX, IDC_CHECK_RIGHT_HANDED, m_oCheckRightHanded);
	DDX_Control(pDX, IDC_CHECK_EXCLUDE_GEOMETRY, m_oCheckExcludeGeometry);
	DDX_Control(pDX, IDC_EDIT_ROTATION_Z, m_oEditRotationZ);
	DDX_Control(pDX, IDC_EDIT_ROTATION_Y, m_oEditRotationY);
	DDX_Control(pDX, IDC_EDIT_ROTATION_X, m_oEditRotationX);
	DDX_Control(pDX, IDC_EDIT_ROOT_FRAME_NAME, m_oEditRootFrameName);
	DDX_Control(pDX, IDC_EDIT_POSITION_SCALE, m_oEditPositionScale);
	DDX_Control(pDX, IDC_EDIT_POSITION_OFFSET_Z, m_oEditPositionOffsetZ);
	DDX_Control(pDX, IDC_EDIT_POSITION_OFFSET_Y, m_oEditPositionOffsetY);
	DDX_Control(pDX, IDC_EDIT_POSITION_OFFSET_X, m_oEditPositionOffsetX);
	DDX_Control(pDX, IDC_STATIC_Z, m_oStaticZ);
	DDX_Control(pDX, IDC_STATIC_Y, m_oStaticY);
	DDX_Control(pDX, IDC_STATIC_X, m_oStaticX);
	DDX_Control(pDX, IDC_STATIC_ROTATION, m_oStaticRotation);
	DDX_Control(pDX, IDC_STATIC_ROOT_FRAME_NAME, m_oStaticRootFrameName);
	DDX_Control(pDX, IDC_STATIC_POSITION_SCALING, m_oStaticPositionScaling);
	DDX_Control(pDX, IDC_STATIC_POSITION_OFFSET, m_oStaticPositionOffset);
	DDX_Control(pDX, IDC_STATIC_INTERPOLATION_COUNT, m_oStaticInterpolationCount);
	DDX_Control(pDX, IDC_STATIC_ANIMATION_RANGE, m_oStaticAnimationRange);
	DDX_Control(pDX, IDC_EDIT_ANIMATION_RANGE_LOW, m_oEditAnimationRangeHigh);
	DDX_Control(pDX, IDC_EDIT_ANIMATION_RANGE_HIGH, m_oEditAnimationRangeLow);
	DDX_Control(pDX, IDC_COMBO_FORMAT, m_oComboFormat);
	DDX_Control(pDX, IDC_CHECK_FLIP_TEXTURE_VERTICAL, m_oCheckFlipTextureVertical);
	DDX_Control(pDX, IDC_CHECK_FLIP_TEXTURE_HORIZONTAL, m_oCheckFlipTextureHorizontal);
	DDX_Control(pDX, IDC_CHECK_MESH_ONLY, m_oCheckMeshOnly);
	DDX_Control(pDX, IDC_CHECK_ADD_INTERPOLATIONS, m_oCheckAddInterpolations);
	DDX_Control(pDX, IDC_EDIT_INTERPOLATION_COUNT, m_oEditInterpolationCount);
	DDX_Control(pDX, IDC_CHECK_MATRIX_KEYS, m_oCheckMatrixKeys);
	DDX_Control(pDX, IDC_CHECK_STAND_AT_OFFSET, m_oStandAtOffset);
	DDX_Control(pDX, IDC_CHECK_CENTER_AT_OFFSET, m_oCheckCenterAtOffset);
	DDX_Control(pDX, IDC_CHECK_EXCLUDE_ANIMATION_OPTIONS, m_oCheckExcludeAnimationOptions);
	DDX_Control(pDX, IDC_STATIC_ANIMATION_SET_NAME, m_oStaticAnimationSetName);
	DDX_Control(pDX, IDC_STATIC_ANIMATION_RATE, m_oStaticAnimationRate);
	DDX_Control(pDX, IDC_CHECK_EXCLUDE_ANIMATION, m_oButtonExcludeAnimation);
	DDX_Control(pDX, IDC_EDIT_ANIMATION_SET_NAME, m_oEditAnimationSetName);
	DDX_Control(pDX, IDC_EDIT_ANIMATION_RATE, m_oEditAnimationRate);
	DDX_Control(pDX, IDC_CHECK_SPLINE_ROTATIONS, m_oButtonSplineRotations);
	DDX_Control(pDX, IDC_CHECK_SPLINE_POSITIONS, m_oButtonSplinePositions);
	DDX_Control(pDX, IDC_CHECK_LOOP_ANIMATIONS, m_oButtonLoopAnimations);
	DDX_Text(pDX, IDC_EDIT_ANIMATION_RATE, m_fAnimationRate);
	DDV_MinMaxFloat(pDX, m_fAnimationRate, 0.f, 3.e+006f);
	DDX_Text(pDX, IDC_EDIT_POSITION_SCALE, m_fPositionScale);
	DDX_Text(pDX, IDC_EDIT_POSITION_OFFSET_X, m_fPositionOffsetX);
	DDX_Text(pDX, IDC_EDIT_POSITION_OFFSET_Y, m_fPositionOffsetY);
	DDX_Text(pDX, IDC_EDIT_POSITION_OFFSET_Z, m_fPositionOffsetZ);
	DDX_Text(pDX, IDC_EDIT_ROTATION_X, m_fRotationX);
	DDX_Text(pDX, IDC_EDIT_ROTATION_Y, m_fRotationY);
	DDX_Text(pDX, IDC_EDIT_ROTATION_Z, m_fRotationZ);
	DDX_Check(pDX, IDC_CHECK_FLIP_TEXTURE_VERTICAL, m_blFlipTextureVertical);
	DDX_Check(pDX, IDC_CHECK_EXCLUDE_ANIMATION, m_blExcludeAnimation);
	DDX_Text(pDX, IDC_EDIT_ROOT_FRAME_NAME, m_sRootFrameName);
	DDX_Check(pDX, IDC_CHECK_LOOP_ANIMATIONS, m_blLoopAnimations);
	DDX_Check(pDX, IDC_CHECK_SPLINE_POSITIONS, m_blSplinePositions);
	DDX_Check(pDX, IDC_CHECK_SPLINE_ROTATIONS, m_blSplineRotations);
	DDX_Text(pDX, IDC_EDIT_ANIMATION_SET_NAME, m_sAnimationSetName);
	DDX_Check(pDX, IDC_CHECK_MATRIX_KEYS, m_blMatrixKeys);
	DDX_Check(pDX, IDC_CHECK_CENTER_AT_OFFSET, m_blCenterAtOffset);
	DDX_Check(pDX, IDC_CHECK_STAND_AT_OFFSET, m_blStandAtOffset);
	DDX_Check(pDX, IDC_CHECK_EXCLUDE_ANIMATION_OPTIONS, m_blExcludeAnimationOptions);
	DDX_Check(pDX, IDC_CHECK_ADD_INTERPOLATIONS, m_blAddInterpolations);
	DDX_Check(pDX, IDC_CHECK_FLIP_TEXTURE_HORIZONTAL, m_blFlipTextureHorizontal);
	DDX_Text(pDX, IDC_EDIT_INTERPOLATION_COUNT, m_iInterpolationCount);
	DDX_Check(pDX, IDC_CHECK_RIGHT_HANDED, m_blRightHanded);
	DDX_Check(pDX, IDC_CHECK_EXCLUDE_GEOMETRY, m_blExcludeGeometry);
	DDX_Check(pDX, IDC_CHECK_MESH_ONLY, m_blMeshOnly);
	DDX_CBIndex(pDX, IDC_COMBO_FORMAT, m_iFormat);
	DDX_Check(pDX, IDC_CHECK_BINARY, m_blBinary);
	DDX_Text(pDX, IDC_EDIT_ANIMATION_RANGE_LOW, m_fAnimationRangeLow);
	DDX_Text(pDX, IDC_EDIT_ANIMATION_RANGE_HIGH, m_fAnimationRangeHigh);
	DDX_Check(pDX, IDC_CHECK_ADD_ROOT_FRAME, m_blAddRootFrame);
	DDX_Check(pDX, IDC_CHECK_ADD_TEMPLATES, m_blAddTemplates);
	DDX_Check(pDX, IDC_CHECK_ADD_SKIN_AND_BONES_TEMPLATES, m_blAddSkinAndBonesTemplates);
	DDX_Check(pDX, IDC_CHECK_CLOSE_HOLES, m_blCloseHoles);
	DDX_Check(pDX, IDC_CHECK_EXCLUDE_NORMALS, m_blExcludeNormals);
	//}}AFX_DATA_MAP

    OnCheckExcludeAnimation();
    OnCheckExcludeAnimationOptions();
    OnCheckExcludeGeometry();
    OnCheckAddRootFrame();
    OnCheckMeshOnly();
    OnSelchangeComboFormat();
}


BEGIN_MESSAGE_MAP(CPlugInOptions, CDialog)
	//{{AFX_MSG_MAP(CPlugInOptions)
	ON_BN_CLICKED(IDC_CHECK_EXCLUDE_ANIMATION, OnCheckExcludeAnimation)
	ON_BN_CLICKED(IDC_CHECK_EXCLUDE_ANIMATION_OPTIONS, OnCheckExcludeAnimationOptions)
	ON_BN_CLICKED(IDC_CHECK_STAND_AT_OFFSET, OnCheckStandAtOffset)
	ON_BN_CLICKED(IDC_CHECK_CENTER_AT_OFFSET, OnCheckCenterAtOffset)
	ON_BN_CLICKED(IDC_CHECK_ADD_INTERPOLATIONS, OnCheckAddInterpolations)
	ON_BN_CLICKED(IDC_CHECK_EXCLUDE_GEOMETRY, OnCheckExcludeGeometry)
	ON_BN_CLICKED(IDC_CHECK_MESH_ONLY, OnCheckMeshOnly)
	ON_BN_CLICKED(IDC_CHECK_ADD_ROOT_FRAME, OnCheckAddRootFrame)
	ON_CBN_SELCHANGE(IDC_COMBO_FORMAT, OnSelchangeComboFormat)
	ON_BN_CLICKED(IDC_CHECK_ADD_TEMPLATES, OnCheckAddTemplates)
	ON_BN_CLICKED(ID_BUTTON_HELP, OnButtonHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlugInOptions message handlers

void CPlugInOptions::OnCheckExcludeAnimation() 
{
    m_blExcludeAnimation = (m_oButtonExcludeAnimation.GetCheck() == 1 ? TRUE : FALSE);

    m_oCheckExcludeAnimationOptions.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oButtonLoopAnimations.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oButtonSplinePositions.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oButtonSplineRotations.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oCheckMatrixKeys.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oCheckAddInterpolations.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oStaticInterpolationCount.EnableWindow(
        m_blAddInterpolations && (TRUE - m_blExcludeAnimation));
    m_oEditInterpolationCount.EnableWindow(
        m_blAddInterpolations && (TRUE - m_blExcludeAnimation));
    m_oEditAnimationRate.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oEditAnimationRangeLow.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oEditAnimationRangeHigh.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oEditAnimationSetName.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oStaticAnimationRate.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oStaticAnimationRange.EnableWindow(TRUE - m_blExcludeAnimation);
    m_oStaticAnimationSetName.EnableWindow(TRUE - m_blExcludeAnimation);
}

void CPlugInOptions::OnCheckExcludeAnimationOptions() 
{
    if (!m_blExcludeAnimation)
    {
        m_blExcludeAnimationOptions = m_oCheckExcludeAnimationOptions.GetState() & 1;
        m_oButtonLoopAnimations.EnableWindow(TRUE - m_blExcludeAnimationOptions);
        m_oButtonSplinePositions.EnableWindow(TRUE - m_blExcludeAnimationOptions);
        m_oButtonSplineRotations.EnableWindow(TRUE - m_blExcludeAnimationOptions);
    }
}

void CPlugInOptions::OnCheckStandAtOffset() 
{
    m_blStandAtOffset = m_oStandAtOffset.GetState() & 1;

    if (m_blStandAtOffset)
    {
        m_blCenterAtOffset = FALSE;
        m_oCheckCenterAtOffset.SetCheck(FALSE);
    }
}

void CPlugInOptions::OnCheckCenterAtOffset() 
{
    m_blCenterAtOffset = m_oCheckCenterAtOffset.GetState() & 1;

    if (m_blCenterAtOffset)
    {
        m_blStandAtOffset = FALSE;
        m_oStandAtOffset.SetCheck(FALSE);
    }
}

void CPlugInOptions::OnCheckAddInterpolations() 
{
    m_blAddInterpolations = (m_oCheckAddInterpolations.GetCheck() == 1 ? TRUE : FALSE);
    m_oStaticInterpolationCount.EnableWindow(m_blAddInterpolations);
    m_oEditInterpolationCount.EnableWindow(m_blAddInterpolations);
}

void CPlugInOptions::OnCheckExcludeGeometry() 
{
    m_blExcludeGeometry = (m_oCheckExcludeGeometry.GetCheck() == 1 ? TRUE : FALSE);

    m_oCheckAddRootFrame.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckMeshOnly.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckBinary.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckRightHanded.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckFlipTextureVertical.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckFlipTextureHorizontal.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oCheckCenterAtOffset.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStandAtOffset.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticX.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticY.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticZ.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticPositionOffset.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditPositionOffsetX.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditPositionOffsetY.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditPositionOffsetZ.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticRotation.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditRotationX.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditRotationY.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditRotationZ.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticPositionScaling.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oEditPositionScale.EnableWindow(TRUE - m_blExcludeGeometry);
    m_oStaticRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
    m_oEditRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
}

void CPlugInOptions::OnCheckMeshOnly() 
{
    m_blMeshOnly = (m_oCheckMeshOnly.GetCheck() == 1 ? TRUE : FALSE);

    m_oCheckAddRootFrame.EnableWindow((TRUE - m_blMeshOnly) && (m_iFormat != kFormatJTGameSkinAndBones));
    m_oStaticRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
    m_oEditRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));

    m_oButtonExcludeAnimation.EnableWindow(TRUE - m_blMeshOnly);
    m_oCheckExcludeAnimationOptions.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oButtonLoopAnimations.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oButtonSplinePositions.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oButtonSplineRotations.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oCheckMatrixKeys.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oCheckAddInterpolations.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oStaticInterpolationCount.EnableWindow(
        m_blAddInterpolations && (TRUE - (m_blMeshOnly || m_blExcludeAnimation)));
    m_oEditInterpolationCount.EnableWindow(
        m_blAddInterpolations && (TRUE - (m_blMeshOnly || m_blExcludeAnimation)));
    m_oEditAnimationRate.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oEditAnimationRangeLow.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oEditAnimationRangeHigh.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oEditAnimationSetName.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oStaticAnimationRate.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oStaticAnimationRange.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
    m_oStaticAnimationSetName.EnableWindow(TRUE - (m_blMeshOnly || m_blExcludeAnimation));
}

void CPlugInOptions::OnCheckAddRootFrame() 
{
    m_blAddRootFrame = (m_oCheckAddRootFrame.GetCheck() == 1 ? TRUE : FALSE);
    m_oStaticRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
    m_oEditRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
}

void CPlugInOptions::OnSelchangeComboFormat() 
{
    int iOldFormat = m_iFormat;

    m_iFormat = m_oComboFormat.GetCurSel();

    m_oCheckAddRootFrame.EnableWindow((TRUE - m_blMeshOnly) && (m_iFormat != kFormatJTGameSkinAndBones));
    m_oStaticRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));
    m_oEditRootFrameName.EnableWindow(
        (m_blAddRootFrame || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups)) &&
            (TRUE - m_blMeshOnly) &&
            (TRUE - m_blExcludeGeometry));

    if ((m_iFormat == kFormatDirectXSkinAndBones) && (m_iFormat != iOldFormat))
    {
        m_blRightHanded = true;
        m_oCheckRightHanded.SetCheck(TRUE);

        if (!m_blAddTemplates)
        {
            m_blAddSkinAndBonesTemplates = TRUE;
            m_oCheckAddSkinAndBonesTemplates.SetCheck(TRUE);
        }
    }

    m_oCheckAddSkinAndBonesTemplates.EnableWindow(
        ((m_iFormat == kFormatDirectXSkinAndBones)
                || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups))
            && !m_blAddTemplates);

    m_oCheckCloseHoles.EnableWindow(
        (m_iFormat != kFormatJTGameSkinAndBones ? TRUE : FALSE));
}

void CPlugInOptions::OnCheckAddTemplates() 
{
    m_blAddTemplates = (m_oCheckAddTemplates.GetCheck() == 1 ? TRUE : FALSE);
    m_oCheckAddSkinAndBonesTemplates.EnableWindow(
        ((m_iFormat == kFormatDirectXSkinAndBones)
                || (m_iFormat == kFormatJTGameSkinAndBones) ||
                (m_iFormat == kFormatJTGameRenderGroups))
            && !m_blAddTemplates);
}

void CPlugInOptions::OnButtonHelp() 
{
    msPlugInHelp oHelp;
    oHelp.DoModal();
}
