//.wal -> .pcx converter by Trey Harrison
//NOTE THE FOLLOWING!!
//after you compile this, copy q2pal.dat to the end of the
//executable file (thats where the palette is read from)
//ex.  copy /b wal2pcx.exe+q2pal.dat wal2pcx.exe
//trey@crack.com

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

int extention_type=0;
unsigned char wal_pal[768];

char **argv;
int  argc;

void load_palette();
void remove_extention(char *string);
void write_pcx(char *base_name,unsigned char *mip, int width,int height,char *ext);

int main(int arg_count, char **arg_strings)
{
  argc = arg_count;
  argv = arg_strings;

  load_palette();

  FILE *f;

  char walname[32];
  int  mip1_offs,mip2_offs,mip3_offs,mip4_offs;
  int  width,height;
  int  mipsize;
  int  fname_num;

  unsigned char *mip=0;
  
  if (argc<2)
  {
    printf("Must specify the .wal file\n");
    exit(-1);
  }

  fname_num = 1;

  if (argc==3)
  {
    //some really lame commandline parsing
    if (!stricmp(argv[2],"-s"))
    {
      extention_type = 1;
      fname_num      = 1;
    }
    
    if (!stricmp(argv[1],"-s"))
    {
      extention_type = 1;
      fname_num      = 2;
    }
    
    if (!stricmp(argv[2],"-1"))
    {
      extention_type = 2;
      fname_num = 1;
    }
    
    if (!stricmp(argv[1],"-1"))
    {
      extention_type = 2;
      fname_num = 2;
    }
  }  

  f = fopen(argv[fname_num],"rb");
  if (!f)
  {
    printf("Invalid .wal name\n");
    exit(-1);
  }

  remove_extention(argv[fname_num]);

  fread(walname,32,1,f);
  
  fread(&width,1,sizeof(int),f);
  fread(&height,1,sizeof(int),f);

  mipsize = width*height;

  fread(&mip1_offs,1,sizeof(int),f);
  fread(&mip2_offs,1,sizeof(int),f);
  fread(&mip3_offs,1,sizeof(int),f);
  fread(&mip4_offs,1,sizeof(int),f);

  mip = new unsigned char [mipsize];
  fseek(f,mip1_offs,SEEK_SET);
  fread(mip,mipsize,1,f);
  write_pcx(argv[fname_num],mip,width,height,"_1");
  delete [mipsize] mip;

  if (extention_type==2)
  {
    //only writing the 1st mip. stop
    fclose(f);
    return 0;
  }

  //write the other mips
  //divide by 4 for each mip level
  mipsize = mipsize >> 2;

  mip = new unsigned char [mipsize];
  fseek(f,mip2_offs,SEEK_SET);
  fread(mip,mipsize,1,f);
  write_pcx(argv[fname_num],mip,width/2,height/2,"_2");
  delete [mipsize] mip;

  //divide by 4 for each mip level
  mipsize = mipsize >> 2;

  mip = new unsigned char [mipsize];
  fseek(f,mip3_offs,SEEK_SET);
  fread(mip,mipsize,1,f);
  write_pcx(argv[fname_num],mip,width/4,height/4,"_3");
  delete [mipsize] mip;

  //divide by 4 for each mip level
  mipsize = mipsize >> 2;

  mip = new unsigned char [mipsize];
  fseek(f,mip4_offs,SEEK_SET);
  fread(mip,mipsize,1,f);
  write_pcx(argv[fname_num],mip,width/8,height/8,"_4");
  delete [mipsize] mip;
  
  fclose(f);
  return 0;
}


void remove_extention(char *name)
{
  int i;
  for (i=strlen(name)-1;i;i--)
  {
    if (name[i]=='.') name[i]=0;
  }
}

void write_pcx(char *base_name,unsigned char *mip, int width,int height,char *ext)
{
  int i,j;
  short w,h,bytesperline;
  char fname[128];    
  FILE *f=0;

  switch (extention_type)
  {
  case 0:
    strcpy(fname,base_name);
    strcat(fname,ext);
    break;
  
  case 1:
    sprintf(fname,"%s_%d_%d",base_name,width,height);
    break;
  
  case 2:
    sprintf(fname,base_name);
    break;
  }

  strcat(fname,".pcx");

  f = fopen(fname,"wb");
  if (!f)
  {
    printf("Invalid destination .pcx filename, %s\n",fname);
    return;
  }

  printf("Writing .pcx file -> %s\n",fname);

  w = width-1;
  h = height-1;
  bytesperline = width;

  //hardcoded 8 bit uncompressed .pcx writer
  fputc(0x0A,f);
  fputc(0x05,f);
  fputc(0x01,f);
  fputc(0x08,f);
  fputc(0x00,f);
  fputc(0x00,f);
  fputc(0x00,f);
  fputc(0x00,f);
	
  fwrite(&w,sizeof(short),1,f);
  fwrite(&h,sizeof(short),1,f);

  fputc(0x00,f);
  fputc(0x96,f);
  fputc(0x00,f);
  fputc(0x96,f);

  for(i=0; i<48; i++)
    fputc(0x00,f);

  fputc(0x00,f);
  fputc(0x01,f);
  fwrite(&bytesperline,sizeof(short),1,f);
  fputc(0x02,f);

  for(i=0; i<59; i++)
    fputc(0x00,f);

  for(i=0; i<height; i++)
  {
    for(j=0; j<width; j++)
    {
      fputc(0xC1,f);
      fputc(mip[i*width+j],f);
    }
  }

  fputc(12,f);
	
  //write the palette
  fwrite(wal_pal,768,1,f);
  fclose(f);
}

void load_palette()
{
  //reads the pallete from the end of the executable file.
  //kinda hacky.

  FILE *f;
  f = fopen("q2pal.dat","rb");//argv[0],"rb");
  //fseek(f,-768,SEEK_END);
  
  if (!f)
  {
    printf("Couldnt read the palette from the executable\n");
    exit(-1);
  }

  fread(wal_pal,768,1,f);
  fclose(f);
}
