-------------------------------------------------------------------------
--MD2 Exporter V2.1.3
--Version 2.0 for 3ds Max 2012
--Adam Barton (adam@add3d.co.uk)
--Updated by Ruiner (http://www.netdoo.com/wodx)
--New: Added Export Support for multiple object/mesh selections
--hypov8: Added setup for kingpin, using paths from diffuse slot(mdx importer default)
--hypov8: Added option to get multiple model bounds to fix seam errors in multi part player models
--hypov8: Moved all code out of global varable. conflicts with other exporters
--hypov8: Added frame file suport without comma seperated. CVS still works. "1,1,framename"  "2,20,framename"
-------------------------------------------------------------------------


--add hypov8 todo
--struct MD2_glcmd
--(
--	s, --s texture coord.
--	t, --t texture coord.
--	index --vertex index
--)


utility MD2Export_KP "Kingpin MD2 Exporter"
(
	----------------------------------		
	-- global varables---------------
	----------------------------------	
	local Kingpin_MD2_Exporter_ver = "Kingpin MD2 Exporter V2.1.3"	

	local md2lastfile_kp=""
	local MD2Export_KP
	local framenamelist_kp=#()
	local nlist_kp=#([-0.525731, 0.000000, 0.850651],[-0.442863, 0.238856, 0.864188],[-0.295242, 0.000000, 0.955423],[-0.309017, 0.500000, 0.809017],[-0.162460, 0.262866, 0.951056],[0.000000, 0.000000, 1.000000],[0.000000, 0.850651, 0.525731],[-0.147621, 0.716567, 0.681718],[0.147621, 0.716567, 0.681718],[0.000000, 0.525731, 0.850651],[0.309017, 0.500000, 0.809017],[0.525731, 0.000000, 0.850651],[0.295242, 0.000000, 0.955423],[0.442863, 0.238856, 0.864188],[0.162460, 0.262866, 0.951056],[-0.681718, 0.147621, 0.716567],[-0.809017, 0.309017, 0.500000],[-0.587785, 0.425325, 0.688191],[-0.850651, 0.525731, 0.000000],[-0.864188, 0.442863, 0.238856],[-0.716567, 0.681718, 0.147621],[-0.688191, 0.587785, 0.425325],[-0.500000, 0.809017, 0.309017],[-0.238856, 0.864188, 0.442863],[-0.425325, 0.688191, 0.587785],[-0.716567, 0.681718, -0.147621],[-0.500000, 0.809017, -0.309017],[-0.525731, 0.850651, 0.000000],[0.000000, 0.850651, -0.525731],[-0.238856, 0.864188, -0.442863],[0.000000, 0.955423, -0.295242],[-0.262866, 0.951056, -0.162460],[0.000000, 1.000000, 0.000000],[0.000000, 0.955423, 0.295242],[-0.262866, 0.951056, 0.162460],[0.238856, 0.864188, 0.442863],[0.262866, 0.951056, 0.162460],[0.500000, 0.809017, 0.309017],[0.238856, 0.864188, -0.442863],[0.262866, 0.951056, -0.162460],[0.500000, 0.809017, -0.309017],[0.850651, 0.525731, 0.000000],[0.716567, 0.681718, 0.147621],[0.716567, 0.681718, -0.147621],[0.525731, 0.850651, 0.000000],[0.425325, 0.688191, 0.587785],[0.864188, 0.442863, 0.238856],[0.688191, 0.587785, 0.425325],[0.809017, 0.309017, 0.500000],[0.681718, 0.147621, 0.716567],[0.587785, 0.425325, 0.688191],[0.955423, 0.295242, 0.000000],[1.000000, 0.000000, 0.000000],[0.951056, 0.162460, 0.262866],[0.850651, -0.525731, 0.000000],[0.955423, -0.295242, 0.000000],[0.864188, -0.442863, 0.238856],[0.951056, -0.162460, 0.262866],[0.809017, -0.309017, 0.500000],[0.681718, -0.147621, 0.716567],[0.850651, 0.000000, 0.525731],[0.864188, 0.442863, -0.238856],[0.809017, 0.309017, -0.500000],[0.951056, 0.162460, -0.262866],[0.525731, 0.000000, -0.850651],[0.681718, 0.147621, -0.716567],[0.681718, -0.147621, -0.716567],[0.850651, 0.000000, -0.525731],[0.809017, -0.309017, -0.500000],[0.864188, -0.442863, -0.238856],[0.951056, -0.162460, -0.262866],[0.147621, 0.716567, -0.681718],[0.309017, 0.500000, -0.809017],[0.425325, 0.688191, -0.587785],[0.442863, 0.238856, -0.864188],[0.587785, 0.425325, -0.688191],[0.688191, 0.587785, -0.425325],[-0.147621, 0.716567, -0.681718],[-0.309017, 0.500000, -0.809017],[0.000000, 0.525731, -0.850651],[-0.525731, 0.000000, -0.850651],[-0.442863, 0.238856, -0.864188],[-0.295242, 0.000000, -0.955423],[-0.162460, 0.262866, -0.951056],[0.000000, 0.000000, -1.000000],[0.295242, 0.000000, -0.955423],[0.162460, 0.262866, -0.951056],[-0.442863, -0.238856, -0.864188],[-0.309017, -0.500000, -0.809017],[-0.162460, -0.262866, -0.951056],[0.000000, -0.850651, -0.525731],[-0.147621, -0.716567, -0.681718],[0.147621, -0.716567, -0.681718],[0.000000, -0.525731, -0.850651],[0.309017, -0.500000, -0.809017],[0.442863, -0.238856, -0.864188],[0.162460, -0.262866, -0.951056],[0.238856, -0.864188, -0.442863],[0.500000, -0.809017, -0.309017],[0.425325, -0.688191, -0.587785],[0.716567, -0.681718, -0.147621],[0.688191, -0.587785, -0.425325],[0.587785, -0.425325, -0.688191],[0.000000, -0.955423, -0.295242],[0.000000, -1.000000, 0.000000],[0.262866, -0.951056, -0.162460],[0.000000, -0.850651, 0.525731],[0.000000, -0.955423, 0.295242],[0.238856, -0.864188, 0.442863],[0.262866, -0.951056, 0.162460],[0.500000, -0.809017, 0.309017],[0.716567, -0.681718, 0.147621],[0.525731, -0.850651, 0.000000],[-0.238856, -0.864188, -0.442863],[-0.500000, -0.809017, -0.309017],[-0.262866, -0.951056, -0.162460],[-0.850651, -0.525731, 0.000000],[-0.716567, -0.681718, -0.147621],[-0.716567, -0.681718, 0.147621],[-0.525731, -0.850651, 0.000000],[-0.500000, -0.809017, 0.309017],[-0.238856, -0.864188, 0.442863],[-0.262866, -0.951056, 0.162460],[-0.864188, -0.442863, 0.238856],[-0.809017, -0.309017, 0.500000],[-0.688191, -0.587785, 0.425325],[-0.681718, -0.147621, 0.716567],[-0.442863, -0.238856, 0.864188],[-0.587785, -0.425325, 0.688191],[-0.309017, -0.500000, 0.809017],[-0.147621, -0.716567, 0.681718],[-0.425325, -0.688191, 0.587785],[-0.162460, -0.262866, 0.951056],[0.442863, -0.238856, 0.864188],[0.162460, -0.262866, 0.951056],[0.309017, -0.500000, 0.809017],[0.147621, -0.716567, 0.681718],[0.000000, -0.525731, 0.850651],[0.425325, -0.688191, 0.587785],[0.587785, -0.425325, 0.688191],[0.688191, -0.587785, 0.425325],[-0.955423, 0.295242, 0.000000],[-0.951056, 0.162460, 0.262866],[-1.000000, 0.000000, 0.000000],[-0.850651, 0.000000, 0.525731],[-0.955423, -0.295242, 0.000000],[-0.951056, -0.162460, 0.262866],[-0.864188, 0.442863, -0.238856],[-0.951056, 0.162460, -0.262866],[-0.809017, 0.309017, -0.500000],[-0.864188, -0.442863, -0.238856],[-0.951056, -0.162460, -0.262866],[-0.809017, -0.309017, -0.500000],[-0.681718, 0.147621, -0.716567],[-0.681718, -0.147621, -0.716567],[-0.850651, 0.000000, -0.525731],[-0.688191, 0.587785, -0.425325],[-0.587785, 0.425325, -0.688191],[-0.425325, 0.688191, -0.587785],[-0.425325, -0.688191, -0.587785],[-0.587785, -0.425325, -0.688191],[-0.688191, -0.587785, -0.425325])

	local img_with_kp=256
	local img_hight_kp=256

	--info
	local string_1 = "Updated to use the Bitmap path from material diffuse slot\n"
	local string_2 = "Path will be trimmed at  \"models/\"  or  \"players/ \"\n"
	local string_3 = "eg..   C:\Games\Kingpin\main\models\weapons\pipe\p.tga\n" 
	local string_4 = "to..   models/weapons/pipe/p.tga\n" 
	local string_5 = "\nFor players, select 3 model parts in the viewport then, hit \"Add\"\n"
	local string_6 = "Then select each model part in viewport and \"Export\"\n"
	local string_7 = "\nThis fixes vertex miss aligment from differnt float compresion\n\n"
	local string_8 = "Frame file supoorts comma seperated \"time,time,name\"\n1,1,Tpose\n2,10,Jumping\n11,22,Running"
	

	----------------------------------		
	-- user controls ---------------
	----------------------------------	
	checkbox UI_save_ani "Animated" checked:true align:#left across:2 tooltip:"Enable for Animated modes\nDisable for static models"
	checkbox UI_vertex_norn "Normals" align:#right checked:false tooltip:"Generate vertex normals"
	spinner UI_frame_steps "Frame Skip" range:[1,200,1] fieldwidth:20 type:#integer  align:#left 
	checkbox UI_usefile4frame "Frame names from File" checked:false align:#left 
	button UI_btn_browse4frame "File" align:#left across:2 height:18
	editText UI_file_4frame "" width: 100 align:#right
	group ""
	(
		radiobuttons UI_anim_time_from labels:#("Active Time Segment","Custom Time Segment")
		spinner UI_animstart_time "from" range:[0,1000,0] type:#integer fieldwidth:40 across:2  align:#centre
		spinner UI_animend_time "to" range:[0,1000,40] type:#integer fieldwidth:40  align:#centre 
	)
	
	group ""
	(
		checkbox UI_multipart_mdl 	"Player Model" align:#left checked:false tooltip:"Fix for multi part model aligment issues\nSets bounding box to the size of all model parts\nDISABLE for player weapons etc.." across:2
		button UI_AddModelToList " Add " align:#right  height:18	 --width:64
		listbox UI_listbox "" items:#("Select head, body, legs") height:3  --tooltip:"pick head body and legs"--width:144 
	) --end group multi part model
		
	button UI_btn_export "  Export .md2  "	align:#left across:2	  height:24	 
	button UI_info_about " Info " align:#right  height:24	 --width:64		

	
	
	
	
	

fn makemd2_kp object=
(	
	struct MD2_Tex
	(
		s,t
	)
	
	struct MD2_Vertex
	(
		pos, lightNormalIndex
	)

	struct MD2_Frame
	(
		scale, translate, name,
		vList,vNorm	
	)

	struct MD2_Tri
	(
		v1,v2,v3,				--vertIndices
		t1,t2,t3				--texCoordIndices
	)

	struct MD2_model
	(
		skinlist,
		texlist,
		trilist,
		framelist
	)
	
	local astart, aend
	
	if UI_anim_time_from.state==1 then --default auto time
	(
		astart=animationrange.start
		aend=animationrange.end
	)
	else
	(	--use imput time
		astart=UI_animstart_time.value
		aend=UI_animend_time.value
	)	
	if not(UI_save_ani.state) then 
	(
		astart=1
		aend=1
	)

	-----------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------
	md2=md2_model skinlist:#() texlist:#() trilist:#() framelist:#()
	-----------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------	
	
	--hypo textures list
	local modelTexName
	local modelIndex
	local error
	local	fdslash = "/"
	local bkslash	= "\\"	
	local mdlPath ="models/"
	local plyerPath ="players/"
	
	for k = 1 to $selection.count do 
	(
		obj=	$selection[k]
		error = 0
		
		if obj.material == Undefined  then	
		(
			error = 1
			print( "--> NO skinn")		
		)
		else if (classof obj.material) as string == "Standardmaterial" then	
		(	--set folder path	
			if (classof obj.material.diffusemap) as string == "Bitmaptexture" then
			(			
				print( "--> skinn name001= " +(obj.material.diffusemap.filename as string))			
				modelTexName = obj.material.diffusemap.filename
					
				img_with_kp = obj.material.diffusemap.bitmap.width
				img_hight_kp = obj.material.diffusemap.bitmap.height
	
				if (img_with_kp == undefined or img_hight_kp == undefined ) then	error = 1
					
				if obj.material != undefined then	
				(			
					print( "--> 3333 <--") 
					modelTexName = substituteString modelTexName bkslash fdslash --replace backSlash with forwardSlash
					modelIndex = findString modelTexName mdlPath					--find index to a folder named "models/"
					if modelIndex == undefined then
						modelIndex = findString modelTexName plyerPath
					if modelIndex == undefined then
						modelIndex = 1 --error in path name. use whole string
					
					if modelIndex < 1 then modelIndex = 1
					
					modelTexName = substring modelTexName modelIndex -1 	--rename  to mod path
				)	
				else					
				(
					error = 1	
				)
			)
			else	
			(
				modelTexName = obj.material.name
				if modelTexName != undefined then	error = 1
			)
		)
		else
		(
			error = 1
		)
		
		if error == 1 then
		(
			messagebox( "Using defaults\ntris.tga and 256px")		title:"ERROR Bitmap Missing!!"
			modelTexName = "tris.tga"
			img_with_kp = 256
			img_hight_kp = 256	
		)		
		
		append md2.skinlist (modelTexName)			
	)
	
	
	
	

	------------------------------------
	-- build texture vert list
	------------------------------------  
	
	for k = 1 to $selection.count do 
	(
		obj=	$selection[k]
		
		for i=1 to getnumtverts obj do
		(
			--s=(((getTVert obj i).x)*256) as integer
			--t=((-(getTVert obj i).y+1)*256) as integer
			s=(((getTVert obj i).x)*img_with_kp) as integer --hypov8
			t=((-(getTVert obj i).y+1)*img_hight_kp) as integer --hypov8
			
			append md2.texlist (md2_tex s:s t:t)
		)
	)

	------------------------------------
	-- build triangle list
	------------------------------------
	
	total = 0
	total2 = 0

	for k = 1 to $selection.count do 
	(
		obj=	$selection[k]
		temp = 0
		temp2 = 0
		
		for i=1 to obj.numfaces do
		(
			v1=((getFace obj i).z)-1
			v2=((getFace obj i).y)-1
			v3=((getFace obj i).x)-1
			
			if v1 > temp then
			(
				temp = v1
			)	
			if v2 > temp then
			(
				temp = v2
			)
			if v3 > temp then
			(
				temp = v3
			)
			
			v1 = v1 +total
			v2 = v2 +total
			v3 = v3 +total
			
			t1 = 0
			t2 = 0
			t3 = 0
			
			try
			(
				t1=((getTVFace obj i).z)-1
				t2=((getTVface obj i).y)-1
				t3=((getTVface obj i).x)-1
			)
			catch
			(
				print "------------------------"
				print obj.name
				print "------------------------"
			)

			if t1 > temp2 then
			(
				temp2 = t1
			)
			if t2 > temp2 then
			(
				temp2 = t2
			)
			if t3 > temp2 then
			(
				temp2 = t3
			)

			t1 = t1 + total2
			t2 = t2 + total2
			t3 = t3 + total2
			

			append md2.trilist (md2_Tri v1 v2 v3 t1 t2 t3)

			if i == obj.numfaces then
			(
				total = total + temp + 1
				total2 = total2 + temp2 + 1
			)
		)
	)


	-------------------------------------
	-- build frame list
	-------------------------------------
	local frameindex = astart as integer + 1
	for f=astart to aend by UI_frame_steps.value do 
	(
		local vertlist=#()
		local normlist=#()

		local framename = "FRAME 000......"

		if (UI_usefile4frame.checked) then
		(
			framename = framenamelist_kp[frameindex]
			if framename != undefined then framename	= substring  framename 1 15 --hypov8 make sure its not longer than 15 chars
			print framename
			frameindex = frameindex + UI_frame_steps.value
		)		
		
		if framename == undefined then
		(
			print ("-->ERROR frame missing name index= "+(frameindex as string))
			framename = "FRAME 000......"
		)

		frame=MD2_frame scale:[1,1,1] translate:[0,0,0] name:framename 
		vmin=[0,0,0]
		vmax=[0,0,0]
		
		--print("using multi models= "+(UI_multipart_mdl.state as string))
		--hypo models with multilpe parts are going out of wack. Calculating bbox size for complet model
		if (UI_multipart_mdl.state) and (UI_listbox.items.count > 1) then --must have 2 or more
		(
			--print("using multi models")
			for arrayMDL in UI_listbox.items do
			(
				obj = getNodeByName arrayMDL 
				for i=1 to obj.numverts do at time f
				(
					local v=in coordsys world(getvert obj i)
					if v.x<vmin.x then vmin.x=v.x
					if v.y<vmin.y then vmin.y=v.y
					if v.z<vmin.z then vmin.z=v.z
					if v.x>vmax.x then vmax.x=v.x
					if v.y>vmax.y then vmax.y=v.y
					if v.z>vmax.z then vmax.z=v.z	
				)
			)	
		)
		else
		(	
			for k = 1 to $selection.count do 
			(
				obj=	$selection[k]	
				for i=1 to obj.numverts do at time f
				(
					local v=in coordsys world(getvert obj i)
					--v+=object.pos
					--v*=object.scale
					--v-=object.pos
					if v.x<vmin.x then vmin.x=v.x
					if v.y<vmin.y then vmin.y=v.y
					if v.z<vmin.z then vmin.z=v.z
					if v.x>vmax.x then vmax.x=v.x
					if v.y>vmax.y then vmax.y=v.y
					if v.z>vmax.z then vmax.z=v.z	
				)
			)
		)
		
		frame.translate=vmin
		frame.scale=(vmax-vmin)/[255,255,255]
		
		
		for k = 1 to $selection.count do 
		(
			obj=	$selection[k]
			for i=1 to obj.numverts do at time f
			(
				local v=in coordsys world (getvert obj i)
				--v+=object.pos
				--v*=object.scale
				--v-=object.pos
				v-=frame.translate
				v/=frame.scale
				append vertlist v
				
				------------------------------------
				--do normals
				------------------------------------
				
				local vn=in coordsys world (getnormal obj i)
				local maxdot=-99999.0
				local normindex=1
				
				if UI_vertex_norn.state then
				for j=1 to nlist_kp.count do
				(
					local dotvalue
					dotvalue=dot nlist_kp[j] vn
					if dotvalue>maxdot then
					(
						maxdot=dotvalue
						normindex=j
					)
				)
				append normlist normindex 
			)
		)
		frame.vList=vertlist
		frame.vNorm=normlist
		append md2.framelist frame
	)	
	md2
)


fn writemd2_kp obj md2file=
(
	if obj==undefined then return"No object"
	
	for k = 1 to $selection.count do 
	(
		obj=	$selection[k]
		if (classof obj)!=editable_mesh then return "Object is not a mesh"
	)

	model=makemd2_kp obj

	print("button pressed2.1")
	f=fopen md2file "wb"
	
	----------------------------------------
	-- write the header
	----------------------------------------
	
	magic=844121161
	version=8
	skinw=img_with_kp
	skinh=img_hight_kp 
	framenum=model.framelist.count
	skinnum=model.skinlist.count
	print( "skinn count= " +(model.skinlist.count as string))
		
	vertnum=model.framelist[1].vlist.count
	texnum=model.texlist.count
	trinum=model.trilist.count
	glnum=0
	print("button pressed2.2")
	texsize=4
	trisize=12
	framesize=40+(4*vertnum)
	
	headersize=68				-- bytes in header
	offsetskins=headersize
	offsettexcoords=offsetskins+(skinnum*64)
	offsettris=offsettexcoords+(texnum*texsize)
	offsetframes=offsettris+(trinum*trisize)
	offsetgl=offsetframes+(framenum*framesize)
	offsetend=offsetgl+(glnum*4)
	print("button pressed2.3")
	writelong f magic
	writelong f version
	writelong f skinw				--(blitz dont care)
	writelong f skinh				--(blitz dont care)
	writelong f framesize
	writelong f skinnum
	writelong f vertnum
	writelong f texnum
	writelong f trinum
	writelong f glnum
	writelong f framenum
	writelong f offsetskins		--offset to skins
	writelong f offsettexcoords	--offset to texture coords
	writelong f offsettris		--offset to triangles
	writelong f offsetframes		--offset to frames
	writelong f offsetgl			--offset to gl commands
	writelong f offsetend			--offset to end

	-----------------------------------------------------
	-- end of header
	-----------------------------------------------------
	
	-----------------------------------------------------
	-- write out the skin names
	-----------------------------------------------------
	print("button pressed2.4")
	for i in model.skinlist do
	(
		local countx = 0
		print( "skinn -----= " +(i as string))
		skinname=i
		print( "skinn -----= " +(skinname.count as string))
			
		writestring f skinname	
			
		-- add hypo write null bytes to end of char array	
		for k = skinname.count to 62	 do
			(
				writebyte f 0 --add NULL
				
				countx += 1	--failsafe				
				if countx > 100 then
				(
					byte file
					MessageBox("error " +(skinname.count as string))				
					exit
				)
			)
	)
	
	print("button pressed2.5")
	-----------------------------------------------------
	-- write texture coordinate list
	-----------------------------------------------------
	
	for i in model.texlist do
	(
		writeshort f i.s #unsigned
		writeshort f i.t #unsigned
	)
	print("button pressed2.6")
	-----------------------------------------------------
	--write triangles
	-----------------------------------------------------	

	for i in model.trilist do
	(
		writeshort f i.v1 #unsigned
		writeshort f i.v2 #unsigned
		writeshort f i.v3 #unsigned
		writeshort f i.t1 #unsigned
		writeshort f i.t2 #unsigned
		writeshort f i.t3 #unsigned
	)
	print("button pressed2.7")
	-----------------------------------------------------
	-- write frames
	-----------------------------------------------------
	
	for i in model.framelist do
	(
		writefloat f i.scale.x
		writefloat f i.scale.y
		writefloat f i.scale.z
		writefloat f i.translate.x
		writefloat f i.translate.y
		writefloat f i.translate.z
		writestring f i.name
		for l = 1 to (16 - i.name.count) - 1 do
		(
			writestring f ""
		)		
		k=0
		for j=1 to i.vlist.count do
		(
			writebyte f i.vlist[j].x
			writebyte f i.vlist[j].y
			writebyte f i.vlist[j].z
			writebyte f i.vNorm[j]
		)
	)
	------------------------------------------------------
	-- end of file writing
	------------------------------------------------------
	
	fclose f
	MessageBox("Export Done!!")
)
	

	----------------------------------		
	-- local functions
	----------------------------------	

	fn md2_addcheck_kp cb=
	(
		if classof cb==string then messagebox cb title:"MD2 Export Error"
	)


	----------------------------------		
	-- startup defaults
	----------------------------------		
	on MD2Export_KP open do 
	(
		UI_file_4frame.enabled = UI_usefile4frame.checked
		UI_btn_browse4frame.enabled = UI_usefile4frame.checked

		UI_listbox.enabled = false --UI_multipart_mdl.checked	

		
		if UI_anim_time_from.state == 1 then
		(
			UI_animstart_time.enabled = false	
			UI_animend_time.enabled = false	
		)
	)	-- on MD2Export_KP open do

		
	----------------------------------
	-- ui state change events
	----------------------------------
	on UI_anim_time_from changed theState do
	(
		if UI_anim_time_from.state == 1 then
		(
			UI_animstart_time.enabled = false	
			UI_animend_time.enabled = false	
		)
		else
		(
			UI_animstart_time.enabled = true	
			UI_animend_time.enabled = true	
		)
	)
	---| radio button |--- use frames file
	on UI_usefile4frame changed theState do
	(
		UI_file_4frame.enabled = UI_usefile4frame.checked
		UI_btn_browse4frame.enabled = UI_usefile4frame.checked
	)
	
	---| button |--- info
	on UI_info_about pressed do
	(
		print("into------")
		messagebox(string_1 +string_2+string_3+string_4+string_5+string_6+string_7+string_8) title:Kingpin_MD2_Exporter_ver
	)

	---| button |--- brows for frames file
	on UI_btn_browse4frame pressed do
	(
		framefile=getopenfilename caption:"Open Frame File" filename:"" types:"MD2 Frame File (*.txt)|*.txt|All Files (*.*)|*.*|"
		if framefile != undefined then
		(
			if DoesFileExist framefile then
			(
				UI_file_4frame.text = framefile 
				
				framenamelist_kp=#()

				local file = openFile framefile mode:"r"
	
				while not EOF file do
		 		(
					local strTmp = readLine file
					if (findString strTmp ",") == undefined then --missing "," delimiter
					(	
							print("--> no delim frame= " +strTmp)
							framename =	strTmp
							append framenamelist_kp framename	--hypov8 ToDo: does this append multiple times? not reset
					)					
					else --found token. use frame x to x and name
					(
						local lineDelim = filterString strTmp ","
						local framefrom = lineDelim[1] as integer
						local frameto = lineDelim[2] as integer
						local framename = ""
						local counter = 1;

						for i = framefrom to frameto do
						(
							framename = lineDelim[3] + "_" +counter as string
							append framenamelist_kp framename

							counter += 1
						)
					)					
				)
				close file
			)
		)
	)
	
	---| button |--- add player models to list	
	on UI_AddModelToList pressed do
	(
		if UI_listbox.items.count > 0 then
		(	
			for listnum=1 to UI_listbox.items.count do
			UI_listbox.items = deleteItem UI_listbox.items 1  -- UI_listbox.selection
		)
		
		For CurrentObject in $selection do 
		( 
			if (superClassOf CurrentObject == GeometryClass) and
				(classOf CurrentObject != BoneGeometry) and (classOf CurrentObject != Biped_Object) and
				(classOf CurrentObject != Blizzard) and (classOf CurrentObject != PF_Source) and (classOf CurrentObject != Spray) and
				(classOf CurrentObject != PCloud) and (classOf CurrentObject != Snow) and
				(classOf CurrentObject != PArray) and (classOf CurrentObject != SuperSpray)	then
			(
				temp_array = UI_listbox.items
				insertItem (CurrentObject.name as string) temp_array 1
				UI_listbox.items = temp_array
			)
		)	
	)		
	
	---| button |--- export md2
	on UI_btn_export pressed do
	( 
		print("button pressed")
		if UI_usefile4frame.checked then
		(	
			if DoesFileExist UI_file_4frame.text == false then 
			(
				messagebox("Frame file is missing")
				return "Frame file is missing"
			)
		)
		md2filename_kp=getsavefilename caption:"Save MD2" filename:md2lastfile_kp types:"Blitz MD2 (*.md2)|*.md2|All Files (*.*)|*.*|"
		print("button pressed1")
		if md2filename_kp!=undefined then 
		(				
			print("button pressed2")
			md2_addcheck_kp (writemd2_kp $ md2filename_kp)
			print("button pressed3")
			md2lastfile_kp=md2filename_kp
			--MessageBox("Export Done!!")
		)
	)
)

