/******************************************************************************

	GENERIC EPISODE CODE

******************************************************************************/

#include "g_local.h"
#include "ep_log.h"

qboolean	EP_Shared_Flash_Newflag		(edict_t *self, int ep_flag, player_log_t *logPtr); // ACC, new (one-size-fits-all routines for logs)
void			EP_Shared_Player_Log			(edict_t *self, int page, player_log_t *logPtr); // ACC, new (one-size-fits-all routines for logs)

//............................................................................
// Character Names
//

// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
//
// Note, these must be in the same order as the defines in ep_all.h!
//
// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !

char *ep_names[] =
{
	"--THIS SLOT MUST BE VACANT--",
	"Al",
	"Beth",
	"Magicj",
	"Lisa",
	"Louie",
	"Frank",
	"Buttmunch",
	"Arnold",
	"Brewster",
	"Punky",
	"Igmo",
	"Johnny",
	"Betty",
	"Leroy",
	"Jed",
	"Buster",
	"Bubba",
	"Momo",
	"Muttski",
	"Spike",
	"ToughGuy1",
	"ToughGuy2",
	"IntroGuy",
	"Bernie",
	"Lamont",
	"Mona",
	"Lenny",
	"Chick",
	"Sluggo",
	"Rocko",
	"Rover",
	"Joseph",
	"Rummy", // sr1 bum
	"Nick",  // sr2 bum
	"Jesus", // sr boss 
	"Yolanda",
	"Carlton",
	"Tina",
	"Hardey",
	"Laurel",
	"Harold",
	"Dick",
	"Burt",
	"Fingers",
	"Dan",
	"Clarence",
	"Adolf",
	"Candy",
	"Sharky",
	"Kingpin",
	"Blunt",
	"NikkiBlanco",
	"Moe",
	"Larry",
	"Curly",
	"Ed",
	"Popeye",
	"Dogg",
	"Selma",
	"Jane",
	"Barney",
	"BigWillie",
	"Sal",
	"Lefty",
	"Bwillie",
	"Mung",
	"Tyrone",
	"Luke",
	"Hann",
	"Kroker",
	"kid_1",
	"kid_2",
	"kid_3",
	"kid_4",
	"kid_5",
	"kid_6",
	"kid_7",
	"kid_8",
	"Oscar",
	"David",
	"Bambi",
	"Brittany",
	"Mathew",
	"Pete",
	"Moker",
	"Heilman",
	"Butch",
	"Patrick",
	"Groucho",
	"Harpo",
	"Chico",
	"Blefty",
	"Scalper",
	"Dubs",
	"Rochelle",
	"Lola",
	"Dude",
	"Walter",
	"Donny",

	// ACC, new:
	"Jeda", // bartender
	"Cain", // hired help
	"Abel", // hired help
	"Gideon", // boss
	"Blake", // guy with two dogs in cemetery
	"BadMonk", // cameo character, found in bar restrooms
	//"Chip", // Guy with a hate boner for Arnie's dog
	"Dale", // Cemetery bum in hub
	NULL
};

//............................................................................

// This sets the self->name_index according to the list above
void	EP_SetNameIndex ( edict_t *self )
{
	int i;

	if (!self->name)
	{
		self->name_index = -1;
		return;
	}

	for (i=0; ep_names[i]; i++)
	{
		if (self->name)
			if (!Q_stricmp(self->name, ep_names[i]))
			{	// found a match
				self->name_index = i;
				return;
			}
	}

	// no match found!
	gi.dprintf( "EP_SetNameIndex: Un-matched \"name\" (%s)\n", self->name );
	self->name_index = -1;
}

// Given a NAME_*, returns the entity with the matching name
edict_t	*EP_GetCharacter ( int nameIndex )
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (level.characters[i]->name_index == nameIndex)
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}

	// This is causing problems be cause the guy could get refrenced yet be on another map
	// gi.dprintf( "EP_GetCharacter: couldn't find %s\n", ep_names[nameIndex] );

	return NULL;	// couldn't find them
}

// Given a "name", returns the entity with the matching name
edict_t	*EP_GetCharacterByName ( char *name )
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (!Q_stricmp( level.characters[i]->name, name ))
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}

	gi.dprintf( "EP_GetCharacter: couldn't find %s\n", name );

	return NULL;	// couldn't find them
}

//............................................................................
// Gang Names
//
// These will match the "cast_group" value for characters in the game
// Also must match the defines in ep_all.h !!

char *ep_gang_names[] =
{
	"(neutral)",
	"Our Gang(?)",
	"Main Gang(?)",
	"Rat-Gang",
	NULL
};

char	*EP_GetGangName ( int cast_group )
{
	static char	unknown_str[] = "**UNKNOWN**";

	if (cast_group >= NUM_GANGS)
		return unknown_str;

	return ep_gang_names[cast_group];
}

//............................................................................
// This gets called whenever an AI character has sighted another character
// (which will happen every frame while they are in view).

qboolean EP_CastSight ( edict_t *self, edict_t *other, cast_memory_t *cast_memory )
	{

	// ACC, this guy is in every episode, so we might as well put him here
	if (self->name_index == NAME_MOMO && other->client)
		{
		GenericMomo_Sight(self, other, cast_memory);
		return true;
		}

	switch (level.episode)
		{
		case EP_SKIDROW:
			return EP_Skidrow_CastSight (self, other, cast_memory);
		case EP_POISONVILLE:
			return EP_Poisonville_CastSight (self, other, cast_memory);
		case EP_STEELTOWN:
			return EP_Steeltown_CastSight (self, other, cast_memory);
		case EP_TRAINYARD:
			break;
		case EP_RADIOCITY:
			return EP_RC_CastSight (self, other, cast_memory);
		case EP_SHIPYARDS:
			return EP_SY_CastSight (self, other, cast_memory);
		case EP_BARRENMEADOW: // ACC, new
			return EP_BarrenMeadow_CastSight (self, other, cast_memory);
		}
	return false;
	}

//............................................................................
// This gets called whenever an AI character dies is "used" (like when they die and have a ->deathtarget)

qboolean EP_CastUse ( edict_t *self, edict_t *other, edict_t *activator )
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			return EP_Skidrow_CastUse (self, other, activator);
		case EP_POISONVILLE:
			return EP_Poisonville_CastUse (self, other, activator);
		case EP_STEELTOWN:
			return EP_Steeltown_CastUse (self, other, activator);
		case EP_TRAINYARD:
			break;
		case EP_RADIOCITY:
			return EP_RC_CastUse (self, other, activator);
		case EP_SHIPYARDS:
			return EP_SY_CastUse (self, other, activator);
		case EP_BARRENMEADOW: // ACC, new
			return EP_BarrenMeadow_CastUse (self, other, activator);
		}
	return false;
	}


//............................................................................
// Generic event based speech for episodes

qboolean EP_EventSpeech (edict_t *self, edict_t *other, int saywhat)
	{

	// ACC, this guy is in every episode, might as well put him here
	if ((self->name_index == NAME_MOMO) && (other->client))
		return GenericMomo_Process(self, other);

	// Episode specific
	switch (level.episode)
		{
		case EP_SKIDROW:
			return EP_Skidrow_EventSpeech (self, other, saywhat);
		case EP_POISONVILLE:
			return EP_Poisonville_EventSpeech (self, other, saywhat);
		case EP_TRAINYARD:
			return EP_Trainyard_EventSpeech (self, other, saywhat);	
		case EP_SHIPYARDS:
			return EP_SY_EventSpeech (self, other, saywhat);
		case EP_STEELTOWN:
			return EP_Steeltown_EventSpeech (self, other, saywhat);
		case EP_RADIOCITY:
			return EP_RC_EventSpeech (self, other, saywhat);
		case EP_BARRENMEADOW: // ACC, new
			return EP_BarrenMeadow_EventSpeech (self, other, saywhat);
		}
	return false;
	}

//............................................................................
// Called whenever an item is picked up

void EP_ItemPickup (edict_t *self, edict_t *other)
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			EP_Skidrow_ItemPickup (self, other);
			break;
		case EP_POISONVILLE:
			EP_Poisonville_ItemPickup (self, other);
			break;
		case EP_TRAINYARD:
			EP_Trainyard_ItemPickup (self, other);
			break;
		case EP_SHIPYARDS:
			EP_SY_ItemPickup (self, other);
			break;
		case EP_STEELTOWN:
			EP_Steeltown_ItemPickup (self, other);
			break;
		case EP_BARRENMEADOW: // ACC, new
			EP_BarrenMeadow_ItemPickup (self, other);
			break;
		}
	}


//............................................................................
// Called whenever a character reaches a path_corner_cast that has a "scriptname" set

void EP_EventScript ( edict_t *self, char *scriptname )
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			EP_Skidrow_Script (self, scriptname);
			break;
		case EP_POISONVILLE:
			EP_Poisonville_Script (self, scriptname);
			break;
		case EP_TRAINYARD:
			EP_Trainyard_Script (self, scriptname);
			break;
		case EP_SHIPYARDS:
			EP_SY_Script (self, scriptname);
			break;
		case EP_STEELTOWN:
			EP_Steeltown_Script (self, scriptname);
			break;
		case EP_BARRENMEADOW: // ACC, new
			EP_BarrenMeadow_Script (self, scriptname);
			break;
		}
	}

// ACC, okay, at this point they just gave up.
void EP_Reset (edict_t *self, edict_t *other)
	{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_Reset (self, other);
	}


void EP_SpawnFlags (edict_t *self)
	{
	// ACC, new (bar no-gun policy found in skidrow and MOMO)
	if (self->name_index == NAME_MOMO) // initialize bouncer
		GenericMomo_Initialize (self);
	else if ((strstr (level.mapname, "bar_"))) // make all weapons invisible while we are in a bar
		{
		if (self->gender == GENDER_MALE || self->gender == GENDER_FEMALE)
			{
			self->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
			self->s.model_parts[PART_GUN2].invisible_objects = (1<<0 | 1<<1);
			}
		}
	// ACC, done

	switch (level.episode)
		{
		case EP_SKIDROW:
			EP_SkidrowFlags (self);
			break;
		case EP_POISONVILLE:
			EP_PVFlags (self);
			break;
		case EP_SHIPYARDS:
			EP_SYFlags (self);
			break;
		case EP_STEELTOWN:
			EP_SteeltownFlags (self);
			break;
		case EP_RADIOCITY: 
			EP_RCFlags (self);
			break;
		case EP_BARRENMEADOW: // ACC, new
			EP_BarrenMeadow_Flags (self);
			break;
		}
	}

int EP_HiredGuys (edict_t *self, edict_t *other)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		return true;
	case EP_POISONVILLE:
		return EP_PV_HiredGuysFlags (self, other);
	case EP_STEELTOWN:
		return EP_Steeltown_HiredGuysFlags (self, other);
	case EP_TRAINYARD:
		return EP_Trainyard_HiredGuysFlags (self, other);
	case EP_RADIOCITY:
		return EP_RC_HiredGuysFlags (self, other);
	case EP_SHIPYARDS:
		return EP_SY_HiredGuysFlags (self, other);
	case EP_BARRENMEADOW: // ACC, new
		return EP_BarrenMeadow_HiredGuysFlags (self, other);
	}
	return true;
}

void EP_CheckMomo (edict_t *ent, cast_memory_t	*mem)
	{
	GenericMomo_Check (ent, mem);
	}

qboolean EP_DoKey (edict_t *ent, edict_t *other)
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			return false;
		case EP_POISONVILLE:
			return EP_PV_DoKey (ent, other);
		case EP_STEELTOWN:
			return EP_Steeltown_DoKey (ent, other);
		case EP_BARRENMEADOW: // ACC, new
			EP_BarrenMeadow_DoKey(ent, other);
		}
	return false;
	}

void EP_Check_DoKey (edict_t *self, edict_t *ent)
	{
	switch (level.episode)
		{
		case EP_SKIDROW:
			break;
		case EP_POISONVILLE:
			EP_PV_Check_DoKey (self, ent);
			break;
		case EP_STEELTOWN:
			EP_Steeltown_Check_DoKey (self, ent);
			break;
		case EP_BARRENMEADOW: // ACC, new
			EP_BarrenMeadow_Check_DoKey(ent, ent);
			break;
		}
	}

void EP_ReachedDoKey (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_PV_ReachedDoKey (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_ReachedDoKey (self);
		break;
	case EP_BARRENMEADOW: // ACC, new
		EP_BarrenMeadow_ReachedDoKey(self);
		break;
	}
}

void EP_EndDoKey (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_PV_EndDoKey (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_EndDoKey (self);
		break;
	case EP_BARRENMEADOW: // ACC, new
		EP_BarrenMeadow_EndDoKey(self);
		break;
	}
}


qboolean EP_UnlockDoorFlag (edict_t *ent)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		return (EP_PV_UnlockDoorFlag (ent));
		break;
	case EP_STEELTOWN:
		return (EP_Steeltown_UnlockDoorFlag (ent));
		break;
	case EP_BARRENMEADOW: // ACC, new
		EP_BarrenMeadow_UnlockDoorFlag(ent);
		break;
	}
	return false;
}

void EP_HiredGuysRegisterFlags (edict_t *ent, edict_t *other)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_PV_HiredGuysRegisterFlags (ent, other);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_HiredGuysRegisterFlags (ent, other);
		break;
	case EP_RADIOCITY:
		EP_RC_HiredGuysRegisterFlags (ent, other);
		break;
	case EP_BARRENMEADOW: // ACC, new
		EP_BarrenMeadow_HiredGuysRegisterFlags (ent, other);
		break;
	}
}

void EP_SpecialEventDeath (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_PV_SpecialEventDeath (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_SpecialEventDeath (self);
		break;
	case EP_TRAINYARD:
		// EP_Trainyard_SpecialEventDeath (self);
		break;
	case EP_RADIOCITY:
		EP_RC_SpecialEventDeath (self);
		break;
	case EP_SHIPYARDS:
		EP_SY_SpecialEventDeath (self);
		break;
	case EP_BARRENMEADOW: // ACC, new
		EP_BarrenMeadow_SpecialEventDeath (self);
		break;
	}
	
}

// JOSEPH 14-JUN-99
void Think_Help (edict_t *ent)
	{
	if (!(level.helpchange))
		{
		level.helpchange = 0;
		G_FreeEdict(ent);
		return;
		}
	
	if (!ent->misstime )
		{
		level.helpchange = 0;
		G_FreeEdict(ent);
		return;
		}
	
	if (ent->misstime <= 15 && level.helpchange)
		level.helpchange = ent->misstime*(255/15);

	ent->misstime--;	
	ent->nextthink = level.time + 0.1;
	}

void Show_Help (void)
	{
	edict_t	*help = NULL;
	edict_t	*ent = NULL;

	ent = G_Find (NULL, FOFS(classname), "showhelp");
	if (ent)
		G_FreeEdict(ent);

	help = G_Spawn();
	
	if (!help)
		return;

	help->classname = "showhelp";
	help->think = Think_Help;
	help->misstime = 315;
	help->nextthink = level.time + 0.1;

	gi.linkentity (help);

	level.helpchange = 255;

	return;
	}
// END JOSEPH

void EP_Flash_Newflag (edict_t *self, int ep_flag)
	{
	player_log_t *logPtr = 0;

	switch (level.episode)
		{
		case EP_SKIDROW:
			logPtr = ep_sr_player_log;
			break;
		case EP_POISONVILLE:
			logPtr = ep_pv_player_log;
			break;
		case EP_SHIPYARDS:
			logPtr = ep_sy_player_log;
			break;
		case EP_STEELTOWN:
			logPtr = ep_st_player_log;
			break;
		case EP_TRAINYARD:
			logPtr = ep_ty_player_log;
			break;
		case EP_RADIOCITY:
			logPtr = ep_rc_player_log;
			break;
		// ACC, new
		case EP_BARRENMEADOW:
			logPtr = ep_bm_player_log;
			break;
		case EP_CARNEY:
			logPtr = ep_ca_player_log;
			break;
		// ACC, done.
		/* INSERT YOUR EPISODE CODE HERE (see ep_log.c and ep_log.h notes) */
		}

	// flash notepad if a new page has been unlocked
	if (EP_Shared_Flash_Newflag(self, ep_flag, logPtr))
		Show_Help ();
	}

//=======================================================================================================


void EP_PlayerLog (edict_t *self, int page)
	{
	player_log_t *logPtr = 0;

	switch (level.episode)
		{
		case EP_SKIDROW:
			logPtr = ep_sr_player_log;
			break;
		case EP_POISONVILLE:
			logPtr = ep_pv_player_log;
			break;
		case EP_SHIPYARDS:
			logPtr = ep_sy_player_log;
			break;
		case EP_STEELTOWN:
			logPtr = ep_st_player_log;
			break;
		case EP_TRAINYARD:
			logPtr = ep_ty_player_log;
			break;
		case EP_RADIOCITY:
			logPtr = ep_rc_player_log;
			break;
		// ACC, new
		case EP_BARRENMEADOW:
			logPtr = ep_bm_player_log;
			break;
		case EP_CARNEY:
			logPtr = ep_ca_player_log;
			break;
		// ACC, done.
		/* INSERT YOUR EPISODE CODE HERE (see ep_log.c and ep_log.h notes) */
		}

	EP_Shared_Player_Log (self, page, logPtr);
	}

//............................................................................

// ACC, for logs
int the_log_page = 0;

// ACC, any log display
void EP_Shared_Player_Log (edict_t *self, int page, player_log_t *logPtr)
	{
	int	i;
	
	// display notepad
	Com_sprintf (game.helpmessage1, sizeof(game.helpmessage1), "");
	Com_sprintf (game.helpmessage2, sizeof(game.helpmessage2), "");

	// no log specified, abort!
	if (!logPtr)
		return;

	// flip pages
	if (page)
		{
		the_log_page += page;
		if (the_log_page > self->client->pers.log_unlockcount)
			the_log_page = self->client->pers.log_unlockcount;
		else if (the_log_page < 0)
			the_log_page = 0;
		else
			gi.sound(self, CHAN_VOICE, gi.soundindex("world/pageturn.wav"), 1, ATTN_NONE, 0);
		}

	// open notepad (display first unread hint)
	else
		{
		for (i = 0; i <= self->client->pers.log_unlockcount; i++) // <= because there's always one unlocked page
			{
			if (self->client->pers.log_unlockstale & (1 << i))
				continue;
			the_log_page = i;
			break;
			}
		}

	// display message
	strcat (game.helpmessage2, logPtr[self->client->pers.log_unlockorder[the_log_page]].ep_text);
	sprintf(game.helpmessage1, "Page %i of %i", the_log_page + 1, self->client->pers.log_unlockcount + 1); // self->client->pers.log_unlockcount + 1 because there's always one unlocked page
	if (!(self->client->pers.log_unlockstale & (1 << the_log_page)))
		{
		strcat(game.helpmessage1, "\nNew Entry");
		self->client->pers.log_unlockstale |= (1 << the_log_page); // mark as read
		}
	}

// ACC, fresh entry checker
qboolean EP_Shared_Flash_Newflag (edict_t *self, int ep_flag, player_log_t *logPtr)
	{
	int i = 0;

	// no log specified, abort!
	if (!logPtr)
		return false;

	// parse the whole list until we reach a blank
	while (logPtr[i].ep_text)
		{
		if (logPtr[i].ep_flag == ep_flag)
			{
			self->client->pers.log_unlockcount++;
			self->client->pers.log_unlockorder[self->client->pers.log_unlockcount] = i;
			return true;
			}
		i++;
		}

	return false;
	}

// ACC, this is EP_Skidrow_Register_EPFLAG, only with a different name
void EP_Shared_Register_EPFLAG (edict_t *self, int ep_flag)
	{
	if (self->client->pers.episode_flags & ep_flag)
		return;
	self->episode_flags = self->client->pers.episode_flags |= ep_flag;
	EP_Flash_Newflag (self, ep_flag);
	}
