#include "g_local.h"
#include "voice_punk.h"
#include "voice_bitch.h"

// Ho joy, there's no easy way to keep cast entities in place during gun fights. It would be useful for bridge ambushes, watch towers, etc.
// Even the aiflag AI_NOWALK_FACE doesn't really work for that. The Ai_guard entity only works AFTER a battle, and using monster clip brushes
// will also affect sidekicks. There's no elegant solution to the problem. Because animations dictate how the character behave, every animation
// has to be hacked to redirect toward custom routines. Even then, some stuff is handled in g_ai.c with generic routines, which makes it borderline
// impossible to create a custom behavior. This sucks. This code is broken as fuck (can't make them rotate properly, can't make them crouch, don't
// know why they freeze at seemingly random, don't know why their hit box is suddenly reset) but seems to do the bare minimum during gameplay.
// Fuck it. I've spend a little more than a day trying to add this feature to the original cast before attempting to rewrite one stuff from
// scratch. I have other things to do (a whole map, some models and lines to record). Fuck this. If it's too broken, I'll just replace the
// cast_stayput entities with the original cast and call it a day.

void stayput_avoid (edict_t *self, edict_t *other, qboolean face);
void stayput_talk_think (edict_t *self);
void stayput_end_stand (edict_t *self);
void stayput_end_attack (edict_t *self);
qboolean stayput_attack (edict_t *self);
qboolean stayput_check_attack(edict_t *self);
void stayput_long_attack(edict_t *self);

void stayput_shotgun_reload (edict_t *self);
void stayput_firehmg (edict_t *self);
void stayput_firegun_cr (edict_t *self);
void stayput_firegun (edict_t *self);
void stayput_reload_snd (edict_t *self);
void stayput_firehmg_delay (edict_t *self);
void stayput_firebazooka_delay (edict_t *self);

void stayput_face (edict_t *self, float dist);
void stayput_talk (edict_t *self);

#include "ai_stayput_tables.h"

#define STAYPUT_FLAMEGUN		4
#define	STAYPUT_BAZOOKA			8
#define STAYPUT_HMG					16
#define	STAYPUT_TOMMYGUN		64
#define STAYPUT_GRENADE			128
#define STAYPUT_SHOTGUN			8192
#define STAYPUT_GUNMASK			8412

#define STAYPUT_PUNK				0
#define STAYPUT_SHORTY			1
#define STAYPUT_WHORE				2

int	tommy_soundindex;
int	shotgun_soundindex;
int	shotgun_reload_soundindex;
int	heavymachinegun_soundindex;
int	rocketgun_soundindex;

qboolean cast_start (edict_t *self);
void cast_start_go (edict_t *self);
void static_cast_start_go (edict_t *self);
void cast_triggered_start (edict_t *self);

void stayput_pain (edict_t *self, edict_t *other, float kick, int damage, int mdx_part, int mdx_subobject);
void stayput_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject);

void think_playthud (edict_t *self);
void playthud(vec3_t org, int surf, int d1, int d2);

#define ANIM_SHOOT_DUCK				0
#define ANIM_SHOOT_TOMMY			1
#define ANIM_SHOOT_SHOTGUN		2
#define ANIM_SHOOT_HMG				3
#define ANIM_SHOOT_BAZOOKA		4
#define ANIM_SHOOT_FLAMEGUN		5
#define ANIM_SHOOT_GRENADE		6
#define ANIM_SHOOT_BAZOOKA2		7
#define ANIM_SHOOT_HMG2       8
#define ANIM_RELOAD					  9

#define ANIM_DUCK_DOWN        10
#define ANIM_DUCK_IDLE        11
#define ANIM_DUCK_UP          12

#define ANIM_STAND_NORMAL     13
#define ANIM_STAND_SHOTGUN    14

#define ANIM_PAIN_DUCK_MID    15
#define ANIM_PAIN_DUCK_LEFT		16
#define ANIM_PAIN_DUCK_RIGHT	17
#define ANIM_PAIN_BODY_MID		18
#define ANIM_PAIN_BODY_LEFT		19
#define ANIM_PAIN_BODY_RIGHT	20
#define ANIM_PAIN_CROTCH			21
#define ANIM_PAIN_BUTT				22
#define ANIM_PAIN_LEG_LEFT		23
#define ANIM_PAIN_LEG_RIGHT		24
#define ANIM_PAIN_HEAD				25

#define ANIM_DEATH1						26
#define ANIM_DEATH2						27
#define ANIM_DEATH3						28
#define ANIM_DEATH4						29
#define ANIM_DEATH_DUCK				30

#define ANIM_WALK             31

#define NUM_ANM								32

// 32 animations per style
mmove_t *anim_stack[] = {
	// Punk, attack (10 animations)
	&stayput_punk_move_crouch_shoot, &stayput_punk_move_tg_shoot, &stayput_punk_move_shg_shoot,
	&stayput_punk_move_hmg_shoot, &stayput_punk_move_bazooka_shoot, &stayput_punk_move_flamegun_shoot,
	&stayput_punk_move_grenade_shoot, &stayput_punk_move_bazooka_shoot2, &stayput_punk_move_hmg_shoot2,
	&stayput_punk_move_tg_reload,
	// Punk, crouch (3 animations)
	&stayput_punk_move_crouch_stand_down, &stayput_punk_move_crch_astand, &stayput_punk_move_crouch_stand_up,
	// Punk, stand (2 animations)
	&stayput_punk_move_stand, &stayput_punk_move_sg_stand,
	// Punk, pain (11 animations)
	&stayput_punk_move_crouch_painC, &stayput_punk_move_crouch_painL, &stayput_punk_move_crouch_painR,
	&stayput_punk_move_pain_chest, &stayput_punk_move_pain_Larm, &stayput_punk_move_pain_Rarm,
	&stayput_punk_move_pain_crch, &stayput_punk_move_pain_butt, &stayput_punk_move_pain_Lleg,
	&stayput_punk_move_pain_Rleg, &stayput_punk_move_pain_head,
	// Punk, death (5 animations)
	&stayput_punk_move_death1, &stayput_punk_move_death2, &stayput_punk_move_death3,
	&stayput_punk_move_death4, &stayput_punk_move_crouch_death,
	// Punk walk (1 animation)
	&stayput_punk_move_run_nw,

	// Shorty, attack (10 animations)
	&stayput_shorty_move_crouch_shoot, &stayput_shorty_move_tg_shoot, &stayput_shorty_move_shg_shoot,
	&stayput_shorty_move_hmg_shoot, &stayput_shorty_move_bazooka_shoot, &stayput_shorty_move_flamegun_shoot,
	&stayput_shorty_move_grenade_shoot, &stayput_shorty_move_bazooka_shoot2, &stayput_shorty_move_hmg_shoot2,
	&stayput_shorty_move_tg_reload,
	// Shorty, crouch (3 animations)
	&stayput_shorty_move_crouch_stand_down, &stayput_shorty_move_crch_astand, &stayput_shorty_move_crouch_stand_up,
	// Shorty, stand (2 animations)
	&stayput_shorty_move_stand, &stayput_shorty_move_stand,
	// Shorty, pain (11 animations)
	&stayput_shorty_move_crouch_painC, &stayput_shorty_move_crouch_painL, &stayput_shorty_move_crouch_painR,
	&stayput_shorty_move_pain_chest, &stayput_shorty_move_pain_Larm, &stayput_shorty_move_pain_Rarm,
	&stayput_shorty_move_pain_crch, &stayput_shorty_move_pain_butt, &stayput_shorty_move_pain_Lleg,
	&stayput_shorty_move_pain_Rleg, &stayput_shorty_move_pain_head,
	// Shorty, death (5 animations)
	&stayput_shorty_move_death1, &stayput_shorty_move_death2, &stayput_shorty_move_death3,
	&stayput_shorty_move_death4, &stayput_shorty_move_crouch_death,
	// Shorty walk (1 animation) -- TODO!!
	&stayput_punk_move_run_nw,

	// Whore, attack (10 animations)
	&stayput_whore_move_crouch_shoot, &stayput_whore_move_tg_shoot, &stayput_whore_move_shg_shoot,
	&stayput_whore_move_hmg_shoot, &stayput_whore_move_bazooka_shoot, &stayput_whore_move_flamegun_shoot,
	&stayput_whore_move_grenade_shoot, &stayput_whore_move_bazooka_shoot2, &stayput_whore_move_hmg_shoot2,
	&stayput_whore_move_tg_reload,
	// Whore, crouch (3 animations)
	&stayput_whore_move_crouch_stand_down, &stayput_whore_move_crch_astand, &stayput_whore_move_crouch_stand_up,
	// Whore, stand (2 animations)
	&stayput_whore_move_stand, &stayput_whore_move_sg_stand,
	// Whore, pain (11 animations)
	&stayput_whore_move_crouch_painC, &stayput_whore_move_crouch_painL, &stayput_whore_move_crouch_painR,
	&stayput_whore_move_pain_chest, &stayput_whore_move_pain_Larm, &stayput_whore_move_pain_Rarm,
	&stayput_whore_move_pain_crch, &stayput_whore_move_pain_butt, &stayput_whore_move_pain_Lleg,
	&stayput_whore_move_pain_Rleg, &stayput_whore_move_pain_head,
	// Whore, death (5 animations)
	&stayput_whore_move_death1, &stayput_whore_move_death2, &stayput_whore_move_death3,
	&stayput_whore_move_death4, &stayput_whore_move_crouch_death,
	// Whore walk (1 animation) -- TODO!!
	&stayput_punk_move_run_nw,
	};

int anim_death_thud[] = {
	// Punk death "thud" frames (two frames per animation)
	6,9,   5,9,   9,20,		6,8,   6,9,
	// Shorty
	6,15,  6,10,  8,7,		7,16,  10,14,
	// Whore
	7,11,  5,7,   4,9,		7,15,  7,0 };


void stayput_battlecry(edict_t *self)
	{
	if (self->last_talk_time < (level.time - TALK_FIGHTING_DELAY))
		{
		switch (self->name_index)
			{
			case NAME_NICKIBLANCO:
				Voice_Random (self, self->enemy, &nickiblanco[6], 10);
				break;
			case NAME_TYRONE:
				Voice_Random (self, self->enemy, &ty_tyrone[6], 10); 
				break;
			case NAME_MOKER:
				Voice_Random (self, self->enemy, &steeltown_moker[6], 10);
				break;
			case NAME_BLUNT:
				Voice_Random (self, self->enemy, &blunt[6], 10); 
				break;
			default:
				if (self->gender == GENDER_MALE)
					{
					if (self->cast_group != 1)
						Voice_Random(self, self->enemy, fightsounds, NUM_FIGHTING);
					else
						Voice_Random(self, self->enemy, friendlycombat, NUM_FRIENDLYCOMBAT);
					}
				else
					Voice_Random(self, self->enemy, f_fightsounds, F_NUM_FIGHTING);
			}
		}
	}

void SP_cast_stayput (edict_t *self)
	{
	int		i;
	int		skin;
	char	artskin[12];
	char	filemask[256], filefull[256];
	char	*partSkin;
	int		partIndex;

	// remove in deathmatch
	if (deathmatch->value)
		{
		G_FreeEdict (self);
		return;
		}

	// validate gun, default to shotgun if none/too many specified
	switch (self->spawnflags & STAYPUT_GUNMASK)
		{
		case STAYPUT_FLAMEGUN:
		case STAYPUT_BAZOOKA:
		case STAYPUT_HMG:
		case STAYPUT_TOMMYGUN:
		case STAYPUT_GRENADE:
		case STAYPUT_SHOTGUN:
			break;
		default:
			gi.dprintf("cast_stayput at %s has wrong equipment, defaulting to shotgun\n", self->s.origin);
			self->spawnflags &= ~STAYPUT_GUNMASK; // strip all guns
			self->spawnflags |= STAYPUT_SHOTGUN;  // give shotgun
		}

	// precache reload sound
	tommy_soundindex = gi.soundindex("weapons/machinegun/machgf1b.wav");
	shotgun_soundindex = gi.soundindex("weapons/shotgun/shotgf1b.wav");
	shotgun_reload_soundindex = gi.soundindex("weapons/shotgun/shotgr1b.wav");
	heavymachinegun_soundindex = gi.soundindex ("weapons/hmg/single.wav");
	rocketgun_soundindex = gi.soundindex ("weapons/rocket_launcher/rl_fire.wav");

	// setup collision box and movement type
	self->movetype = MOVETYPE_NONE;
	//self->movetype = MOVETYPE_STEP;
	self->solid = SOLID_BBOX;
	VectorSet (self->mins, -16, -16, -24);
	VectorSet (self->maxs,  16,  16,  48);

	// get file mask and validate style (PUNK is default)
	if (self->style == STAYPUT_WHORE)
		{
		sprintf(filemask, "models/actors/whore/");
		self->gender = GENDER_FEMALE;
		}
	else
		{
		self->gender = GENDER_MALE;
		if (self->style == STAYPUT_SHORTY)
			sprintf(filemask, "models/actors/shorty/");
		else
			{
			self->style = STAYPUT_PUNK;
			sprintf(filemask, "models/actors/punk/");
			}
		}
	strcat(filemask, "%s.mdx");
	self->frame_first = self->style * NUM_ANM;

	// get skins (quick & dirty, assumes "HHH BBB LLL")
	self->s.skinnum = (self->skin - 1) * 3;
	if (self->art_skins)
		{
		strcpy(artskin, self->art_skins);
		artskin[3] = artskin[7] = '\0';
		}
	else
		{
		artskin[0] = artskin[4] = artskin[8] = '\0';
		gi.dprintf("cast_stayput at %s without proper art_skins\n", self->s.origin);
		}
	

	// setup body and weapon
	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	for (partIndex = PART_HEAD; partIndex <= PART_GUN; partIndex++)
		{
		switch (partIndex)
			{
			case PART_HEAD:
				sprintf(filefull, filemask, "head");
				switch (self->head)
					{
					case 1:
						if ((self->style == STAYPUT_PUNK) || (self->style == STAYPUT_WHORE))
							sprintf(filefull, filemask, "bald_head");
						break;
					case 2:
						if (self->style == STAYPUT_PUNK)
							sprintf(filefull, filemask, "weld_head");
						else if (self->style == STAYPUT_WHORE)
							sprintf(filefull, filemask, "pony_head");
						break;
					case 3:
						continue;
					}
				partSkin = &artskin[0];
				break;
			case PART_LEGS:
				sprintf(filefull, filemask, "legs");
				partSkin = &artskin[8];
				break;
			case PART_BODY:
				sprintf(filefull, filemask, "body");
				partSkin = &artskin[4];
				break;
			case PART_GUN:
				{
				if (self->spawnflags & STAYPUT_TOMMYGUN)
					sprintf(filefull, filemask, "tommygun");
				else if (self->spawnflags & STAYPUT_SHOTGUN)
					sprintf(filefull, filemask, "shotgun");
				else if (self->spawnflags & STAYPUT_HMG)
					sprintf(filefull, filemask, "hmg");
				else if (self->spawnflags & STAYPUT_BAZOOKA)
					sprintf(filefull, filemask, "rocket_lnch");
				else if (self->spawnflags & STAYPUT_FLAMEGUN)
					sprintf(filefull, filemask, "flamethrower");
				else if (self->spawnflags & STAYPUT_GRENADE)
					{
					sprintf(filefull, filemask, "grenade_lnch");
					self->cast_info.aiflags |= AI_GRENADE_GUY;
					}
				skin = 0;
				break;
				}
			}
		self->s.num_parts++;
		self->s.model_parts[partIndex].modelindex = gi.modelindex(filefull);
		if (partIndex != PART_GUN)
			{
			if (partSkin > 0)
				skin = gi.skinindex(self->s.model_parts[partIndex].modelindex, partSkin);
			else
				skin = self->s.skinnum;
			}
		for (i = 0; i < MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[partIndex].baseskin = self->s.model_parts[partIndex].skinnum[i] = skin;
		gi.GetObjectBounds(filefull, &self->s.model_parts[partIndex]);
		}

	// Cigar, available for PUNK, SHORTY and WHORE
	if (self->count & 1)
		{
		sprintf(filefull, filemask, "cigar");
		self->s.num_parts++;
		self->s.model_parts[PART_CIGAR].modelindex = gi.modelindex(filefull);
		for (i = 0; i < MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_CIGAR].baseskin = self->s.model_parts[PART_CIGAR].skinnum[i] = 0;
		gi.GetObjectBounds(filefull, &self->s.model_parts[PART_CIGAR]);
		}

	// Fedora, stetson and cap, only for PUNK and SHORTY
	if ((self->style == STAYPUT_SHORTY || self->style == STAYPUT_PUNK) && (self->count & 14))
		{
		if (self->count & 2)
			sprintf(filefull, filemask, "fedora");
		else if (self->count & 4)
			sprintf(filefull, filemask, "stetson");
		else if (self->count & 8)
			sprintf(filefull, filemask, "cap");
		self->s.num_parts++;
		self->s.model_parts[PART_CIGAR].modelindex = gi.modelindex(filefull);
		for (i = 0; i < MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_CIGAR].baseskin = self->s.model_parts[PART_CIGAR].skinnum[i] = 0;
		gi.GetObjectBounds(filefull, &self->s.model_parts[PART_CIGAR]);
		}
	
	// Set health
	if (!self->health)
		self->health = 100;
	self->gib_health = -200;
	self->mass = 200;

	self->pain = stayput_pain;
	self->die = stayput_die;

	if (self->spawnflags & STAYPUT_FLAMEGUN)
		self->cast_info.max_attack_distance = 384;
	else
		self->cast_info.max_attack_distance = 2000;

	gi.linkentity (self);

	// standing animations
	if (self->spawnflags & STAYPUT_SHOTGUN)
		self->cast_info.move_stand = anim_stack[self->frame_first + ANIM_STAND_SHOTGUN];
	else
		self->cast_info.move_stand = anim_stack[self->frame_first + ANIM_STAND_NORMAL];
	self->cast_info.move_run = self->cast_info.move_stand; // anim_stack[self->frame_first + ANIM_WALK];
	self->cast_info.move_runwalk = self->cast_info.move_run; // bare minimum

	// crouching animations
	self->cast_info.move_crouch_down = anim_stack[self->frame_first + ANIM_DUCK_DOWN];
	self->cast_info.move_crstand = anim_stack[self->frame_first + ANIM_DUCK_IDLE];
	self->cast_info.move_stand_up = anim_stack[self->frame_first + ANIM_DUCK_UP];

	self->cast_info.talk = stayput_talk;

	self->cast_info.avoid = stayput_avoid;
	self->cast_info.checkattack = stayput_check_attack;
	self->cast_info.attack = stayput_attack;
	self->cast_info.long_attack = stayput_long_attack;

	// set default animation to standing (could use a spawnflag to set to crouch instead)
	self->cast_info.currentmove = self->cast_info.move_stand;

	// set proper model scale
	if (!self->cast_info.scale)
		self->cast_info.scale = 1.00;
	self->s.scale = self->cast_info.scale - 1.0;

	// assume we start in our territory (friendly cast has no territory)
	if (self->cast_group > 1)
		self->current_territory = self->cast_group;
	else
		self->current_territory = 0;

	// talk by default
	self->cast_info.aiflags |= AI_TALK;

	if (!self->acc)
		self->acc = 2;

	self->think = static_cast_start_go;
	cast_start(self);
	}

void static_cast_start_go (edict_t *self)
	{
	if (!(self->spawnflags & 2) && level.time < 1)
		{
		M_droptofloor (self);
		if ((self->groundentity) && (!M_walkmove (self, 0, 0)))
			gi.dprintf ("%s in solid at %s\n", self->classname, vtos(self->s.origin));
		}

	self->viewheight = self->cast_info.standing_max_z - 4;

	cast_start_go(self);

	if (self->cast_group == 1 && !self->name)
		gi.dprintf( "\n** WARNING: friendly %s without a NAME.\n  All friendly characters MUST have a name.\n\n", self->classname );

	if (self->spawnflags & 2)
		cast_triggered_start (self);
	}

void stayput_pain(edict_t *self, edict_t *other, float kick, int damage, int mdx_part, int mdx_subobject)
	{
	int orientation;

	if (self->s.renderfx2 & RF2_FLAMETHROWER)
		self->s.renderfx2 &= ~RF2_FLAMETHROWER;

	AI_CheckMakeEnemy(self, other);

	// can't stack pain animation
	if (level.time < self->pain_debounce_time)
		return;
	self->pain_debounce_time = level.time + 3 + random();

	// no pain animation in skill 3
	if (skill->value >= 3)
		return;

	// specific pain sound
	switch (self->name_index)
		{
		case NAME_NICKIBLANCO:
			Voice_Random (self, self->enemy, &nickiblanco[2], 4);
			break;
		case NAME_TYRONE:
			Voice_Random (self, self->enemy, &ty_tyrone[2], 4); 
			break;
		case NAME_MOKER:
			Voice_Random (self, self->enemy, &steeltown_moker[2], 4);
			break;
		case NAME_HEILMAN:
			Voice_Random (self, self->enemy, &heilman[2], 4);
			break;
		case NAME_JESUS:
			Voice_Random (self, self->enemy, &sr_jesus[2], 4); 
			break;
		case NAME_KINGPIN:
			Voice_Random (self, self->enemy, &kingpin[2], 4); 
			break;
		case NAME_POPEYE:
			Voice_Random (self, self->enemy, &sy_popeye[19], 3);
			break;
		case NAME_BLUNT:
			Voice_Random (self, self->enemy, &blunt[2], 4); 
			break;
		default:
			if (self->gender == GENDER_MALE)
				{
				int r, l;

				r = 1 + (rand() & 1);
				if (self->health < 25)
					l = 25;
				else if (self->health < 50)
					l = 50;
				else if (self->health < 75)
					l = 75;
				else
					l = 100;
				gi.sound (self, CHAN_BODY, gi.soundindex(va("*pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
				}
			else
				{
				if (self->health < 25)
					Voice_Specific (self, other, female_specific, 4);
				else if (self->health < 50)
					Voice_Specific (self, other, female_specific, 3);
				else if (self->health < 75)
					Voice_Specific (self, other, female_specific, 2);
				else
					Voice_Specific (self, other, female_specific, 1);
				}
		}

	// don't always play a pain animation
	// stayput cast are DANGEROUS, allow pain animations
	if (skill->value > 0 && random() < .1)
		return;

	// get shot direction
	if (other->client || (other->svflags & SVF_MONSTER))
		orientation = AI_GetOrientation(self, other);
	else
		orientation = ORIENTATION_CENTER;

	if (self->maxs[2] < self->cast_info.standing_max_z) // crouching
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_DUCK_MID + orientation];
	else // standing
		{
		if ((mdx_part == PART_BODY) || (other->client && other->client->pers.weapon && !(other->client->pers.weapon->ammo) && (orientation = rand()%2 + 1)))
			self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_BODY_MID + orientation];
		else if (mdx_part == PART_LEGS)
			{
			switch (orientation)
				{
				case ORIENTATION_CENTER:
					{
					if (infront(self, other))
						self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_CROTCH];
					else
						self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_BUTT];
					break;
					}
				case ORIENTATION_LEFT:
					self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_LEG_LEFT];
					break;
				case ORIENTATION_RIGHT:
					self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_LEG_RIGHT];
					break;
				}
			}
		else if (mdx_part == PART_HEAD)
			self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_PAIN_HEAD];
		}
	}

void stayput_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
	{
	trace_t	tr;
	vec3_t	end;
	int			anm;

	// reset flamethrower animation
	if (self->s.renderfx2 & RF2_FLAMETHROWER)
		self->s.renderfx2 &= ~RF2_FLAMETHROWER;

	// remove gun from hands
	self->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
	self->s.model_parts[PART_GUN2].invisible_objects = (1<<0 | 1<<1);

	// regular death
	self->takedamage = DAMAGE_YES;

	// gibbed to smithereens
	if (DeathByGib(self, inflictor, attacker, damage))
		{
		self->deadflag = DEAD_DEAD;
		GibEntity(self, inflictor, damage);
		return;
		}

	// cast is already dead, abort
	if (self->deadflag == DEAD_DEAD)
		return;
	self->deadflag = DEAD_DEAD;

	// drop gun
	if (self->spawnflags & STAYPUT_SHOTGUN)
		SpawnTheWeapon (self, "weapon_shotgun_e");
	else if (self->spawnflags & STAYPUT_HMG)
		SpawnTheWeapon (self, "weapon_heavymachinegun_e");
	else if (self->spawnflags & STAYPUT_BAZOOKA)
		SpawnTheWeapon (self, "weapon_bazooka_e");
	else if (self->spawnflags & STAYPUT_FLAMEGUN)
		SpawnTheWeapon (self, "weapon_flamethrower_e");
	else if (self->spawnflags & STAYPUT_GRENADE)
		SpawnTheWeapon (self, "weapon_grenadelauncher_e");
	else
		SpawnTheWeapon (self, "weapon_tommygun_e");

	// get material beneath the cast's feet (for thud)
	VectorCopy (self->s.origin, end);
	end[2] -= 64;
	tr = gi.trace (self->s.origin, self->mins, self->maxs, end, self, MASK_SHOT);
	
	// select proper animation and matching sound
	if (mdx_part == PART_HEAD)
		anm = 2; // head shot
		/*
	else if (self->maxs[2] < self->cast_info.standing_max_z) // I don't know why exactly, but right now self->maxs[2] is always equal to 0, probably because it fails to load currentmove properly??
		anm = 4; // crouch death */
	else
		anm = rand() % 4; // random animation, excluding crouch death
	self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_DEATH1 + anm];
	playthud(self->s.origin, tr.surface->flags, anim_death_thud[self->style * 10 + anm], anim_death_thud[self->style * 10 + anm + 1]);

	// character burned to death
	if (!self->onfiretime)
		{
		switch (self->name_index)
			{
			case NAME_NICKIBLANCO:
				Voice_Random (self, self->enemy, nickiblanco, 2);
				break;
			case NAME_TYRONE:
				Voice_Random (self, attacker, &ty_tyrone[0], 2);
				break;
			case NAME_MOKER:
				Voice_Random (self, attacker, &steeltown_moker[0], 2);
				break;
			default:
				if (self->gender == GENDER_MALE)
					Voice_Random (self, attacker, &male_specific[8], 2);
				else
					Voice_Random (self, attacker, &female_specific[4], 2);
			}
		}
	}

void stayput_talk_think (edict_t *self)
	{
	AI_TalkThink(self, (self->gender == GENDER_MALE));
	}

void stayput_end_stand (edict_t *self)
	{
	mmove_t *oldmove;
	oldmove = self->cast_info.currentmove;

	// stay crouching forever
	if (self->cast_info.currentmove == self->cast_info.move_crstand) 
		return;
	// stay put, you may talk to nearby buddies
	self->cast_info.currentmove = self->cast_info.move_stand;
	AI_CheckTalk(self);
	}

void stayput_end_attack(edict_t *self)
	{
	/*mmove_t *oldmove;
	oldmove = self->cast_info.currentmove;*/

	// hack to turn off the flamethrow effect
	if (self->s.renderfx2 & RF2_FLAMETHROWER)
		self->s.renderfx2 &= ~RF2_FLAMETHROWER;

	// no enemy or can't attack, back to default idle move.
	if (!self->enemy || !self->cast_info.checkattack(self))
		{
		self->cast_info.currentmove = self->cast_info.move_stand;
		self->cast_info.talk(self);
		/*if (self->enemy)
			self->cast_info.currentmove = self->cast_info.move_crouch_down;*/
		}
	}

// Plays thud sound for death
void playthud(vec3_t org, int surf, int d1, int d2)
	{
	edict_t *thud1, *thud2;

	thud1 = G_Spawn();
	VectorCopy (org, thud1->s.origin);
	thud1->thudsurf = surf;
	thud1->thudsnd = 1; 
	thud1->nextthink = level.time + d1 * 0.1;
	thud1->think = think_playthud;
	gi.linkentity (thud1);

	if (!d2)
		return;
	thud2 = G_Spawn();
	VectorCopy (org, thud2->s.origin);
	thud2->thudsurf = surf;
	thud2->thudsnd = 2; 
	thud2->nextthink = level.time + d2 * 0.1;
	thud2->think = think_playthud;
	gi.linkentity (thud2);
	}



void stayput_long_attack(edict_t *self)
	{
	stayput_attack(self);
	}

qboolean stayput_attack (edict_t *self)
	{
	vec3_t	vec;

	if (self->maxs[2] < self->cast_info.standing_max_z)
		{
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_DUCK];
		return true;
		}

	//VectorSubtract(self->enemy->s.origin, self->s.origin, vec);
	//dist = VectorNormalize( vec );

	self->ideal_yaw = vectoyaw(vec);
	M_ChangeYaw(self);

	if (self->spawnflags & STAYPUT_TOMMYGUN)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_TOMMY];
	else if (self->spawnflags & STAYPUT_SHOTGUN)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_SHOTGUN];
	else if (self->spawnflags & STAYPUT_HMG)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_HMG];
	else if (self->spawnflags & STAYPUT_BAZOOKA)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_BAZOOKA];
	else if (self->spawnflags & STAYPUT_FLAMEGUN)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_FLAMEGUN];
	else if (self->spawnflags & STAYPUT_GRENADE)
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_GRENADE];

	return true;
	}

qboolean stayput_check_attack(edict_t *self)
	{
	float dist;

	if (!self->cast_info.attack || !self->cast_info.long_attack)
		return false;	// never attack if we are unable to

	if (self->cast_info.pausetime > (level.time - 1))
		return false;

	// Verify the enemy is a valid target
	if (!self->enemy || (self->enemy->health <= 0) || !self->enemy->inuse)
		{
		self->enemy = NULL;
		return false;
		}

	// in range
	dist = VectorDistance(self->enemy->s.origin, self->s.origin);
	if (dist > self->cast_info.max_attack_distance)
		return false;

	// something's in the way?
	if (!AI_ClearSight(self, self->enemy, true))
		return false;

	return self->cast_info.attack(self);
	}

// Reload sound
void stayput_reload_snd (edict_t *self)
	{
	if (self->spawnflags & (STAYPUT_TOMMYGUN | STAYPUT_HMG))
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
	else if (self->spawnflags & STAYPUT_BAZOOKA)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/rocket_launcher/reload.wav"), 1, ATTN_NORM, 0);
	else if (self->spawnflags & STAYPUT_GRENADE)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/grenade_launcher/reload.wav"), 1, ATTN_NORM, 0);
	}

void stayput_shotgun_reload (edict_t *self)
	{
	if (!(self->spawnflags & STAYPUT_SHOTGUN))
		return;

	gi.sound(self, CHAN_AUTO, shotgun_reload_soundindex, 1, ATTN_NORM, 0);
	self->cast_info.aiflags &= ~AI_RELOAD;
	}
	
void stayput_firegun (edict_t *self)
	{
	vec3_t	start;
	vec3_t	forward, right;
	vec3_t	target;
	vec3_t	aim;
	vec3_t	offset;
	int			flash_number;
	float		dist;

	// we need to reload first, just do it now (since it's a similar motion)
	if (self->cast_info.aiflags & AI_RELOAD)
		{
		stayput_shotgun_reload(self);
		self->s.frame++;
		return;
		}

	// standing reload for tommygun, rocket launcher and grenade launcher
	self->duration++;
	if ((self->maxs[2] == self->cast_info.standing_max_z) && !(self->cast_info.aiflags & AI_SIDE_ATTACK))
		{
		if (((self->spawnflags & STAYPUT_TOMMYGUN) && (self->duration > 40)) ||
			 ((self->spawnflags & STAYPUT_BAZOOKA) && (self->duration > 3)) ||
			 ((self->spawnflags & STAYPUT_GRENADE) && (self->duration > 2)))
			{
			self->duration = 0;
			self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_RELOAD];
			self->s.frame++;
			return;
			}
		}

	// begin attack if not done yet
	if (!AI_BeginAttack(self))
		{
		self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		return;
		}

	// yell at them?
	stayput_battlecry(self);

	// fire the gun
	if (self->spawnflags & STAYPUT_BAZOOKA)
		{
		VectorSet(offset, 0, 8,  self->viewheight-8);

		AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource (self->s.origin, offset, forward, right, start);

		// project enemy back a bit and target there
		VectorCopy (self->enemy->s.origin, target);
		target[2] -= 24; // this will help create more splash damage

		VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

		if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
			target[2] += - ( 8 * random());
		else
			target[2] += self->enemy->viewheight - 4 - (16 * random());

		flash_number = MZ2_GUNNER_MACHINEGUN_1;

		VectorSubtract (target, start, aim);
		dist = VectorNormalize (aim);

		// idiot check
			{
			// clean shot???
			trace_t tr;
			vec3_t mins;
			vec3_t maxs;
			vec3_t origin;
			vec3_t destination;

			VectorCopy (self->s.origin, origin);
			origin[2] += self->viewheight;

			VectorCopy (self->enemy->s.origin, destination);
			destination[2] += self->enemy->viewheight;

			VectorSet (mins, -8, -8, -8);
			VectorSet (maxs,  8,  8,  8);
			
			tr = gi.trace (origin, mins, maxs, destination, self, MASK_SHOT);

			if (tr.ent != self->enemy)
				{
				if (!(AI_ForceTakeCover (self, self->enemy, false)))
					self->cast_info.avoid(self, self->enemy, false);

				if (self->duration)
					self->duration--;

				// NAV_DrawLine (origin, destination);
				return;
				}
			goto skipbail; // causes bazooka dude to shoot twice
			}
		}
	else
		{
		VectorSet(offset, 0, 8,  self->viewheight-8);

		AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource (self->s.origin, offset, forward, right, start);

		// project enemy back a bit and target there
		VectorCopy (self->enemy->s.origin, target);
		VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

		if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
			target[2] += - (8 * random());
		else
			target[2] += self->enemy->viewheight - 4 - (16 * random());

		flash_number = MZ2_GUNNER_MACHINEGUN_1;

		VectorSubtract (target, start, aim);
		dist = VectorNormalize (aim);
		}


skipbail:

	self->ideal_yaw = vectoyaw(aim);

	if (self->spawnflags & STAYPUT_TOMMYGUN)
		{
		if (self->acc)
			cast_fire_bullet (self, start, aim, 4, 0, DEFAULT_BULLET_HSPREAD>>self->acc, DEFAULT_BULLET_VSPREAD>>self->acc, flash_number);
		else
			cast_fire_bullet (self, start, aim, 4, 0, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, flash_number);
		gi.sound(self, CHAN_WEAPON, tommy_soundindex, 1, ATTN_NORM, 0);
		}
	else if (self->spawnflags & STAYPUT_SHOTGUN)
		{
		cast_fire_shotgun (self, start, aim, 6, 0, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SHOTGUN_COUNT, flash_number); 
		gi.sound(self, CHAN_WEAPON, shotgun_soundindex, 1, ATTN_NORM, 0);
		self->cast_info.aiflags |= AI_RELOAD;
		}
	else if (self->spawnflags & STAYPUT_HMG)
		{
		fire_bullet (self, start, aim, 15, 50, DEFAULT_BULLET_HSPREAD>>self->acc, DEFAULT_BULLET_VSPREAD>>self->acc, MOD_BARMACHINEGUN);

		if (self->lastduration == 1)
			gi.sound(self, CHAN_WEAPON, gi.soundindex("weapons/hmg/hmg.wav"), 1, ATTN_NORM, 0);
		if (self->lastduration == 0)
			self->durationflag = 1;
		}
	else if (self->spawnflags & STAYPUT_BAZOOKA)
		{
		cast_fire_rocket (self, start, aim, 100, 900, MOD_ROCKET); // damage: 100, speed: 900
		gi.sound (self, CHAN_WEAPON, rocketgun_soundindex, 1, ATTN_NORM, 0);
		}
	else if (self->spawnflags & STAYPUT_FLAMEGUN)
		{
		static int flamesnd = 0;

		fire_flamethrower(self, start, aim, 1, 0, MOD_FLAMETHROWER); // damage: 1
		self->s.renderfx2 |= RF2_FLAMETHROWER;

		flamesnd = (flamesnd + 1) % 3;

		if (flamesnd == 0)
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame1.wav"), 1, ATTN_NORM, 0);
		else if (flamesnd == 1)
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame2.wav"), 1, ATTN_NORM, 0);
		else
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame3.wav"), 1, ATTN_NORM, 0);
		}
	else if (self->spawnflags & STAYPUT_GRENADE)
		{
		// Ridah, lob it higher if they're further away
		if (VectorDistance(self->s.origin, self->enemy->s.origin) > 512)
			aim[2] += 0.4;

		fire_grenade (self, start, aim, 150, 450, 2.0, 256);
		gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/grenade_launcher/gl_fire.wav"), 1, ATTN_NORM, 0);
		}
	}

void stayput_firegun_cr (edict_t *self)
	{
	if (self->spawnflags & STAYPUT_TOMMYGUN)
		stayput_firegun (self);
	}

//
// Replaces ai_charge for attack
//
void stayput_face (edict_t *self, float dist)
	{
	#if 0
	ai_turn(self, dist);
	#else
	vec3_t	v;

	if (!self->enemy)
		return;


	VectorSubtract (self->enemy->s.origin, self->s.origin, v);
	self->ideal_yaw = vectoyaw(v);

	//gi.dprintf("ideal_yaw: %f\n", self->ideal_yaw);
	self->s.angles[YAW] = self->ideal_yaw;
	// for some reason, using M_ChangeYaw doesn't work...
	M_ChangeYaw (self);
	#endif
	}

void stayput_firehmg_delay (edict_t *self)
	{
	if (((self->style == STAYPUT_PUNK) && (self->s.frame == 35)) ||
	    ((self->style == STAYPUT_SHORTY) && (self->s.frame == 28)) ||
	    ((self->style == STAYPUT_WHORE) && (self->s.frame == 41)))
		self->cast_info.currentmove =  anim_stack[self->frame_first + ANIM_SHOOT_HMG2];
	}

void stayput_firebazooka_delay (edict_t *self)
	{
	if (((self->style == STAYPUT_PUNK) && (self->s.frame == 35)) ||
	    ((self->style == STAYPUT_SHORTY) && (self->s.frame == 28)) ||
	    ((self->style == STAYPUT_WHORE) && (self->s.frame == 41)))
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_SHOOT_BAZOOKA2];
	}

void stayput_firehmg (edict_t *self)
	{
	vec3_t	start;
	vec3_t	forward, right;
	vec3_t	target;
	vec3_t	aim;
	vec3_t	offset;
	int		flash_number;
	float	dist;

	if (!AI_BeginAttack(self))
		{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
		}
	
	if (self->duration++ > 30)
		{
		self->duration = 0;
		self->cast_info.currentmove = anim_stack[self->frame_first + ANIM_RELOAD];
		self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		return;
		}

	// yell at them?
	stayput_battlecry(self);

	VectorSet(offset, 0, 8,  self->viewheight-8);

	AngleVectors (self->s.angles, forward, right, NULL);
	G_ProjectSource (self->s.origin, offset, forward, right, start);

	// project enemy back a bit and target there
	VectorCopy (self->enemy->s.origin, target);
	VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

	if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
		target[2] += -8 * random();
	else
		target[2] += self->enemy->viewheight - 4 - (16 * random());

	flash_number = MZ2_GUNNER_MACHINEGUN_1;

	VectorSubtract (target, start, aim);
	dist = VectorNormalize (aim);
	self->ideal_yaw = vectoyaw(aim);

	fire_bullet (self, start, aim, 15, 50, DEFAULT_BULLET_HSPREAD>>self->acc, DEFAULT_BULLET_VSPREAD>>self->acc, MOD_BARMACHINEGUN);
	if (((self->style == STAYPUT_PUNK) && (self->s.frame == 31)) ||
	    ((self->style == STAYPUT_SHORTY) && (self->s.frame == 22)) ||
	    ((self->style == STAYPUT_WHORE) && (self->s.frame == 28)))
		gi.sound(self, CHAN_WEAPON, gi.soundindex("weapons/hmg/hmg.wav"), 1, ATTN_NORM, 0);
	}


// don't care, it's flavoring, just making a dummy function to avoid a null pointer
void stayput_talk( edict_t *self )
	{
	return;
	}

void stayput_avoid (edict_t *self, edict_t *other, qboolean face)
	{
	vec3_t	vec;

	if ((self->health <= 0) || (!self->groundentity))
		return;

	if (!other)
		{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
		}

	self->cast_info.last_avoid = level.time;
	self->cast_info.avoid_ent = NULL;

	if (face)
		{	
		VectorSubtract(other->s.origin, self->s.origin, vec);
		self->cast_info.avoid_ent = other;
		}
	else
		VectorSubtract(self->s.origin, other->s.origin, vec);
	VectorNormalize(vec);

	self->ideal_yaw = vectoyaw(vec);
	self->cast_info.currentmove = self->cast_info.move_stand;
	//self->cast_info.currentmove = self->cast_info.move_crouch_down;
	}