  'Include this program via '#INCLUDE ONCE   "genlib.bas"'
  
  #DEFINE RCMLN_FORCEONE    1
  #DEFINE RCMLN_SHOWINPUT   2
  #DEFINE RCMLN_ALLOWEMPTY  4
  
  dim shared as ubyte GENLIB_ENABLECONSOLE
  
  'String processing
  DECLARE FUNCTION    STRMATCH        (BYVAL Source AS STRING = "", BYVAL Find AS STRING = "") AS UBYTE
  DECLARE FUNCTION    STRDIR          (BYVAL Source AS STRING = "") AS STRING
  DECLARE FUNCTION    STRTRIM         (BYVAL Source AS STRING = "") AS STRING
  DECLARE FUNCTION    STRSUB          (BYVAL Source AS STRING = "", BYVAL Find AS STRING = "", BYVAL Replace AS STRING = "", BYVAL exact AS UBYTE = 0) AS STRING
  DECLARE FUNCTION    LINEBREAK       (BYVAL Source AS STRING, BYVAL IdealLength AS UBYTE = 40, BYVAL BreakSymbol AS STRING = "\n") AS STRING
  DECLARE FUNCTION    HTIME           (BYVAL Seconds AS DOUBLE = 0) AS STRING

  'Command line processing
  declare SUB         SETOPTION       (BYVAL FullCom AS STRING = "", BYVAL ShortCom AS STRING = "", BYVAL Description AS STRING = "", BYVAL FlagValue AS USHORT = 0, BYVAL Variable AS ANY PTR, BYVAL Extra AS UBYTE = 0)
  declare function    READCOMMANDLINE (BYVAL ExtraStuff as ubyte = 0) as string
  declare sub         DisplayUsage    (byval Flag as ubyte = 0)

  'Misc
  DECLARE SUB         CPRINT          (BYVAL Source AS wString PTR, BYVAL Debug AS wstring PTR)  
  declare sub         Critical        (byval Text as string)
  DECLARE SUB         MMDIR           (Source AS wString)
  declare function    Overwrite       (filename as wstring, BYVAL Variable AS short PTR, byval FlagValue as ushort = 0) as ubyte  
  declare function    ASK             (text as wstring, byval clist as string) as ubyte  

  TYPE Com_t
    LParameter AS STRING
    SParameter AS STRING
    Flag       AS USHORT
    Usage      AS STRING
    Extra      AS UBYTE
    Activated  as ubyte
    Variable   AS USHORT  PTR
    Variable2  AS wString PTR
  END TYPE: REDIM SHARED AS Com_T CmdOption(0 TO 0)

  ' Defines a new parameter for the command line options
  ' ("-fast" "-f" "enable fast mode" 16 @ToolFlags, 0)  If the user inputs -fast or -f, the value 16 will be added to ToolFlags
  ' Extra: 0 -- This option is a flag, no extra info needed
  '        1 -- This option needs an argument (integer)
  '        2 -- This option needs an argument (string)
  ' If the flagvalue and extra are NULL, the usage page is displayed
  ' Note: when using a string variable, use "strptr" instead of "@", also
  ' the destination variable's size must be defined (string*1024 for instance)
  '---------------------------------------------------------------------------
  SUB SETOPTION (BYVAL FullCom AS STRING = "", BYVAL ShortCom AS STRING = "", BYVAL Description AS STRING = "", BYVAL FlagValue AS USHORT = 0, BYVAL Variable AS ANY PTR, BYVAL Extra AS UBYTE = 0)
    REDIM PRESERVE CmdOption (1 TO UBOUND(CmdOption)+1)
    CmdOption(UBOUND(CmdOption)).LParameter = "-"+LCASE(FullCom)
    CmdOption(UBOUND(CmdOption)).SParameter = "-"+LCASE(ShortCom)
    CmdOption(UBOUND(CmdOption)).Flag       = FlagValue
    CmdOption(UBOUND(CmdOption)).Usage      = Description
    CmdOption(UBOUND(CmdOption)).Extra      = Extra
    IF (Extra = 2) THEN CmdOption(UBOUND(CmdOption)).Variable2= Variable ELSE CmdOption(UBOUND(CmdOption)).Variable = Variable
  END SUB

  ' This function test a file, and kills it if asked
  '-----------------------------------------------------------------------------
  function Overwrite(filename as wstring, BYVAL Variable AS short PTR, byval FlagValue as ushort = 0) as ubyte
    dim as string UserEntry
    dim as ubyte  UserSaid
    if dir$(Filename) = "" then return 1 'no file found
    if (Variable <> 0) and (FlagValue <> 0) then
      if (*Variable and FlagValue) then kill filename: return 1 'overwrite flag is on in this variable, kill file
    end if
    UserSaid = ask(Filename+" already exists, replace", "Yes/No")
    if UserSaid = 1 then kill Filename: return 1
    if UserSaid = 2 then return 0
  end function

  ' Read all arguments from the command line
  '-----------------------------------------------------------------------------
  function READCOMMANDLINE (BYVAL ExtraStuff as ubyte = 0) as string
    DIM AS UBYTE  TEMP_CurrentCommand=1
    DIM AS STRING TEMP_Com
    READCOMMANDLINE = ""
    if (ExtraStuff and RCMLN_FORCEONE) and (COMMAND(1) = "") then DisplayUsage(ExtraStuff):END
    DO
      TEMP_Com = LCASE(STRTRIM(COMMAND(TEMP_CurrentCommand)))
      IF MID(TEMP_Com,1,1) = "-" THEN
        FOR k AS USHORT = LBOUND(CmdOption) TO UBOUND(CmdOption)+1
          IF k = UBOUND(CmdOption)+1 THEN
            if (GENLIB_ENABLECONSOLE) then cprint ("[!] Parameter unknow: "+Temp_Com, "") else print "[!] Parameter unknow: "+Temp_Com
          ELSE
            IF (Temp_Com = CmdOption(k).LParameter) OR (Temp_Com = CmdOption(k).SParameter) THEN
              IF (CmdOption(k).FLAG) THEN 
                *CmdOption(k).VARIABLE OR= CmdOption(k).FLAG
                CmdOption(k).Activated = 1
                EXIT FOR 'DONE
              ELSE
                IF (CmdOption(k).EXTRA = 0) THEN
                  DisplayUsage(ExtraStuff):END 'DONE
                ELSE
                  TEMP_CurrentCommand += 1
                  IF (CmdOption(k).EXTRA = 1) THEN
                    *CmdOption(k).VARIABLE = VAL(STRTRIM(COMMAND(TEMP_CurrentCommand)))
                    CmdOption(k).Activated = 1
                    EXIT FOR 'DONE
                  ELSEIF (CmdOption(k).EXTRA = 2) THEN
                    *CmdOption(k).VARIABLE2 = LCASE(STRTRIM(COMMAND(TEMP_CurrentCommand)))
                    CmdOption(k).Activated = 1
                    EXIT FOR 'DONE
                  END IF
                END IF
              END IF
            END IF
          END IF
        NEXT k
      ELSEIF (TEMP_COM <> "") THEN
        if (ExtraStuff and RCMLN_ALLOWEMPTY) then
          READCOMMANDLINE = TEMP_COM
        else
          if (GENLIB_ENABLECONSOLE) then cprint("[!] Argument invalid: "+Temp_Com, "") else print "[!] Argument invalid: "+Temp_Com
        end if
      END IF
      TEMP_CurrentCommand += 1
    LOOP WHILE COMMAND(TEMP_CurrentCommand) <> "" 
    if (ExtraStuff and RCMLN_SHOWINPUT) then
      for x as ushort = lbound(CmdOption) to ubound(CmdOption)
        if (CmdOption(X).Activated) then
          if (CmdOption(X).FLAG) then
            if (*CmdOption(X).Variable and CmdOption(X).FLAG) then
              if (GENLIB_ENABLECONSOLE) then 
                cprint (CmdOption(X).LParameter+" ("+CmdOption(x).Usage+")", "")
              else
                print CmdOption(X).LParameter+" ("+CmdOption(x).Usage+")"
              end if
            end if
          else
            if (CmdOption(X).Extra <> 0) then
              if (GENLIB_ENABLECONSOLE) then
                if (CmdOption(X).Extra = 1) then
                  cprint (ucase(right(CmdOption(X).LParameter,len(CmdOption(X).LParameter)-1))+" set to "+str(*CmdOption(X).Variable), "")
                else
                  cprint (ucase(right(CmdOption(X).LParameter,len(CmdOption(X).LParameter)-1))+": "+chr(34)+str(*CmdOption(X).Variable2)+chr(34), "")
                end if
              else
                print ucase(right(CmdOption(X).LParameter,len(CmdOption(X).LParameter)-1));
                if (CmdOption(X).Extra = 1) then
                  print " set to "+str(*CmdOption(X).Variable)
                else
                  print ": "+chr(34)+str(*CmdOption(X).Variable2)+chr(34)
                end if
              end if
            end if
          end if
        end if
      next x
    end if
  END function

  ' Prompt user
  '-----------------------------------------------------------------------------
  function ASK(text as wstring, byval clist as string) as ubyte
    redim as string*1 choices(0 to 0)
    dim as string     UserKey, TmpString
    dim as integer    CurRow, CurLine
    CurRow = pos: CurLine = Csrlin
    if Clist ="" then CList = "Yes/No"
    if right(clist,1) <> "/" then clist +="/"
    TmpString = Clist
    do
      for k as ushort=1 to len(TmpString)
        if mid(TmpString, k,1) = "/" then
          redim preserve Choices(1 to ubound(Choices)+1)
          Choices(ubound(Choices)) = lcase(left(TmpString,1))
          TmpString = right(TmpString, len(TmpString)-k)
          exit for
        end if
      next k
    loop while TmpString <> ""
    if (GENLIB_ENABLECONSOLE) then
      cprint (Text+"? ["+left(Clist,len(Clist)-1)+"]", "")
    else
      CurLine = csrlin: locate CurLine,CurRow:print Text+"? ["+left(Clist,len(CList)-1)+"]";
    end if
    do
      UserKey = lcase(inkey)
      for k as ushort = lbound(Choices) to ubound(Choices)
        if UserKey = Choices(k) then
          if (GENLIB_ENABLECONSOLE) then
            return k
          else
            locate CurLine,CurRow:print space(len(Text)+len(CList)+4);
            locate CurLine,CurRow
            return k
          end if
        end if
      next k
    loop
  end function

  ' Display usage
  '-----------------------------------------------------------------------------
  sub DisplayUsage (byval Flag as ubyte = 0)
    dim as string UsageString
    UsageString = "Usage: "
    if instr(Command(0), "\") then
      for k as ushort = 0 to len(Command(0))-1
        if mid(Command(0),len(Command(0))-k,1) = "\" then UsageString += right(Command(0),k):exit for
      next k
    else
      UsageString += command(0)
    end if
    if (Flag and RCMLN_ALLOWEMPTY) then UsageString +=" [filename]"
    if (ubound(CmdOption)) then UsageString +=" [options]"
    if (GENLIB_ENABLECONSOLE) then
      cprint (UsageString, ""):cprint (" ", "")
    else
      print UsageString:print
    end if
    if ubound(CmdOption) then
      dim as string Str1, Str2, Str3, Str4
      for x as ushort = lbound(CmdOption) to ubound(CmdOption)
        Str1 = CmdOption(x).LParameter: Str2 = CmdOption(x).SParameter: Str3 = CmdOption(x).Usage:Str4 = ""
        if (CmdOption(X).Extra = 1) then Str4 = " #"
        if (CmdOption(X).Extra = 2) then Str4 = " $"
        if (GENLIB_ENABLECONSOLE) then
          cprint ("  "+Str1+Str4+space(15-len(Str1+Str4))+"("+Str2+Str4+")"+space(6-len(Str2+Str4))+" > "+Str3, "")
        else
          print "  "+Str1+Str4+space(15-len(Str1+Str4))+"("+Str2+Str4+")"+space(6-len(Str2+Str4))+" > "+Str3
        end if
      next x
    end if
    if (GENLIB_ENABLECONSOLE) then
      cprint (" ", "Press any key to exit.")
    else
      print:print "Press any key to exit."
    end if
    sleep
  end sub

  ' Return a natural string to describe time
  '-----------------------------------------------------------------------------  
  FUNCTION HTIME     (BYVAL Seconds AS DOUBLE = 0) AS STRING
    DIM AS UINTEGER Counter = ABS(Seconds)
    DIM AS STRING   FStr
    IF Counter >= (60*60*24)    THEN FStr += STR(Counter \ 86400)+"D ": Counter MOD= 86400
    IF Counter >= (60*60)       THEN FStr += STR(Counter \ 3600)+"h ":  Counter MOD= 3600
    IF Counter >= 60            THEN FStr += STR(Counter \ 60)+"m ":    Counter MOD= 60
    Fstr += STR(Counter)+"s"
    RETURN Fstr
  END FUNCTION

  ' Console PRINT
  '-----------------------------------------------------------------------------  
  SUB CPRINT (BYVAL Source AS wString PTR, BYVAL Debug AS wstring PTR)
    STATIC AS wstring*78 Console(0 TO 23)
    STATIC AS wstring*78 NewDebug
    
    IF ((*Source) = "") AND ((*Debug) = "") THEN
      GENLIB_ENABLECONSOLE = 1: SCREEN 0,0,0: LOCATE ,,0:COLOR 7,0:CLS: LOCATE 25,1:COLOR 0,7:PRINT SPACE(80);: color 7,0
      exit sub
    else
      if GENLIB_ENABLECONSOLE = 0 then
        if (*Source <> "") then print *Source
        if (*Debug <> "") then print *Debug;:locate ,1
      end if
    END IF
    
    *Source = LEFT(*Source,78): *Debug  = LEFT(*Debug, 78)

    IF (*Source) <> "" THEN
      FOR k AS UBYTE = LBOUND(Console) TO UBOUND(Console)-1
        Console(UBOUND(Console)-k) = Console(UBOUND(Console)-k-1)
      NEXT k
      Console(0) = LEFT(*Source,78)
      FOR k AS UBYTE = LBOUND(Console) TO UBOUND(Console)
        IF (k MOD 2) THEN COLOR 7 ELSE COLOR 8
        LOCATE 24-k,1:PRINT SPACE(80);
        LOCATE 24-k,1:PRINT "  "+Console(k);
      NEXT k      
    END IF:COLOR 7
    
    IF (*Debug) <> "" THEN
      IF LEN(*Debug) < LEN(NewDebug) THEN
        NewDebug = SPACE(LEN(NewDebug)-LEN(*Debug))+*Debug
      ELSE
        NewDebug = *Debug
      END IF
      LOCATE 25,79-LEN(NewDebug):COLOR 0,7:PRINT " "+NewDebug;
    END IF
    
    COLOR 7,0
  END SUB
  
  ' Make Multiple dirs if necessary
  '-----------------------------------------------------------------------------  
  SUB MMDIR (Source AS wString)
    FOR l AS USHORT = 1 TO LEN(Source)
      IF MID(Source, l, 1) = "/" THEN
        IF DIR(MID(Source, 1, l-1), 16) = "" THEN MKDIR(MID(Source,1,l-1))
      END IF
    NEXT l
    IF DIR(Source,16) = "" THEN MKDIR(Source)
  END SUB
  
  ' Breaks line if necessary, do not cut words
  '-----------------------------------------------------------------------------  
  FUNCTION LINEBREAK (BYVAL Source AS STRING, BYVAL IdealLength AS UBYTE = 40, BYVAL BreakSymbol AS STRING = "\n") AS STRING
    DIM AS USHORT LastSpace, ParsedChars
    FOR k AS USHORT = 1 TO LEN(Source)
      ParsedChars += 1
      IF MID(Source,k,1) = " " THEN lastSpace = k
      IF ParsedChars = IdealLength THEN
        ParsedChars = 0: k = lastSpace+1
        Source = LEFT(Source,LastSpace-1)+BreakSymbol+RIGHT(Source,LEN(Source)-LastSpace)
      END IF
    NEXT k
    RETURN Source
  END FUNCTION 


  ' Search for [Find] in [Source], return 0 if there's none
  '-----------------------------------------------------------------------------
  FUNCTION STRMATCH (BYVAL Source AS STRING = "", BYVAL Find AS STRING = "") AS UBYTE
    DIM AS USHORT     TMP
    DIM AS UBYTE      LeftSide, RightSide    
    IF (INSTR(LCASE(Source), LCASE(Find)) = 0) THEN RETURN 0
    Tmp = INSTR(LCASE(Source), LCASE(Find))
    DO
      LeftSide = 0: RightSide = 0
      IF (Tmp = 1) THEN
        LeftSide = 1  'we start with the very first stuff
      ELSE
        IF (INSTR("() .,;:'"+CHR(34), MID(Source,Tmp-1,1))) THEN LeftSide = 1  'there's a space, a quote or whatever
      END IF
      IF (Tmp+LEN(Find)-1) = LEN(Source) THEN
        RightSide = 1 'we're at the end of the line
      ELSE
        IF (INSTR("() .,;:'"+CHR(34), MID(Source, Tmp+LEN(Find),1))) THEN RightSide = 1
      END IF
      IF (LeftSide = 1) AND (RightSide = 1) THEN
        RETURN 1 'Found!
      ELSE
        RETURN 0 'Not found
      END IF
      Tmp = INSTR(Tmp+1, LCASE(Source), LCASE(Find))
    LOOP WHILE tmp    
  END FUNCTION

  ' Write a standarized directory string out of [Source]
  '-----------------------------------------------------------------------------
  FUNCTION STRDIR (BYVAL Source AS STRING = "") AS STRING
    DIM AS STRING Source2 = Source
    DO WHILE (LEFT(Source2,1) = CHR(9)) OR (LEFT(Source2,1) = CHR(32))
      Source2 = RIGHT(Source2,LEN(Source2)-1)
    LOOP
    DO WHILE (RIGHT(Source2,1) = CHR(9)) OR (RIGHT(Source2,1) = CHR(32))
      Source2 = LEFT(Source2,LEN(Source2)-1)
    LOOP     
    FOR tmp AS USHORT = 1 TO LEN(Source2)
      IF MID(Source2,tmp,1) = "\" THEN MID(Source2,tmp,1) = "/"
    NEXT tmp
    IF (LEFT(Source2,1) = "/")  THEN Source2 = RIGHT(Source2,LEN(Source2)-1)
    RETURN Source2
  END FUNCTION

  ' Trim [source] and remove indents
  '-----------------------------------------------------------------------------
  FUNCTION STRTRIM (BYVAL Source AS STRING = "") AS STRING
    FOR k AS USHORT = 1 TO LEN(Source)
      IF MID(Source, k,1) = CHR(9) THEN MID(Source,k,1)= CHR(32)
    NEXT k
    RETURN LTRIM(RTRIM(Source))
  END FUNCTION
  
  ' Replace all [Find] in [Source] with [Replace]
  '-----------------------------------------------------------------------------
  FUNCTION STRSUB (BYVAL Source AS STRING = "", BYVAL Find AS STRING = "", BYVAL Replace AS STRING = "", BYVAL exact AS UBYTE = 0) AS STRING
    REDIM AS USHORT   FoundAt(0 TO 0)
    DIM AS USHORT     Tmp
    DIM AS UBYTE      LeftSide, RightSide
    DIM AS STRING     Part1, Part2
    IF (INSTR(LCASE(Source), LCASE(Find)) = 0) OR (LCASE(Find) = LCASE(Replace)) THEN RETURN Source
    Tmp = INSTR(LCASE(Source), LCASE(Find))
    DO
      IF exact THEN
        LeftSide = 0: RightSide = 0 'reset
        IF (Tmp = 1) THEN
          LeftSide = 1  'we just started the line
        ELSE
          IF (INSTR("() .,;:'"+CHR(34), MID(Source,Tmp-1,1))) THEN LeftSide = 1  'there's a space, a quote or whatever
        END IF
        IF (Tmp+LEN(Find)-1) = LEN(Source) THEN
          RightSide = 1 'we're at the end of the line
        ELSE
          IF (INSTR("() .,;:'"+CHR(34), MID(Source, Tmp+LEN(Find),1))) THEN RightSide = 1
        END IF
      ELSE
        LeftSide = 1: RightSide = 1
      END IF
      IF (LeftSide = 1) AND (RightSide = 1) THEN
        REDIM PRESERVE FoundAt(1 TO UBOUND(FoundAt)+1)
        FoundAt(UBOUND(FoundAt)) = Tmp-1  'our stuff to replace is the character right after
      END IF
      Tmp = INSTR(Tmp+1, LCASE(Source), LCASE(Find))
    LOOP WHILE tmp
    IF UBOUND(FoundAt) = 0 THEN RETURN source
    FOR i AS USHORT = 1 TO UBOUND(FoundAt)
      Part1 = LEFT(Source, FoundAt(UBOUND(FoundAt)-(i-1)))
      IF LEN(Source)-(FoundAt(UBOUND(FoundAt)-(i-1))+LEN(Find)) <> 0 THEN
        Part2 = RIGHT(Source, LEN(Source)-(FoundAt(UBOUND(FoundAt)-(i-1))+LEN(Find)))
      ELSE
        Part2 = ""
      END IF
      Source = Part1 + Replace + Part2
    NEXT i
    RETURN Source
  END FUNCTION

  sub Critical (byval Text as string)
    if GENLIB_ENABLECONSOLE then
      locate ,,1:cprint ("[!] "+Text, "Press any key to exit."):sleep
    else
      print "[!] "+Text+"...":sleep
    end if
  end sub
  