/******************************************************************************

	GENERIC EPISODE CODE

******************************************************************************/

#include "g_local.h"

/*
	case EP_SKIDROW :
	case EP_POISONVILLE :
	case EP_STEELTOWN:
	case EP_TRAINYARD:
	case EP_RADIOCITY:
	case EP_SHIPYARDS:
	case EP_CRYSTALPALACE:
*/
//............................................................................
// Character Names
//

// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
//
// Note, these must be in the same order as the defines in ep_all.h!
//
// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !

char *ep_names[] =
{
	"--THIS SLOT MUST BE VACANT--",
	"Al",
	"Beth",
	"Magicj",
	"Lisa",
	"Louie",
	"Frank",
	"Buttmunch",
	"Arnold",
	"Brewster",
	"Punky",
	"Igmo",
	"Johnny",
	"Betty",
	"Leroy",
	"Jed",
	"Buster",
	"Bubba",
	"Momo",
	"Muttski",
	"Spike",
	"ToughGuy1",
	"ToughGuy2",
	"IntroGuy",
	"Bernie",
	"Lamont",
	"Mona",
	"Lenny",
	"Chick",
	"Sluggo",
	"Rocko",
	"Rover",
	"Joseph",
	"Rummy", // sr1 bum
	"Nick",  // sr2 bum
	"Jesus", // sr boss 
	"Yolanda",
	"Carlton",
	"Tina",
	"Hardey",
	"Laurel",
	"Harold",
	"Dick",
	"Burt",
	"Fingers",
	"Dan",
	"Clarence",
	"Adolf",
	"Candy",
	"Sharky",
	"Kingpin",
	"Blunt",
	"NikkiBlanco",
	"Moe",
	"Larry",
	"Curly",
	"Ed",
	"Popeye",
	"Dogg",
	"Selma",
	"Jane",
	"Barney",
	"BigWillie",
	"Sal",
	"Lefty",
	"Bwillie",
	"Mung",
	"Tyrone",
	"Luke",
	"Hann",
	"Kroker",
	"kid_1",
	"kid_2",
	"kid_3",
	"kid_4",
	"kid_5",
	"kid_6",
	"kid_7",
	"kid_8",
	"Oscar",
	"David",
	"Bambi",
	"Brittany",
	"Mathew",
	"Pete",
	"Moker",
	"Heilman",
	"Butch",
	"Patrick",
	"Groucho",
	"Harpo",
	"Chico",
	"Blefty",
	"Scalper",
	"Dubs",
	"Rochelle",
	"Lola",
	"Dude",
	"Walter",
	"Donny",
	NULL
};


/*************************************************************************************
	EP_Register_EPFLAG
	This code register the specified ep_flag value to the *self entity. It used to
	be named "EP_Skidrow_Register_EPFLAG", even though it is a common procedure
	called by every episode; therefore I renamed it "EP_Register_EPFLAG" and move
	its code here (ACC)
*************************************************************************************/
void EP_Register_EPFLAG (edict_t *self, int ep_flag)
{
	if (self->client->pers.episode_flags & ep_flag)
		return;
	self->episode_flags = self->client->pers.episode_flags |= ep_flag;
	EP_Flash_Newflag (self, ep_flag);
}

/*************************************************************************************
	Show_Help
	"Spawn" the note book icon down the screen
*************************************************************************************/
void Think_Help (edict_t *ent)
{
	if (!level.helpchange || !ent->misstime)
	{
		level.helpchange = 0;
		G_FreeEdict(ent);
		return;
	}
	if (ent->misstime <= 15 && level.helpchange)
		level.helpchange = ent->misstime*(255/15);
	ent->misstime--;	
	ent->nextthink = level.time + 0.1;
}

void Show_Help ()
{
	edict_t	*help	= NULL;
	edict_t	*ent	= NULL;
	ent = G_Find (NULL, FOFS(classname), "showhelp");
	if (ent) { G_FreeEdict(ent); }
	help = G_Spawn();
	if (!help) { return; }
	help->classname = "showhelp";
	help->think = Think_Help;
	help->misstime = 315;
	help->nextthink = level.time + 0.1;
	gi.linkentity (help);
	level.helpchange = 255;
}

/*************************************************************************************
	EP_SetNameIndex
	Returns the entity ent->name_index value from searchname (ent->name), new code.
*************************************************************************************/
int EP_SetNameIndex (char *searchname)
{
	int i;
	if (!searchname)
		return -1;
	for (i=0; ep_names[i]; i++)
	{
		if (!Q_stricmp(searchname, ep_names[i]))
			return i;
	}

	if (Wherever_Valid() == false) // ACC, Only display error in the original episodes
		gi.dprintf( "EP_SetNameIndex: Un-matched \"name\" (%s)\n", searchname );
	return -1;
}

// Given a NAME_*, returns the entity with the matching name
edict_t	*EP_GetCharacter (int nameIndex)
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (level.characters[i]->name_index == nameIndex)
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}
	return NULL;	// couldn't find them
}

// Given a "name", returns the entity with the matching name
edict_t	*EP_GetCharacterByName ( char *name )
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (!Q_stricmp( level.characters[i]->name, name ))
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}

	gi.dprintf( "EP_GetCharacter: couldn't find %s\n", name );

	return NULL;	// couldn't find them
}



/*************************************************************************************
	EP_PlayerLog
	Called whenever we switch pages in the roadbook (called by HelpComputer in p_hud)
*************************************************************************************/
void EP_PlayerLog (edict_t *self, int page)
{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_Player_Log (self, page);
	else if (level.episode == EP_POISONVILLE)
		EP_Poisonville_Player_Log (self, page);
	else if (level.episode == EP_SHIPYARDS)
		EP_Shipyard_Player_Log (self, page);
	else if (level.episode == EP_STEELTOWN)
		EP_Steeltown_Player_Log (self, page);
	else if (level.episode == EP_TRAINYARD)
		EP_Trainyard_Player_Log (self, page);
	else if (level.episode == EP_RADIOCITY)
		EP_Radiocity_Player_Log (self, page);
	else
		Wherever_Player_Log (self, page);		// ACC, added fallback values
}

/*************************************************************************************
	EP_CastSight
	This gets called whenever an AI character has sighted another character (which
	will happen every frame while they are in view).
*************************************************************************************/
qboolean EP_CastSight ( edict_t *self, edict_t *other, cast_memory_t *cast_memory )
{
	if (level.episode == EP_SKIDROW)
		return EP_Skidrow_CastSight (self, other, cast_memory);
	else if (level.episode == EP_POISONVILLE)
		return EP_Poisonville_CastSight (self, other, cast_memory);	
	else if (level.episode == EP_SHIPYARDS)
		return EP_Shipyard_CastSight (self, other, cast_memory);
	else if (level.episode == EP_STEELTOWN)
		return EP_Steeltown_CastSight (self, other, cast_memory);
	else if (level.episode == EP_TRAINYARD)
		return EP_Trainyard_CastSight (self, other, cast_memory);	// always false
	else if (level.episode == EP_RADIOCITY)
		return EP_Radiocity_CastSight (self, other, cast_memory);
	else
		return Wherever_CastSight (self, other, cast_memory);		// ACC, added fallback values
}

/*************************************************************************************
	EP_CastUse
	This gets called whenever an AI character dies (or are used, like they
	die and have a ->deathtarget)
*************************************************************************************/
qboolean EP_CastUse (edict_t *self, edict_t *other, edict_t *activator)
{
	if (level.episode == EP_SKIDROW)
		return EP_Skidrow_CastUse (self, other, activator);
	else if (level.episode == EP_POISONVILLE)
		return EP_Poisonville_CastUse (self, other, activator);	// always false
	else if (level.episode == EP_SHIPYARDS)
		return EP_Shipyard_CastUse (self, other, activator);	// always false
	else if (level.episode == EP_STEELTOWN)
		return EP_Steeltown_CastUse (self, other, activator);	// always false
	else if (level.episode == EP_TRAINYARD)
		return EP_Trainyard_CastUse (self, other, activator);	// always false
	else if (level.episode == EP_RADIOCITY)
		return EP_Radiocity_CastUse (self, other, activator);	// always false
	else
		return Wherever_CastUse (self, other, activator);		// ACC, added fallback values
}

/*************************************************************************************
	EP_EventSpeech
	Generic event based speech for episodes
*************************************************************************************/
qboolean EP_EventSpeech (edict_t *self, edict_t *other, int saywhat)
{
	if (level.episode == EP_SKIDROW)
		return EP_Skidrow_EventSpeech (self, other, saywhat);
	else if (level.episode == EP_POISONVILLE)
		return EP_Poisonville_EventSpeech (self, other, saywhat);
	else if (level.episode == EP_TRAINYARD)
		return EP_Trainyard_EventSpeech (self, other, saywhat);
	else if (level.episode == EP_SHIPYARDS)
		return EP_Shipyard_EventSpeech (self, other, saywhat);
	else if (level.episode == EP_STEELTOWN)
		return EP_Steeltown_EventSpeech (self, other, saywhat);
	else if (level.episode == EP_RADIOCITY)
		return EP_Radiocity_EventSpeech (self, other, saywhat);
	else
		return Wherever_EventSpeech (self, other, saywhat);		// ACC, added fallback values
}

/*************************************************************************************
	EP_ItemPickup
	Called whenever an item is picked up
*************************************************************************************/
void EP_ItemPickup (edict_t *self, edict_t *other)
{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_ItemPickup(self, other);
	else if (level.episode == EP_POISONVILLE)
		EP_Poisonville_ItemPickup(self, other);
	else if (level.episode == EP_SHIPYARDS)
		EP_Shipyard_ItemPickup(self, other);
	else if (level.episode == EP_STEELTOWN)
		EP_Steeltown_ItemPickup (self, other);		// null
	else if (level.episode == EP_TRAINYARD)
		EP_Trainyard_ItemPickup(self, other);		// null
	else if (level.episode == EP_RADIOCITY)
		EP_Radiocity_ItemPickup (self, other);		// null
	else
		Wherever_ItemPickup (self, other);			// ACC, added fallback values
}

/*************************************************************************************
	EP_EventScript
	Called whenever a character reaches a path_corner_cast that
	has a "scriptname" set
*************************************************************************************/
void EP_EventScript (edict_t *self, char *scriptname)
{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_Script(self, scriptname);
	else if (level.episode == EP_POISONVILLE)
		EP_Poisonville_Script(self, scriptname);	// null
	else if (level.episode == EP_TRAINYARD)
		EP_Trainyard_Script(self, scriptname);		// null
	else if (level.episode == EP_SHIPYARDS)
		EP_Shipyard_Script(self, scriptname);		// null
	else if (level.episode == EP_STEELTOWN)
		EP_Steeltown_Script (self, scriptname);		// null
	else if (level.episode == EP_RADIOCITY)
		EP_Radiocity_Script (self, scriptname);		// null
	else
		Wherever_Script (self, scriptname);			// ACC, added fallback values
}

/*************************************************************************************
	EP_SpawnFlags
	Called by cast_start (in g_cast.c), set spawnflags on entity initialization
*************************************************************************************/
void EP_SpawnFlags (edict_t *self)
{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_Flags (self);
	else if (level.episode == EP_POISONVILLE)
		EP_Poisonville_Flags (self);
	else if (level.episode == EP_TRAINYARD)
		EP_Trainyard_Flags (self);				// null
	else if (level.episode == EP_SHIPYARDS)
		EP_Shipyard_Flags (self);
	else if (level.episode == EP_STEELTOWN)
		EP_Steeltown_Flags (self);
	else if (level.episode == EP_RADIOCITY)
		EP_Radiocity_Flags (self);
	else
		Wherever_Flags (self);					// ACC, added fallback values
}

/*************************************************************************************
	EP_HiredGuys
	Called by cmd_order_f (in g_cmds.c), used whenever we try to hire someone (the
	function will return 0 if we can't hire the guy -- party's full or we don't have
	the permission yet, see Poisonville)
*************************************************************************************/
int EP_HiredGuys (edict_t *self, edict_t *other)
{
	if (level.episode == EP_SKIDROW)
		return EP_Skidrow_HiredGuysFlags (self, other);		// always 1
	else if (level.episode == EP_POISONVILLE)
		return EP_Poisonville_HiredGuysFlags (self, other);
	else if (level.episode == EP_STEELTOWN)
		return EP_Steeltown_HiredGuysFlags (self, other);
	else if (level.episode == EP_TRAINYARD)
		return EP_Trainyard_HiredGuysFlags (self, other);	// always 1
	else if (level.episode == EP_RADIOCITY)
		return EP_Radiocity_HiredGuysFlags (self, other);	
	else if (level.episode == EP_SHIPYARDS)
		return EP_Shipyard_HiredGuysFlags (self, other);
	else
		return Wherever_HiredGuysFlags (self, other);		// ACC, added fallback values
}

/*************************************************************************************
	EP_CheckMomo
	We checked the bouncer (yep, every bouncer in the game is called Momo), called
	by cmd_speech_f (in g_cmds.c).
*************************************************************************************/
void EP_CheckMomo (edict_t *ent, cast_memory_t	*mem)
{
	if (level.episode == EP_SKIDROW)
		EP_Skidrow_CheckMomo (ent, mem);
	else if (level.episode == EP_POISONVILLE)
		EP_Poisonville_CheckMomo (ent, mem);
	else if (level.episode == EP_SHIPYARDS)
		EP_Shipyard_CheckMomo (ent, mem);
	else if (level.episode == EP_STEELTOWN)
		EP_Steeltown_CheckMomo (ent, mem);
	else if (level.episode == EP_TRAINYARD)
		return;
	else if (level.episode == EP_RADIOCITY)
		EP_Radiocity_CheckMomo (ent, mem);
	else
		Wherever_CheckMomo (ent, mem);	// ACC, added fallback values (does nothing)
}

qboolean EP_DoKey (edict_t *ent, edict_t *other)
{
	if (level.episode == EP_SKIDROW)
		return false;
	else if (level.episode == EP_POISONVILLE)
		return EP_Poisonville_DoKey (ent, other);
	else if (level.episode == EP_SHIPYARDS)
		return false;
	else if (level.episode == EP_STEELTOWN)
		return EP_Steeltown_DoKey (ent, other);
	else if (level.episode == EP_TRAINYARD)
		return false;
	else if (level.episode == EP_RADIOCITY)
		return false;
	else
		return Wherever_DoKey (ent, other);	// ACC, added fallback values
}

void EP_CheckDoKey (edict_t *self, edict_t *ent)
{

	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_Poisonville_CheckDoKey (self, ent);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_CheckDoKey (self, ent);
		break;
	default:
		Wherever_CheckDoKey (self, ent);	// ACC, added fallback values
		break;
	}

}

void EP_ReachedDoKey (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_Poisonville_ReachedDoKey (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_ReachedDoKey (self);
		break;
	default:
		Wherever_ReachedDoKey (self);	// ACC, added fallback values
		break;
	}
}

void EP_EndDoKey (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_Poisonville_EndDoKey (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_EndDoKey (self);
		break;
	default:
		Wherever_EndDoKey (self);	// ACC, added fallback values
		break;
	}
}


qboolean EP_UnlockDoorFlag (edict_t *ent)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		return (EP_Poisonville_UnlockDoorFlag (ent));
		/*break;*/
	case EP_STEELTOWN:
		return (EP_Steeltown_UnlockDoorFlag (ent));
		/*break;*/
	default:
		return Wherever_UnlockDoorFlag (ent);	// ACC, added fallback values but guess what? all the above functions ALWAYS return false
		/*break;*/
	}

	return false;
}

void EP_HiredGuysRegisterFlags (edict_t *ent, edict_t *other)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_Poisonville_HiredGuysRegisterFlags (ent, other);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_HiredGuysRegisterFlags (ent, other);
		break;
	case EP_RADIOCITY:
		EP_Radiocity_HiredGuysRegisterFlags (ent, other);
		break;
	default:
		Wherever_HiredGuysRegisterFlags (ent, other);	// ACC, added fallback values
		break;
	}

}

void EP_SpecialEventDeath (edict_t *self)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		break;
	case EP_POISONVILLE:
		EP_Poisonville_SpecialEventDeath (self);
		break;
	case EP_STEELTOWN:
		EP_Steeltown_SpecialEventDeath (self);
		break;
	case EP_TRAINYARD:
		// EP_Trainyard_SpecialEventDeath (self);
		break;
	case EP_RADIOCITY:
		EP_Radiocity_SpecialEventDeath (self);
		break;
	case EP_SHIPYARDS:
		EP_Shipyard_SpecialEventDeath (self);
		break;
	default:
		Wherever_SpecialEventDeath (self);	// ACC, added fallback values
		break;
	}
	
}


void EP_Flash_Newflag (edict_t *self, int ep_flag)
{
	qboolean rval = false;
	switch (level.episode)
	{
	case EP_SKIDROW:
		rval = EP_Skidrow_Flash_Newflag (self, ep_flag); break;
	case EP_POISONVILLE:
		rval = EP_Poisonville_Flash_Newflag (self, ep_flag); break;
	case EP_STEELTOWN:
		rval = EP_Steeltown_Flash_Newflag (self, ep_flag); break;
	case EP_TRAINYARD:
		rval = EP_Trainyard_Flash_Newflag (self, ep_flag); break;
	case EP_RADIOCITY:
		rval = EP_Radiocity_Flash_Newflag (self, ep_flag); break;
	case EP_SHIPYARDS:
		rval = EP_Shipyard_Flash_Newflag (self, ep_flag); break;
	default:
		rval = Wherever_Flash_Newflag (self, ep_flag); break;	// ACC, added fallback values
	}

	if (rval) { Show_Help (); } // joe flash the notepad help icon here
}

/*************************************************************************************
	EP_Reset
	... ACC, I'm speachless
*************************************************************************************/
void EP_Reset (edict_t *self, edict_t *other)
{
	switch (level.episode)
	{
	case EP_SKIDROW:
		EP_Skidrow_Reset(self, other); break;
	//case EP_POISONVILLE:
		// EP_Poisonville_Reset(self, other); break;
	}
}
