#include "g_local.h"
#include "ai_spawnflags.h"


/******************************************************************************
	ACC_UsesBullets
	Returns true if the entity uses a bullet-based weapon.
******************************************************************************/
qboolean ACC_UsesBullets(edict_t *ent)
{
	if (ent->client)
	{
		if (ent->client->pers.weapon) 
			if (((!strcmp(ent->client->pers.weapon->pickup_name, "Pistol")) || (!strcmp(ent->client->pers.weapon->pickup_name, "SPistol")) || (!strcmp(ent->client->pers.weapon->pickup_name, "Shotgun")) || (!strcmp(ent->client->pers.weapon->pickup_name, "Tommygun")) || (!strcmp(ent->client->pers.weapon->pickup_name, "Heavy machinegun"))))
				return true;
	}
	else
	{
		if ((!strcmp(ent->classname, "cast_punk")) || (!strcmp(ent->classname, "cast_shorty")) || (!strcmp(ent->classname, "cast_whore")))
		{
			if (!(ent->spawnflags & AI_SPAWNFLAG_FLAMEGUN) && !(ent->spawnflags & AI_SPAWNFLAG_BAZOOKA) && !(ent->spawnflags & AI_SPAWNFLAG_GRENADE))
				return true;
		}
		else if ((!strcmp(ent->classname, "cast_thug")) || (!strcmp(ent->classname, "cast_runt")) || (!strcmp(ent->classname, "cast_bitch")))
		{
			if (!(ent->spawnflags & AI_SPAWNFLAG_MELEE))
				return true;
		}
	}
	return false;
}

/******************************************************************************
	ACC_TieWeapon
	Tie and initalize a weapon to a cast_ entity.
******************************************************************************/
void ACC_TieWeapon(edict_t *self, char *WeaponModel)
	{
	int		i;
	self->s.num_parts++;
	self->s.model_parts[PART_GUN].modelindex = gi.modelindex(WeaponModel);
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;
	gi.GetObjectBounds(WeaponModel, &self->s.model_parts[PART_GUN]);
	}		

/******************************************************************************
	Wherever_Read_Log_File
	Loads EPLOG[episodenumber].SSF located in the mod directory, this file
	contains several scripts (episode flags, log entries, shop prices...)
	This procedure is summoned by ClientBegin (in p_client.c)
******************************************************************************/
void Wherever_Read_Log_File  ()
{
	FILE		*f;
	cvar_t		*game_dir;
	char		logfilename[MAX_QPATH];
	char		epnmbr[33];
	edict_t		*player;	

	player = &g_edicts[1];
	
	if (Wherever_Valid()==false)
		return;						// Exit if we're using a non-SPMod episode number

	// Get Kingpin Log File
	game_dir = gi.cvar("gamedir", "", 0);
	if (!strlen(game_dir->string))
		strcpy(logfilename, "main");
	else
		strcpy(logfilename, game_dir->string);
	strcat(logfilename, DIR_SLASH);
	itoa(level.episode, epnmbr, 10);
	strcat(logfilename, "eplog");
	strcat(logfilename, epnmbr);
	strcat(logfilename, ".ssf");

	// Opening EPLOG#.SSF
	f = fopen(logfilename, "rb");
	if (!f)
		{
		gi.dprintf("Cannot open %s!\n",logfilename);
		return;
		}
	else
		{
		char			SSFSignature[3];
		unsigned char	SSFVersion;
		unsigned short	SSFTables;
		unsigned char	Chunk;
		unsigned char	TBLId;

		strcpy (SSFSignature, "");	// Erase SSFSignature, just in case
		CPawn.IsSet = 0;			// No pawn defined yet (once again, just in case)

		fread (SSFSignature, sizeof(SSFSignature), 1, f);		// Reading Signature (should be SSF)
		if (strcmp(SSFSignature, "SSF")) { gi.dprintf("%s is not a valid SPMod Script File (%s)!\n",logfilename, SSFSignature); fclose(f); return; }

		fread (&SSFVersion, 1, 1, f);		// Reading Version number (should be 1)
		if (SSFVersion != 1) { gi.dprintf("%s is a version %i (should be 1)!\n",logfilename, SSFVersion); fclose(f); return; }

		fread (&SSFTables, 2, 1, f);	// Reading amount of tables (should be at least 1)
		if (!SSFTables) { gi.dprintf("No table defined in %s\n", logfilename); fclose(f); return; }

		if (spmod_debug->value) { gi.dprintf("==== Reading %s v%i (%i chunks) ====\n", logfilename, SSFVersion, SSFTables); }

		for (Chunk=0; Chunk < SSFTables; Chunk++)
			{
			fread(&TBLId, 1, 1, f);		// Reading chunk ID number
			if (spmod_debug->value) { gi.dprintf("Chunk %i of %i: ChunkID %i\n", (Chunk+1), SSFTables, TBLId); }
			if (TBLId == 1)			// FLAGS TABLE
				{
				unsigned int		i = 0;
				unsigned char		FlEntries;
				unsigned char		FlNmLength;
				unsigned char		FlNmNumber;
				fread(&FlEntries, 1, 1, f);
				if (FlEntries >= 33) {gi.dprintf("More than 32 flags defined in %s!\n", logfilename); fclose(f); return; }
				if (spmod_debug->value) { gi.dprintf("Reading %i flags\n", FlEntries); }
				for (i=0; i < FlEntries; i++)
					{
					fread(&FlNmNumber, 1, 1, f);			// Flag NUMBER (1 to 32)
					if (!(FlNmNumber)) {gi.dprintf("Tried to define FLAG VALUE 0 in %s!\n", logfilename); fclose(f); return; }
					if (FlNmNumber >= 33) {gi.dprintf("Tried to define more than 32 flags in %s!\n", logfilename); fclose(f); return; }
					fread(&FlNmLength, 1, 1, f);			// Flag Name (length)
					fread(wherever_flags[FlNmNumber-1].flagname, 1, FlNmLength, f);	// Flag Name (string)					
					wherever_flags[FlNmNumber-1].flagval = 1UL << (FlNmNumber-1);	// Define flag value (power of two)
					if (spmod_debug->value) { gi.dprintf("\"%s\" (%i)\n", wherever_flags[FlNmNumber-1].flagname, wherever_flags[FlNmNumber-1].flagval); }
					}
				}
			else if (TBLId == 2)	// LOG ENTRIES
				{
				unsigned int		i = 0;
				unsigned char		LgEntries;
				unsigned char		LgLength;
				unsigned char		LgNumber;
				fread(&LgEntries, 1, 1, f);
				if (LgEntries >= 34) {gi.dprintf("More than 33 logs defined in %s!\n", logfilename); fclose(f); return; }
				if (spmod_debug->value) { gi.dprintf("Reading %i logs\n", LgEntries); }
				for (i=0; i < LgEntries; i++)
					{
					fread(&LgNumber, 1, 1, f);								// Flag number (0 to 32) (0 is used as a default message, always triggered), also defines message number
					if (!((LgNumber >= 0) && (LgNumber <= 32))) {gi.dprintf("Tried to assign an invalid flag number to a log entry in %s!\n", logfilename); fclose(f); return; }
					fread(&LgLength, 1, 1, f);								// Log Message (length)
					fread(wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_text, 1, LgLength, f);	//LgNumber CAN be 0, so we shouldn't write LgNumber-1
					wherever_player_log[NUM_WHEREVER_PLAYER_LOG].clue_number = NUM_WHEREVER_PLAYER_LOG;			// Clue identification number (I don't think it's even used)
					if (player->client->pers.episode_flags == 0)					// We just started this episode, so turn all logs to "not new" and log_flag 0 to "new"
						{
							if (wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_flag == 0)
								wherever_player_log[NUM_WHEREVER_PLAYER_LOG].new_clue = true;
							else
								wherever_player_log[NUM_WHEREVER_PLAYER_LOG].new_clue = false; // can't remember why I put LgNumber+1, but if there's anything wrong going on, bet it's here
						}
					if (LgNumber) { wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_flag = 1UL << (LgNumber-1); } else  { wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_flag = 0; }
					if (spmod_debug->value) { gi.dprintf("\"%s\" (%i)\n", wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_text, wherever_player_log[NUM_WHEREVER_PLAYER_LOG].ep_flag); }
					NUM_WHEREVER_PLAYER_LOG++;
					}
				}
			else if ((TBLId == 3) || (TBLId == 4))	// SHOP DEFINITION (3 = stocks, 4 = prices)
				{
				unsigned char	ShopID;
				edict_t			*pawnboard;

				if (level.pawn_time || strstr (level.mapname, "pawn_"))
				{
					fread (&ShopID, 1, 1, f);		// 1 (shop ID, should be > 0)
					pawnboard = G_Find(NULL, FOFS(classname), "pawn_o_matic");
					if ((pawnboard->count != ShopID))
					{
						gi.dprintf("Pawn_o_matic id != chunk (%i, %i)\n", pawnboard->count, ShopID);
						if (TBLId == 3) { fseek (f, 8, SEEK_CUR); } else { fseek(f, 128, SEEK_CUR); }	// Skip 8 bits for stocks, 128 bits for prices (8slots x 8items x 2bytes)
					}
					else		// Matchin pawn_o_matic found!
					{
						if (TBLId == 3)	// Stocks
						{
							int i;
							gi.dprintf("Pawn_o_matic matches chunk, loading stocks.\n");
							CPawn.IsSet |= 1;
							for (i = 0; i < 8; i++)
							{
								fread (&CPawn.Stocks[i], sizeof(char), 1, f);
							}
						}
						else	// Prices
						{
							int i;
							gi.dprintf("Pawn_o_matic matches chunk, loading prices.\n");
							CPawn.IsSet |= 2;
							for (i = 0; i < 64; i++)
							{
								fread (&CPawn.Prices[i], sizeof(short), 1, f);	// reading 8x8 items
							}
						}
					}
				}
				else	// We're not in pawn-o-matic mode, read 8+1 or 128+1 bytes
				{
					if (TBLId == 3) { fseek (f, 9, SEEK_CUR); } else { fseek(f, 129, SEEK_CUR); }	// Skip 9 bits for stocks, 129 bits for prices (8slots x 8items x 2bytes)
				}
			}
			else if (TBLId == 16)	// META STUFF (strings of chars, copyright notes or whatever)
			{
				unsigned short 	MtLength;
				char			MtString[1025];	// We allow 1024 chars at most, but terminate the stuff later
				fread (&MtLength, sizeof(short), 1, f);
				fread (MtString, 1, MtLength, f);
				MtString[MtLength] = 0; // Force end line
				if (spmod_debug->value) { gi.dprintf("\"%s\" (%i bytes)\n", MtString, MtLength); }
			}
			else
			{
				gi.dprintf("ChunkID %i unknown!\n", TBLId);
				fclose(f);
				return;
			}
		}
	}
	fclose(f);
	if (player->client->pers.episode_flags == 0) { EP_Flash_Newflag (player, 0); } // new episode, let's display the road book icon
}

/*********************************************************************
		FUNC_SPRAY
		Creates a gaz pipe or something similar, spray when shot.

		"health"			Damages the shell can take before bursting
		"delay"				Spray duration
		"wait"				Extra random duration
		"target"			What entity do we trigger when shot
		"targetname"		This entity's name
		"killtarget"		What entity do we kill when shot

		Spawnflags:
		1		Start off
		2		Once only
		4		Spawn flames
		8		Spawn smoke
		16		Spawn sparks
		32		Spawn water
		64		Animated
		128		Animated (fast)
		256		Not in easy
		512		Not in normal
		1024	Not in hard
		2048	Not in deathmatch
		4096	Not in coop
		8192	Surf2_Alpha
		
*********************************************************************/

#define	SPRAY_FLAG_STARTOFF			0x00000001	// Start off
#define	SPRAY_FLAG_ONCEONLY			0x00000002	// Die only once
#define	SPRAY_FLAG_FLAMES			0x00000004	// Spawn flames
#define	SPRAY_FLAG_SMOKE			0x00000008	// Spawn smoke
#define	SPRAY_FLAG_SPARKS			0x00000010	// Spawn sparks
#define	SPRAY_FLAG_WATER			0x00000020	// Spawn water
#define	SPRAY_FLAG_ANIMALL			0x00000040	// Anim all (does this thing even work?)
#define	SPRAY_FLAG_ANIMFAST			0x00000080	// Anim fast (does this thing even work?)
//#define SPAWNFLAG_NOT_EASY		0x00000100	// common, defined in g_local.h
//#define SPAWNFLAG_NOT_MEDIUM		0x00000200	// common, defined in g_local.h
//#define SPAWNFLAG_NOT_HARD		0x00000400	// common, defined in g_local.h
//#define SPAWNFLAG_NOT_DEATHMATCH	0x00000800	// common, defined in g_local.h
//#define SPAWNFLAG_NOT_COOP		0x00001000	// common, defined in g_local.h
#define	SPRAY_FLAG_SURFALPHA		0x00002000	// Surface is alpha


void fire_target_flamethrower (edict_t *self, vec3_t start, vec3_t forward, int damage, int kick, int mod);

void func_spray_sparksidle (edict_t *self)
{
	if (level.time > self->wait) { G_FreeEdict(self); return; }
	self->nextthink = level.time + 0.1;
	gi.WriteByte		(svc_temp_entity);
	gi.WriteByte		(TE_EXPLOSION1C);
	gi.WritePosition	(self->s.origin);
	gi.WriteDir			(self->s.angles);
	gi.WriteByte		(1);	// count
	gi.WriteByte		(2);	// fxdensity (lifetime)
	gi.multicast		(self->s.origin, MULTICAST_PVS);
}

void func_spray_wateridle (edict_t *self)
{
	gi.WriteByte		(svc_temp_entity);
	gi.WriteByte		(TE_RAIN);
	gi.WritePosition	(self->s.origin);
	gi.WriteShort		(20);
	gi.WriteShort		(2);
	gi.WriteShort		(2);
	gi.WriteShort		(2);	
	gi.WriteShort		(1);
	gi.multicast		(self->s.origin, MULTICAST_ALL_R);	
	G_FreeEdict(self);	// yeah, kill now because the rain effect NEVER WEARS OUT (engine limitation, can't do shit about it)
}

void func_spray_smokeidle (edict_t *self)
{
	if (level.time > self->wait) { G_FreeEdict(self); return; }
	self->nextthink = level.time + 0.5;
	gi.WriteByte		(svc_temp_entity);
	gi.WriteByte		(TE_SFXSMOKE);
	gi.WritePosition	(self->s.origin);
	gi.WriteByte		(self->fxdensity);
	gi.WriteByte		(self->alphalevel);
	gi.multicast		(self->s.origin, MULTICAST_PVS);
}

void func_spray_flameidle (edict_t *self)
{
	vec3_t		forward;
	//vec3_t		cpyorg;

	if (level.time > self->wait) { G_FreeEdict(self); return; }
	AngleVectors (self->s.angles, forward, NULL, NULL);

	//VectorCopy(self->s.origin, cpyorg);
	fire_target_flamethrower(self, self->s.origin, forward, 4, 0, MOD_FLAMETHROWER);
	//fire_flamethrower(self, cpyorg, forward, 2, 0, MOD_FLAMETHROWER);	// For whatever reason, I get a crash whenever someone catches fire

	self->s.renderfx2 = RF2_FLAMESHOOTER;
	self->s.renderfx2 |= RF2_FLAMESHOOTER_MOD;
	self->healspeed++;
	if (self->healspeed > 2) { self->healspeed = 0; }
	if (self->healspeed == 0)
		gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame2.wav"), 1, ATTN_NORM, 0);
	else if (self->healspeed == 1)
		gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame3.wav"), 1, ATTN_NORM, 0);
	else
		gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame1.wav"), 1, ATTN_NORM, 0);
	self->think = func_spray_flameidle;
	self->nextthink = level.time + FRAMETIME;
	// let's add some light effect
	gi.WriteByte	(svc_muzzleflash2);
	gi.WriteShort	(self - g_edicts);
	gi.WriteByte	(MZ2_GUNNER_MACHINEGUN_1);
	gi.multicast	(self->s.origin, MULTICAST_PVS);
}

void func_spray_die ( edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject )
{
	/* The method I use to calculate the surface we've hit is pretty bad: we're tracing a line
	from the attacker's origin to the hurt spray entity. If the bullet travels in an unexpected
	direction (aka non-centered), this method will confuse the hurt entity with the closest to
	the predicted shot, therefor getting the wrong surface.	*/
	vec3_t		forward, start;
	vec3_t		aimdir, dang, end, dir;
	trace_t		tr;

	self->health = self->max_health;
	if (ACC_UsesBullets(inflictor) == true)
		{
		if ((self->count > 0) && (self->spawnflags & SPRAY_FLAG_ONCEONLY))
			return;
		else if (!self->count)
			{
			G_UseTargets (self, inflictor);
			self->count = 1;
			}
		VectorSubtract (point, inflictor->s.origin, aimdir);
		vectoangles (aimdir, dang);
		AngleVectors (dang, forward, NULL, NULL);	
		VectorMA (inflictor->s.origin, 2, forward, start);
		VectorMA (start, MAXVIEWDIST, forward, end);
		tr = gi.trace( inflictor->s.origin, NULL, NULL, end, inflictor, MASK_ALL );
		vectoangles(tr.plane.normal, dir);	

		if (self->spawnflags & SPRAY_FLAG_FLAMES)
			{
			edict_t		*flame;
			flame = G_Spawn();
			flame->delay = self->delay;
			flame->wait = level.time + flame->delay + (random()*self->wait);
			VectorCopy (point, flame->s.origin);
			VectorCopy (dir, flame->s.angles);
			flame->s.modelindex = gi.modelindex("models/weapons/sshell_md2/tris.md2");
			flame->s.renderfx |= RF_BEAM;
			flame->think = func_spray_flameidle;
			flame->nextthink = level.time + FRAMETIME;
			gi.linkentity (flame);
			}
		if (self->spawnflags & SPRAY_FLAG_SMOKE)
			{
			edict_t		*smoke;
			smoke = G_Spawn();
			VectorCopy(point, smoke->s.origin);
			smoke->firetype = 30;
			VectorSet (smoke->movedir, 0.0, 1+(random()*2), 0.0);
			smoke->fxdensity = floor(random()*20)+20;
			smoke->alphalevel = floor(random()*10);
			smoke->wait = level.time + self->delay + (random()*self->wait);
			smoke->think = func_spray_smokeidle;
			smoke->nextthink = level.time + FRAMETIME;
			gi.linkentity (smoke);
			}
		if (self->spawnflags & SPRAY_FLAG_SPARKS)
			{
			edict_t		*sparks;
			sparks = G_Spawn();
			sparks->delay = self->delay;
			sparks->wait = level.time + sparks->delay + (random()*self->wait);
			VectorCopy(point, sparks->s.origin);
			VectorCopy(dir, sparks->s.angles);
			sparks->think = func_spray_sparksidle;
			sparks->nextthink = level.time + FRAMETIME;
			gi.linkentity (sparks);
			}
		if (self->spawnflags & SPRAY_FLAG_WATER)
			{
			edict_t		*leak;
			leak = G_Spawn();
			leak->delay = self->delay;
			leak->wait = level.time + leak->delay + (random()*self->wait);
			VectorCopy(point, leak->s.origin);
			VectorCopy(dir, leak->s.angles);
			leak->think = func_spray_wateridle;
			leak->nextthink = level.time + FRAMETIME;
			gi.linkentity (leak);
			}
		}
}

void func_spray_use (edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->style)
		{
		if (spmod_debug->value) { gi.dprintf("%s (%s) turned on\n", self->classname, self->targetname); }
		self->die = func_spray_die;
		self->takedamage = DAMAGE_YES;
		self->style = 0;
		}
	else
		{
		if (spmod_debug->value) { gi.dprintf("%s (%s) turned off\n", self->classname, self->targetname); }
		self->die = NULL;
		self->takedamage = DAMAGE_NO;
		self->style = 1;
		}
}

void SP_func_spray ( edict_t *self )
{
	self->movetype = MOVETYPE_PUSH;
	self->solid = SOLID_BSP;
	gi.setmodel (self, self->model);

	self->max_health = self->health;
	self->count = 0;

	if (self->spawnflags & SPRAY_FLAG_ANIMALL)
		self->s.effects |= EF_ANIM_ALL;
	if (self->spawnflags & SPRAY_FLAG_ANIMFAST)
		self->s.effects |= EF_ANIM_ALLFAST;
	if (self->spawnflags & SPRAY_FLAG_SURFALPHA)
		self->s.renderfx2 |= RF2_SURF_ALPHA;
	if (!self->health)
		self->health = 25;
	if (!self->delay)
		self->delay = 3.2;
	if (!self->wait)
		self->wait	= 1;
	if (self->targetname)
		self->use = func_spray_use;
	if (self->spawnflags & SPRAY_FLAG_STARTOFF)
		self->style = 0;
	else
		self->style = 1;

	gi.setmodel (self, self->model);
	func_spray_use (self, NULL, NULL);
	gi.linkentity (self);
}


/*********************************************************************
		MODELS -- Aug, 4th 2010

		New point entity: "misc_model" -- display a model (animated
		or not), and can be displayed or hidden when triggered. Put a
		"clip" brush around the model if you want it to be solid.

		"model"			Model to display
		"targetname"	This entity name
		"pawn_index1"	First frame
		"pawn_index2"	Last frame
		Spawnflags:		1	start off (targetname must be set!)
						2	important! (always display)
						4	non-looped animation
						8	glow
						16	no shadow
						32	dir_light
						64  fullbright (?)
						128 alpha2

*********************************************************************/

#define	MODEL_FLAG_STARTOFF				0x00000001	// Start off
#define	MODEL_FLAG_IMPORTANT			0x00000002	// Important
#define	MODEL_FLAG_NOLOOP				0x00000004	// Non-looped animation
#define	MODEL_FLAG_GLOW					0x00000008	// Glow
#define	MODEL_FLAG_NOSHADOW				0x00000010	// No Shadow
#define	MODEL_FLAG_DIRLIGHT				0x00000020	// Directional Light
#define	MODEL_FLAG_FULLBRIGHT			0x00000040	// Fullbright
#define	MODEL_FLAG_SURFALPHA2			0x00000080	// Alpha2
//#define MODEL_FLAG_NOT_EASY			0x00000100	// common, defined in g_local.h
//#define MODEL_FLAG_NOT_MEDIUM			0x00000200	// common, defined in g_local.h
//#define MODEL_FLAG_NOT_HARD			0x00000400	// common, defined in g_local.h
//#define MODEL_FLAG_NOT_DEATHMATCH		0x00000800	// common, defined in g_local.h
//#define MODEL_FLAG_NOT_COOP			0x00001000	// common, defined in g_local.h


void Anim_Misc_Model (edict_t *self)
{
	if (self->s.frame < self->pawn_index2)
		self->s.frame++;
	else
		if (!(self->spawnflags & MODEL_FLAG_NOLOOP)) { self->s.frame = self->pawn_index1; }
	self->nextthink = level.time + FRAMETIME;
}

void misc_model_setmodel (edict_t *self)
{
	int i;
	// First, do we use "md2" or "mdx" file format?
	if (strcmp(self->model, ".md2"))
	{
		gi.setmodel (self, self->model);
		self->s.frame = self->pawn_index1;	// reset animation when re-appearing
	}
	else if (strcmp(self->model, ".mdx"))
	{
		self->s.skinnum = self->skin;
		memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		self->s.num_parts++;
		self->s.model_parts[0].modelindex = gi.modelindex(self->model);
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[0].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds(self->model, &self->s.model_parts[0]);	
	}
}

void Use_Misc_Model (edict_t *self, edict_t *other, edict_t *activator)
{
	self->count = abs(self->count-1);
	if (self->count)	// Count == 1, show model
	{
		misc_model_setmodel (self);
	}
	else	// Count == 0, hide model
	{
		self->s.frame = 0;
		gi.setmodel (self, "");
	}
}

void SP_misc_model (edict_t *self)
{
	if (deathmatch->value)	// deathmatch? remove
	{
		G_FreeEdict (self);
		return;
	}

	if (!self->model)	// no model set? remove
		{
		gi.dprintf( "Warning: %s without model at %s\n", self->classname, vtos(self->s.origin) );
		G_FreeEdict (self);
		return;
		}

	if (self->spawnflags & MODEL_FLAG_STARTOFF)	// Start off?
	{
		self->count = 0;
		if (!self->targetname)	// Start off, but cannot be triggered, remove
		{
			gi.dprintf( "Warning: %s is off, without targetname at %s\n", self->classname, vtos(self->s.origin) );
			G_FreeEdict (self);
			return;
		}
	}
	else	// Start on
	{
		misc_model_setmodel (self);
		self->count = 1;
	}

	if (self->targetname)	// Can be triggered
		self->use = Use_Misc_Model;

	if ((self->pawn_index2 - self->pawn_index1) > 0)	// pawn_index1 < pawn_index2 AND pawn_index2 != 0 -- So we should animate this stuff.
	{
		self->nextthink = level.time + FRAMETIME *2;
		self->think = Anim_Misc_Model;
	}

	if (self->pawn_index1)	// Set default frame
		self->s.frame = self->pawn_index1;

	if (!(self->spawnflags & MODEL_FLAG_IMPORTANT))
		self->svflags |= SVF_PROP;
	if (self->spawnflags & MODEL_FLAG_GLOW)
		self->s.renderfx = RF_GLOW;
	if (self->spawnflags & MODEL_FLAG_NOSHADOW)
		self->s.renderfx2 |= RF2_NOSHADOW;
	if (self->spawnflags & MODEL_FLAG_DIRLIGHT)
		self->s.renderfx2 |= RF2_DIR_LIGHTS;	// I'm not sure what this stuff is for anymore -- I'm confused (maybe only works with MDX?)
	if (self->spawnflags & MODEL_FLAG_FULLBRIGHT)
		self->s.renderfx |= RF_FULLBRIGHT;		//self->flags |= RF_FULLBRIGHT;
	if (self->spawnflags & MODEL_FLAG_SURFALPHA2)
		self->s.renderfx2 |= RF2_SURF_ALPHA;

	if (self->pawn_index3 != 0)						// we use a transparency level, let's set fx flags
	{
		self->s.renderfx2 |= RF2_PASSALPHA;
		self->s.effects = 255 - self->pawn_index3;  // reverse values so 0 == visible and 255 == hidden
	}

	if (!self->cast_info.scale)
		self->cast_info.scale = 1.0;

	self->s.scale = self->cast_info.scale - 1.0;

	self->solid = SOLID_NOT;
	self->movetype = MOVETYPE_NONE;
	gi.linkentity (self);
}



/*********************************************************************
		SAVEGAME - 18th may 2011

		New point entity: "target_savegame" -- will save current game
		when triggered, can be disabled using "sv_noautosave"
	
		SPAWNFLAGS:
		1	Multiple use (can be triggered several times)

		"message"		Savegame name (default: quick)
		"targetname"	This entity's ID
**********************************************************************/
#define	SAVEGAME_FLAG_MULTIUSE		0x00000001
void use_target_savegame (edict_t *self, edict_t *other, edict_t *activator)
{
	if ((sv_noautosave->value) || (self->count))	// NoAutoSave CVAR is on AND/OR Triggered once already
		return;

	if (!(self->spawnflags & SAVEGAME_FLAG_MULTIUSE)) { self->count = 1; }
	gi.AddCommandString(va("echo Saving...\nwait\nsave %s\n", self->message));
}

void SP_target_savegame ( edict_t *ent )
{
	if (deathmatch->value)
	{
		G_FreeEdict(ent);
		return;
	}
	if (Wherever_Valid() == false)
		{
		gi.dprintf ("%s cannot be used in episode %i!\n", ent->classname, level.episode);
		G_FreeEdict(ent);
		return; 
		}
	if (!ent->message)
		ent->message="quick";
	ent->use = use_target_savegame;
	ent->count = 0;
	gi.linkentity (ent);
}


/*********************************************************************
		TRIGGER_SWITCHAREA - 20th may 2011

		New brush entity: "trigger_switcharea" -- when the player
		enter or exit a marked area, an entity can be triggered and/or
		an episode flag can be toggled.
	
		SPAWNFLAGS:
		1	Start IN (player starts inside the area)
		2	Do not trigger when going in
		4	Do not trigger when going out
		8	Master

		"name"			EPFlag name
		"target"		Entity to trigger
		"targetname"	The area's name
*********************************************************************/

#define	AREA_FLAG_STARTIN		0x00000001	// Player starts inside the area
#define	AREA_FLAG_NOIN			0x00000002	// Do not trigger when going in
#define	AREA_FLAG_NOOUT			0x00000004	// Do not trigger when going out
#define	AREA_FLAG_MASTER		0x00000008	// Master

void G_LinkAreaMarkers (edict_t *self)
{
	edict_t		*parentent;
	
	if (self->targetname)
		{
		parentent = NULL;
		while ((parentent = G_Find (parentent, FOFS(targetname), self->targetname)))
			{
			if (parentent != self)
				{
				if (parentent->count != self->count)
					{
					parentent->count = self->count;	
					if (spmod_debug->value) { gi.dprintf("Set %s to %i\n", parentent->targetname, parentent->count); }
					}
				}
			}
		}
}

void trigger_switcharea_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	vec3_t	vec;
	int			i;
	byte		AllowAct=0;
	edict_t		*player;
	
	player = &g_edicts[1];
	
	if (!(other->client))
		return;
	
	VectorSubtract( other->s.origin, self->pos1, vec );	// Are we going into or out of the area?
	vec[2] = 0;
	VectorNormalize( vec );
	
	if (DotProduct( vec, self->movedir ) > 0)	// Going into
	{
		if (self->count == 0)
			{
			if (spmod_debug->value) { gi.dprintf("%s: going in!\n", self->classname); }
			self->count = 1;
			G_LinkAreaMarkers (self);	// Link all other area markers
			if (!(self->spawnflags & AREA_FLAG_NOIN))
				AllowAct = 1;
			else
				if (spmod_debug->value) { gi.dprintf("Going in with NO_IN flag\n"); }
			}
	}
	else	// Going out of
	{
		if (self->count == 1)
			{
			if (spmod_debug->value) { gi.dprintf("%s: going out!\n", self->classname); }
			self->count = 0;
			G_LinkAreaMarkers (self);	// Link all other area markers
			if (!(self->spawnflags & AREA_FLAG_NOOUT))
				AllowAct = 1;
			else
				if (spmod_debug->value) { gi.dprintf("Going out with NO_OUT flag\n"); }
			}		
	}

	if (AllowAct == 1)
		{
		if (self->name)
			{
			for (i=0; i<=33; i++)		// Browse ALL flags
				{
				if (i == 33)
					{ gi.dprintf("%s: Flag %s undefined\n", self->classname, self->name); break; }
				else
					{
					if ((wherever_flags[i].flagval) && (!strcmp(wherever_flags[i].flagname,self->name)))	// Flag is not NULL and it's name match self->message
						{
						if (spmod_debug->value) { gi.dprintf("EPFlags: %i to ", player->episode_flags); }
						player->episode_flags = player->client->pers.episode_flags ^= wherever_flags[i].flagval;// -- episode_flags represent all the flags sets for the episode (toggle)
						if (spmod_debug->value) { gi.dprintf("%i\n", player->episode_flags); }
						break;
						}
					}
				}
			}
		if (self->target)
			G_UseTargets (self, other);
		}
}

void SP_trigger_switcharea ( edict_t *ent )
{
	if (deathmatch->value)
		{
		G_FreeEdict(ent);
		return;
		}
	if (Wherever_Valid() == false)
		{
		gi.dprintf ("%s cannot be used in episode %i!\n", ent->classname, level.episode);
		G_FreeEdict(ent);
		return; 
		}
	ent->solid = SOLID_TRIGGER;
	ent->touch = trigger_switcharea_touch;
	ent->svflags |= SVF_NOCLIENT;
	
	if ((!ent->target) && (!ent->name))
		gi.dprintf("%s without target nor episode flag at %s!\n", ent->classname, vtos(ent->s.origin));	// A trigger without target
	if ((ent->spawnflags & AREA_FLAG_NOIN) && (ent->spawnflags & AREA_FLAG_NOOUT))
		gi.dprintf("%s is useless at %s!\n", ent->classname, vtos(ent->s.origin));						// A trigger unable to do anything

	ent->count = (int)(ent->spawnflags & AREA_FLAG_STARTIN);	// Set default position to "in area" (1) or "out of area" (0)
	if (ent->spawnflags & AREA_FLAG_MASTER)
	{
		if (!(ent->targetname))
			gi.dprintf("%s at %s set as MASTER, but has no targetname!\n", ent->classname, vtos(ent->s.origin));
		else
			{
			ent->think = G_LinkAreaMarkers;			// Make sure all other area markers are set like this one
			ent->nextthink = level.time + 0.1;		// Wait a bit beofre linking all markers
			}
	}
	
 	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);
	
	VectorAdd( ent->absmin, ent->absmax, ent->pos1 );
	VectorScale( ent->pos1, 0.5, ent->pos1 );
	AngleVectors( ent->s.angles, ent->movedir, NULL, NULL );
}



/*********************************************************************
		TARGET_NOWEAPON - 20th may 2011

		When triggered, toggle level.bar_lvl mode (disable or enable
		the use of weapon for the player)

		"targetname"	This entity's ID
*********************************************************************/

void use_target_noweapon_done (edict_t *self)
{
	level.bar_lvl = 1;
	self->nextthink=0;
}

void use_target_noweapon (edict_t *self, edict_t *other, edict_t *activator)
{
	edict_t		*player;
	player = &g_edicts[1];
	
	// When level.bar_lvl is 1, the weapon suddently dissapear. For this reason, we had to allow extra time for the weapon to be holstered before we
	// switch to level.bar_lvl = 1. Unfortunately, if the player is able to trigger this entity again BEFORE the delay is over, we invert the bar areas.
	// So: if we're still "thinking" about going level.bar_lvl=1, let's do it RIGHT NOW.
	if (self->nextthink)
		{ level.bar_lvl = 1; self->nextthink = 0; }

	if (level.bar_lvl)	// Always draw gun (going out of bar)
		{
		level.bar_lvl = 0;
		player->client->newweapon = player->client->pers.holsteredweapon;
		ChangeWeapon (player);
		player->client->pers.holsteredweapon = 0;
		}
	else	// Hide gun if there's one (going into bar)
		{
		if (!player->client->pers.holsteredweapon)
			{
			if (player->client->pers.weapon)
				{
				player->client->pers.holsteredweapon = player->client->pers.weapon;
				player->client->newweapon = NULL;
				player->client->weaponstate = WEAPON_DROPPING;
				if (player->s.renderfx2 & RF2_FLAMETHROWER)
					player->s.renderfx2 &= ~RF2_FLAMETHROWER;
				}
			}
			self->nextthink = level.time + 0.3;	// We must wait a bit before switching to bar mode, or the weapon will suddently dissapear (see THINK trick above)
			self->think=use_target_noweapon_done;
		}
}

void SP_target_noweapon ( edict_t *ent )
{
	if (deathmatch->value)
	{
		G_FreeEdict(ent);
		return;
	}
	ent->use = use_target_noweapon;
	gi.linkentity (ent);
}



/*********************************************************************
		SUPER KEY -- January, 24th 2011

		New point entity: "trigger_superkey" -- will trigger all of
		its targeted entities if ITEM or FLAG is SET (or not).

		"style"			0=item, 1=episode flag
		"name"			item as displayed in inventory or flag name
		"target"		targets to trigger
		"targetname"	this name entity (yep, must be triggered)
		Spawnflags:		1	present/registered
						2	once_only

*********************************************************************/

#define	SUPERKEY_FLAG_REGISTERED		0x00000001
#define	SUPERKEY_FLAG_ONCEONLY			0x00000002

void use_trigger_superkey (edict_t *self, edict_t *other, edict_t *activator)
{
	gitem_t		*item;
	edict_t		*player;
	int			index, i, meetcondition;
	
	player = &g_edicts[1];

	if (self->count)	// this one has been triggered once already
		return;

	if (self->style == 0)	// search for an item
	{
		item = FindItem (self->name);
		index = ITEM_INDEX (item);
		if (player->client->pers.inventory[ index ])
			meetcondition = abs(0 - (self->spawnflags & SUPERKEY_FLAG_REGISTERED));	// will be 1 if mustbeset=1, will be 0 if mustbeset = 0
		else
			meetcondition = abs(1 - (self->spawnflags & SUPERKEY_FLAG_REGISTERED));	// will be 1 if mustbeset=0, will be 0 if mustbeset = 1
	}
	else if (self->style == 1) // search for a registered episode flag
	{
		for (i=0; i<=33; i++)		// Browse ALL flags
		{
			if (i == 33)			// Error!, We need this check
				{	gi.dprintf("%s: Flag %s undefined!\n", self->classname, self->name); break;	}
			else
				{
				if ((wherever_flags[i].flagval) && (!strcmp(wherever_flags[i].flagname,self->name)))	// Flag is not NULL and it's name match self->name
					{
					if (player->episode_flags & wherever_flags[i].flagval)	// okay, item is present
						meetcondition = abs(0 - (self->spawnflags & SUPERKEY_FLAG_REGISTERED));	// will be 1 if mustbeset=1, will be 0 if mustbeset = 0
					else													// right, item is NOT present
						meetcondition = abs(1 - (self->spawnflags & SUPERKEY_FLAG_REGISTERED));	// will be 0 if mustbeset=1, will be 1 if mustbeset = 0
					break;
					}
				}
			}
		}
	if (meetcondition == 1)
	{
		G_UseTargets (self, activator);
		if (self->spawnflags & SUPERKEY_FLAG_ONCEONLY) {	self->count = 1; }
	}
}

void SP_trigger_superkey ( edict_t *ent )
{
	if (deathmatch->value)
	{
		G_FreeEdict(ent);
		return;
	}
	if (Wherever_Valid() == false)
		{
		gi.dprintf ("%s cannot be used in episode %i!\n", ent->classname, level.episode);
		G_FreeEdict(ent);
		return; 
		}
	if (!ent->name)
		{
		gi.dprintf ("%s without episode flag name or item name at %s!\n", ent->classname, vtos(ent->s.origin));
		G_FreeEdict(ent);
		return;
		}
	ent->use = use_trigger_superkey;
	ent->count = 0;
	gi.linkentity (ent);
}
