#include "g_local.h"

void Ar_setcurrentweapon(gclient_t *client);
void Ar_Initialise( void );
void Ar_LoadMOTD( void );
void Ar_incrementammo(gclient_t* client);
void Ar_CheckChangeWeapon( void );
void Ar_CheckSingleWeapon( edict_t *ent );
void Ar_ChangeClientWeapon( edict_t *ent, int Last_Weapon, int Current_Weapon );
static void Ar_set_ammo(gclient_t* cl, int count, int nWeap, qboolean ClearClip);

extern void AutoLoadWeapon( gclient_t *client, gitem_t *weapon, gitem_t *ammo );
extern int QweryClipIndex (gitem_t *item);

/**************************************************************************

	09/09/00	Started Arsenal conversion from SOF because someone had
				mentioned it in the Wireplay forum :)


**************************************************************************/

// Variables and defines go here.
#define	INI_FILE	"arsenal.ini"

int			allowBigHealth		= false; 	// Can players pickup large health items
int			allowSmallHealth	= false; 	// Can players pickup small health items
int			allowArmour			= false;	// Can players pickup armour
int			allowInvulnerable	= false;	// Can players be Invulnerable
int			observerAllowed     = true;		// Are players allowed to go into observer mode
int			cameraAllowed       = true;		// Are players allowed to go into camera mode
int			stdLogging			= false;
int			FragRange1			= 10;		// Number of kills required 4 weapon upgrade1
int			FragRange2			= 20;		// Number of kills required 4 weapon upgrade2
int			FragRange3			= 30;		// Number of kills required 4 weapon upgrade3
int			FragPointsKill		= 2;		// Points for killing someone using Fragpower
int			FragPointsKilled	= 4;		// Points for killing a Fragpower user
int			RequiredSpawns		= 10;		// Number of spawns required before new weapon


//
// Ini file options
//
typedef struct
{
	char	*ident;
	int		*variable;
	int		MinVariable;
	int		MaxVariable;
	int		DefaultVariable;
} INI_OPTION;

INI_OPTION	option[] = 

//	Normal Options

	{	{"bighealth",		&allowBigHealth,	0,1,1},
		{"smallhealth",		&allowSmallHealth,	0,1,1},
		{"armor",			&allowArmour,		0,1,1},
		{"invuln",			&allowInvulnerable,	0,1,1},
		{"stdlog",			&stdLogging,		0,1,1},	// Dont change ident name
		{"allowcamera",		&cameraAllowed,		0,1,1},
		{"allowobserver",	&observerAllowed,	0,1,1},
		{"powerup1",		&FragRange1,		6,10,10},
		{"powerup2",		&FragRange2,		16,10,20},
		{"powerup3",		&FragRange3,		26,30,30},
		{"points1",			&FragPointsKill,	2,4,2},
		{"points2",			&FragPointsKilled,	3,7,4},
		{"weapspawns",		&RequiredSpawns,	5,30,10}
	};

//*************************************************************************

typedef struct   // Message of the Day
	{
	char textline[100];
	} MOTD_t;

	MOTD_t	MOTD[20];

#define MAX_OPTIONS (sizeof(option)/sizeof(option[0]))
#define MOTD_lines		3

#define AR_ONESECOND	1.0
#define STARTING_WEAPON 7

#define ar_PISTOL_ROUNDS			10
#define ar_TOMMYGUN_ROUNDS			50
#define ar_SHOTGUN_ROUNDS			16
#define ar_BARMACHINEGUN_ROUNDS 	30
#define ar_GRENADELAUNCHER_ROUNDS	3
#define ar_ROCKETLAUNCHER_ROUNDS	10
#define	ar_FLAMEGUN_ROUNDS			80

//*************************************************************************
// Note that the current weapon index (1-10) always corresponds to the 
// standard weapons in order (blaster through bfg10k). This is still the case 
// even if the user bans certain weapons (e.g. the bfg) and/or specifies a 
// specific order in which case the NIQ-determined current weapon is converted
// to the standard weapon index 1-10.

typedef struct Arsenalitem_s
{
	char		*szName;                    // weapon name                    
    char		*szAmmo;                    // weapon ammo                    

    int         nAmmoInitial;               // amount of ammo on switch       
    int         nAmmoIncrement;             // amount of ammo given per second   
    int         nAmmoSecs;                  // secs to wait before adding ammo
    int         nAmmoMax;                   // max amount of ammo             

    int         nArIndexWeapon;				// itemlist index for weapon (set in Ar_Inititalise)
    int         nArIndexAmmo;				// itemlist index for ammo
} Arsenalitem_t;

Arsenalitem_t Arsenallist[9] = 
{
	{
		NULL
	},	// leave index 0 alone

	{//1
		"pistol",					// doesn't use any ammo!
        "bullets",                
        ar_PISTOL_ROUNDS,			// Initial ammo on weapon change
        2,							// Amount per seconds to give
        1,							// How many seconds before adding ammo
        200,						// Maximum amount of ammo full stop
        999,                     
        999
	},

	{//2
		"shotgun",              
        "shells",               
        ar_SHOTGUN_ROUNDS,
        1,
        1,
        100,
        999,
        999
	},

	{//5
		"Grenade Launcher",     
        "grenades",             
        ar_GRENADELAUNCHER_ROUNDS,                     
        1,                     
        2,
        12,
        999,                     
        999
	},

	{//7
		"FlameThrower",         
        "Gas",                
        ar_FLAMEGUN_ROUNDS,                     
        10,                     
        1,
        200,                    
        999,                     
        999
	},

	{//3
		"tommygun",           
        "bullets",              
        ar_TOMMYGUN_ROUNDS,                     
        5,                     
        1,
        200,
        999,                     
        999
	},

	{//6
		"Bazooka",      
        "rockets",              
        ar_ROCKETLAUNCHER_ROUNDS,                     
        2,                     
        2,
        25,                    
        999,                     
        999
	},

	{//4
		"Heavy machinegun",             
        "308cal",              
        ar_BARMACHINEGUN_ROUNDS,                     
        5,
        2,                     
        90,                    
        999,                     
        999
	},

	// end of list marker
	{NULL}
};


//*************************************************************************
// Ar_setcurrentweapon:
//
// Used to set the current weapon and ammo amount for new clients.

void Ar_setcurrentweapon(gclient_t *cl)
	{
    int			nCurWeaponIndex;
	int			nAmmoIndex;
	int			nAmmoInitial;
	gitem_t		*item, *ammo;

	if(!cl)
		return;

	if (cl->resp.NoWeaponReset == false)
		{
//		gi.dprintf ("Bollox!\n");
		cl->resp.Last_Weapon = game.Ar_StartingWeapon;
		cl->resp.Current_Weapon = game.Ar_StartingWeapon;
		cl->resp.NoWeaponReset = true;
		}

	//gi.dprintf ("Current weapon = %i\n",cl->resp.Current_Weapon);

	if (cl->resp.Current_Weapon < 1 || cl->resp.Current_Weapon > 7)
		cl->resp.Current_Weapon = 1;

	nAmmoIndex       = Arsenallist[cl->resp.Current_Weapon].nArIndexAmmo;
    nCurWeaponIndex	 = Arsenallist[cl->resp.Current_Weapon].nArIndexWeapon;

	// not in intermission and/or in deathmatch allocate default ammo
	nAmmoInitial = Arsenallist[cl->resp.Current_Weapon].nAmmoInitial;

	// Set the initial ammo for this weapon
	Ar_set_ammo(cl, nAmmoInitial, cl->resp.Current_Weapon, true);

	// allocate new weapon (in case not already done)
	cl->pers.inventory[nCurWeaponIndex] = 1;
	cl->newweapon                       = &itemlist[nCurWeaponIndex];
	cl->pers.weapon                     = &itemlist[nCurWeaponIndex];
    cl->pers.selected_item              = nCurWeaponIndex;
	cl->ammo_index						= nAmmoIndex;

	// Load the weapon with the correct ammo.
	item = FindItem(Arsenallist[cl->resp.Current_Weapon].szName);
	ammo = FindItem (item->ammo);

	AutoLoadWeapon( cl, item, ammo );

	}

/////////////////////////////////////////////////////////////////////////////
// Ar_set_ammo:
//
static void Ar_set_ammo(gclient_t* cl, int count, int nWeap, qboolean ClearClip)
	{
	gitem_t		*weapon;
	int			clip_index;

	if (!cl) 
		return; 

	// If the clearclip flag is set then we want to make sure the ammo added doesn't
	// include whats in the clip from the last time we had this weapon.
	if (ClearClip)
		{
		weapon = FindItem(Arsenallist[nWeap].szName);
		clip_index = QweryClipIndex( weapon );
		cl->pers.weapon_clip[clip_index] = 0;
		}

    cl->pers.inventory[Arsenallist[nWeap].nArIndexAmmo] = count;

	}

/////////////////////////////////////////////////////////////////////////////
// Ar_add_ammo:
//
static void Ar_add_ammo(gclient_t* cl, int count, int nWeap)
	{

	if (!cl) 
		return; 

	count += cl->pers.inventory[Arsenallist[nWeap].nArIndexAmmo];

	if (count > Arsenallist[nWeap].nAmmoMax)
		count = Arsenallist[nWeap].nAmmoMax;

    cl->pers.inventory[Arsenallist[nWeap].nArIndexAmmo] = count;

	}

/////////////////////////////////////////////////////////////////////////////
//
//	check to see if we need to add some ammo.

void Ar_Check_Timers(edict_t* ent)
	{
	gclient_t* client;

  	if (!ent->inuse)
    	return;

    // don't do anything after client dies
	if (ent->health < 1)
        return;

	client = ent->client;
	if (!client)
		return;

	if (client->Ar_sectimer < level.time)
		{
	    // increment ammo unless infinite ammo is enabled
		if ( !((int)dmflags->value & DF_INFINITE_AMMO) )
	   		Ar_incrementammo(client);

		// reset timer
		client->Ar_sectimer = level.time + AR_ONESECOND;
		}
	}

//////////////////////////////////////////////////////////////////////////
//
// Set the weapon Timer for 1 second and clear the second counter.
//

void Ar_Set_Timers(gclient_t* client)
	{
    if(!client)
        return;

	client->Ar_sectimer		= level.time + AR_ONESECOND;
	client->Ar_ammotics		= 0;                               
	client->Ar_timescaletimer = level.time + (AR_ONESECOND * 15);

	}

/////////////////////////////////////////////////////////////////////////////
// Hm_incrementammo:
//
// Each client maitains its own ammo timer?

void Ar_incrementammo(gclient_t* client)
	{
	int nAmmoIncrease, nAmmoIndex;

    client->Ar_ammotics++;

    if (client->Ar_ammotics >= Arsenallist[client->resp.Current_Weapon].nAmmoSecs) 
        {
        client->Ar_ammotics = 0;

		nAmmoIncrease   = Arsenallist[client->resp.Current_Weapon].nAmmoIncrement;
       	nAmmoIndex      = Arsenallist[client->resp.Current_Weapon].nArIndexAmmo;

       	if(nAmmoIncrease <= 0)
        	return;							

       	if(nAmmoIndex <= 0)
   	    	return;							

		// goose up ammo (niq_add_ammo enforces limits)
		Ar_add_ammo(client, nAmmoIncrease, client->resp.Current_Weapon);
        }
	}

//***********************************************************************
//	Check to see if this player is a cheating bastard and it they are
//	then let everyone know.

void CheckForCheating(edict_t* ent)
	{
	if (!ent->client)
		return;		// not fully in game yet

  	if (!ent->inuse)
    	return;

	// After 15 seconds recheck cheat, this is so we don't overflow.
	if (ent->client->Ar_timescaletimer < level.time)
		{
		// Retrieve the timescale
		gi.WriteByte(13);
		gi.WriteString("clienttimescale $timescale\n");
		gi.unicast(ent,true);

		// Reset time to next check for cheating.
		ent->client->Ar_timescaletimer = level.time + (AR_ONESECOND * 15);
		}
	}


//***************************************************************************
//
//	Store the previous weapon so we know what to remove before giving the
//	player the next one. Then call the routine to do the swap.
//

void Ar_CheckChangeWeapon( void )
	{
   	edict_t	*ent;
    int		i;

	// get all current clients to change to new weapon
	for (i=1; i<=maxclients->value; i++)
        {
		ent = g_edicts + i;

    	if (!ent->inuse)
	    	continue;

		if ((teamplay->value) && (ent->client->pers.team == 0))
			continue;

		// have we got a new weapon to change to ?
		if (ent->client->resp.Last_Weapon != ent->client->resp.Current_Weapon)
			{
			Ar_ChangeClientWeapon( ent, ent->client->resp.Last_Weapon, ent->client->resp.Current_Weapon );
			ent->client->resp.Last_Weapon = ent->client->resp.Current_Weapon;
			}
    	}
	}


//***************************************************************************
//
//	After many problems I decided to try having a routine to swap a single players
//	weapon. I think the problem comes from using the code from Hitmen which swaps
//	everyones weapon at the same time.
//
void Ar_CheckSingleWeapon( edict_t *ent )
	{
	Ar_ChangeClientWeapon( ent, ent->client->resp.Last_Weapon, ent->client->resp.Current_Weapon );
	ent->client->resp.Last_Weapon = ent->client->resp.Current_Weapon;
	}

//***************************************************************************
//
//	This will do the actually swapping of the weapon by removing the current
//	one and allocating the next one.
//

void Ar_ChangeClientWeapon( edict_t *ent, int ArOldweapon, int ArNewweapon )
	{
	gclient_t	*client;
	gitem_t		*item, *ammo;
	int			nNewAmmoAmount;

	client = ent->client;
	if (!client)
		return;

    // is he dead?
	if (ent->health < 1)
       return;

	// Remove the old weapon.
    client->pers.inventory[Arsenallist[ArOldweapon].nArIndexWeapon] = 0;

	// Remove old ammo.
    //if((nOldAmmoIndex != 999) && (nOldAmmoIndex != nNewAmmoIndex))
//		Hm_set_ammo (ent->client, 0, HmOldweapon);
	
	// Add the new weapon to the inventory.
	client->pers.inventory[Arsenallist[ArNewweapon].nArIndexWeapon] = 1;

	// Make the new weapon the current one.
	client->pers.selected_item = Arsenallist[ArNewweapon].nArIndexWeapon;
	client->newweapon = &itemlist[Arsenallist[ArNewweapon].nArIndexWeapon];

    // allocate new ammo:
	nNewAmmoAmount = Arsenallist[ArNewweapon].nAmmoInitial;
   	Ar_set_ammo(ent->client, nNewAmmoAmount, ArNewweapon, true);

	// Set the index for this ammo type.
	ent->client->ammo_index = Arsenallist[ArNewweapon].nArIndexAmmo;

	// Load the weapon with the correct ammo.
	item = FindItem(Arsenallist[ArNewweapon].szName);
	ammo = FindItem (item->ammo);
	AutoLoadWeapon( client, item, ammo );

	ChangeWeapon(ent);

	gi.sound (ent, CHAN_AUTO, gi.soundindex ("misc/w_pkup.wav"), 1, ATTN_NORM, 0);
	}

/////////////////////////////////////////////////////////////////////////////
// Ar_Initialise
//
//	This will setup all of the weapons index's so we can do without the
//	constant use of FindItem, it also sets the ammo ones too.
// 

void Ar_Initialise( void )
	{
    int nWeap;

	// Load any extra text for the message of the day
	Ar_LoadMOTD();

	// load the ini file with the required settings
	//LoadHitmenWorldIni();

	// Check to see if the values we have are correct.
	//VerifyIniFileValues();

	// Setup the weapon indexs
	for(nWeap=1; nWeap<=7; nWeap++)
		{
		Arsenallist[nWeap].nArIndexWeapon = ITEM_INDEX(FindItem(Arsenallist[nWeap].szName));
		Arsenallist[nWeap].nArIndexAmmo   = ITEM_INDEX(FindItem(Arsenallist[nWeap].szAmmo));
		}

	// This will set the available weapons and how many
	//Ar_ProcessWeaponsList();

	// Clear the list of used weapons for getting the next available one
	//for ( i=0; i < 7; i++ )
	//	game.HmWeaponsAvailList[i].nAlreadyUsed = false;

	//game.Current_Weapon = nWeap;
	//game.Weapon_Index = 0;	// only used for sequential weapon access.

	//game.Weapon_Timer_Reset = HmWeaponTime;
	//game.Weapon_Timer = level.time + game.Weapon_Timer_Reset;

	game.Ar_StartingWeapon = STARTING_WEAPON;
	game.Ar_BonusFrags = BonusFrags->value;
	}

//*************************************************************************

void Ar_LoadMOTD( void )
	{

	FILE	*motd_file;
	char	line[80];
	int		i;

	// Open the motd file
	if (motd_file = fopen("arsenal/motd.txt", "r"))
		{
		i = 0;

		// Read the lines now
		while ( fgets(line, 80, motd_file) )
			{
			// Once we've read a line copy it to the MOTD array.
			strcpy(MOTD[i].textline, line);
			i++;

			// We don't want more than 3 lines so lets piss off.
			if (i>3)
				break;
			}

		// be good now ! ... close the file
		fclose(motd_file);
		}
	}


/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void LoadIniFile( void )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	int		IniOption = 0, Processed = 0;
	char	Buffer[256], filename[256];
	char	*VariableName = NULL, *VariableValue = NULL;
	static	qboolean	AlreadyRead = false;


	if (AlreadyRead)
		return;

	game_dir = gi.cvar ("game", "", 0);

    sprintf(filename, ".\\%s\\%s", game_dir->string, INI_FILE);

	// open the *.ini file

	if ((f = fopen (filename, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s. Using defaults.\n", INI_FILE);
		return;
		}

	gi.dprintf("\nProcessing %s.. \n", INI_FILE);

	// read 256 characters or until we get to the eof or a return for a newline.

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{

		
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// Get the variable name, skipping spaces, tabs, and newlines.

			VariableName	= strtok(Buffer, " \t\n");
			IniOption	= 0;

			// If we haven't processed the maximum number of options then keep going
			while (IniOption < MAX_OPTIONS)
				{

				// Find this option in the array of options, if we don't find it tough

				if (!strcmp(VariableName, option[IniOption].ident))
					{

					// Using NULL will continue the search for the value from where the previous
					// strtok for the variable name left off.
					VariableValue = strtok(NULL, " \t\n#");

					// If the variable name is stdlog then we want to set the flag to turn
					// logging on
					if (!strcmp(VariableName, "stdlog"))
						gi.cvar_set("stdlogfile", VariableValue);
					else
						// This will set the valu in the array using string value to integer conversion
						*option[IniOption].variable = atoi(VariableValue);

					Processed++;
					break;
					}

				IniOption++;
				}
			}
		}

	gi.dprintf("%d Options processed\n", Processed);
	fclose (f);
	AlreadyRead = true;	
	}

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void VerifyIniFileValues( void )
	{	
	int	Loop;

	for ( Loop=0; Loop<MAX_OPTIONS; Loop++ )
		{

		// If the value which has been set isn't in the normal range then
		// set it to a default value.

		if ((*option[Loop].variable < option[Loop].MinVariable) ||
			(*option[Loop].variable > option[Loop].MaxVariable))
			{
			*option[Loop].variable = option[Loop].DefaultVariable;
			}
		}
	}

/***********************************************************************
/*
/*	Function:	Displays a superb message of the day 
/*
/**********************************************************************/
void MOTDScoreboardMessage (edict_t *ent)
	{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	char	*seperator = "++++++++++++++++++++++++++++++++++";

	char	*selectheader[] =
			{
			"Atrophy Presents",
			"-<> Arsenal v1.1 <>-",
			"By Rat Instinct",
			"www.Atrophy.co.uk",
			NULL
			};

	string[0] = 0;
	stringlength = 0;

	yofs = 80 - MOTD_lines * 10;
	if (yofs < 0 )
		yofs = 0;

	for (i=0; selectheader[i]; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 752 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 30;

	for (i=0; i< MOTD_lines; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 842 \"%s\" ",
			-5*strlen(MOTD[i].textline), yofs + (int)(-60.0+-3.5*14), MOTD[i].textline );

		j = strlen(entry);
		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}

		yofs += 20;
		}

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}
