/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//  and is available over at The Scorpion Network, at http://www.und3rgr0und.com
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington
//  immediately, via The Scorpion Network Homepage http://www.und3rgr0und.com
//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"


void cash_kill( edict_t *self )
{
	num_cash_items--;
	G_FreeEdict( self );
}


void cashroll_animate( edict_t *self )
{
	// reduce XY velocity (air friction)
	self->velocity[0] *= 0.9;
	self->velocity[1] *= 0.9;

	if (level.time > (self->timestamp))
	{
		cash_kill( self );
		return;
	}

	if (self->movetype != MOVETYPE_NONE)
	{

		if (VectorDistance( self->s.origin, self->pos1 ) < 1)
			self->count++;
		else
			self->count = 0;

		VectorCopy( self->s.origin, self->pos1 );

		if (self->count > 2)	// rested for 2 frames
		{
			VectorClear( self->velocity );
			VectorClear( self->avelocity );
			self->s.angles[PITCH] = 0;
			self->s.angles[ROLL] = 0;

			self->movetype = MOVETYPE_NONE;
		}
	}

	self->nextthink = level.time + 0.1;
}



// Cash Spawning during BAGMAN
void cash_touch( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float speed;

	if (surf && plane && plane->normal[2] > 0.5)
	{	// let it rest here

		if ((speed = VectorLength( self->velocity )) > 10)
		{
			self->s.angles[ROLL]	= 0;
			self->s.angles[PITCH]	= 0;
			self->avelocity[PITCH]	= 0;
			self->avelocity[ROLL]	= 0;
			self->avelocity[YAW]	*= 0.5;

			// randomize bounce
			VectorAdd( self->velocity, tv( crandom()*speed*0.3, crandom()*speed*0.3, random()*speed*0.15 ), self->velocity );
		}
		else
		{
			VectorClear( self->velocity );
			VectorClear( self->avelocity );
			self->s.angles[PITCH] = 0;
			self->s.angles[ROLL] = 0;

			self->movetype = MOVETYPE_NONE;
		}

		return;
	}

	if (other->client)
	{
		if (other->client->pers.currentcash < MAX_CASH_PLAYER)
		{	// they can hold the cash

			if ((self->currentcash == CASH_BAG) || (self->movetype != MOVETYPE_NONE) || (other->client->ps.pmove.pm_flags & PMF_DUCKED))
			{	// they can pick it up

				Touch_Item( self, other, plane, surf );

				num_cash_items--;

				G_FreeEdict( self );
				return;
			}

		}
	}
}


void cashspawn_think( edict_t *self )
{
	edict_t	*cash;

	if ((num_cash_items > MAX_CASH_ITEMS) || (level.modeset == MATCHSETUP) || (level.modeset == FINALCOUNT) || (level.modeset == FREEFORALL))
	{
		self->nextthink = level.time + self->delay;
		return;
	}

	// spawn some money
	cash = G_Spawn();

	VectorCopy( self->s.origin, cash->s.origin );
	cash->movetype = MOVETYPE_BOUNCE;
	cash->solid = SOLID_TRIGGER;

	AngleVectors( self->s.angles, cash->velocity, NULL, NULL );
	VectorScale( cash->velocity, self->speed, cash->velocity );

	// randomize the velocity a bit
	VectorAdd( cash->velocity, tv( crandom()*self->speed*0.3, crandom()*self->speed*0.3, crandom()*self->speed*0.15 ), cash->velocity );

	cash->s.renderfx2 |= RF2_NOSHADOW;

	// FIXME: doh this doesn't work, need to spawn actual item's, so the HUD is updated automatically when picking up

	if (!strcmp(self->type, "cashroll"))
	{	// small dollar notes
		cash->s.modelindex = gi.modelindex( "models/pu_icon/cash/tris.md2" );
		cash->gravity = 0.1 + random()*0.5;

		cash->think = cashroll_animate;
		cash->nextthink = level.time + 0.1;
		cash->s.angles[PITCH] = 10;
		VectorSet( cash->avelocity, 0, 10000 * cash->gravity, 0 );

		VectorSet( cash->mins, -4, -4, -15 );
		VectorSet( cash->maxs,  4,  4, -13 );

		cash->item = FindItem("Cash");

		cash->currentcash = CASH_ROLL;
		cash->touch = cash_touch;

		cash->timestamp = level.time + 60;

		cash->think = cashroll_animate;
		cash->nextthink = level.time + 0.1;
	}
	else
	{
		cash->s.modelindex = gi.modelindex( "models/pu_icon/money/money_sm.md2" );
		cash->gravity = 1.0;

		VectorSet( cash->mins, -12, -12, -15 );
		VectorSet( cash->maxs,  12,  12,  10 );

		cash->item = FindItem("Small Cash Bag");

		cash->currentcash = CASH_BAG;
		cash->touch = cash_touch;

		cash->think = cash_kill;
		cash->nextthink = level.time + 60;
	}

	num_cash_items++;

	self->nextthink = level.time + self->delay;

}


/*QUAKED dm_cashspawn (0.5 0 1) (-16 -16 -16) (16 16 16)
Spawn location for cash during "Grab da Loot" games

  angle - direction to project cash upon spawning
  speed - speed of projection
  type	- "cashroll" or "cashbag" (more money, longer delay)
*/
void SP_dm_cashspawn( edict_t *self )
{

    self->classname = "dm_cashspawn";

    if (gamemode->value == 1)
    {

	// set the game to "Grab da Loot"
	teamplay_mode = TM_GRABDALOOT;

	num_cash_items = 0;

    if (!self->type)
    self->type = "cashbag";

	if (!strcmp(self->type, "cashroll"))
	{
		self->delay = (float)g_cashspawndelay->value;
	}
	else	// bag, so longer delay
	{
		self->delay = (float)g_cashspawndelay->value * (CASH_BAG / CASH_ROLL);
	}

	if (!self->speed)
		self->speed = 10;

	self->think = cashspawn_think;
	self->nextthink = level.time + self->delay;

   }
}



/*QUAKED dm_props_banner (.5 0 1) (-4 -4 -4) (4 4 4)
Temp banner for teamplay

 style = team (1 / 2)
 scale = scale the size up/down (2 = double size)

model="models\props\temp\triangle\small.md2"
*/
void SP_dm_props_banner (edict_t *self)
{

	if (!self->style)
	{
		gi.dprintf( "%s has invalid style (should be 1 or 2) at %s\n", self->classname, vtos(self->s.origin) );
		G_FreeEdict (self);
		return;
	}

#if 1
	{
		void think_flag (edict_t *self);

		self->movetype = MOVETYPE_NONE;

		if (self->style == 2)
		{
			self->model = "models/props/flag/flag1.md2";
		}
		else
		{
			self->model = "models/props/flag/flag3.md2";
		}

		self->s.modelindex = gi.modelindex (self->model);

		self->s.renderfx2 |= RF2_NOSHADOW;
		self->s.renderfx |= RF_MINLIGHT;

		if (!self->cast_info.scale)
			self->cast_info.scale = 1;

		self->s.scale = (self->cast_info.scale - 1);

		self->cast_info.scale *= 0.3;

		gi.linkentity (self);

		self->s.effects |= EF_ANIM_ALLFAST_NEW;
		self->s.renderfx2 |= RF2_MODULUS_FRAME;
		self->s.renderfx2 |= RDF_NOLERP;

	}

#else // TRIANGULAR ROTATING ICONS

	self->solid = SOLID_NOT;
	self->movetype = MOVETYPE_NONE;

	self->s.skinnum = self->style - 1;

	self->s.renderfx2 |= RF2_NOSHADOW;	
	self->s.renderfx |= RF_MINLIGHT;

	if (!self->cast_info.scale)
		self->cast_info.scale = 1;

	self->s.scale = self->cast_info.scale - 1;

	self->s.modelindex = gi.modelindex ("models/props/temp/triangle/small.md2");

	gi.linkentity (self);

	{
		edict_t *arm;

		arm = G_Spawn();
		arm->solid = self->solid;
		arm->movetype = self->movetype;
		arm->s.renderfx2 |= RF2_NOSHADOW;
		arm->s.scale = self->s.scale;

		VectorCopy( self->s.origin, arm->s.origin );
		VectorCopy( self->s.angles, arm->s.angles );

		arm->s.modelindex = gi.modelindex ("models/props/temp/triangle/arm.md2");
		gi.linkentity (arm);
	}

	VectorCopy( self->s.angles, self->last_step_pos );
	VectorClear( self->move_angles );
#endif
}
