
// g_teamplay.c - teamplay oriented code

#include "g_local.h"


void light_fire_think( edict_t *ent);
// current teamplay mode (set by "level.style")
teamplay_mode_t	teamplay_mode;

int		num_cash_items;

char *team_names[] = {
	"(spectator)",
	team1name,
	team2name,
	NULL
};

char *dragonsafe = "Thugs' Safe";
char *nikkisafe = "Quakers' Safe";

int	team_cash[3];	// cash per team, 0 is neutral so just ignore

float	last_safe_withdrawal[3];
float	last_safe_deposit[3];


// Safebag think, if a friendly guy has been standing near us for more than a few seconds, make them vulnerable to friendly fire
void safebag_think(edict_t *self)
{
	int	i;
	edict_t *trav;
	qboolean	noenemies = true;
	#define	SAFE_CLOSE_DIST		128
	#define	MAX_TIMEATSAFE		8.0

	// first, check if we have any unwanted enemies around, if so, don't count
	for (i=0; i<maxclients->value; i++)
	{
		trav = &g_edicts[i+1];

		if (!trav->inuse || !trav->client)
			continue;

		if (trav->health <= 0)
			continue;

		if (!trav->client->pers.team || (trav->client->pers.team == self->style))
			continue;

		if (VectorDistance( self->s.origin, trav->s.origin ) > 512)
			continue;

		if (!gi.inPVS( self->s.origin, trav->s.origin ))
			continue;

		noenemies = false;
	}

	for (i=0; i<maxclients->value; i++)
	{
		trav = &g_edicts[i+1];

		if (!trav->inuse || !trav->client)
			continue;

		if (trav->health <= 0)
			continue;

		if (!trav->client->pers.team || (trav->client->pers.team != self->style))
			continue;

		if (noenemies)
		{

			if (VectorDistance( self->s.origin, trav->s.origin ) > SAFE_CLOSE_DIST)
			{
				trav->client->pers.timeatsafe -= 0.2;

				if (trav->client->pers.timeatsafe < 0)
					trav->client->pers.timeatsafe = 0;
			}
			else
			{
				trav->client->pers.timeatsafe += 0.2;

				if (trav->client->pers.timeatsafe > MAX_TIMEATSAFE)
					trav->client->pers.timeatsafe = MAX_TIMEATSAFE;
			}

			if (trav->client->pers.timeatsafe >= MAX_TIMEATSAFE)
				trav->client->pers.friendly_vulnerable = true;
			else
				trav->client->pers.friendly_vulnerable = false;

		}
		else	// turn off vulnerability, there is an enemy in range
		{
			trav->client->pers.friendly_vulnerable = false;
		}
	}

	self->nextthink = level.time + 0.2;
}

/*QUAKED dm_safebag (0.5 0 1) (-12 -12 -16) (12 12 12)
Bag that holds the money in the safe.

  style - team that this bag belongs to (1 or 2)
*/

void SP_dm_safebag( edict_t *self )
{

   if (teamplay->value != 1)
   {
		G_FreeEdict (self);
		return;
   }

	
	if (!self->style)
     self->style = 1;

	if (self->style == 1){

    self->classname = "dm_safebag1";
	self->takedamage = DAMAGE_NO;


    self->s.effects = EF_FLAG1;	
	
	self->s.renderfx2 = RF2_NOSHADOW;
	self->s.renderfx = RF_GLOW;


	if (self->style < 1 || self->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(self->s.origin));
		G_FreeEdict(self);
		return;
	}

	self->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( self->mins, -12, -12, -16 );
	VectorSet( self->maxs,  12,  12,  12 );

    if (self->is_entload == true)
    self->movetype = MOVETYPE_BOUNCE;
    else
    self->movetype = MOVETYPE_NONE;  

	self->solid = SOLID_TRIGGER;

	gi.linkentity(self);

	self->touch = safebag_touch1;
	self->currentcash = 0;	// start with no cash

	self->think = safebag_think;
	self->nextthink = level.time + 2;

}

	if (self->style == 2){

    self->classname = "dm_safebag2";
	self->takedamage = DAMAGE_NO;


    self->s.effects = EF_FLAG2;	
	
	self->s.renderfx2 = RF2_NOSHADOW;
	self->s.renderfx = RF_GLOW;


	if (self->style < 1 || self->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(self->s.origin));
		G_FreeEdict(self);
		return;
	}

	self->s.modelindex = gi.modelindex("models/pu_icon/money/money_lg.md2");
	VectorSet( self->mins, -12, -12, -16 );
	VectorSet( self->maxs,  12,  12,  12 );

    if (strstr (level.mapname, "!q2_"))
    self->movetype = MOVETYPE_BOUNCE;  

    if (!strstr (level.mapname, "!q2_"))
    self->movetype = MOVETYPE_NONE;  


    self->solid = SOLID_TRIGGER;

	gi.linkentity(self);

	self->touch = safebag_touch2;
	self->currentcash = 0;	// start with no cash

	self->think = safebag_think;
	self->nextthink = level.time + 2;
}





}



// ....................................................................

void Teamplay_ValidateSkin( edict_t *self )
{
	// TODO: we need color coded skins, for now, just use any skin
}

extern void ClientUserinfoChanged (edict_t *ent, char *userinfo);

// Papa - made some changes to this function

qboolean Teamplay_ValidateJoinTeam( edict_t *self, int teamindex )
{
	// NOTE: this is called by each player on level change, as well as when a player issues a "join XXX" command

	// TODO: player limit per team? cvar?


	// setup client stuff
	Teamplay_ValidateSkin( self );

//	InitClientPersistant (self->client);

	self->client->pers.team = teamindex;
	self->client->pers.spectator = PLAYING;
	if ((level.modeset != STARTINGMATCH) && (level.modeset != STARTINGPUB))
	{
		safe_bprintf( PRINT_HIGH, "%s joined %s\n", self->client->pers.netname, team_names[teamindex] );
	}

	if ((level.modeset == TEAMPLAY) || (level.modeset == MATCH) || (level.modeset == STARTINGMATCH) || (level.modeset == STARTINGPUB))
	{
		self->movetype = MOVETYPE_WALK;
		self->solid = SOLID_BBOX;
		self->svflags &= ~SVF_NOCLIENT;


/*
	// Validate skins
	{
		char *str[256];

		strcpy( str, self->client->pers.userinfo );
		ClientUserinfoChanged ( self, str );
	}
*/

		self->health = 0;	// so we're not counted in spawn point checking
		self->client->resp.enterframe = level.framenum;
	//	InitClientResp( self->client );
		self->client->resp.score = 0;
		self->client->resp.deposited = 0;
		PutClientInServer( self );	// find a new spawn point
	}
	return true;
}

void Teamplay_AutoJoinTeam( edict_t *self )
{
	int	team_count[2];
	int	i;

	// count number of players on each team, assign the team with least players

	team_count[0] = 0;
	team_count[1] = 0;

	for (i=1; i<maxclients->value; i++)
	{
		if (g_edicts[i].client && g_edicts[i].client->pers.team)
			team_count[g_edicts[i].client->pers.team - 1]++;
	}

	if (team_count[0] > team_count[1])
		self->client->pers.team = 2;
	else
		self->client->pers.team = 1;
	self->client->pers.spectator = PLAYING;

	Teamplay_ValidateJoinTeam( self, self->client->pers.team );
}


void Teamplay_InitTeamplay (void)
{
	num_cash_items = 0;
	memset( team_cash, 0, sizeof(int) * 3 );
	memset( last_safe_withdrawal, 0, sizeof(float) * 3 );
	memset( last_safe_deposit, 0, sizeof(float) * 3 );

	last_safe_deposit[0] = last_safe_deposit[1] = 0;
	last_safe_withdrawal[0] = last_safe_withdrawal[1] = 0;
	if (teamplay->value) UPDATESCORE
}








