#include "g_local.h"
#include "m_player.h"

qboolean Hogie_Filter(edict_t *ent);
void Cmd_Barcode_f (edict_t *ent);
void Cmd_Jaxon_f (edict_t *ent);
void Cmd_Sephi_f (edict_t *ent);
void Cmd_Hydro_f (edict_t *ent);
void Cmd_Cuts_f (edict_t *ent);
void Cmd_Cypress_f (edict_t *ent);
void Cmd_Hogie_f (edict_t *ent);
qboolean Curse_Filter(edict_t *ent , qboolean gender);
void Cmd_Kingpin_f (edict_t *ent);
void Cmd_Leroy_f (edict_t *ent);
void Cmd_Lamont_f (edict_t *ent);
void Cmd_Nikki_f (edict_t *ent);
void Cmd_Momo_f (edict_t *ent);
void Cmd_Jesus_f (edict_t *ent);
void Cmd_Tyrone_f (edict_t *ent);
void Cmd_Willy_f (edict_t *ent);
void Cmd_Moker_f (edict_t *ent);
void Cmd_Popeye_f (edict_t *ent);
void Cmd_Fem_f (edict_t *ent);
void Cmd_Honey_f (edict_t *ent);
void Cmd_Blunt_f (edict_t *ent);
void Cmd_Curse_f (edict_t *ent);


qboolean Hogie_Filter(edict_t *ent)
{
	int		i;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;
	
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
//		safe_cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return false;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return false;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return false;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;
	return true;
}

//FRANK Feb21,00
/*
==================
Cmd_Barcode_f //private fucntion for server admin: Barcode
==================
*/


void Cmd_Barcode_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/eatlead1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fucker.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/pieceshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/takesome.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/ratfuck.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

    
	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}

//FRANK June26,00
/*
==================
Cmd_Jaxon_f
==================
*/



void Cmd_Jaxon_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 16;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/larry.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/armor_head2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	default:
	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/fuckshit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Jaxon_Curse


//FRANK 9/12/00
/*
==================
Cmd_Sephi_f
==================
*/



void Cmd_Sephi_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/david/david3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killme2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/leave.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/morgue.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk13.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/moe1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar3.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;


	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;
	default:
	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Sephi_Curse



//FRANK June26,00
/*
==================
Cmd_Hydro_f
==================
*/




void Cmd_Hydro_f (edict_t *ent)
{
	int i;
	static int rnd;

    if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/amb1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/buyticket1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/scalper/yes2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/getout.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny6.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv14.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/player/male/peekaboo.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("world/pawnomatic/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Hydro_Curse


//FRANK June26,00
/*
==================
Cmd_Cuts_f
==================
*/



void Cmd_Cuts_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 30 seconds ago.
	if (ent->client->last_wave > (level.time - 30) && (ent->client->last_wave <= level.time))
    return;

	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//			(int)flood_waitdelay->value);
	      return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
//				(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}

	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv1.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut_pv2.wav"), 1, ATTN_NORM, 0);     break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut2_1.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/cut3_2.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut2.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut3.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut4.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut5.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/kpcut7.wav"), 1, ATTN_NORM, 0);     break;

	case 11:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("cut_scenes/sycut.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CutScenes


//FRANK June26,00
/*
==================
Cmd_Cypress f
==================
*/


void Cmd_Cypress_f (edict_t *ent)
{

	int		i;
	static int	rnd;
	gclient_t *cl;

	//can't talk if you just talked or tried to talk less than 15 seconds ago.
	if (ent->client->last_wave > (level.time - 15) && (ent->client->last_wave <= level.time))
    return;
	
	//cant talk if your dying.
	if (ent->health <= 10)
	{
//		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
		return;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0)
          i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;
		if (cl->flood_when[i] && 
			level.time - cl->flood_when[i] < flood_persecond->value) {
			cl->flood_locktill = level.time + flood_waitdelay->value;
	//		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
		{
			cl->flood_locktill = level.time + flood_waitdelay->value;
//			safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",
	//			(int)flood_waitdelay->value);
         return;
		}

		cl->flood_whenhead = (cl->flood_whenhead + 1) %
			(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
		cl->flood_when[cl->flood_whenhead] = level.time;
	}



	if (ent->client->anim_priority > ANIM_WAVE)
	return;

    ent->client->anim_priority = ANIM_WAVE;
	//mark the last time that you talked.
	ent->client->last_wave = level.time;

    rnd = (rnd + 1) % 4;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress.wav"), 1, ATTN_NORM, 0);		break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress2.wav"), 1, ATTN_NORM, 0);		break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress3.wav"), 1, ATTN_NORM, 0);		break;

	default:
	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("world/hmcypress4.wav"), 1, ATTN_NORM, 0);		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end CypressHill

//FRANK Jan25,00
/*
==================
Cmd_Hogie_f
==================
*/



void Cmd_Hogie_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 23;
	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/getme2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/bum.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/pain.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/swat.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/death.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/sit.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/bum/shuffle.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/worked2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/magicj/holdbuck.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot1.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;
	}

	if(rand()%2==0)
	{
		//pick a taunt wave.
		i = rand() % 3;
		switch(i)
		{
		case 0: ent->s.frame = FRAME_tg_bird_01-1;
				ent->client->anim_end = FRAME_tg_bird_10;
				break;
		case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
				ent->client->anim_end = FRAME_tg_crch_grab_16;
				break;
		case 2:
		default: ent->s.frame = FRAME_tg_chin_flip_01-1;
				 ent->client->anim_end = FRAME_tg_chin_flip_15;
		}
	}

}





qboolean Curse_Filter(edict_t *ent , qboolean gender)
{
	int i;
	gclient_t *cl;
	char *cmd;
	cmd = gi.argv(0);
	//can't talk if you just talked or tried to talk less than 3 seconds ago.
	if (ent->client->last_wave > (level.time - 3) && (ent->client->last_wave <= level.time))
    return false;

	//kingpin has to be male.
	if ((!(ent->gender == GENDER_MALE)) && (gender))
	{
		safe_cprintf(ent, PRINT_CHAT, ">> %s is a MALE taunt!\n>> %s is female.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}	

	else if ((!(ent->gender == GENDER_FEMALE)) && (!gender) )
	{
		safe_cprintf(ent, PRINT_CHAT, ">> %s is a FEMALE taunt!\n>> %s is male.\n" , cmd, ent->client->pers.netname );
		ent->client->last_wave = level.time;
		return false;
	}

	//cant talk if your dying.
	if (ent->health <= 10)
	{
		safe_cprintf(ent, PRINT_CHAT, "%s is too ill to speak!\n" , ent->client->pers.netname );
		//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		return false; 
	}

	//cant cuss if underwater
	if (ent->waterlevel >= 2)
	{	//mark the last time that you talked.
	    ent->client->last_wave = level.time;
		safe_cprintf(ent, PRINT_CHAT, "%s is trying to curse underwater!\n" , ent->client->pers.netname );
		return false; 
	}

	// can't wave when ducked.
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED) return false;
	if (ent->client->anim_priority > ANIM_WAVE)	return false;

    ent->client->anim_priority = ANIM_WAVE;

	//mark the last time that you talked.
	ent->client->last_wave = level.time;

	if (flood_msgs->value) 
	{
	  cl = ent->client;

      if (level.time < cl->flood_locktill) 
	  {
			safe_cprintf(ent, PRINT_HIGH, "You can't talk for %d more seconds\n",
				(int)(cl->flood_locktill - level.time));
            return false;
      }

      i = cl->flood_whenhead - flood_msgs->value + 1;

      if (i < 0) i = (sizeof(cl->flood_when)/sizeof(cl->flood_when[0])) + i;

	  if (cl->flood_when[i] && level.time - cl->flood_when[i] < flood_persecond->value) 
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
      }

      // if they repeat themselves really quickly, bitch-slap time
	  if (cl->flood_when[cl->flood_whenhead] && (cl->flood_when[cl->flood_whenhead] > level.time - 1) )
	  {
		cl->flood_locktill = level.time + flood_waitdelay->value;
		safe_cprintf(ent, PRINT_CHAT, "Flood protection:  You can't talk for %d seconds.\n",(int)flood_waitdelay->value);
        return false;
	  }

	  cl->flood_whenhead = (cl->flood_whenhead + 1) %	(sizeof(cl->flood_when)/sizeof(cl->flood_when[0]));
	  cl->flood_when[cl->flood_whenhead] = level.time;
	}

	return true;
}

//FRANK Jan28,00
/*
==================
Cmd_Kingpin_f
==================
*/




void Cmd_Kingpin_f (edict_t *ent)
{	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 13;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny7.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 13 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}



//FRANK Jan28,00
/*
==================
Cmd_Leroy_f
==================
*/


void Cmd_Leroy_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0); break;

	case 9: 
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0); break;
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}

}


//FRANK Jan28,00
/*
==================
Cmd_Lamont_f
==================
*/



void Cmd_Lamont_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny1.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny2.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/mfcomeout.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/offstreet2.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Lamont_f



//FRANK Mar19,00
/*
==================
Cmd_Nikki_f
==================
*/



void Cmd_Nikki_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny4.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Nikki_f

//FRANK Jan28,00
/*
==================
Cmd_Momo_f
==================
*/


void Cmd_Momo_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 21;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0); break;
	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0); break;
	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0); break;
	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0); break;
	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0); break;
	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0); break;
	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0); break;
	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0); break;
	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-6.wav"), 1, ATTN_NORM, 0); break;
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0); break;
	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile1.wav"), 1, ATTN_NORM, 0); break;
	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle4.wav"), 1, ATTN_NORM, 0); break;
	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_typhoon.wav"), 1, ATTN_NORM, 0); break;
	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/hostile2.wav"), 1, ATTN_NORM, 0); break;
	case 14: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/scram.wav"), 1, ATTN_NORM, 0); break;
	case 15: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/comeback2.wav"), 1, ATTN_NORM, 0); break;
	case 16: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle3.wav"), 1, ATTN_NORM, 0); break;
	case 17: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_saltydog.wav"), 1, ATTN_NORM, 0); break;
	default:
    case 18: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0); break;
	case 19: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle2.wav"), 1, ATTN_NORM, 0); break;
	case 20: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_boilerroom.wav"), 1, ATTN_NORM, 0); break;
	}
	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 15 waves
	     i = rand() % 3;
	     switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Momo_f




//FRANK Jan28,00
/*
==================
Cmd_Jesus_f
==================
*/



void Cmd_Jesus_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 14;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/battery.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain3.wav"), 1, ATTN_NORM, 0); break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny6.wav"), 1, ATTN_NORM, 0); break;


	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain1.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 14 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Jesus_f


//FRANK Jan28,00
/*
==================
Cmd_Tyrone_f
==================
*/


void Cmd_Tyrone_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 10;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 10 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Tyrone_f


//FRANK Jan28,00
/*
==================
Cmd_Willy_f
==================
*/



void Cmd_Willy_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 8;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/onfloor5.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/lizzy1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 8 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Willy_f



//FRANK Jan28,00
/*
==================
Cmd_Moker_f
==================
*/



void Cmd_Moker_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Moker_f


/*
==================
Cmd_Popeye_f       Frank 12/14/00
==================
*/



void Cmd_Popeye_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,true))
		return;
    rnd = (rnd + 1) % 11;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/whistle.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/burp.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/tackle.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh2.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/argh3.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile2.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile3.wav"), 1, ATTN_NORM, 0); break;

	default:
	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/wharfshrimp.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/barney.wav"), 1, ATTN_NORM, 0); break;
	}

	if((rand()%2)==0)
	{
		//pick a taunt wave only once out of 10 waves
		 i = rand() % 3;
		 switch(i)
		 {
			case 0: ent->s.frame = FRAME_tg_bird_01-1;
					ent->client->anim_end = FRAME_tg_bird_10;
					break;
			case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
					ent->client->anim_end = FRAME_tg_crch_grab_16;
					break;
			case 2:
					default: ent->s.frame = FRAME_tg_chin_flip_01-1;
					ent->client->anim_end = FRAME_tg_chin_flip_15;
		 }
	}
}//end Cmd_Popeye_f

//FRANK June26,00
/*
==================
Cmd_Fem_f
==================
*/



void Cmd_Fem_f (edict_t *ent)
{
	int i;
	static int	rnd;
	if(!Curse_Filter(ent,false))
		return;
    rnd = (rnd + 1) % 15;
	switch (rnd)
	{
	case 0:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);	break;

	case 1:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);    break;

	case 2:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);		break;

	case 3:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);		break;

	case 4:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);		break;

	case 5:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);		break;

	case 6:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);		break;

	case 7:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/neutral/seennothing.wav"), 1, ATTN_NORM, 0);		break;

	case 8:	gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_backoff.wav"), 1, ATTN_NORM, 0);		break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die.wav"), 1, ATTN_NORM, 0);		break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die2.wav"), 1, ATTN_NORM, 0);     break;

	case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_die3.wav"), 1, ATTN_NORM, 0);     break;

	case 12: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/f_takethat.wav"), 1, ATTN_NORM, 0);     break;

	case 13: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/fighting/infacemf.wav"), 1, ATTN_NORM, 0);     break;

	case 14:
	default: gi.sound(ent, CHAN_AUTO, gi.soundindex("rc/actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

} // end Fem

//FRANK Nov24,00
/*
==================
Cmd_Honey_f
==================
*/


void Cmd_Honey_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,true))
		return;

//	gi.WriteByte( svc_stufftext );
//	gi.WriteString( va("play glad/rock/honey.wav"));
//	gi.unicast (ent, true);

	gi.sound(ent, CHAN_AUTO, gi.soundindex("kpl/honey.wav"), 1, ATTN_NORM, 0); 

	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
			ent->client->anim_end = FRAME_tg_crch_grab_16;
			break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
			 ent->client->anim_end = FRAME_tg_chin_flip_15;
	}
}//end Cmd_Honey_f



//FRANK Jan28,00
/*
==================
Cmd_Blunt_f
==================
*/



void Cmd_Blunt_f (edict_t *ent)
{
	int i;
	static int	rnd;

	if(!Curse_Filter(ent,false))
		return;

    rnd = (rnd + 1) % 12;
	switch (rnd)
	{
	case 0: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 1: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0); break;

	case 2: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0); break;

	case 3: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0); break;

	case 4: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0); break;

	case 5: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0); break;

	case 6: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0); break;

	case 7: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0); break;

	case 8: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0); break;

	case 9: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0); break;

	case 10: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0); break;

	default:
    case 11: gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight5.wav"), 1, ATTN_NORM, 0); 
			//pick a taunt wave only once out of 12 waves
	         i = rand() % 3;
	         switch(i)
			 {
				case 0: ent->s.frame = FRAME_tg_bird_01-1;
						ent->client->anim_end = FRAME_tg_bird_10;
						break;
				case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
						ent->client->anim_end = FRAME_tg_crch_grab_16;
						break;
				case 2:
						default: ent->s.frame = FRAME_tg_chin_flip_01-1;
						ent->client->anim_end = FRAME_tg_chin_flip_15;
			 }
	}
}//end Cmd_Blunt_f


//FRANK Jan24,00
/*
==================
Cmd_Curse f
==================
*/


void Cmd_Curse_f (edict_t *ent)
{
	int		i;
	static int	rnd;

	if(!Hogie_Filter(ent))
		return;

    rnd = (rnd + 1) % 87;

	switch (rnd)
	{
	case 0:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 1:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);      
		break;

	case 2:
		if (ent->gender == GENDER_MALE)
		  gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0);
		else
          gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 3:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 4:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 5:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 6:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 7:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 8:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 9:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/brittany/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 10:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/10bucks2.wav"), 1, ATTN_NORM, 0);
		break;

	case 11:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0);
		else
           gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 12:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 13:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;

	case 14:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 15:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 16:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;

	case 17:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/party.wav"), 1, ATTN_NORM, 0);
		break;

	case 18:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/piece.wav"), 1, ATTN_NORM, 0);
		break;

	case 19:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 20:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/coverme.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 21:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shakin.wav"), 1, ATTN_NORM, 0);
		break;

	case 22:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 23:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 24:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 25:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 26:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level1/f_cuss1-5.wav"), 1, ATTN_NORM, 0);
		break;

	case 27:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 28:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 29:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 30:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level2/f_cuss2-4.wav"), 1, ATTN_NORM, 0);
		break;

	case 31:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 32:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 33:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 34:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/shitbaby.wav"), 1, ATTN_NORM, 0);
		break;

	case 35:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/neutral/yeah2.wav"), 1, ATTN_NORM, 0);
		break;

	case 36:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry1.wav"), 1, ATTN_NORM, 0);
		break;

	case 37:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry2.wav"), 1, ATTN_NORM, 0);
		break;

	case 38:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry3.wav"), 1, ATTN_NORM, 0);
		break;

	case 39:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry4.wav"), 1, ATTN_NORM, 0);
		break;

	case 40:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/angry5.wav"), 1, ATTN_NORM, 0);
		break;

	case 41:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/mona/nobar1.wav"), 1, ATTN_NORM, 0);
		break;

	case 42:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/ladiesroom.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 43:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/neutral/talk10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse2.wav"), 1, ATTN_NORM, 0);
		break;

	case 44:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lola/curse3.wav"), 1, ATTN_NORM, 0);
		break;

	case 45:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/lisa_specific/findpiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 46:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/hiredgirl/orders/fighting/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 47:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight1.wav"), 1, ATTN_NORM, 0);
		break;

	case 48:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight2.wav"), 1, ATTN_NORM, 0);
		break;

	case 49:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 50:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight4.wav"), 1, ATTN_NORM, 0);
		break;

	case 51:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight5.wav"), 1, ATTN_NORM, 0);
		break;

	case 52:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 53:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level3/cuss3-2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 54:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/pullshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 55:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-12.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 56:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-13.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/backoff.wav"), 1, ATTN_NORM, 0);
		break;

	case 57:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-15.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny1.wav"), 1, ATTN_NORM, 0);
		break;

	case 58:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-16.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny2.wav"), 1, ATTN_NORM, 0);
		break;

	case 59:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-17.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny3.wav"), 1, ATTN_NORM, 0);
		break;

	case 60:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny4.wav"), 1, ATTN_NORM, 0);
		break;

	case 61:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level2/cuss2-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny5.wav"), 1, ATTN_NORM, 0);
		break;

	case 62:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/funny6.wav"), 1, ATTN_NORM, 0);
		break;

	case 63:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-6.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/beth_specific/droppiece.wav"), 1, ATTN_NORM, 0);
		break;

	case 64:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-7.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/biggergun.wav"), 1, ATTN_NORM, 0);
		break;

	case 65:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/profanity/level1/cuss1-8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/die.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 66:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/sal/shotguns.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 67:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 68:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 69:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 70:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 71:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 72:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 73:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 74:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 75:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 76:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/stepoff.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/fuckyou.wav"), 1, ATTN_NORM, 0);
		break;

	case 77:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv10.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/holyshit.wav"), 1, ATTN_NORM, 0);
		break;

	case 78:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/warned.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/mf.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 79:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/fuckyou.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/pissoff.wav"), 1, ATTN_NORM, 0);
		break;
		
	case 80:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/die.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/yolanda/shithead.wav"), 1, ATTN_NORM, 0);
		break;

	case 81:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv11.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;

	case 82:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv8.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-2.wav"), 1, ATTN_NORM, 0);
		break;

	case 83:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/conv9.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-3.wav"), 1, ATTN_NORM, 0);
		break;

	case 84:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/mybitch1.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/bambi/curse1.wav"), 1, ATTN_NORM, 0);
		break;

	case 85:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/skidrow/leroy/whatsup.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/blunt/fight3.wav"), 1, ATTN_NORM, 0);
		break;

	case 86:
	default:
		if (ent->gender == GENDER_MALE)
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0);
		else
		   gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/female/profanity/level3/f_cuss3-1.wav"), 1, ATTN_NORM, 0);
		break;
	}

	//pick a taunt wave.
	i = rand() % 3;
	switch(i)
	{
	case 0: ent->s.frame = FRAME_tg_bird_01-1;
			ent->client->anim_end = FRAME_tg_bird_10;
			break;
	case 1: ent->s.frame = FRAME_tg_crch_grab_01-1;
		    ent->client->anim_end = FRAME_tg_crch_grab_16;
		    break;
	case 2:
	default: ent->s.frame = FRAME_tg_chin_flip_01-1;
		     ent->client->anim_end = FRAME_tg_chin_flip_15;
	}

}



void Cmd_Kpq2_Taunts_f (edict_t *ent)
{

    char	*cmd;

	cmd = gi.argv(0);

    if (Q_stricmp (cmd, "1") == 0){   SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv0.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "2") == 0){   SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv11.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "3") == 0){   SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv12.wav"), 1, ATTN_NORM, 0);	return;}
	if (Q_stricmp (cmd, "4") == 0){   SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv17.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "5") == 0){	  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv19.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "6") == 0){	  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv2.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "7") == 0){	  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv3.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "8") == 0){	  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv5.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "9") == 0){	  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv7.wav"), 1, ATTN_NORM, 0); return;}
	if (Q_stricmp (cmd, "10") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/ambient/conv8.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "11") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/david/david1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "12") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/david/david2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "13") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "14") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/dogg/dogg5.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "15") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fucker.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "16") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "17") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/fuckyou2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "18") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/fighting/pieceshit.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "19") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "20") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "21") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/hostile3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "22") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hann/rand2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "23") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/death1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "24") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/death2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "25") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "26") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "27") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "28") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/fight4.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "29") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "30") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "31") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "32") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny4.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "33") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny5.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "34") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny6.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "35") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/funny7.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "36") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/pain1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "37") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/pain2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "38") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/pain3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "39") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/pain4.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "40") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt1 orig.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "41") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "42") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt2 orig.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "43") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "44") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt3 orig.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "45") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "46") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt4 orig.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "47") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/heilman/taunt4.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "48") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "49") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight2.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "50") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight3.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "51") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight4.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "52") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/fighting/fight5.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "53") == 0){  SK gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/orders/response1.wav"), 1, ATTN_NORM, 0);return;}
	if (Q_stricmp (cmd, "54") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/orders/response2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "55") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/orders/response3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "56") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/orders/response4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "57") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/orders/response5.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "58") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/coverme.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "59") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/deadmeat.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "60") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/fixhimup.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "61") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "62") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/friendlyfire2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "63") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/fuckedup.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "64") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/hitarm.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "65") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/hitchest.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "66") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/hitleg.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "67") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/hurtbad.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "68") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/wounded/stopmf.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "69") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/waiting1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "70") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/waiting2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "71") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/hiredguy/workalone.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "72") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "73") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "74") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "75") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/fight4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "76") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "77") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "78") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "79") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "80") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny5.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "81") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/funny6.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "82") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "83") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "84") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "85") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/jesus/pain4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "86") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/alliknow.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "87") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/alltosay.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "88") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/bodybag.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "89") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/keepout.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "90") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/motard.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "91") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/outofskidrow.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "92") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/joseph/ripass.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "93") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "94") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/death2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "95") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "96") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "97") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "98") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/fight4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "99") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "100") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "101") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "102") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "103") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny5.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "104") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny6.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "105") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny7.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "106") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kingpin/funny8.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "107") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/getout.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "108") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/kroker/opensafe.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "109") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "110") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/babble2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "111") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckinprob.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "112") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/fuckyou.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "113") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/getsome.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "114") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/killem.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "115") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "116") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "117") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lenny3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "118") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "119") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/lookinat2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "120") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/mfcomeout.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "121") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/offstreet1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "122") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/offstreet2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "123") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lamont/outofface.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "124") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lefty/random1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "125") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lefty/random2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "126") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/great.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "127") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "128") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "129") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "130") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle5.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "131") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/idle6.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "132") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/killme.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "133") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/lenny/leave.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "134") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "135") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "136") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/getout3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "137") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/goodluck.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "138") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/hangaround.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "139") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/madeit.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "140") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/morgue.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "141") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/louie/payback.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "142") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "143") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "144") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/hostile3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "145") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/rand1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "146") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/rand2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "147") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/rand3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "148") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/luke/rand4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "149") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "150") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "151") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/mathew/curse3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "152") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive1.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "153") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive2.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "154") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive3.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "155") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/aggressive4.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "156") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "157") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "158") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/cowar3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "159") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/killhim.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "160") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moe/moe1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "161") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "162") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "163") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "164") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/fight4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "165") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "166") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "167") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "168") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny4.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "169") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny5.wav"), 1, ATTN_NORM, 0);
    	return;
	}	
	if (Q_stricmp (cmd, "170") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/moker/funny6.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "171") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle2.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "172") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/idle3.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "173") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_boilerroom.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "174") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_saltydog.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "175") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_swank.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "176") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/momo/welcome_typhoon.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "177") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny3.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "178") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny4.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "179") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny5.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "180") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/nicki/funny6.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "181") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse1.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "182") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse2.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "183") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse3.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "184") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/curse4.wav"), 1, ATTN_NORM, 0);
		return;
	}	
	if (Q_stricmp (cmd, "185") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "186") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "187") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "188") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/pete/rand4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "189") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/burp.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "190") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "191") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
    if (Q_stricmp (cmd, "192") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/windowtoss.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
		
	
	if (Q_stricmp (cmd, "193") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/hostile3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "194") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/popeye/whistle.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "195") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "196") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/fuckthem2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "197") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/getme1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "198") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/getme2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "199") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "200") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/nogot2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	

	
	
	
	if (Q_stricmp (cmd, "201") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	

	
	
	
	if (Q_stricmp (cmd, "202") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/rummy/yesgot2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	
	if (Q_stricmp (cmd, "203") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/sal/onfloor.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	
	if (Q_stricmp (cmd, "204") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "205") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	
	if (Q_stricmp (cmd, "206") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	
	if (Q_stricmp (cmd, "207") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/spec4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "208") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	
	if (Q_stricmp (cmd, "209") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "210") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/specific/weapon3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "211") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/steelkids/bye1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "212") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/steelkids/bye2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	
	if (Q_stricmp (cmd, "213") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/steelkids/bye3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "214") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/steelkids/bye4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "215") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "216") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "217") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "218") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/fight4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "219") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "220") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "221") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "222") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "223") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny5.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "224") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/tyrone/funny6.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "225") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight1.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "226") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight2.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "227") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight3.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "228") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight4.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	
	
	if (Q_stricmp (cmd, "229") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("actors/male/willy/fight5.wav"), 1, ATTN_NORM, 0);
		return;
	
	}	
	if (Q_stricmp (cmd, "230") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/230.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "231") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/231.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "232") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/232.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "233") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/233.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "234") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/234.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "235") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/235.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "236") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/236.wav"), 1, ATTN_NORM, 0);
		return;
	}

	if (Q_stricmp (cmd, "237") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/237.wav"), 1, ATTN_NORM, 0);
		return;
	}

	if (Q_stricmp (cmd, "238") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/238.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "239") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/239.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "240") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/240.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "241") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/241.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "242") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/242.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "243") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/243.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "244") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/244.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "245") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/245.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "246") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/246.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "247") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/247.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "248") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/248.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "249") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/249.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "250") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/250.wav"), 1, ATTN_NORM, 0);
		return;
	}
	if (Q_stricmp (cmd, "251") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/251.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
	if (Q_stricmp (cmd, "252") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/252.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
	if (Q_stricmp (cmd, "253") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/253.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
	if (Q_stricmp (cmd, "254") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/254.wav"), 1, ATTN_NORM, 0);
		return;
	}

	if (Q_stricmp (cmd, "255") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/255.wav"), 1, ATTN_NORM, 0);
		return;
	}

	if (Q_stricmp (cmd, "256") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/256.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
		if (Q_stricmp (cmd, "257") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/257.wav"), 1, ATTN_NORM, 0);
		return;
	}

		if (Q_stricmp (cmd, "258") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/258.wav"), 1, ATTN_NORM, 0);
		return;
	}

		if (Q_stricmp (cmd, "259") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/259.wav"), 1, ATTN_NORM, 0);
		return;
	}

	
		if (Q_stricmp (cmd, "260") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/260.wav"), 1, ATTN_NORM, 0);
		return;
	}

		if (Q_stricmp (cmd, "261") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/261.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
			if (Q_stricmp (cmd, "262") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/262.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "263") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/263.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "264") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/264.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "265") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/265.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "266") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/266.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "267") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/267.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "268") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/268.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "269") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/269.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "270") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/270.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "271") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/271.wav"), 1, ATTN_NORM, 0);
		return;
	}
	
				if (Q_stricmp (cmd, "272") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/272.wav"), 1, ATTN_NORM, 0);
		return;
	}

	
				if (Q_stricmp (cmd, "273") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/273.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "274") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/274.wav"), 1, ATTN_NORM, 0);
		return;
	}

				if (Q_stricmp (cmd, "275") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/275.wav"), 1, ATTN_NORM, 0);
		return;
	}

			if (Q_stricmp (cmd, "276") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/276.wav"), 1, ATTN_NORM, 0);
		return;
	}


			if (Q_stricmp (cmd, "277") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/277.wav"), 1, ATTN_NORM, 0);
		return;
	}

				
			if (Q_stricmp (cmd, "278") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/278.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
				
				
			if (Q_stricmp (cmd, "279") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/279.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "280") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/280.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
				
			if (Q_stricmp (cmd, "281") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/281.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "282") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/282.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "283") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/283.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "284") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/284.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "285") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/285.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "286") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/286.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "287") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/287.wav"), 1, ATTN_NORM, 0);
		return;
	}
				
			if (Q_stricmp (cmd, "288") == 0)
	{
		SK
		gi.sound(ent, CHAN_AUTO, gi.soundindex("redkneck/288.wav"), 1, ATTN_NORM, 0);
		return;
	}

}








