/************************************************
=================================================

          CRASH COMMANDS crash_cmds.c

=================================================
************************************************/

#include "g_local.h"

void check_version(edict_t *ent)
{
	char buf[32];
	sprintf(buf,"%s $classicv\n",ver_check);
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void Cmd_fov_f(edict_t *ent)
{
	char buf[32];

	if (ent->scope != OFF) {
		cprintf(ent,PRINT_HIGH,"You cannot change FOV while using scope.\n");
		return;
	}
	if (gi.argc()!=2) {
		cprintf(ent,PRINT_HIGH,"Usage: changefov 90\n");
		return;
	}
		
	ent->client->ps.fov = ent->oldfov = atoi(gi.argv(1));
	if (ent->client->ps.fov < 90){
		ent->client->ps.fov = ent->oldfov = 90;
		cprintf(ent,PRINT_HIGH,"FOV below 90 not allowed. Setting FOV to 90.\n");
	}
	else if (ent->client->ps.fov > 160)
		ent->client->ps.fov = ent->oldfov = 160;

	// so their client-side variable is correct
	sprintf(buf,"fov %i\n",ent->oldfov);
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

void Cmd_usescope_f (edict_t *ent)
{
	
	if ( ent->client->pers.weapon != FindItem ("awsm") && ent->client->pers.weapon != FindItem ("msg90") )
		return;

	if (ent->client->weaponstate == WEAPON_RELOADING || ent->client->weaponstate == WEAPON_ACTIVATING || ent->client->weaponstate == WEAPON_DROPPING)
		return;

	ent->client->pers.usedscope = 1; // MH: scope has been used

	if(ent->scope == FULL){
		char buffer[32];
		char buff[32];

		ent->scope = OFF;
//		ent->client->showscores = NO_SCOREBOARD; // MH: not needed with disabled scope
		
		// set client's original fov
		ent->client->ps.fov = ent->oldfov;

/*		// set client's original crosshair (MH: disabled)
		sprintf(buffer,"crosshair %i\n",ent->crosshair);
		gi.WriteByte(13);
		gi.WriteString(buffer);
		gi.unicast(ent, true);*/

		// set client's original mouse sens.
		sprintf(buff,"sensitivity %f\n",ent->sens);
		gi.WriteByte(13);
		gi.WriteString(buff);
		gi.unicast(ent, true);
	}
	else if(ent->scope == HALF){
		char buf[32];

		ent->scope = FULL;
//		ent->client->showscores = SCORE_SCOPE;  //just incase something happened: FIXME (MH: disabled)
		ent->client->ps.fov = 15;

		// adjust mouse sensitivity (MH: changed to use ratio)
		sprintf(buf,"sensitivity %f\n",ent->sens * 15 / 90);
		gi.WriteByte(13);
		gi.WriteString(buf);
		gi.unicast(ent, true);
	}
	else if(ent->scope == OFF){
		char buf[32];
		char buf2[32];
		char buf3[32];
		
		ent->scope = HALF;

/*		// get current crosshair, stored to ent->crosshair (MH: disabled)
		sprintf(buf,"%s $crosshair\n",crosshair_check);
		gi.WriteByte(13);
		gi.WriteString(buf);
		gi.unicast(ent, true);*/

/*		// get current mouse sensitivity, stored to ent->sens (MH: moved to ClientBegin)
		sprintf(buf2,"%s $sensitivity\n",sens_check);
		gi.WriteByte(13);
		gi.WriteString(buf2);
		gi.unicast(ent, true);*/

		// show the scope blackout on screen (MH: disabled because it doesn't work with custom resolutions)
//		ent->client->showscores = SCORE_SCOPE;

		ent->client->ps.fov = 40;

/*		// turn off their crosshair (MH: disabled)
		gi.WriteByte(13);
		gi.WriteString("crosshair 0\n");
		gi.unicast(ent, true);*/

		// adjust mouse sensitivity (MH: changed to use ratio)
		sprintf(buf3,"sensitivity %f\n",ent->sens * 40 / 90);
		gi.WriteByte(13);
		gi.WriteString(buf3);
		gi.unicast(ent, true);
	}

//	DeathmatchScoreboard (ent); // MH: not needed with disabled scope


}

void killscope (edict_t *ent)
{
	char buffer[32];
	char buff[32];

	if(ent->scope == OFF)
		return;

	ent->scope = OFF;
	
	// set client's original fov
	ent->client->ps.fov = ent->oldfov;

/*	// set client's original crosshair (MH: disabled)
	sprintf(buffer,"crosshair %i\n",ent->crosshair);
	gi.WriteByte(13);
	gi.WriteString(buffer);
	gi.unicast(ent, true);*/

	// set client's original mouse sens.
	sprintf(buff,"sensitivity %f\n",ent->sens);
	gi.WriteByte(13);
	gi.WriteString(buff);
	gi.unicast(ent, true);

}

void killscope2 (edict_t *ent)
{
	char buffer[32];
	char buff[32];

	if(ent->scope == OFF)
		return;

	ent->scope = OFF;
	
//	ent->client->showscores = NO_SCOREBOARD; // MH: not needed with disabled scope

	// set client's original fov
	ent->client->ps.fov = ent->oldfov;

/*	// set client's original crosshair (MH: disabled)
	sprintf(buffer,"crosshair %i\n",ent->crosshair);
	gi.WriteByte(13);
	gi.WriteString(buffer);
	gi.unicast(ent, true);*/

	// set client's original mouse sens.
	sprintf(buff,"sensitivity %f\n",ent->sens);
	gi.WriteByte(13);
	gi.WriteString(buff);
	gi.unicast(ent, true);

}

extern char *MapCycleNext( char *map );
void Cmd_mapinfo_f(edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH,"current map is: %s (played for %i minutes)\nnext map will be: %s\n", level.mapname, (int)level.time/60, MapCycleNext( level.mapname ));
}

void Cmd_radiomenu_f(edict_t *ent)
{
	// MH: can only use radio if it's on and in game
	if (!ent->radio_power || !ent->playing_ingame)
		return;

	if(ent->client->showscores == SCORE_RADIO)
		ent->client->showscores = NO_SCOREBOARD;
	else
		ent->client->showscores = SCORE_RADIO;

	ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard

}

void Cmd_timeleft_f(edict_t *ent)
{
	gi.cprintf(ent, PRINT_HIGH,"timeleft until next map: %i minutes\n", (int)map_timelimit->value - (int)level.time/60);
}

/************************************************
=================================================

             END CRASH COMMANDS

=================================================
************************************************/