#include "g_local.h"

// =================================================
//   crash_main.c
//     Main functions used in the mod.
//   -SnaP
// =================================================

void apply_kick (edict_t *ent, int amount){
	int i;
	int kickamt;
	int amt;

	if(amount == 0)
		return;

	amt = amount;

	if(amt > 3)
		amt = 3;
	
	for(i=0; i<=2; i++){
		kickamt = rand()%amt;
		if(rand()%2)
			kickamt *= -1;
		ent->client->kick_angles[i] = kickamt;
	}
}


// *************************************************
//   snap, begin new respawn_breakables functions
// *************************************************

// this function will respawn a pushable chair
void respawn_chair (edict_t *self)
{
	// move the item back to where it's supposed to be if it was moved
	int temp;
	for(temp = 0; temp < 3; temp++){
		if(self->s.origin[temp] != self->map_origin[temp])
			self->s.origin[temp] = self->map_origin[temp];
	}
	VectorCopy(self->s.origin, self->save_avel);

	// reset everything else and make it visible
	self->solid = SOLID_BBOX;
	self->movetype = MOVETYPE_STEP;
	self->svflags &= ~SVF_NOCLIENT;
	self->takedamage = DAMAGE_YES;
	self->health = self->max_health;
	self->think = M_droptofloor;
	self->nextthink = level.time + 2 * FRAMETIME;

}

// this function will respawn a func_explosive ent
void respawn_funcexp (edict_t *self)
{
	self->svflags &= ~SVF_NOCLIENT;
	self->takedamage = DAMAGE_YES;
	self->solid = SOLID_BSP;
	self->health = self->max_health;
}

// this function will respawn an ammobox
void respawn_ammobox (edict_t *self)
{

	self->solid = SOLID_BBOX;
	self->movetype = MOVETYPE_NONE;
	self->svflags &= ~SVF_NOCLIENT;
	self->takedamage = DAMAGE_YES;
	self->health = self->max_health;

}

// relocks the door
void respawn_triggerunlock (edict_t *self){
	self->key = -1;
}

// this function will respawn broken breakable props
void respawn_breakables ()
{
	int i;

	for(i = 1; i <= level.num_ent_respawn; i++){
		switch(level.ent_to_respawn[i].ent_type)
		{
			case FUNCEXP:
				respawn_funcexp (level.ent_to_respawn[i].ent);
//				gi.dprintf ("respawning FUNCEXP entity. item number %d\n", i);
				break;
			case CHAIR:
				respawn_chair (level.ent_to_respawn[i].ent);
//				gi.dprintf ("respawning CHAIR entity. item number %d\n", i);
				break;
			case AMMOBOX:
				respawn_ammobox (level.ent_to_respawn[i].ent);
//				gi.dprintf ("respawning AMMOBOX entity. item number %d\n", i);
				break;
			case UNLOCK:
				respawn_triggerunlock (level.ent_to_respawn[i].ent);
//				gi.dprintf ("respawning UNLOCK entity. item number %d\n", i);
				break;
			default:
				break;
		}

	}

	level.num_ent_respawn = 0;
}


// adds entity to end of array
void add_ent_to_array(edict_t *thing){
	level.ent_to_free[++level.num_ent_free].ent = thing;
	thing->freenum = level.num_ent_free;	
}


// removes the entity from the ent to free array
// this is done when freeedict is called on the 
// ent before the entire array is freed
void remove_ent_from_array(edict_t *thing){

	int i;

	for(i=thing->freenum; i < level.num_ent_free; i++){
		level.ent_to_free[i].ent = level.ent_to_free[i+1].ent;
		level.ent_to_free[i].ent->freenum = i;
	}

	level.num_ent_free--;
}


// this freeedict doesnt do the ent_to_free array checking
void G_FreeEdict_2 (edict_t *ed)
{
	// Ridah, fixes Rockets crashing SR1
	if (ed->character_index)
		level.characters[ed->character_index] = NULL;

	gi.unlinkentity (ed);		// unlink from world

	if ((ed - g_edicts) <= (maxclients->value + BODY_QUEUE_SIZE))
	{
//		gi.dprintf("tried to free special edict\n");
		return;
	}

	memset (ed, 0, sizeof(*ed));
	ed->classname = "freed";
	ed->freetime = level.time;
	ed->inuse = false;
	ed->freenum = 0;
}


void free_dropped_ents ()
{
	int i;

	// array pos 0 is always not used
	for(i = 1; i <= level.num_ent_free; i++){
//		// snap, for debug purposes
//		gi.bprintf(PRINT_HIGH,"free dropped edict classname: %s\n", level.ent_to_free[i].ent->classname);
		G_FreeEdict_2(level.ent_to_free[i].ent);
	}

	level.num_ent_free = 0;
}

// *************************************************
//   snap, end new respawn_breakables functions
// *************************************************

// snap, this function will pick a new VIP
void Assign_VIP()
{
	edict_t	*doot;
	int i;
	int team_1_players = 0;
	int number_past_vips = 0;

	// count players and past vips on team 1 and make sure things are setup properly
	for_each_player (doot,i)
	{
		if(doot->client->pers.team == 1){
			team_1_players++;
			if(doot->pastVIP == TRUE)
				number_past_vips++;
		}
		else{
			doot->pastVIP = FALSE;
		}
		doot->crashType = CRASH_NORMAL;  // reset all players
	}

	// reset team 1's past VIP status if everyone has been a vip already
	if(team_1_players == number_past_vips){
		for_each_player (doot,i)
		{
			if(doot->client->pers.team == 1)
				doot->pastVIP = FALSE;
		}
	}

	// figure out who we need to assign VIP status to, and do it
	for_each_player (doot,i)
	{
		if(doot->client->pers.team == 1 && doot->pastVIP == FALSE){
			doot->crashType = CRASH_VIP;
			doot->pastVIP = TRUE;
			gi.bprintf (PRINT_HIGH, "%s Is The VIP!\n", doot->client->pers.netname);
			return;
		}
	}
}

// snap, this function will pick a new BOMBHOLDER
//		note: pastVIP is used to note if the client has been a bomber already on this map
void Assign_BOMBHOLDER()
{
	edict_t	*doot;
	int i;
	int team_2_players = 0;
	int number_past_bombers = 0;

	// count players and past bombholders on team 2 and make sure things are setup properly
	for_each_player (doot,i)
	{
		if(doot->client->pers.team == 2){
			team_2_players++;
			if(doot->pastVIP == TRUE)
				number_past_bombers++;
		}
		else{
			doot->pastVIP = FALSE;
		}
		doot->crashType = CRASH_NORMAL; // reset all players
	}

	// reset team 2's past VIP status if everyone has been a bombholder already
	if(team_2_players == number_past_bombers){
		for_each_player (doot,i)
		{
			if(doot->client->pers.team == 2)
				doot->pastVIP = FALSE;
		}
	}

	// figure out who we need to assign Bomber status to, and do it
	for_each_player (doot,i)
	{
		if(doot->client->pers.team == 2 && doot->pastVIP == FALSE){
			doot->crashType = CRASH_BOMBHOLDER;
			doot->pastVIP = TRUE;
			gi.bprintf (PRINT_HIGH, "%s Has The Bomb!\n", doot->client->pers.netname);
			return;
		}
	}
}