//CTF.h - includes for Capture The Flag

#include "Harpoon.h"

#define CTF_CODE_VERSION 111

#define CTF_CAPTURE_FLASH_TIME 5
#define CTF_CRASHED_PLAYER_CHECK_DELAY 50 //10 server thinks = 1 second

#define CTF_POINTS_TAKE_ENEMY_FLAG 2		//stole from base
#define CTF_POINTS_CAPTURE_ENEMY_FLAG 5		//returned enemy flag to own base (this is added to team capture bonus for total award)
#define CTF_POINTS_PICKUP_ENEMY_FLAG 1		//picked enemy flag up after someone dropped it
#define CTF_POINTS_RESCUE_OWN_FLAG 1		//rescued own flag
#define CTF_POINTS_CARRIER_KILL_BONUS 2		//killed flag carrier
#define CTF_POINTS_FLAG_PROTECT_BONUS 1		//protected own flag at base
#define CTF_POINTS_TEAM_CAPTURE_BONUS 0		//team points for capture
#define CTF_POINTS_HOMERUN_BONUS 5			//player took enemy flag from base to base - skill bonus

#define FLAG_RETURN_DELAY 300 //time in flag thinks (*0.1 - 300 = 30 seconds)
#define FLAG_THINK_TIME 0.1f //time between each flag think

//Spawn point array
#define MAX_SPAWN_SLOTS 64

//Valid model type
typedef enum _Cast_Type_Def
{
	CAST_TYPE_NULL = 0,
	CAST_TYPE_BITCH,
	CAST_TYPE_THUG,
	CAST_TYPE_RUNT,
	CAST_TYPE_FORCE_DWORD = 0xffffffff
} Cast_Type_Def;

typedef struct _Spawn_Slot_Def
{
	edict_t* Point;		//Pointer to an info_player_deathmatch entity
	float Distance[2];	//Distance to the flags - 0 = team 1, 1 = team 2
} Spawn_Slot_Def;

typedef struct _Spawn_Array_Def
{
	Spawn_Slot_Def Slot[MAX_SPAWN_SLOTS];	//Array of info_player_deathmatch entities for the team
	Spawn_Slot_Def* Slot_Pointer;			//Pointer to the next free storage slot
	int Num_Occupied;						//Number of stored entities
} Spawn_Array_Def;

typedef struct
{
	int team_score[2];
	float capture_time[2];
	int CrashedPlayerCheckTime;
//Flag model indices. These are team1, team2
	int Flag_Model_Index[2];
//Flag sounds
	int Flag_Capture_Sound;		//Played when a flag has been taken to enemy base while their flag there
	int Flag_Return_Sound;		//Played when a flag is returned to its base - either bu player or auto
	int Flag_Steal_Sound;		//Played when a flag is stolen from the base
//Harpoon override. If non-zero, players will not be given a harpoon at spawn time even if the server allows it
	qboolean Harpoon_Enable_Override;
} CTF_Game_Struct;

#define CTF_DATA_FLAG_STATE_NULL 0
#define CTF_DATA_FLAG_STATE_CAPTURED 1
#define CTF_DATA_FLAG_STATE_PICKEDUP 2

typedef struct
{
	qboolean VersionTested;//Has version checking been done?
//Player flag carry state - uses bitwise OR if more than 1 state stored
	int Flag_State;

	int Frags;//separate frag count since resp.score is needed to display total

//Really just for player stats (in case they're used sometime....)
	int Enemy_Flag_Stolen;				//How many stolen from enemy base
	int Enemy_Flag_Stolen_Captures;		//How many stolen from enemy base and captured
	int Enemy_Flag_Pickups;				//How many picked up away from base
	int Enemy_Flag_Pickup_Captures;		//How many picked up away from base and captured
	int Enemy_Flag_Total_Captures;		//Total enemy flag returns to home base (Stolen + Pickup captures)
	int Team_Flag_Rescued;				//How many own flag returned to home base after being picked up
} CTF_Player_Struct;

typedef struct _CTF_Flag_Struct
{
	qboolean Dropped;//Has someone dropped it?
	int ReturnTimer;//Its been dropped - counter for auto-return to base
} CTF_Flag_Struct;

typedef enum _RespawnType
{
	CTF_FLAG_RESPAWN_NULL = 0x00,
	CTF_FLAG_RESPAWN_RESCUED,
	CTF_FLAG_RESPAWN_CAPTURED,
	CTF_FLAG_RESPAWN_DROPPED,
	CTF_FLAG_RESPAWN_MATCH_START,
	CTF_FLAG_RESPAWN_PLAYER_CRASHED,
	CTF_FLAG_RESPAWN_OUT_OF_RANGE
} Respawn_Type;

typedef enum _TeamNameType
{
	TEAMNAME_NULL = 0x00,
	TEAMNAME_OWNTEAM,
	TEAMNAME_OTHERTEAM
} TeamNameType;

typedef enum _Version_Check_State
{
	CLIENT_FILES_NULL = 0x00,
	CLIENT_FILES_NONE,
	CLIENT_FILES_OLD
} Version_Check_State;

//CTF player skins
#define NUM_BITCH_SKINSETS 2
#define NUM_THUG_SKINSETS 2
#define NUM_RUNT_SKINSETS 2

typedef struct _Model_Skin_Set_Def
{
	char* Legs;
	char* Body;
	char* Head;
} Model_Skin_Set_Def;

//Misc
extern char* Address_URL;
extern cvar_t *URL1;
extern cvar_t *capture_limit;
extern cvar_t* spawn_ratio;

extern CTF_Game_Struct CTF_Game;
extern char CTF_Version_Command[];
extern char CTF_Pain_Skins_Command[];

extern char* CTF_Flag_Model_Array[];

//CTF
extern edict_t *SelectRandomDeathmatchSpawnPoint(edict_t *ent);
extern float PlayersRangeFromSpot(edict_t *spot);

//CTF_Flag
extern void CTF_Flag_Initialise(void);
extern void CTF_Crashed_Player_Check(void);
extern void CTF_Flag_Player_Throw(edict_t *ent);
extern edict_t* CTF_Flag_Find(int Team);

//CTF_Spawn
extern edict_t* CTF_Player_Spawn_Point_Select(edict_t *ent);
extern void CTF_Spawn_Initialise(void);
extern void CTF_Spawn_Store_Entity(edict_t* ent);
extern qboolean CTF_Spawn_Points_Range(void);

//CTF_Main
extern void CTF_Initialise_Level(void);
extern void CTF_Initialise_Game(void);
extern void CTF_Check_Award_Defend_Bonus(edict_t *target, edict_t *attacker);
extern qboolean CTF_Check_Award_Kill_Bonus(edict_t *target, edict_t *attacker);
extern void CTF_Match_Start_Reset_Flags(void);
extern void CTF_Player_Data_Reset(edict_t* ent);
extern void CTF_Effects(edict_t *ent);

extern void CTF_Precache_Items(gclient_t *client);
extern void CTF_Version_Check(edict_t *ent);
extern void CTF_Version_Check_Fail(edict_t *ent, Version_Check_State Reason);
extern void CTF_Pain_Skins_Check(edict_t *ent);
extern void Cmd_SetCaptureLimit_f(edict_t *ent, char *value);

//CTF_Stats
extern void CTF_Stats_Team(edict_t *ent, int Team);
extern void CTF_Cmd_Score_f(edict_t *ent);
extern void CTF_DeathmatchScoreboard(edict_t *ent);

//P_CLIENT
extern void ClientUserinfoChanged(edict_t *ent, char *userinfo);
extern void nameclash_think(edict_t *self);
extern void maxrate_think(edict_t *self);

//Harpoon
extern void P_ProjectSource(gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
extern qboolean CheckTeamDamage(edict_t *targ, edict_t *attacker);
extern void Weapon_Generic(edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void(*fire)(edict_t *ent));

//GAME END
extern int CTF_Check_Rules(void);

//g_spawn
extern void SP_CTF_Dummy(edict_t *self);
extern void SP_CTF_Flag(edict_t *self);

//p_hud
extern int GetChaseMessage(edict_t *ent, char *entry);

extern void MOTDScoreboardMessage(edict_t *ent);
extern void RejoinScoreboardMessage(edict_t *ent);
extern void SpectatorScoreboardMessage(edict_t *ent);
extern void VoteMapScoreboardMessage(edict_t *ent);
extern void GrabDaLootScoreboardMessage(edict_t *ent);

//CTF_Xmas
extern void CTF_Xmas_Remap_Cast_Skins(Cast_Type_Def Cast, char *Head, char *Body, char *Legs);
extern Model_Skin_Set_Def* CTF_Xmas_Get_Random_Bitch_Skin(int Team);
extern Model_Skin_Set_Def* CTF_Xmas_Get_Random_Thug_Skin(int Team);
extern Model_Skin_Set_Def* CTF_Xmas_Get_Random_Runt_Skin(int Team);

extern void CTF_Xmas_Level_End_Music(void);
extern void SP_christmas_snowman_thug(edict_t *self);
extern void SP_christmas_snowman_runt(edict_t *self);
