
//
// This will load a set of ini file variables into the games variables for
// changing the settings between levels.
//
#include "g_local.h"

// Variables and defines go here.

int			test1		= false; 	// 
int			test2		= 10;		// 

//
// Level ini file parameters.
//
typedef struct
{
	char	*ident;				// Name of the variable in the ini file 
	int		*variable;			// Pointer to the game variable
	int		MinVariable;		//
	int		MaxVariable;		// I think these are a bit obvious don't you
	int		DefaultVariable;	//
} LEVEL_INI_OPTION;

LEVEL_INI_OPTION	LevelSettings[] = 

//	Noraml options go here just incase something gets screwed up

	{	{"test1",		&test1,	0,1,1},
		{"test2",		&test2,	6,100,10}
	};

#define MAX_LEVEL_OPTIONS (sizeof(LevelSettings)/sizeof(LevelSettings[0]))

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void LoadLevelSettings( char *LevelName )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	int		IniOption = 0, Processed = 0;
	char	Buffer[256], Filename[256], FullPathname[256];
	char	*VariableName = NULL, *VariableValue = NULL;

	strcpy( Filename, LevelName );
	strcat( Filename, ".ini" );

	game_dir = gi.cvar ("game", "", 0);

    sprintf(FullPathname, ".\\%s\\%s", game_dir->string, Filename);

	// open the *.ini file

	if ((f = fopen (FullPathname, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s. Using defaults.\n", LevelName);
		return;
		}

	gi.dprintf("\nProcessing %s settings\n", LevelName);

	// read 256 characters or until we get to the eof or a return for a newline.

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// Get the variable name, skipping spaces, tabs, and newlines.

			VariableName	= strtok(Buffer, " \t\n");
			IniOption	= 0;

			// If we haven't processed the maximum number of options then keep going
			while (IniOption < MAX_LEVEL_OPTIONS)
				{

				// Find this option in the array of options, if we don't find it tough

				if (!strcmp(VariableName, LevelSettings[IniOption].ident))
					{

					// Using NULL will continue the search for the value from where the previous
					// strtok for the variable name left off.
					VariableValue = strtok(NULL, " \t\n#");

					// This will set the value in the array using string value to integer conversion
					*LevelSettings[IniOption].variable = atoi(VariableValue);

					Processed++;
					break;
					}

				IniOption++;
				}
			}
		}

	gi.dprintf("%d Level settings processed\n", Processed);
	fclose (f);
	}

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void VerifyLevelIniValues( void )
	{	
	int	Loop;

	for ( Loop=0; Loop<MAX_LEVEL_OPTIONS; Loop++ )
		{

		// If the value which has been set isn't in the normal range then
		// set it to a default value.

		if ((*LevelSettings[Loop].variable < LevelSettings[Loop].MinVariable) ||
			(*LevelSettings[Loop].variable > LevelSettings[Loop].MaxVariable))
			{
			*LevelSettings[Loop].variable = LevelSettings[Loop].DefaultVariable;
			}
		}
	}


typedef struct   // Message of the Day
	{
	char textline[100];
	} MOTD_t;

	MOTD_t	MOTD[20];

void MOTDScoreboardMessage (edict_t *ent)
	{
	FILE*	infile;		// Config file to be opened
	char	mapname[64];
	char	entry[1024];
	char	string[1400];
	char	temp[128];
	int		stringlength;
	int		i, j;
	int		yofs;
	int			found;
	edict_t		*player;
//	char		*seperator = "=============================";
	char		*seperator = "+++++++++++++++++++++++++++++";

	char	*selectheader[] =
			{
			"Atrophy Presents",
			"HITMEN v1.0",
			"By Rat Instinct",
			"www.planetkingpin.com/atrophy",
			NULL
			};


	string[0] = 0;
	stringlength = 0;

//	yofs = 80 - game.num_MOTD_lines * 10;
	yofs = 80 - 3 * 10;
	if (yofs < 0 )
		yofs = 0;

	for (i=0; selectheader[i]; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 752 \"%s\" ",
			-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		yofs += 20;
		}

	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;
	yofs += 30;


	for (i=0; i<3 /*game.num_MOTD_lines*/; i++)
		{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 842 \"%s\" ",
			-5*strlen(MOTD[i].textline), yofs + (int)(-60.0+-3.5*14), MOTD[i].textline );

		j = strlen(entry);
		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}

		yofs += 20;
		}

	yofs += 10;
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + (int)(-60.0+-3.5*14), seperator );

	j = strlen(entry);

	if (stringlength + j < 1024)
		{
		strcpy (string + stringlength, entry);
		stringlength += j;
		}

	yofs += 30;

//	Com_sprintf (mapname, sizeof(mapname), "comp/%s.txt",level.mapname);	
//	infile = fopen(mapname, "r");

	infile = NULL;

/*	if (infile == NULL)
		{
		if ((int)teamplay->value == 0)
			Com_sprintf (temp, sizeof(temp), "This server is running Standard Deathmatch");
		else if ((int)teamplay->value == 1)
			Com_sprintf (temp, sizeof(temp), "This server is running Bagman");
		else if ((int)teamplay->value == 4)
			Com_sprintf (temp, sizeof(temp), "This server is running Team Deathmatch");

		Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
			-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
		yofs += 20;
		j = strlen(entry);

		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}

		if (level.modeset == FREEFORALL)
			if (teamplay->value)
				Com_sprintf (temp, sizeof(temp), "The Game will start soon. Please even the Teams!");
			else
				Com_sprintf (temp, sizeof(temp), "The Game will start soon.");
			else if (level.modeset == MATCH)
				Com_sprintf (temp, sizeof(temp), "in Match Mode. (Please don't join).");
			else if (level.modeset == MATCHSETUP)
				Com_sprintf (temp, sizeof(temp), "in Match Setup Mode.");
			else if (level.modeset == FINALCOUNT)
				Com_sprintf (temp, sizeof(temp), "and is in the Final Countdown before a Match.");
			else if (level.modeset == TEAMPLAY)
				Com_sprintf (temp, sizeof(temp), "in Public Mode, so please join in.");


		Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
			-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
		yofs += 20;
		j = strlen(entry);

		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}


		i=0;
		found = false;
		while ((!found) && (i<maxclients->value)) 
			{
			player = g_edicts + 1 + i;
			i++;
			if (!player->inuse)
				continue;
			if (player->client->pers.admin > NOT_ADMIN)
				found = TRUE;
			}

		if (found)
			Com_sprintf (temp, sizeof(temp), "Your admin is %s",player->client->pers.netname);
		else
			Com_sprintf (temp, sizeof(temp), "No one currently has admin");

		Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
			-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
		j = strlen(entry);

		if (stringlength + j < 1024)
			{
			strcpy (string + stringlength, entry);
			stringlength += j;
			}
		}
	else
		{
//		fgetline(infile, temp);

		while (!feof(infile))	// while there's still stuff
			{
			Com_sprintf (entry, sizeof(entry), "xm %i yv %i dmstr 874 \"%s\" ",
				-5*strlen(temp), yofs + (int)(-60.0+-3.5*14), temp );
			j = strlen(entry);

			if (stringlength + j < 1024)
				{
				strcpy (string + stringlength, entry);
				stringlength += j;
				}

			fgetline(infile, temp);
			yofs += 20;
			}
		}*/

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

	}

