/*****************************************************************************

  b_debug.c - Debug print instructions

  Contains bot-safe print routines. These prints don't show up to bots, in
  order to prevent them overflowing. Note that these are put in stack for
  later delivery and may result in an overflow when stuffing long messages;
  use gi.dprintf() when printing out tons of text.
  
  From Steve Yeager's notes: all id code needs to be changed to these so the
  bots do not blow up on messages sent to them. Do a find and replace on all
  code that matches the below criteria (got the basic idea from Ridah)

  change: gi.cprintf to safe_cprintf
  change: gi.bprintf to safe_bprintf
  change: gi.centerprintf to safe_centerprintf

*****************************************************************************/

#include "g_local.h"
#if compileJACKBOT

	//
	// output log
	//
	void safe_fileprint(char *fmt)
		{
		FILE	      *pOut;
		static int  x = 1;

		pOut = fs_fileOpen("botlog.txt", "a");
		if (!pOut)
			return;
		if (x)
			{
			fprintf(pOut, "\n\n==== N E W   S E S S I O N ====\n\n");
			x = 0;
			}
		fprintf(pOut, fmt);
		fclose(pOut);
		}

	//
	// botsafe cprintf (client print)
	//
	void safe_cprintf (edict_t *ent, int printlevel, char *fmt, ...)
		{
		int			len;
		char	  bigbuffer[MAX_STRING_CHARS];
		va_list argptr;

		if (ent && (!ent->inuse || ent->botInfo))
			return;

		va_start(argptr, fmt);
		len = vsprintf(bigbuffer, fmt, argptr);
		va_end(argptr);

		gi.cprintf(ent, printlevel, bigbuffer);

		if (jb_Debug & BOTDEBUG_LOGFILE)
			safe_fileprint(bigbuffer);
		}

	//
	// botsafe centerprintf (client, center print)
	//
	void safe_centerprintf (edict_t *ent, char *fmt, ...)
		{
		int			len;
		char	  bigbuffer[MAX_STRING_CHARS];
		va_list argptr;

		if (ent && (!ent->inuse || ent->botInfo))
			return;

		va_start(argptr, fmt);
		len = vsprintf(bigbuffer, fmt, argptr);
		va_end(argptr);

		gi.centerprintf(ent, bigbuffer);

		if (jb_Debug & BOTDEBUG_LOGFILE)
			safe_fileprint(bigbuffer);
		}

	//
	// botsafe bprintf (bulk print)
	//
	void safe_bprintf (int printlevel, char *fmt, ...)
		{
		int	  len;
		char	  bigbuffer[MAX_STRING_CHARS];
		va_list argptr;
		int	  i;
		edict_t *cl_ent;

		va_start(argptr, fmt);
		len = vsprintf(bigbuffer, fmt, argptr);
		va_end(argptr);

		if (dedicated->value)
		gi.cprintf(NULL, printlevel, bigbuffer);

		for (i = 0; i < maxclients->value; i++)
			{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse || cl_ent->botInfo)
				continue;

			gi.cprintf(cl_ent, printlevel, bigbuffer);
			}

		if (jb_Debug & BOTDEBUG_LOGFILE)
		safe_fileprint(bigbuffer);
		}

	//
	// Debug print (same as bulk print, only forces PRINT_MEDIUM)
	//
	void debug_printf(char *fmt, ...)
		{
		int			len;
		char	  bigbuffer[MAX_STRING_CHARS];
		va_list argptr;
		int			i;
		edict_t *cl_ent;

		va_start(argptr, fmt);
		len = vsprintf(bigbuffer, fmt, argptr);
		va_end(argptr);

		if (dedicated->value)
		gi.cprintf(NULL, PRINT_MEDIUM, bigbuffer);

		for (i = 0; i < maxclients->value; i++)
			{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse || cl_ent->botInfo)
				continue;
			gi.cprintf(cl_ent, PRINT_MEDIUM, bigbuffer);
			}

		if (jb_Debug & BOTDEBUG_LOGFILE)
			safe_fileprint(bigbuffer);
		}


	//
	// bot think print
	//
	void botprint (edict_t *bot, char *fmt, ...)
		{
		int			len;
		char	  bigbuffer[MAX_STRING_CHARS];
		va_list argptr;

		if (!(bot->botInfo->def.flags & BOTFLAG_THINK))
			return;

		va_start(argptr, fmt);
		len = vsprintf(bigbuffer, fmt, argptr);
		va_end(argptr);

		gi.dprintf("%s: %s", bot->client->pers.netname, bigbuffer);
  
		if (jb_Debug & BOTDEBUG_LOGFILE)
			safe_fileprint(bigbuffer);
		}

	void botDebugFlags(edict_t *bot)
		{
		static int prev = -1;
		if (!(bot->botInfo->def.flags & BOTFLAG_THINK))
			return;

		if (prev == bot->botInfo->state)
			return;

		gi.dprintf("NEW BOT STATE FOR %s\n", bot->client->pers.netname);

		gi.dprintf("  Lift Wait: ");
		if (bot->botInfo->state & BOTSTATE_ELEVATOR_WAIT)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("  Lift Ride: ");
		if (bot->botInfo->state & BOTSTATE_ELEVATOR_RIDE)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("Follow Path: ");
		if (bot->botInfo->state & BOTSTATE_FOLLOWPATH)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("       Flee: ");
		if (bot->botInfo->state & BOTSTATE_FLEE)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("       Camp: ");
		if (bot->botInfo->state & BOTSTATE_WEAPON_WAIT)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("Investigate: ");
		if (bot->botInfo->state & BOTSTATE_INVESTIGATE)
			gi.dprintf("YES\n");
		else
			gi.dprintf("NO\n");

		gi.dprintf("\n");

		prev = bot->botInfo->state;
		}


#endif

