#include "g_local.h"
#if compileJACKBOT

	/******************************************************************************
   
		 Can we get there?

	******************************************************************************/
	// also check the height difference (if too high to jump to, ignore)
	qboolean botAI_isReachable(edict_t *self, vec3_t goal)
		{
		vec3_t v;

		VectorCopy(self->mins, v);
		v[2] += BOTMOVE_STEPSIZE;

		return (gi.trace(self->s.origin, v, self->maxs, goal, self, CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_SLIME | CONTENTS_LAVA | CONTENTS_PLAYERCLIP).fraction == 1.00);
		}



	/******************************************************************************
    
			Change weapon (if available) -- Move to another file. Maybe b_attack.c?

	******************************************************************************/
	qboolean botAI_changeWeapon(edict_t *ent, int itemIndex)
		{
		gitem_t *item;

		// Just to make sure
		if ((itemIndex < 0) || (itemIndex >= MAX_ITEMS))
			return false;

		// If we don't have the gun, bail
		if (!ent->client->pers.inventory[itemIndex])
			return false;

		item = &itemlist[itemIndex];
				
		// switch if we're not already using it
		if (item != ent->client->pers.weapon)
			ent->client->newweapon = item;

		return true;
		}


	/******************************************************************************

	  Get mod weight

	******************************************************************************/
	float weight_modWeight(edict_t *self, int item)
		{	
		// MOD TYPE //
		if (!Q_stricmp(itemlist[item].classname, "pistol_mod_rof"))
			{
			if (self->client->pers.pistol_mods & WEAPON_MOD_ROF)
				return (0.00);
			}
		else if (!Q_stricmp(itemlist[item].classname, "pistol_mod_reload"))
			{
			if (self->client->pers.pistol_mods & WEAPON_MOD_RELOAD)
				return (0.00);
			}
		else if (!Q_stricmp(itemlist[item].classname, "pistol_mod_damage"))
			{
			if (self->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
				return (0.00);
			}
		else if (!Q_stricmp(itemlist[item].classname, "hmg_mod_cooling"))
			{
			if ((self->client->pers.pistol_mods & WEAPON_MOD_COOLING_JACKET) && (self->client->pers.hmg_shots == 30))
				return (0.00);
			}

		// RANKING //
		if ((itemlist[item].botItemWeap == wPistol) || (itemlist[item].botItemWeap == wTommyGun) || (itemlist[item].botItemWeap == wMeta_BulletGun))
			{
			if (self->botInfo->def.rankWeight[wPistol] > self->botInfo->def.rankWeight[wTommyGun])
				return (self->botInfo->def.rankWeight[wPistol]);
			return (self->botInfo->def.rankWeight[wTommyGun]);
			}
		return (self->botInfo->def.rankWeight[itemlist[item].botItemWeap]);
		}
		
	/******************************************************************************

	  Get ammo weight (also used for already owned weapons)

	******************************************************************************/
	float weight_ammoWeight(edict_t *self, int item)
		{
		float ammoNow;
		float ammoMax;
		float ammoRank;

		// MELEE //
		if ((itemlist[item].botItemFlag & botItem_Weapon) && (!itemlist[item].ammo))
			return (0.00);

		// HANDLING BULLETS //
		if ((itemlist[item].botItemWeap == wPistol) || (itemlist[item].botItemWeap == wTommyGun) || (itemlist[item].botItemWeap == wMeta_BulletGun))
			{
			// rank
			if (self->botInfo->def.rankWeight[wPistol] > self->botInfo->def.rankWeight[wTommyGun])
				ammoRank = self->botInfo->def.rankWeight[wPistol];
			else
				ammoRank = self->botInfo->def.rankWeight[wTommyGun];
			// current stock
			ammoNow	= (float)self->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))];
			// maximum stock
			ammoMax	= (float)self->client->pers.max_bullets;
			}

		// HANDLING ANY OTHER TYPE OF AMMO //
		else
			{
			// rank
			ammoRank = self->botInfo->def.rankWeight[itemlist[item].botItemWeap];
			// current stock
			if (itemlist[item].botItemFlag & botItem_Weapon)
				ammoNow	= (float)self->client->pers.inventory[ITEM_INDEX(FindItem(itemlist[item].ammo))];
			else
				ammoNow = (float)self->client->pers.inventory[ITEM_INDEX(FindItem(itemlist[item].pickup_name))];
			// maximum stock
			if (itemlist[item].botItemWeap == wShotgun)
				ammoMax = (float)self->client->pers.max_shells;
			else if (itemlist[item].botItemWeap == wHeavyMachineGun)
				ammoMax = (float)self->client->pers.max_308cal;
			else if (itemlist[item].botItemWeap == wGrenadeLauncher)
				ammoMax = (float)self->client->pers.max_grenades;
			else if (itemlist[item].botItemWeap == wRocketLauncher)
				ammoMax = (float)self->client->pers.max_rockets;
			else if (itemlist[item].botItemWeap == wFlamethrower)
				ammoMax = (float)self->client->pers.max_gas;
			}

		// HOW ATTACTIVE IT IS //
		/*if (itemlist[item].botItemFlag & botItem_Weapon)
			gi.dprintf("WEAP: %s: ((1.00 - (%f / %f)) * %f)\n", itemlist[item].classname, ammoNow, ammoMax, ammoRank);
		else
			gi.dprintf("AMMO: %s: ((1.00 - (%f / %f)) * %f)\n", itemlist[item].classname, ammoNow, ammoMax, ammoRank);*/
		return ((1.00 - (ammoNow / ammoMax)) * ammoRank);
		}

	/**************************************************************
	
		How interested in armor the bot is. The older code uses tons
		of broken functions. For instance, there's a line invoking
		ArmorIndex(other), which always return 0. I don't believe
		someone would have used this function UNLESS it is a copy
		and paste from some other code; I don't trust the original
		code one bit.

	**************************************************************/
	void inventoryArmor(edict_t *self, int *head, int *torso, int *legs)
		{
		int ownedArmor;

		// GET HELMET //
		if (head)
			{
			*head = 0;
			ownedArmor = ITEM_INDEX(FindItem("Helmet Armor"));
			if (self->client->pers.inventory[ownedArmor])
				*head = self->client->pers.inventory[ownedArmor];
			else
				{
				ownedArmor = ITEM_INDEX(FindItem("Helmet Armor Heavy"));
				if (self->client->pers.inventory[ownedArmor])
					*head = self->client->pers.inventory[ownedArmor];
				}
			}
		
		// GET JACKET //
		if (torso)
			{
			*torso = 0;
			ownedArmor = ITEM_INDEX(FindItem("Jacket Armor"));
			if (self->client->pers.inventory[ownedArmor])
				*torso = self->client->pers.inventory[ownedArmor];
			else
				{
				ownedArmor = ITEM_INDEX(FindItem("Jacket Armor Heavy"));
				if (self->client->pers.inventory[ownedArmor])
					*torso = self->client->pers.inventory[ownedArmor];
				}
			}

		// GET LEGS //
		if (legs)
			{
			*legs = 0;
			ownedArmor = ITEM_INDEX(FindItem("Legs Armor"));
			if (self->client->pers.inventory[ownedArmor])
				*legs = self->client->pers.inventory[ownedArmor];
			else
				{
				ownedArmor = ITEM_INDEX(FindItem("Legs Armor Heavy"));
				if (self->client->pers.inventory[ownedArmor])
					*legs = self->client->pers.inventory[ownedArmor];
				}
			}
		}



	float weight_armorWeight(edict_t *self, int item)
		{
		gitem_t				*it;
		int						floorArmor;
		int						ownedArmor;
		float					ownedStrength;
		char					typeLo[MAX_INFO_VALUE];
		char					typeHi[MAX_INFO_VALUE];

		// What's on the floor?
		it = &itemlist[item];
		floorArmor			= item;

		// Check armor type
		if (it->botItemFlag & botItem_Helmet)
			sprintf(typeLo, "Helmet Armor");
		else if (it->botItemFlag & botItem_Jacket)
			sprintf(typeLo, "Jacket Armor");
		else if (it->botItemFlag & botItem_Legs)
			sprintf(typeLo, "Legs Armor");
		else
			return (0.00);

		// Get current protection (heavy overwrites standard on pickup)
		ownedArmor = ITEM_INDEX(FindItem(typeLo));
		if (self->client->pers.inventory[ownedArmor])
			ownedStrength		= self->client->pers.inventory[ownedArmor];

		else
			{
			sprintf(typeHi, "%s Heavy", typeLo);
			ownedArmor			= ITEM_INDEX(FindItem(typeHi));
			ownedStrength		= self->client->pers.inventory[ownedArmor];
			}

		// Worthless pick up
		if (ownedStrength == 100)
			return (0.00);

		return (((100 - ownedStrength) / 100) * self->botInfo->def.preserve);
		}



	/******************************************************************************

		 Get item weight (general function, redirects to various funcs as needed)

	******************************************************************************/
	float weight_itemWeight(edict_t *self, int item)
		{
		int botItemFlag;
		int botItemWeap;

		// Bail if you don't know what it is
		if ((item < 0) || (item >= MAX_ITEMS))
			return (0.00);
		botItemFlag = itemlist[item].botItemFlag;
		botItemWeap = itemlist[item].botItemWeap;

		// Medkits
		if (botItemFlag & botItem_Health)
			return ((1.00 - (((float)self->health) / ((float)self->max_health))) * (self->botInfo->def.preserve * 10));

		// Armors
		else if (botItemFlag & botItem_Armor)
			return (weight_armorWeight(self, item));

		// Weapons
		else if (botItemFlag & botItem_Weapon)
			{
			if (self->client->pers.inventory[item]) // I already own this gun; process like ammunitions
				return (weight_ammoWeight(self, item));
			return (self->botInfo->def.rankWeight[botItemWeap] + 0.10); // Make sure the weapon always wins when compared against ammunition
			}
		
		// Mods
		else if (botItemFlag & botItem_Mod)
			return (weight_modWeight(self, item));

		// Ammunitions
		else if (botItemFlag & botItem_Ammo)
			return (weight_ammoWeight(self, item));

		return (0.00);
		}

#endif