/*****************************************************************************

  b_local.h - Secondary header

  This header is included right after g_local.h; to make sure the file will
  properly be added and bots will be compiled, go to g_local.h and make sure
  the define "compileJACKBOT" is not NULL.

*****************************************************************************/

// TODO: write "go to last seen position"
// TODO: reaction time when spotting someone for the first time
// TODO: somehow, they stoppped looking for loot (weapon_xxx_e)
// TODO: create one server command (or a CVAR_SERVERINFO|CVAR_LATCH cvar) such as "botdev" and redirect all other commands to standard client-commands.
// TODO: bot talk? See Cmd_Say_f()
// TODO: Fix path_LinkCheckUp not alway showing up all networks.
// TODO: Bot team play (use proper skin, proper behavior as team member, etc.)

#ifndef JACKBOT_HEADER
  #define JACKBOT_HEADER

	#define UINT8 	unsigned char    
	#define UINT16	unsigned short int
	#define UINT32	unsigned int
	#define  INT16	signed short int
	#define  INT32	signed int

	#define doAimYaw		0x01
	#define doAimPitch	0x02
	#define doAimForce	0x04

	#define VectorSide2D(org, p1, p2) ((p2[0] - p1[0]) * (org[1] - p1[1]) - (p2[1] - p1[1]) * (org[0] - p1[0])) // 0: ALIGNED, <0 LEFT, >0 RIGHT
	#define VectorDistanceTaxicab(src, dst) (abs(src[0] - dst[0]) + abs(src[1] - dst[1]) + abs(src[2] - dst[2]))
	#define ValidNode(n) ((n > -1) && (n < jb_NumNodes))

	#if (compileTEST)
	#define getString( ofs )( ((char *)(jb_StringBank[ofs])) )
	#endif

	// Special masks for gi.trace (note: can't use CONTENTS_PLAYERCLIP because it seems to be triggered by entities too?!!)
	#define MASK_BOTBLOCK		(CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_PLAYERCLIP ) // Is solid, blocks path, safe to walk on
	#define MASK_BOTNOGO		(CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_LAVA | CONTENTS_SLIME) // Move detection, no go (dangerous or blocking)
	#define MASK_BOTREACH		(CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_LAVA | CONTENTS_SLIME | CONTENTS_LADDER ) // Used in ACEMV_CheckEyes
	#define MASK_BOTROCKET  (CONTENTS_SOLID | CONTENTS_WINDOW) // Trace rocket attack

  // Platform states (from g_func.h)
  #define STATE_TOP							    0
  #define STATE_BOTTOM							1
  #define STATE_UP									2
  #define STATE_DOWN								3

  // Nodes...
  #define BOTNODE_DIST_MIN					128			// Minimal distance
	#define BOTNODE_DIST_EXT					192			// Extended distance
	#define BOTNODE_DIST_MAX					65535 	// Maximum distance
	#define BOTNODE_MAX 							1024		// Maximum node count
	#define BOTNODE_INVALID 					-1			// Invalid node index (also used as a path breaker)
	
  // Bot state types
  #define BOTSTATE_ELEVATOR_WAIT		0x01	// Don't move
	#define BOTSTATE_ELEVATOR_RIDE		0x02	// Don't move
  #define BOTSTATE_FOLLOWPATH				0x04	// Move toward goal
  #define BOTSTATE_FLEE  						0x08	// While attacking, keep moving toward goal
	#define BOTSTATE_WEAPON_WAIT			0x10	// Wait for an item to respawn
	#define	BOTSTATE_INVESTIGATE			0x20	// Looking around when shot
	
  // Angle for surroundings testing
  #define BOTMOVE_LEFT							90
  #define BOTMOVE_RIGHT						 -90
  #define BOTMOVE_BACK						 -180
  #define BOTMOVE_FORWARD						0

	#define BOTMOVE_STEPSIZE					18 // Walkable step height
	#define BOTMOVE_JUMPSIZE					50 // Jump height
	#define BOTMOVE_CROUCHSIZE				48 // Crouch height
	

  // itemlist[]: items, as bot understands them (flags)
  #define botItem_Undefined					0x00000000
  #define botItem_Health						0x00000001
  #define botItem_Armor						  0x00000002
  #define botItem_Weapon						0x00000004
  #define botItem_Ammo							0x00000008
  #define botItem_Mod  							0x00000010
  #define botItem_Big								0x00000020
  #define botItem_MeleeWeapon				0x00000040
	#define	botItem_Helmet						0x00000080
	#define	botItem_Jacket						0x00000100
	#define	botItem_Legs  						0x00000200
	#define botItem_Cash     					0x00000400

  #define BOTDEBUG_LOGFILE					0x00000001  // debug flag, outputs console info in real time to botlog.txt
  #define BOTDEBUG_ROUTE						0x00000002  // debug flag, route debug and creation
	#define BOTDEBUG_NODEAREA					0x00000004  // debug flag, drawin a node area

  #define BOTFLAG_SLAVE 						0x00000001  // Bot doesn't look for stuff to do, do as told
  #define BOTFLAG_HOLSTER						0x00000002  // Bot doesn't shoot
	#define BOTFLAG_NOREACTION				0x00000004  // Bot doesn't react at all
	#define BOTFLAG_THINK							0x00000008	// Shows what the bot is thinking

  #define BOTSPEED_WALK							150
  #define BOTSPEED_RUN							400
  #define BOTSPEED_WATER						300

	#define VEHICLE_NONE							0						// How we can reach Y from X (bot can't)
	#define VEHICLE_WALK							1						// How we can reach Y from X (just walk)
	#define VEHICLE_JUMP							2						// How we can reach Y from X (bot needs to jump)
	#define VEHICLE_CROUCH						3						// How we can reach Y from X (bot needs to crouch)

	// Node types
	typedef enum
		{
		nMove				= 0x0001,
		nLadder			=	0x0002,
		nElevator		=	0x0004,
		nTeleporter	=	0x0008,
		nItem				=	0x0010,
		nWater			=	0x0020,
		nAirFall		=	0x0040,
		nAirJump		=	0x0080,
		nCashSpawn	= 0x0100,
		nAll				= 0xffff
		} botNodeEnum_t;
	
	// Node type
	typedef struct nodeType_s
		{
		char								*name;				// Node Name (used in WAY files)
		int									skinNum;			// Skin Number (for dummies)
		botNodeEnum_t				value;				// Node Value (faster and more reliable than Node Name)
		qboolean						linksEntity;	// Can Be Linked To Entities?
		int									krazeValue;		// Node Value (as used in KPR files)
		} nodeType_t;

	// For jump & duck tables
	typedef struct nodePair_s
		{
		short int						from;					// Vector start (node index)
		short int						to;						// Vector end (node index)
		} nodePair_t;

	// For link forcing
	typedef struct nodePair2_s
		{
		short int						from;					// Vector start (node index)
		short int						to;						// Vector end (node index)
		unsigned short 			vehicle;			// How to get there
		} nodePair2_t;

  // Node structure
  typedef struct botnode_s
	  {
	  vec3_t							origin;				// Node position
		nodeType_t					*type;				// Node type
	  } botnode_t;

  // Item table
  typedef struct itemLink_s
	  {
	  int									item;					// Item index (see ITEMLIST_# list)
	  edict_t							*ent;					// Pointer to entity 
		short int						node;					// Node this item is linked to
		int									turf;					// In what turf the item is located (0 for deathmatch, 1 for Team1, 2 for Team2)
	  } itemLink_t;

	// File system -- used when loading/saving WAY files
	typedef struct fs_NodeSave_s
		{
		unsigned short	nodeLabel;				// Offset in string bank
		unsigned short	entityLabel;			// Offset in string bank
		float						x;								// X position
		float						y;								// Y position
		float						z;								// Z position
		} fs_NodeSave_t;

	// File system -- chunks
	typedef struct fs_Chunk_s
	  {
		unsigned short int	label;				// Chunk Name
		unsigned short int	version;			// Chunk Version
		unsigned int				initial;			// Initial length (before compression)
		byte								padding;			// Size of padding (0 to 15)
		byte								*rleBuffer;		// Run-Length Encoding instructions
		unsigned int				rleLength;		// Length of the instruction block for RLE, in bytes
		byte								*wrBuffer;		// Word Repeat instructions
		unsigned int				wrLength;			// Length of the instruction block for WR, in bytes
		short int						*dataBuffer;	// Data buffer
		unsigned int				dataLength;		// Length of data buffer, in bytes
	  } fs_Chunk_t;

  // needed from original code (routines)
  void			ClientThink (edict_t *ent, usercmd_t *ucmd);
  void			SelectSpawnPoint (edict_t *ent, vec3_t origin, vec3_t angles);
  void			ClientUserinfoChanged (edict_t *ent, char *userinfo);
  void			CopyToBodyQue (edict_t *ent);
  qboolean	ClientConnect (edict_t *ent, char *userinfo);
  void			Use_Plat (edict_t *ent, edict_t *other, edict_t *activator);
	void			Cmd_Reload_f (edict_t *ent);
	void			DoRespawn (edict_t *ent);
	void			cash_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
	qboolean	Pickup_Cash (edict_t *ent, edict_t *other);

	// needed from original code (variables)
	extern int	auto_rounds[];

  // headers
  #include "b_ai.h"
	#include "b_chat.h"
  #include "b_cmds.h"
	#include "b_compress.h"
  #include "b_debug.h"
	#include "b_dummy.h"
	#include "b_edit.h"
  #include "b_filesys.h"
	#include "b_hooks.h"
  #include "b_items.h"
  #include "b_misc.h"
	#include "b_move_elevator.h"
	#include "b_move_ladder.h"
  #include "b_movement.h"
  #include "b_nodes.h"
	#include "b_pathing.h"
	#include "b_react.h"
  #include "b_sight.h"
	#include "b_spawn.h"
	#include "b_teamplay.h"
	   
	// Needed in b_cmds, b_filesys, b_items, b_movement, b_nodes
  extern short int			jb_ShowPathFrom;													// For debugging paths
  extern short int			jb_ShowPathTo;														// For debugging paths
  extern int						jb_NumNodes;															// Number of nodes on the map
	extern botnode_t			jb_Node[BOTNODE_MAX];											// Array for node data
  extern short int			jb_PathTable[BOTNODE_MAX][BOTNODE_MAX];		// Node linking
	extern nodeType_t			jb_NodeType[];														// Node type lookup table
//extern short int			jb_PathTableRocket[BOTNODE_MAX][BOTNODE_MAX];	// Node linking with rocket jump enabled
	extern nodePair_t			jb_JumpTable[BOTNODE_MAX];								// Jump required to link .from and .to
	extern nodePair_t			jb_DuckTable[BOTNODE_MAX];								// Crouching required to link .from and .to
	extern nodePair2_t		jb_LinkTable[BOTNODE_MAX];								// Forcing link between .from and .to
	extern itemLink_t			jb_ItemTable[MAX_EDICTS];									// Item table
	extern short int			jb_BotVersion;
	extern short int			jb_NumRevs;																// Route revisions

  // Needed in b_ai, b_filesys, b_items, b_movement
  extern edict_t			*jb_Player[MAX_CLIENTS];										// Pointer to each player
	extern botinfo_t		jb_BotInfo[MAX_CLIENTS];

	extern int					jb_NumJumps; // Jump links (auto)
	extern int					jb_NumDucks; // Duck links (auto)
	extern int					jb_NumLinks; // Forced links (user-defined)
  extern int					jb_NumItems;																// Number of items on the map
  extern int					jb_NumPlayers;															// Number of players in the server
	
	extern int					jb_NumNodeTypes;														// Size of jb_NodeType[] (computed in b_local.c)

	#if (compileTEST)
	extern byte								*jb_StringBank;												// Global string bank
	extern unsigned short int	jb_StringBankSize;										// Global string bank size
	#endif

  // Needed everywhere a debug message is needed
  extern int					jb_Debug;																		// Debug purpose

  // Needed in b_debug, b_filesys, b_misc
  extern field_t			jb_Script[];																// Bot script attributes

	// Needed in p_client.c
	extern qboolean			jb_NewMap;																	// Map change
	extern float				jb_AutoSave;

	extern vec3_t				jb_TeamBorder1;															// Invisible line dividing the map in two for bagman (0,1 = start; 2,3 = stop)
	extern vec3_t				jb_TeamBorder2;															// Invisible line dividing the map in two for bagman (0,1 = start; 2,3 = stop)

	extern vec3_t				jb_NodeArea1;																// Starting point for node areas (edition mode)
	extern vec3_t				jb_NodeArea2;																// End point for nodes areas (edition mode)

	extern cvar_t				*bot_mute;

	extern cvar_t				*bot_nodeviewdist;
	extern cvar_t				*bot_nodeviewfade;
	extern cvar_t				*bot_nodeviewupdate;
	extern cvar_t				*bot_nodeviewtest;
	extern cvar_t				*bot_nodetrail;
	extern cvar_t				*bot_nodeviewlinks;
	extern cvar_t				*bot_nodeshrink;
	extern cvar_t				*bot_nodesound;
	extern cvar_t				*bot_nodeautosave;
#endif
