#include "g_local.h"
#if compileJACKBOT


	void reactSearchStart(edict_t *self)
		{
		qboolean lf, rt;

		botprint(self, "started investigation...\n");
		self->botInfo->state |= BOTSTATE_INVESTIGATE;
		self->botInfo->searchStartTimeOut = level.time + self->botInfo->def.reactiontime; // Give one second before turning around
		self->botInfo->searchRemaining = 360;

		lf = testWall(self, BOTMOVE_LEFT, 64);
		rt = testWall(self, BOTMOVE_RIGHT, 64);

		// There's no wall around, turn according to handedness
		if (!lf && !rt)
			{
			#if (compileTEST)
			if (!Q_stricmp(getString(self->botInfo->def.ofsHand), "0")) // 0 is right, 1 is left
			#else
			if (!Q_stricmp(self->botInfo->def.hand, "0")) // 0 is right, 1 is left
			#endif
				self->botInfo->searchDirection = -1; // turn right
			else
				self->botInfo->searchDirection =  1; // turn left
			}
		// There's a wall on one side, don't look in that direction
		else
			{
			if (!rt)
				self->botInfo->searchDirection = -1; // turn right
			else
				self->botInfo->searchDirection =  1; // turn left
			}
		}

	void reactSearchStop(edict_t *self)
		{
		botprint(self, "stopped investigation...\n");
		self->botInfo->state &= ~BOTSTATE_INVESTIGATE;
		self->botInfo->searchNextTimeOut = level.time + 0.70; // We searched and found nothing, wait a little before reacting to damage again (do I really need that?!)
		if (!(self->botInfo->state & BOTSTATE_FOLLOWPATH))
			self->botInfo->state = BOTSTATE_FOLLOWPATH;
		}

	// bot: searching for enemy...
	void reactSearch(edict_t *self)
		{
		float current;
		float	yawspeed;

		botprint(self, "looking for that mofo!\n");

		// Not ready yet //
		if (self->botInfo->searchStartTimeOut > level.time)
			return;

		current = anglemod(self->s.angles[YAW]);
		yawspeed = 16 + (96 * self->botInfo->def.navigation);
		self->botInfo->searchRemaining -= yawspeed;
		self->s.angles[YAW] = anglemod(current + (yawspeed * self->botInfo->searchDirection));
		if (self->botInfo->searchRemaining < yawspeed)
			reactSearchStop(self);
		}


	void botAi_Reaction(edict_t *self)
		{
		// Only react to damage
		if (!(self->health < self->botInfo->healthTrack))
			return;

		// Already searching or in cooldown
		if ((self->botInfo->state & BOTSTATE_INVESTIGATE) || (self->botInfo->searchNextTimeOut > level.time))
			return;

		// Likely on a ladder, stay focused //
		if (!self->groundentity)
			return;

		// Not on worlspawn, maybe on an elevator, stay focused //
		if (Q_stricmp(self->groundentity->classname, "worldspawn"))
			return;

		// Check if the enemy can see us (return false if there's no enemy)
		if (sight_EnemyAimingAtMe(self, self->enemy))
			return;

		reactSearchStart(self);
		}


#endif