#include "g_local.h"
#include "m_player.h"
#if compileJACKBOT


	/******************************************************************************

		Return true if the gun is ready, false if it's not (clip is empty, or
		the weapon is not in the inventory).

	******************************************************************************/
	qboolean awarenessGunIsReady(edict_t *self, int weapIndex)
		{
		// Bail if no weapon
		if (weapIndex == -1)
			return false;

		// Bail if gun not owned
		if (!self->client->pers.inventory[weapIndex])
			return false;

		// Identify clip type and current ammo stocks
		if (itemlist[weapIndex].botItemWeap == wPistol)
			return (self->client->pers.weapon_clip[CLIP_PISTOL] > 0);
		else if (itemlist[weapIndex].botItemWeap == wShotgun)
			return (self->client->pers.weapon_clip[CLIP_SHOTGUN] > 0);
		else if (itemlist[weapIndex].botItemWeap == wTommyGun)
			return (self->client->pers.weapon_clip[CLIP_TOMMYGUN] > 0);
		else if (itemlist[weapIndex].botItemWeap == wHeavyMachineGun)
			return (self->client->pers.weapon_clip[CLIP_SLUGS] > 0);
		else if (itemlist[weapIndex].botItemWeap == wRocketLauncher)
			return (self->client->pers.weapon_clip[CLIP_ROCKETS] > 0);
		else if (itemlist[weapIndex].botItemWeap == wGrenadeLauncher)
			return (self->client->pers.weapon_clip[CLIP_GRENADES] > 0);
		else if (itemlist[weapIndex].botItemWeap == wFlamethrower)
			return (self->client->pers.inventory[ITEM_INDEX(FindItem("Gas"))] > 0); // there's no "clip" for the flamethrower
		else if ((itemlist[weapIndex].botItemWeap == wPipe) || (itemlist[weapIndex].botItemWeap == wCrowbar))
			return true;
		
		return false;
		}



	/******************************************************************************

	   Check if a weapon should be reloaded; that is, its clip is not full and
		 we have some ammunitions available in stock. If the weapon is selected,
		 the reloading action is triggered.

	******************************************************************************/
	qboolean botAI_reloadGun(edict_t *self, int weapIndex)
		{
		int			clipType;
		int			clipFull;
		int			clipNow;
		int			ammoStock;
		int			ammoIndex;

		// Bail if no weapon
		if (weapIndex == -1)
			return false;

		// Bail if gun not owned
		if (!self->client->pers.inventory[weapIndex])
			return false;

		// Identify clip type and current ammo stocks
		if (itemlist[weapIndex].botItemWeap == wPistol)
			clipType = CLIP_PISTOL;
		else if (itemlist[weapIndex].botItemWeap == wShotgun)
			clipType = CLIP_SHOTGUN;
		else if (itemlist[weapIndex].botItemWeap == wTommyGun)
			clipType = CLIP_TOMMYGUN;
		else if (itemlist[weapIndex].botItemWeap == wHeavyMachineGun)
			clipType = CLIP_SLUGS;
		else if (itemlist[weapIndex].botItemWeap == wRocketLauncher)
			clipType = CLIP_ROCKETS;
		else if (itemlist[weapIndex].botItemWeap == wGrenadeLauncher)
			clipType = CLIP_GRENADES;
		else
			return false;

		// Get stats
		ammoIndex = botMisc_FindItemIndexByPickupName(itemlist[weapIndex].ammo);	// get ammo index in inventory
		ammoStock = self->client->pers.inventory[ammoIndex];											// current stock
		clipFull = auto_rounds[clipType];																					// size of clip
		clipNow  = self->client->pers.weapon_clip[clipType];											// current stock in clip

		// Bail if clip is full
		if (clipNow == clipFull)
			return false;

		// Bail if no ammo to reload
		if (!ammoStock)
			return false;

		// It needs to be reloaded
		if (self->client->pers.weapon != &itemlist[weapIndex])
			self->client->newweapon = &itemlist[weapIndex];
		else
			{
			Cmd_Reload_f(self);
			botprint(self, "Reloading %s (%i %s required, has %i)\n", itemlist[weapIndex].pickup_name, clipFull - clipNow, itemlist[ammoIndex].pickup_name, self->client->pers.inventory[ammoIndex]);
			}

		return true;
		}



	/******************************************************************************

	   Reloading all guns in the inventory, starting with the favorite.

	******************************************************************************/
	void botAI_reloadGuns(edict_t *self)
		{
		int		i;
		int		weapIndex;

		// already reloading currently held gun, bail
		if (self->client->reload_weapon)
			return;

		// reload weapon (starting with favorite)
		for (i = 0; i < MAX_WEAPONS; i++)
			{
			if ((self->botInfo->def.rankOrder[i] == wPipe) || (self->botInfo->def.rankOrder[i] == wCrowbar) || (self->botInfo->def.rankOrder[i] == wFlamethrower))
				continue;
			weapIndex = botMisc_FindItemIndexByBotItemType(self->botInfo->def.rankOrder[i]);
			if (botAI_reloadGun(self, weapIndex))
				return;
			}

		// all guns are reloaded
		self->botInfo->extra &= ~BOTEXTRA_DEFERRED_RELOAD;
		botprint(self, "Done reloading all.\n");
		}


	void botAI_FleeFrom(edict_t *self, edict_t *other)
		{
		int i;
		float dist;

		for (i = 0; i < jb_NumNodes; i ++)
			{
			dist = VectorDistance(self->s.origin, jb_Node[i].origin);
			if (dist > BOTNODE_DIST_EXT)
				continue;
			if (sight_CouldSee(other, jb_Node[i].origin))
				continue;

			ACEND_SetGoal(self, -1, i);
			return;
			}
		}

	void botAi_KillGoal(edict_t *self)
		{
		self->botInfo->nodeGoal			= BOTNODE_INVALID;
		self->botInfo->nodeNext			= BOTNODE_INVALID;
		self->botInfo->goalEntity		= NULL;
		self->botInfo->nodeDistance	= 0;
		self->botInfo->extra			 &= ~BOTEXTRA_DEFERRED_GOAL;
		}


	//
	// Bot think
	//
	void ACEAI_Think (edict_t *self)
		{
		#define		FastDeath false
		float			dist;
		edict_t		*seenClient;

		
		#if (FastDeath)
		// Could use this as a quick exit, no more need for checks after that
		if (self->deadflag)
			{
			VectorCopy(self->client->ps.viewangles, self->s.angles);				// Clear angles
			VectorSet (self->client->ps.pmove.delta_angles, 0, 0, 0);				// Clear angles
			memset (&self->botInfo->ucmd, 0, sizeof (self->botInfo->ucmd));	// Clear UCMD

			botChatThink(self);																							// Chat if there's anything to say

			self->client->buttons = 0;																			// Reset keys
			self->botInfo->ucmd.buttons = BUTTON_ATTACK;										// Attack (leave scoreboard)
			self->nextthink = level.time + FRAMETIME;												// Come back in FRAMETIME

			self->botInfo->ucmd.msec = 75 + floor((random() + 1) * 25);			// dummy ping
			self->client->ping = self->botInfo->ucmd.msec;									// dummy ping for scoreboard
			self->botInfo->ucmd.angles[PITCH]	= ANGLE2SHORT(self->s.angles[PITCH]);
			self->botInfo->ucmd.angles[YAW]		= ANGLE2SHORT(self->s.angles[YAW]);
			self->botInfo->ucmd.angles[ROLL]	= ANGLE2SHORT(self->s.angles[ROLL]);
			ClientThink(self, &self->botInfo->ucmd);

			return;
			}
		#endif

		// RESET CLIENT MOVEMENTS //
		VectorCopy(self->client->ps.viewangles, self->s.angles);
		VectorSet (self->client->ps.pmove.delta_angles, 0, 0, 0);
		memset (&self->botInfo->ucmd, 0, sizeof (self->botInfo->ucmd));

		// CHAT THINK //
		botChatThink(self);

		botDebugFlags(self);

		#if (FastDeath == false)
		// DEAD, RESPAWN // 
		if (self->deadflag)
			{
			self->client->buttons = 0;
			self->botInfo->ucmd.buttons = BUTTON_ATTACK;
			}
		#endif

		// BOT LANDING //
		if ((self->groundentity) && (self->botInfo->extra & BOTEXTRA_ISJUMPING))
			{
			if (self->botInfo->landTimeout < level.time)
				{
				self->botInfo->extra &= ~BOTEXTRA_ISJUMPING;
				self->botInfo->jumpTimeout = level.time + 0.07;
				}
			self->botInfo->landTimeout = level.time + 0.10;
			}

		// DEFERRED THINKING, CHECK IF THE GOAL IS STILL AVAILABLE //
		if (self->botInfo->extra & BOTEXTRA_DEFERRED_GOAL)
			{
			self->botInfo->extra &= ~BOTEXTRA_DEFERRED_GOAL;
			if (!sight_GoalIsStillThere(self))
				botAi_KillGoal(self);
			}

		// GO DO THINGS //
		if (!(self->botInfo->def.flags & BOTFLAG_SLAVE))
			{
			// Pick something to do if you have nowhere to go //
			if (self->botInfo->nodeGoal == BOTNODE_INVALID)
				roam_GetObjective(self);

			// Pickup nearby money //
			if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
				getToddlerGoal_BagmanMoney(self);
			else
				self->botInfo->taskNow = TASK_KILLING_SPREE; // Should start with "getting ready" and then switch to "killing spree" - I think I need to split the THINK function, and provide different thinkings for every game mode
			}

		// LOOK FOR ENEMIES //
		#if (FastDeath == false)
		if ((self->health > 0) && (!self->deadflag))
		#else
		if (self->health > 0)
		#endif
			{
			seenClient = sight_ClosestVisibleEnemy(self, &dist);

			// We've got an enemy
			if (seenClient)
				{
				// New target
				if (self->enemy != seenClient)
					{
					reactSearchStop(self);	// Stop investigation
					self->enemy = seenClient;
					}

				// In Bagman: flee if located in enemy territory, stand your ground otherwise
				if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
					{
					if ((getEntityTerritory(self) != self->client->pers.team) || (self->botInfo->taskClass == BOTROLE_HONEYBEE) || (self->botInfo->taskClass == BOTROLE_THIEF))
						self->botInfo->state |= BOTSTATE_FLEE;
					else
						self->botInfo->state &= ~BOTSTATE_FLEE;
					}
				// Any other mode: flee if in a bad spot, stand your ground otherwise
				else
					{
					if ((self->health * 2) < ((self->botInfo->def.preserve + self->botInfo->def.navigation) * 100)) // should be more complex than that: estimate enemy's health, our chances, etc.
						self->botInfo->state |= BOTSTATE_FLEE;
					else
						self->botInfo->state &= ~BOTSTATE_FLEE;
					}

				// Pick weapon (if no weapon is available, BOTSTATE_FLEE is set)
				botAI_chooseWeapon(self, dist);

				// Pick an attack mode
				if (self->botInfo->state & BOTSTATE_FLEE)
					combatPassiveMove(self, dist); /*gi.dprintf("%s is fleeing!\n", self->client->pers.netname);*/
				else
					combatActiveMove(self, dist);
				//	Just in case, here's a function to force the bot to break line of sight.
				//	flee (botAI_FleeFrom(self, self->enemy);

				}

			// No enemy
			else
				{
				if (self->enemy)
					{
					self->botInfo->reloadTimeout = level.time + 0.70 + (random() * 3); // Reload your guns in...
					botprint(self, "Target lost!\n");
					self->botInfo->nodeCurrent = botMisc_CurrentNode(self); // Maybe I dodged a little too much... where am I now?
					}
				self->enemy = NULL;
				self->goalentity = NULL;
				}

			// TODDLER GOAL //
			if (self->movetarget)
				{
				if ((self->movetarget->solid == SOLID_NOT) || perfectMatch(self->s.origin, self->movetarget->s.origin))
					{
					self->botInfo->state |= BOTSTATE_FOLLOWPATH;
					self->movetarget = NULL;
					}
				else
					{
					self->botInfo->state &= ~BOTSTATE_FOLLOWPATH;
					bot_SetMotion(self, self->movetarget->s.origin, BOTSPEED_RUN);
					}
				}

			// REACT TO SURROUNDINGS (SOUND, PAIN,...) //
			botAi_Reaction(self);

			// NO ENEMY //
			if (!self->enemy)
				{
				// DEFERRED THINKING: RELOAD GUNS //
				if ((self->botInfo->reloadTimeout < level.time) && (self->botInfo->extra & BOTEXTRA_DEFERRED_RELOAD))
					botAI_reloadGuns(self);

				// FOLLOWING PATH //
				if (self->botInfo->state & BOTSTATE_FOLLOWPATH)
					{
					botprint(self, "Following path, going to [%i]\n", self->botInfo->nodeNext);
					if (self->botInfo->nodeNext != BOTNODE_INVALID)
						VectorCopy(jb_Node[self->botInfo->nodeNext].origin, self->botInfo->lookAt);
					moveGoToNextNode(self);
					}
				if (self->botInfo->state & BOTSTATE_INVESTIGATE)
					reactSearch(self);
				}
			}

		// PACK CLIENT MOVEMENTS AND SEND //
		self->botInfo->ucmd.msec = 75 + floor((random() + 1) * 25);	// dummy ping
		self->client->ping = self->botInfo->ucmd.msec;							// for scoreboard
		self->botInfo->ucmd.angles[PITCH]	= ANGLE2SHORT(self->s.angles[PITCH]);
		self->botInfo->ucmd.angles[YAW]		= ANGLE2SHORT(self->s.angles[YAW]);
		self->botInfo->ucmd.angles[ROLL]	= ANGLE2SHORT(self->s.angles[ROLL]);
		ClientThink(self, &self->botInfo->ucmd);
	
		// SEE YOU IN "FRAMETIME", KEEP TRACK OF HEALTH //
		self->nextthink = level.time + FRAMETIME;
		self->botInfo->healthTrack = self->health;
		}

	qboolean getObjective_Deathmatch(edict_t *bot, short int nodeCurrent)
		{
		int				i;
		float			weight, w2;

		float			best_weight		= 0.00;
		float			best_w2;
		short	int	best_goal			= BOTNODE_INVALID;
		short int	best_cost			= jb_NumNodes;
		edict_t		*best_entity	= 0;

		float			cost;

		// ACTIVE ITEM //
		for (i = 0; i < jb_NumItems; i++)
			{
			// Ignore defunct ItemTable entries
			if ((jb_ItemTable[i].item < 0) || (jb_ItemTable[i].item >= game.num_items))
				continue;
			if (!jb_ItemTable[i].ent)
				continue;
			if ((!jb_ItemTable[i].ent->think) || (jb_ItemTable[i].ent->solid == SOLID_NOT))
				continue;

			// Route length
			cost = botNode_MoveCost(nodeCurrent, jb_ItemTable[i].node);
			if (cost < 1)
				continue;

			// Is it worth it?
			w2 = weight_itemWeight(bot, jb_ItemTable[i].item);
			weight = w2 / cost;
			if (weight > best_weight)
				{
				best_cost		= cost;
				best_weight = weight;
				best_w2			= w2;
				best_goal		= jb_ItemTable[i].node;
				best_entity	= jb_ItemTable[i].ent;
				}
			}

		// We've got an item!
		if ((best_entity) && (best_goal != BOTNODE_INVALID))
			{
			bot->botInfo->state |= BOTSTATE_FOLLOWPATH;
			ACEND_SetGoal(bot, nodeCurrent, best_goal);
			botprint(bot, "selected \"%s\" with %f\n", best_entity->classname, best_w2);
			return true;
			}

		return false;
		}

	///////////////////////////////////////////////////////////////////////
	// Evaluate the best long range goal and send the bot on
	// its way. This is a good time waster, so use it sparingly. 
	// Do not call it for every think cycle.
	///////////////////////////////////////////////////////////////////////
	void roam_GetObjective(edict_t *self)
		{
		short int	nodeCurrent;


		// GET CURRENT POSITION //
		nodeCurrent = botMisc_CurrentNode(self);
		if (!ValidNode(nodeCurrent))
			{
			self->botInfo->nodeGoal = BOTNODE_INVALID;
			return;
			}

		// Get objectives for Bagman
		// Note: could use a "playstyle" member pointing straight to the proper function.
		if ((teamplay->value) && (teamplay_mode == TM_GRABDALOOT))
			{
			int oldRole = self->botInfo->taskClass;

			if (self->botInfo->taskNow == TASK_NONE)
				self->botInfo->taskClass = teamBalance(self);

			// Regardless of class, if you're close enough drop cash to base
			if ((self->client->pers.currentcash) || (self->client->pers.bagcash))
				getObjective_BagmanMoneyDeposite(self, nodeCurrent, (self->client->pers.currentcash + self->client->pers.bagcash > 150));


			if (self->botInfo->taskClass == BOTROLE_GUARD)
				{
				if (oldRole != self->botInfo->taskClass)
					botChatInitiate(self, "Guard", true, true);
				if (getObjective_BagmanGuard(self, nodeCurrent))
					return;
				}
			else if (self->botInfo->taskClass == BOTROLE_THIEF)
				{
				if (oldRole != self->botInfo->taskClass)
					botChatInitiate(self, "Thief", true, true);
				if (getObjective_BagmanThief(self, nodeCurrent))
					return;
				}
			else if (self->botInfo->taskClass == BOTROLE_HONEYBEE)
				{
				if (oldRole != self->botInfo->taskClass)
					botChatInitiate(self, "Honey bee", true, true);
				if (getObjective_BagmanHoneyBee(self, nodeCurrent))
					return;
				}
			return;
			}

		// Get objectives for Deathmatch
		else
			{
			if (getObjective_Deathmatch(self, nodeCurrent))
				return;
			}

		// WANDER AROUND, I DON'T CARE //
		botprint(self, "has nothing to do... go... do a thing... whatever you want.\n");
		ACEND_SetGoal(self, nodeCurrent, (int)(random() * jb_NumNodes));
		}

	///////////////////////////////////////////////////////////////////////
	// Pick best goal based on importance and range. This function
	// overrides the long range goal selection for items that
	// are very close to the bot and are reachable.
	///////////////////////////////////////////////////////////////////////
	/*
	void ACEAI_PickShortRangeGoal(edict_t *self)
		{
		int				index;
		float			weight;
		float			best_weight = 0.00;
		edict_t		*target;
		edict_t		*best;

		#define		seekrange 256

		// look for a target (should make more efficent later)
		target = findradius(NULL, self->s.origin, seekrange);

		while (target)
			{
			if (target->classname)
				{
				if (botAI_isReachable(self, target->s.origin))
					{
					index = botMisc_FindItemIndexByClassname(target->classname);
					weight = weight_itemWeight(self, index);
					if (weight > best_weight)
						{
						best_weight = weight;
						best = target;
						}
					}
				}
			target = findradius(target, self->s.origin, seekrange);
			}

		if (best_weight)
			{
			self->movetarget = best;
			if (self->goalentity != self->movetarget)
				botprint(self, "selected %s for SHORT RANGE goal (need: %f).\n", self->movetarget->classname, best_weight);
			self->goalentity = best;
			}
		}
		*/


	/***************************************************************************
	
	   Choose best weapon according on preferences, distance from target, and
		 availability.

	***************************************************************************/
	void botAI_chooseWeapon(edict_t *self, float dist)
		{
		int i;
		int safe;
		int itemIndex;

		// target too close, prioritize safe weapons
		safe = (dist < 256);

		// pick weapon (favorite to least favorite)
		for (i = 0; i < MAX_WEAPONS; i++)
			{
			itemIndex = -1;
			// melee (can reach, just run)
			if ((dist < 250) && ((self->botInfo->def.rankOrder[i] == wPipe) || (self->botInfo->def.rankOrder[i] == wCrowbar)))
				itemIndex = botMisc_FindItemIndexByBotItemType(self->botInfo->def.rankOrder[i]);

			// standard
			if ((self->botInfo->def.rankOrder[i] == wPistol) || (self->botInfo->def.rankOrder[i] == wShotgun) || (self->botInfo->def.rankOrder[i] == wTommyGun) || (self->botInfo->def.rankOrder[i] == wHeavyMachineGun))
				itemIndex = botMisc_FindItemIndexByBotItemType(self->botInfo->def.rankOrder[i]);

			// dangerous
			if (!safe)
				{
				if ((self->botInfo->def.rankOrder[i] == wRocketLauncher) || (self->botInfo->def.rankOrder[i] == wFlamethrower))
					itemIndex = botMisc_FindItemIndexByBotItemType(self->botInfo->def.rankOrder[i]);
				else if ((self->botInfo->def.rankOrder[i] == wGrenadeLauncher) && ((dist > 128) && (dist < 512) && (self->enemy->s.origin[2] - 20) < (self->s.origin[2])))
					itemIndex = botMisc_FindItemIndexByBotItemType(self->botInfo->def.rankOrder[i]);
				}
			if (itemIndex == -1)
				continue;
			else
				{
				if (awarenessGunIsReady(self, itemIndex))
					if (botAI_changeWeapon(self, itemIndex))
						return;
				}
			}

		// failed to get any weapon at all, default to melee
		// TODO: trigger a special flag to make sure the bot KNOWS there's nothing
		// left available right now (doesn't mean there's no ammo, maybe all your
		// guns need to be reloaded).
		//botprint(self, "ran out of ammo, should flee\n");
		self->botInfo->state |= BOTSTATE_FLEE;
		if (self->botInfo->def.rankWeight[wPipe] > self->botInfo->def.rankWeight[wCrowbar])
			botAI_changeWeapon(self, botMisc_FindItemIndexByPickupName("pipe"));
		else
			botAI_changeWeapon(self, botMisc_FindItemIndexByPickupName("crowbar"));
		}



#endif


