#include "g_local.h"
#if compileJACKBOT



	/*****************************************************************************************

		Hide node (called only if not in range, and self->dmg != 0)

	*****************************************************************************************/
	void DummyNode_Hidden(edict_t *self)
		{
		self->dmg = 0;
		self->s.renderfx2 = 0;
		self->s.effects = 0;
		gi.setmodel (self, "");
		}



	/*****************************************************************************************

		Display node (called only if in range, and self->dmg == 0)

	*****************************************************************************************/
	void DummyNode_Display(edict_t *self)
		{
		self->dmg = 1;
		self->s.renderfx2 = RF2_NOSHADOW | RF2_PASSALPHA;
		self->s.effects = 255;
		gi.setmodel (self, self->model);
		}



	/****************************************************************

		Update dummy nodes; show, fade, or hide depending on how far
		they are from the player (we assume the player is first in the
		jb_Player[] list).

	****************************************************************/
	void DummyNode_Think(edict_t *self)
		{
		float		dist;

		// Whatever happens, don't forget to come back for your update
		self->nextthink = level.time + bot_nodeviewupdate->value;
		self->think = DummyNode_Think;

		// Test visibility (PVS and in front)
		if (bot_nodeviewtest->value)
			{
			// Not in same PVS, abort
			if (!gi.inPVS(jb_Player[0]->s.origin, self->s.origin))
				{
				if (self->dmg)
					DummyNode_Hidden(self);
				return;
				}

			// Not in front, abort
			if (!infront(jb_Player[0], self))
				{
				if (self->dmg)
					DummyNode_Hidden(self);
				return;
				}
			}

		// Could be in range?
		dist = VectorDistance(jb_Player[0]->s.origin, self->s.origin);

		// In range
		if (dist <= (bot_nodeviewdist->value + bot_nodeviewfade->value))
			{
			if (!self->dmg)
				DummyNode_Display(self);
			if (dist <= (bot_nodeviewdist->value))
				{
				self->s.renderfx2 = 0;
				self->s.effects = 0;
				}
			else
				{
				self->s.renderfx2 = RF2_NOSHADOW | RF2_PASSALPHA;
				self->s.effects = (int)(((dist - bot_nodeviewdist->value) / bot_nodeviewfade->value) * 255);
				}
			self->s.angles[YAW] += 5;
			}

		// Not in range
		else
			{
			if (self->dmg)
				DummyNode_Hidden(self);
			}
		}



	/****************************************************************

		Remove dummy node <nodeIndex>

	****************************************************************/
	void DummyNode_Remove(int nodeIndex)
		{
		edict_t	*entity;

		if (!ValidNode(nodeIndex))
			return;

		for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
			{
			if (!entity)
				continue;
			if ((!entity->inuse) || (Q_stricmp(entity->classname, "info_node_display")) || (entity->count != nodeIndex))
				continue;
			gi.unlinkentity(entity);
			G_FreeEdict(entity);
			}
		}



	/****************************************************************

		Remove all dummy nodes

	****************************************************************/
	void DummyNode_RemoveAll()
		{
		edict_t	*entity;

		for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
			{
			if (!entity)
				continue;
			if ((!entity->inuse) || (Q_stricmp(entity->classname, "info_node_display")))
				continue;
			gi.unlinkentity(entity);
			G_FreeEdict(entity);
			}
		}



	
	/****************************************************************

		Spawn all dummy nodes

	****************************************************************/
	void DummyNode_SpawnAll()
		{
		int i = 0;

		if (jb_NumNodes)
			{
			for (i = 0; i < jb_NumNodes; i++)
				DummyNode_Spawn(i);
			}
		else
			gi.dprintf("No node to display\n");
		}



	/****************************************************************

		Move dummy node

	****************************************************************/
	void DummyNode_Move(int node, vec3_t org)
		{
		edict_t *entity;

		if (!ValidNode(node))
			return;

		for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
			{
			if (!entity)
				continue;
			if ((!entity->inuse) || (Q_stricmp(entity->classname, "info_node_display")) || (entity->count != node))
				continue;
			VectorCopy(org, entity->s.origin);
			return;
			}
		}



	/*****************************************************************************************

		Spawn dummy nodes (for route creation purpose), invisible by default

	*****************************************************************************************/
	void DummyNode_Spawn(int node)
		{
		edict_t					*ent;

		// Can't use this
		if (!ValidNode(node))
			return;
		
		// Get free slot
		ent = G_Spawn();
		if (!ent)
			return;

		// Init entity, make invisible by default, check visiblity ASAP
		ent->movetype		= MOVETYPE_NONE;
		ent->solid			= SOLID_NOT;
		ent->classname	= "info_node_display";
		ent->owner			= ent;
		ent->nextthink	= level.time + 0.01;
		ent->think			= DummyNode_Think;                
		ent->dmg				= 0; // is visible?
		ent->count			= node;

		// Setup model & appropriate skin
		ent->model = "models/pu_icon/bots/tris.md2";
		if (jb_Node[node].type)
			ent->s.skinnum = jb_Node[node].type->skinNum;
		else
			ent->s.skinnum = getNodeTypeByValue(nAll)->skinNum;
		ent->s.renderfx = RF_FULLBRIGHT;

		// Put in world
		VectorCopy(jb_Node[node].origin, ent->s.origin);
		gi.linkentity(ent);
		}

#endif