#include "g_local.h"
#if compileJACKBOT



	/******************************************************************************
  
     Catch bots by name (or "all") -- IMPORTANT: if "botList" is NULL, only
		 the count is returned; otherwise, enough memory MUST be reserved at
		 memory segment pointed by "botList". The memory is freed if no bot is
		 found, otherwise the calling routine MUST free the memory on its own.

  ******************************************************************************/
	int botMisc_CatchBot(char *name, edict_t ***ptr)
		{
		int							i;
		int							count = 0;
		edict_t					*ent;
		qboolean				getAll = !Q_stricmp(name, "all");
		static edict_t	*botList[MAX_CLIENTS];

		// No name specified
		if (!strlen(name))
			gi.dprintf("No bot name specified.\n");

		// Search for bots
		else
			{
			// Copy pointers
			for (i = maxclients->value; i > 0; i--)
				{
				ent = &g_edicts[i + 1];
				if ((!ent->inuse) || (!ent->botInfo))
					continue;
				if ((!Q_stricmp(ent->client->pers.netname, name)) || getAll)
					{
					botList[count] = ent;
					count++;
					}
				}
			// No bot found
			if ((!count) && (ptr))
				{
				if (getAll)
					gi.dprintf("No bot available for the requested operation.\n");
				else
					gi.dprintf("Unable to find bot named %s for the requested operation.\n", name);
				}
			}
		// Return info
		if (ptr)
			*ptr = botList;
		return count;
		}


	/**************************************************************

		Find closest entity, approximate closest entity with taxicab,
		return pointer to entity if it is within range.

	**************************************************************/
	edict_t *getClosestEntity(char *classname, vec3_t origin, float dist)
		{
		edict_t		*entity;
		edict_t		*closestEntity = NULL;
		int  			distMax = -1;
		int  			distApprox;

		// Any entity
		if (!classname)
			{
			for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
				{
				if (!entity->classname)
					continue;
				if (!Q_stricmp(entity->classname, "info_node_display")) // can't select those
					continue;
				distApprox = VectorDistanceTaxicab(entity->s.origin, origin);
				if (!((distMax == -1) || (distApprox < distMax)))
					continue;
				distMax = distApprox;
				closestEntity = entity;
				}
			}

		// Specified classname only
		else
			{	
			for (entity = g_edicts; entity < &g_edicts[globals.num_edicts]; entity++)
				{
				if (!entity->classname)
					continue;
				if (Q_stricmp(entity->classname, classname))
					continue;
				distApprox = VectorDistanceTaxicab(entity->s.origin, origin);
				if (!((distMax == -1) || (distApprox < distMax)))
					continue;
				distMax = distApprox;
				closestEntity = entity;
				}
			}

		// Closest entity is in range?
		if (closestEntity)
			if (VectorDistance(closestEntity->s.origin, origin) <= dist)
				return closestEntity;
		return NULL;
		}



	/******************************************************************************

		Get level of the top surface of a solid (we assume origin is stuck in solid)

	******************************************************************************/
	float getSolidTop(vec3_t origin, vec3_t min, vec3_t max, edict_t *ignore, int maxHeight)
		{
		vec3_t	v;
		trace_t tr;
		float		height = 0.00;
		
		VectorCopy(origin, v);
		while (true);
			{
			v[2]  += 8.00;
			height += 8.00;
			tr = gi.trace(v, min, max, origin, ignore, CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_PLAYERCLIP);
			if (!tr.startsolid)
				{
				if ((tr.fraction != 1.00) && (tr.contents & (CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_PLAYERCLIP)))
					return tr.endpos[2];
				else
					return v[2];
				}
			else if (height > maxHeight)
				return v[2];
			}
		/*
		VectorCopy(origin, v);
		VectorCopy(origin, v2);
		tr = gi.trace(v, min, max, v, ignore, CONTENTS_SOLID | CONTENTS_WINDOW | CONTENTS_PLAYERCLIP);
		if (tr.startsolid)
			{
			do
				{
				v2[2]  += 8;
				height += 8;
				tr = gi.trace(v2, min, max, v, ignore, MASK_SOLID);
				if (!tr.startsolid)
					return tr.endpos[2];
				} while (height < maxHeight);
			return v2[2];
			}
		gi.dprintf("getSolidTop didn't start in solid?!\n");
		return v2[2] + 512;
		*/
		};

	/******************************************************************************
	  
		Get floor level under point <origin> using a box of <min> <max>

	******************************************************************************/
	float getFloor(vec3_t origin, vec3_t min, vec3_t max, edict_t *ignore)
		{
		vec3_t	v;
		trace_t tr;

		v[0] = origin[0];
		v[1] = origin[1];
		v[2] = origin[2] - 1024;
		tr = gi.trace(origin, min, max, v, ignore, MASK_BOTBLOCK);
		if (tr.fraction == 1.00 || tr.allsolid)
			return v[2];
		return tr.endpos[2];
		}



	/******************************************************************************
	  
		Get ceiling level above point <origin> using a box of <min> <max>

	******************************************************************************/
	float getCeiling(vec3_t origin, vec3_t min, vec3_t max, edict_t *ignore)
		{
		vec3_t	v;
		trace_t tr;

		v[0] = origin[0];
		v[1] = origin[1];
		v[2] = origin[2] + 1024;
		tr = gi.trace(origin, min, max, v, ignore, MASK_BOTBLOCK);
		if (tr.fraction == 1.00 || tr.allsolid)
			return v[2];
		return tr.endpos[2];
		}



	/******************************************************************************
	  
		Draw line

	******************************************************************************/
	void showTrace(vec3_t v1, vec3_t v2)
		{
		gi.WriteByte (svc_temp_entity);
		gi.WriteByte (TE_BFG_LASER);
		gi.WritePosition (v1);
		gi.WritePosition (v2);
		gi.multicast (v1, MULTICAST_PVS);
		}



	/******************************************************************************

		Find closest ladder surface and return its normal. The facing
		angle should be anglemod(vectoyaw(tr.plane.normal) + 180.00). This
		function will not return the proper value if the node is located
		above the ladder surface.

	******************************************************************************/
	qboolean getLadderNormal(edict_t *self, vec3_t org, vec3_t normal)
		{
		int			i;
		vec3_t	dir;
		trace_t	tr;
		float		angle;

		for (i = 0; i < 360; i += 30)
			{
			angle = (float)i * (M_PI * 2 / 360);
			dir[0] = org[0] + (sin(angle) * 32.00);
			dir[1] = org[1] + (cos(angle) * 32.00);
			dir[2] = org[2];
			tr = gi.trace(org, NULL, NULL, dir, self, CONTENTS_LADDER);
			if ((tr.fraction < 1.00) && (tr.contents & CONTENTS_LADDER))
				{
				VectorCopy(tr.plane.normal, normal);
				return true;
				}
			}
		return false;
		}



	/******************************************************************************
	  
		Get the middle of the line segment <p1><p2>

	******************************************************************************/
	void VectorMiddle(vec3_t p1, vec3_t p2, vec3_t m)
		{
		m[0] = p2[0] + ((p1[0] - p2[0]) * 0.50);
		m[1] = p2[1] + ((p1[1] - p2[1]) * 0.50);
		m[2] = p2[2] + ((p1[2] - p2[2]) * 0.50);
		}



	/************************************************************************

		Return true if <ent> is facing a ladder

	************************************************************************/
	qboolean onLadder(edict_t *ent)
		{
		vec3_t	v, forward;
		trace_t	tr;

		AngleVectors(ent->s.angles, forward, NULL, NULL);
		VectorMA(ent->s.origin, 1, forward, v);
		tr = gi.trace(ent->s.origin, ent->mins, ent->maxs, v, ent, CONTENTS_LADDER);
		return ((tr.fraction < 1.00) || (tr.contents & CONTENTS_LADDER));
		}



	/************************************************************************

		Return TRUE if there's a wall in the specified direction (eye level)

	************************************************************************/
	qboolean testWall(edict_t *ent, int angle, int dist)
		{
		vec3_t	v, eyes, forward;
		trace_t tr;

		eyes[0] = ent->s.origin[0];
		eyes[1] = ent->s.origin[1];
		eyes[2] = ent->s.origin[2] + ent->viewheight;

		AngleVectors(ent->s.angles, forward, NULL, NULL);
		VectorMA(eyes, dist, forward, v);
		tr = gi.trace(eyes, NULL, NULL, v, ent, MASK_BOTNOGO);
		return ((tr.fraction < 1.00) || (tr.contents & CONTENTS_SOLID));
		}


	/******************************************************************************

		 Angle MOD 360, but doesn't turn the float into int.

	******************************************************************************/
	float angleRange(float angle)
		{
		float angle2 = angle;
		if (angle2 >= 360)
			do
				{
				angle2 -= 360;
				} while (angle2 >= 360);
		else if (angle2 < 0)
			do
				{
				angle2 += 360;
				} while (angle2 < 0);
		return angle2;
		}



	/******************************************************************************

		 Rank favorite weapons -- Called after reading ".bot" script files and
		 after changing any attribute via the "sv botscript" command. Note that
		 "botDef.rankWeight[]" must be initialized for this routine to work.

	******************************************************************************/
	void botMisc_rankWeapons(botDef_t *def)
		{
		int						i;
		int						k = 0;
		botItemWeap_t j;

		// initialize ranks
		for (i = 0; i < MAX_WEAPONS; i ++)
			def->rankOrder[i] = i;

		// sort ranking
		do
			{
			k = 0;
			for (i = 0; i < MAX_WEAPONS - 1; i++)
  			{
				if (def->rankWeight[def->rankOrder[i]] < def->rankWeight[def->rankOrder[i + 1]])
    			{
					j = def->rankOrder[i];
					def->rankOrder[i] = def->rankOrder[i + 1];
					def->rankOrder[i + 1] = j;
					k = 1;
					}
				}
			} while (k == 1);
		}



	/******************************************************************************
  
     Assign "value" to "key", or fill "value" with current setting

  ******************************************************************************/
  qboolean botMisc_attribute(botDef_t *botdef, char *key, char *value)
		{
		float			j;
		qboolean	found = false;
		field_t		*f;
		byte			*b;
	
		// Change current value, or return current value
		for (f = jb_Script; f->name; f++)
			{
			if (Q_stricmp(f->name, key))
				continue;

			b = (byte *)botdef;
			found = true;
			switch (f->type)
				{
				case F_IGNORE:
					break;
		
				case F_LSTRING:
					if (strlen(value))
						strcpy((char*)(b+f->ofs), value);
					else
						sprintf(value, "%s", (char*)(b+f->ofs));
					break;

				#if (compileTEST)
				case F_STRBANK:
					if (strlen(value))
						*(unsigned short int *)(b+f->ofs) = fs_stringBankAppend(&jb_StringBank, &jb_StringBankSize, value);
					else
						sprintf(value, "%s", getString(*(unsigned short int *)(b+f->ofs)));
					break;
				#endif
		
				case F_INT:
					if (strlen(value))
						*(int *)(b+f->ofs) = atoi(value);
					else
						sprintf(value, "%i", *(int *)(b+f->ofs));
					break;

				case F_FLOAT:
					if (strlen(value))
						*(float *)(b+f->ofs) = atof(value);
					else
						sprintf(value, "%f", *(float *)(b+f->ofs));
					break;
		
				case F_PERCENT:
					if (strlen(value))
						{
						j = atof(value);
						if (j < 0)
							j = 0;
  					if (j > 100)
							j = 100;
						*(float *)(b+f->ofs) = j / 100;
						}
					else
						sprintf(value, "%i", (int)(*(float *)(b+f->ofs) * 100));
					break;
		
				case F_BOTFLAG:
					if (strlen(value))
						{
						if (atoi(value))
							*((int *)(b+f->ofs)) |= f->flags;
						else
							*((int *)(b+f->ofs)) &= ~(f->flags);
						}
					else
						sprintf(value, "%i", (*((int *)(b+f->ofs)) & f->flags)?1:0);
					break;

				case F_ANGLE:
					if (strlen(value))
						{
						j = atoi(value);
						if (j < 0)
							j = 0;
  					if (j > 360)
							j = 360;
						*(int *)(b+f->ofs) = j;
						}
					else
						sprintf(value, "%i", *(int *)(b+f->ofs));
					break;

				case F_BOTHAND:
					#if (compileTEST)
					if (strlen(value))
						{
						if (!Q_stricmp(value, "right"))
							*(unsigned short int *)(b+f->ofs) = fs_stringBankAppend(&jb_StringBank, &jb_StringBankSize, "0");
						else if (!Q_stricmp(value, "left"))
							*(unsigned short int *)(b+f->ofs) = fs_stringBankAppend(&jb_StringBank, &jb_StringBankSize, "1");
						else
							*(unsigned short int *)(b+f->ofs) = fs_stringBankAppend(&jb_StringBank, &jb_StringBankSize, "2");
						}
					else
						{
						char *str = getString(*(unsigned short int *)(b+f->ofs));
						if (!Q_stricmp(str, "0"))
							sprintf(value, "right");
						else if (!Q_stricmp(str, "1"))
							sprintf(value, "left");
						else
							sprintf(value, "center");
						}
					#else
					if (strlen(value))
						{
						if (!Q_stricmp(value, "right"))
							strcpy((char*)(b+f->ofs), "0");
						else if (!Q_stricmp(value, "left"))
							strcpy((char*)(b+f->ofs), "1");
						else
							strcpy((char*)(b+f->ofs), "2");
						}
					else
						{
						if (!Q_stricmp((char*)(b+f->ofs), "0"))
							sprintf(value, "right");
						else if (!Q_stricmp((char*)(b+f->ofs), "1"))
							sprintf(value, "left");
						else
							sprintf(value, "center");
						}
					#endif
					break;
				}
			}
		return (found);
		}



	/******************************************************************************

		 Return an index in itemlist[] (this is useful because this index number is
		 also used in client->pers.inventory[]) -- using a classname

	******************************************************************************/
	int botMisc_FindItemIndexByClassname(char *classname)
		{
		int		i;
		gitem_t *it;

		if (!classname)
			return -1;

		it = itemlist;
		for (i = 0; i < game.num_items; i++, it++)
			{
			if (!it->classname)
				continue;
			if (!Q_stricmp(it->classname, classname))
				return i;
			}
		return -1;
		}



	/******************************************************************************

		 Return an index in itemlist[] (this is useful because this index number is
		 also used in client->pers.inventory[]) -- using a pickup name

	******************************************************************************/
	int botMisc_FindItemIndexByPickupName(char *pickup_name)
		{
		int		i;
		gitem_t *it;

		it = itemlist;
		for (i = 0; i < game.num_items; i++, it++)
			{
			if (!it->pickup_name)
				continue;
			if (!Q_stricmp(it->pickup_name, pickup_name))
				return i;
			}
			return -1;
		}



	/******************************************************************************

		 Return an index in itemlist[] (this is useful because this index number is
		 also used in client->pers.inventory[]) -- using a botItemType

	******************************************************************************/
	int botMisc_FindItemIndexByBotItemType(botItemWeap_t botItemWeap)
		{
		int			i;
		gitem_t *it;

		if (botItemWeap < 0)
			return -1;

		it = itemlist;
		for (i = 0; i < game.num_items; i++, it++)
			{
			if (!(it->botItemFlag & botItem_Weapon))
				continue;
			if (it->botItemWeap == botItemWeap)
				return i;
			}
		return -1;
		}






#endif